/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.LeftTree;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.Link;
import org.netbeans.modules.soa.mappercore.model.MapperModel;
import org.netbeans.modules.soa.mappercore.model.TreeSourcePin;
import org.netbeans.modules.soa.mappercore.utils.Utils;
import org.openide.util.NbBundle;

public class FiltersToolBar
extends JToolBar
implements ActionListener {
    private Mapper mapper;
    private JButton expandLeftButton;
    private JButton expandRightButton;
    private JToggleButton leftAllButton;
    private JToggleButton leftOutputButton;
    private ButtonGroup leftGroup;
    private JToggleButton rightAllButton;
    private JToggleButton rightInputButton;
    private ButtonGroup rightGroup;
    private SwitchLeftFilterAction switchLeftFilterAction;
    private SwitchRightFilterAction switchRightFilterAction;
    private ExpandNonEmptyGraphsAction expandNonEmptyGraphsAction;
    private CollapseAllRightAction collapseAllRightAction;
    private CollapseOtherNodesAction collapseOtherNodesAction;
    private CollapseAllLeftAction collapseAllLeftAction;
    private ExpandMappedNodesLeftAction expandMappedNodesLeftAction;
    private JPopupMenu expandLeftMenu;
    private JPopupMenu expandRightMenu;

    public FiltersToolBar(Mapper mapper) {
        this.setFloatable(false);
        this.setBorder(new EmptyBorder(2, 1, 2, 1));
        this.mapper = mapper;
        boolean bl = mapper.isFilterLeft();
        boolean bl2 = mapper.isFilterRight();
        this.collapseAllLeftAction = new CollapseAllLeftAction();
        this.expandMappedNodesLeftAction = new ExpandMappedNodesLeftAction();
        this.expandNonEmptyGraphsAction = new ExpandNonEmptyGraphsAction();
        this.collapseOtherNodesAction = new CollapseOtherNodesAction();
        this.collapseAllRightAction = new CollapseAllRightAction();
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("resources/expandactions.png"));
        this.expandLeftButton = new JButton(imageIcon);
        this.expandLeftButton.addActionListener(this);
        this.expandLeftButton.setFocusable(false);
        this.expandRightButton = new JButton(imageIcon);
        this.expandRightButton.addActionListener(this);
        this.expandRightButton.setFocusable(false);
        this.switchLeftFilterAction = new SwitchLeftFilterAction();
        this.switchRightFilterAction = new SwitchRightFilterAction();
        InputMap inputMap = mapper.getInputMap(1);
        ActionMap actionMap = mapper.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(76, 192), "SwitchLeftFilter");
        inputMap.put(KeyStroke.getKeyStroke(82, 192), "SwitchRightFilter");
        actionMap.put("SwitchLeftFilter", this.switchLeftFilterAction);
        actionMap.put("SwitchRightFilter", this.switchRightFilterAction);
        this.registerMapperAction(this.expandMappedNodesLeftAction, "ExpandMappedNodesLeftAction");
        this.registerMapperAction(this.collapseAllLeftAction, "\u0421ollapseAllLeftAction");
        this.registerMapperAction(this.expandNonEmptyGraphsAction, "ExpandNonEmptyGraphsAction");
        this.registerMapperAction(this.collapseAllRightAction, "CollapseAllRightAction");
        this.registerMapperAction(this.collapseOtherNodesAction, "CollapseOtherNodesAction");
        String string = NbBundle.getMessage(this.getClass(), (String)"TTT_LeftTreeFilter");
        String string2 = NbBundle.getMessage(this.getClass(), (String)"TTT_RightTreeFilter");
        this.leftAllButton = new JToggleButton(NbBundle.getMessage(this.getClass(), (String)"LBL_LeftTreeFilterAll"));
        this.leftAllButton.setFocusable(false);
        this.leftAllButton.setSelected(!bl);
        this.leftAllButton.setToolTipText(string);
        this.leftAllButton.addActionListener(this);
        this.leftOutputButton = new JToggleButton(NbBundle.getMessage(this.getClass(), (String)"LBL_LeftTreeFilterOutput"));
        this.leftOutputButton.setSelected(bl);
        this.leftOutputButton.setFocusable(false);
        this.leftOutputButton.setToolTipText(string);
        this.leftOutputButton.addActionListener(this);
        this.leftGroup = new ButtonGroup();
        this.leftGroup.add(this.leftAllButton);
        this.leftGroup.add(this.leftOutputButton);
        this.rightAllButton = new JToggleButton(NbBundle.getMessage(this.getClass(), (String)"LBL_RightTreeFilterAll"));
        this.rightAllButton.setSelected(!bl2);
        this.rightAllButton.setFocusable(false);
        this.rightAllButton.setToolTipText(string2);
        this.rightAllButton.addActionListener(this);
        this.rightInputButton = new JToggleButton(NbBundle.getMessage(this.getClass(), (String)"LBL_RightTreeFilterInput"));
        this.rightInputButton.setSelected(bl2);
        this.rightInputButton.setFocusable(false);
        this.rightInputButton.setToolTipText(string2);
        this.rightInputButton.addActionListener(this);
        this.rightGroup = new ButtonGroup();
        this.rightGroup.add(this.rightAllButton);
        this.rightGroup.add(this.rightInputButton);
        this.configureAccessibleContext(this.leftAllButton, "LeftTreeFilterAll");
        this.configureAccessibleContext(this.leftOutputButton, "LeftTreeFilterOutput");
        this.configureAccessibleContext(this.rightAllButton, "RightTreeFilterAll");
        this.configureAccessibleContext(this.rightInputButton, "RightTreeFilterInput");
        this.configureAccessibleContext(this.expandLeftButton, "ExpandCollapseLeft");
        this.configureAccessibleContext(this.expandRightButton, "ExpandCollapseRight");
        this.add(this.expandLeftButton);
        this.add(this.leftAllButton);
        this.add(this.leftOutputButton);
        this.add(this.rightInputButton);
        this.add(this.rightAllButton);
        this.add(this.expandRightButton);
    }

    private void configureAccessibleContext(JComponent jComponent, String string) {
        AccessibleContext accessibleContext = jComponent.getAccessibleContext();
        accessibleContext.setAccessibleName(NbBundle.getMessage(this.getClass(), (String)("ACSN_" + string)));
        accessibleContext.setAccessibleDescription(NbBundle.getMessage(this.getClass(), (String)("ACSD_" + string)));
    }

    private void registerMapperAction(Action action, String string) {
        Object object = action.getValue("AcceleratorKey");
        if (object instanceof KeyStroke) {
            this.mapper.getInputMap(1).put((KeyStroke)object, string);
            this.mapper.getActionMap().put(string, action);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.leftAllButton) {
            this.mapper.setFilter(false, this.mapper.isFilterRight());
        } else if (object == this.leftOutputButton) {
            this.mapper.setFilter(true, this.mapper.isFilterRight());
        } else if (object == this.rightAllButton) {
            this.mapper.setFilter(this.mapper.isFilterLeft(), false);
        } else if (object == this.rightInputButton) {
            this.mapper.setFilter(this.mapper.isFilterLeft(), true);
        } else if (object == this.expandLeftButton) {
            this.showExpandLeftMenu();
        } else if (object == this.expandRightButton) {
            this.showExpandRightMenu();
        }
    }

    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (JComponent jComponent : new JComponent[]{this.leftAllButton, this.leftOutputButton, this.rightAllButton, this.rightInputButton}) {
            Dimension dimension = jComponent.getPreferredSize();
            n = Math.max(n, dimension.width);
            n2 = Math.max(n2, dimension.height);
            if (!jComponent.isVisible()) continue;
            ++n3;
        }
        Dimension dimension = this.expandLeftButton.getPreferredSize();
        Dimension dimension2 = this.expandRightButton.getPreferredSize();
        n2 = Math.max(n2, Math.max(dimension.height, dimension2.height));
        int n4 = Math.max(dimension.width, dimension2.width);
        n = insets.left + n4 + 1 + n * n3 + 4 + 1 + n4 + insets.right;
        n2 = insets.top + n2 + insets.bottom;
        return new Dimension(n, n2);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void doLayout() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        Insets insets = this.getInsets();
        int n3 = insets.left;
        int n4 = n - insets.right;
        int n5 = insets.top;
        int n6 = n2 - insets.top - insets.bottom;
        int n7 = 0;
        for (JComponent n9 : new JComponent[]{this.leftAllButton, this.leftOutputButton, this.rightAllButton, this.rightInputButton}) {
            n7 = Math.max(n7, n9.getPreferredSize().width);
        }
        Dimension dimension = this.expandLeftButton.getPreferredSize();
        Dimension dimension2 = this.expandRightButton.getPreferredSize();
        int n8 = Math.max(dimension.width, dimension2.width);
        this.expandLeftButton.setBounds(n3, n5, n8, n6);
        n3 += n8 + 1;
        if (this.leftAllButton.isVisible()) {
            this.leftAllButton.setBounds(n3, n5, n7, n6);
            n3 += n7;
        }
        if (this.leftOutputButton.isVisible()) {
            this.leftOutputButton.setBounds(n3, n5, n7, n6);
            n3 += n7;
        }
        int n9 = n4 - n8 - 1;
        if (this.rightAllButton.isVisible()) {
            n9 -= n7;
        }
        if (this.rightInputButton.isVisible()) {
            n9 -= n7;
        }
        n9 = Math.max(n9, n3 + 4);
        if (this.rightInputButton.isVisible()) {
            this.rightInputButton.setBounds(n9, n5, n7, n6);
            n9 += n7;
        }
        if (this.rightAllButton.isVisible()) {
            this.rightAllButton.setBounds(n9, n5, n7, n6);
            n9 += n7 + 1;
        }
        this.expandRightButton.setBounds(n9, n5, n8, n6);
    }

    public void updateButtonsState() {
        boolean bl = this.mapper.isFilterLeft();
        boolean bl2 = this.mapper.isFilterRight();
        this.leftAllButton.setSelected(!bl);
        this.leftOutputButton.setSelected(bl);
        this.rightAllButton.setSelected(!bl2);
        this.rightInputButton.setSelected(bl2);
    }

    protected void paintBorder(Graphics graphics) {
        Color color = graphics.getColor();
        int n = this.getWidth() - 1;
        int n2 = this.getHeight() - 1;
        graphics.setColor(this.getBackground().brighter());
        graphics.drawLine(0, 0, n, 0);
        graphics.setColor(this.getBackground().darker());
        graphics.drawLine(0, n2, n, n2);
        graphics.setColor(color);
    }

    private void showExpandLeftMenu() {
        if (this.expandLeftMenu == null) {
            this.expandLeftMenu = new JPopupMenu();
            this.expandLeftMenu.add(this.expandMappedNodesLeftAction);
            this.expandLeftMenu.add(this.collapseAllLeftAction);
        }
        this.expandLeftMenu.show(this.expandLeftButton, -2, this.expandLeftButton.getHeight() + 1);
    }

    private void showExpandRightMenu() {
        if (this.expandRightMenu == null) {
            this.expandRightMenu = new JPopupMenu();
            this.expandRightMenu.add(this.expandNonEmptyGraphsAction);
            this.expandRightMenu.add(this.collapseAllRightAction);
            this.expandRightMenu.add(this.collapseOtherNodesAction);
        }
        int n = this.expandRightMenu.getPreferredSize().width;
        this.expandRightMenu.show(this.expandRightButton, this.expandRightButton.getWidth() - n + 2, this.expandRightButton.getHeight() + 1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExpandMappedNodesLeftAction
    extends AbstractAction {
        ExpandMappedNodesLeftAction() {
            super(NbBundle.getMessage(FiltersToolBar.class, (String)"LBL_ExpandMappedNodesLeft"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(107, 640));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LeftTree leftTree = FiltersToolBar.this.mapper.getLeftTree();
            MapperModel mapperModel = FiltersToolBar.this.mapper.getFilteredModel();
            TreeModel treeModel = leftTree.getModel();
            if (mapperModel == null || treeModel == null) {
                return;
            }
            Object object = mapperModel.getRoot();
            if (object == null) {
                return;
            }
            TreePath treePath = new TreePath(object);
            HashSet<TreePath> hashSet = new HashSet<TreePath>();
            this.collectMappedNodes(mapperModel, treePath, hashSet);
            for (TreePath treePath2 : hashSet) {
                if (!Utils.isTreePathExpandable(treeModel, treePath2)) continue;
                leftTree.expandPath(treePath2);
            }
        }

        private void collectMappedNodes(MapperModel mapperModel, TreePath treePath, Set<TreePath> set) {
            Object object;
            List<Link> list;
            Graph graph = mapperModel.getGraph(treePath);
            if (graph != null && graph.hasIngoingLinks() && (list = graph.getIngoingLinks()) != null) {
                for (Link link : list) {
                    TreePath treePath2;
                    TreePath treePath3;
                    object = link.getSource();
                    if (!(object instanceof TreeSourcePin) || (treePath3 = (treePath2 = ((TreeSourcePin)object).getTreePath()) == null ? null : treePath2.getParentPath()) == null) continue;
                    set.add(treePath3);
                }
            }
            if (!mapperModel.isLeaf(list = treePath.getLastPathComponent()) && mapperModel.searchGraphsInside(treePath)) {
                int n = mapperModel.getChildCount(list);
                for (int i = 0; i < n; ++i) {
                    object = mapperModel.getChild(list, i);
                    this.collectMappedNodes(mapperModel, treePath.pathByAddingChild(object), set);
                }
            }
        }
    }

    private class CollapseAllLeftAction
    extends AbstractAction {
        CollapseAllLeftAction() {
            super(NbBundle.getMessage(FiltersToolBar.class, (String)"LBL_CollapseAllLeft"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(109, 640));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LeftTree leftTree = FiltersToolBar.this.mapper.getLeftTree();
            for (int i = leftTree.getRowCount() - 1; i >= 0; --i) {
                leftTree.collapseRow(i);
            }
        }
    }

    private class CollapseAllRightAction
    extends AbstractAction {
        CollapseAllRightAction() {
            super(NbBundle.getMessage(FiltersToolBar.class, (String)"LBL_CollapseAllRight"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(109, 128));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FiltersToolBar.this.mapper.collapseAll(1);
        }
    }

    private class CollapseOtherNodesAction
    extends AbstractAction {
        CollapseOtherNodesAction() {
            super(NbBundle.getMessage(FiltersToolBar.class, (String)"LBL_CollapseOtherNodes"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(109, 192));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FiltersToolBar.this.mapper.hideOtherPathes(1);
        }
    }

    private class ExpandNonEmptyGraphsAction
    extends AbstractAction {
        ExpandNonEmptyGraphsAction() {
            super(NbBundle.getMessage(FiltersToolBar.class, (String)"LBL_ExpandNonEmptyGraphs"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(107, 128));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FiltersToolBar.this.mapper.expandNonEmptyGraphs();
        }
    }

    private class ExpandRightAction
    extends AbstractAction {
        private ExpandRightAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FiltersToolBar.this.showExpandRightMenu();
        }
    }

    private class ExpandLeftAction
    extends AbstractAction {
        private ExpandLeftAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FiltersToolBar.this.showExpandLeftMenu();
        }
    }

    private class SwitchRightFilterAction
    extends AbstractAction {
        private SwitchRightFilterAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FiltersToolBar.this.mapper.setFilter(FiltersToolBar.this.mapper.isFilterLeft(), !FiltersToolBar.this.mapper.isFilterRight());
        }
    }

    private class SwitchLeftFilterAction
    extends AbstractAction {
        private SwitchLeftFilterAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FiltersToolBar.this.mapper.setFilter(!FiltersToolBar.this.mapper.isFilterLeft(), FiltersToolBar.this.mapper.isFilterRight());
        }
    }
}

