/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore;

import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.Canvas;
import org.netbeans.modules.soa.mappercore.MapperKeyboardAction;
import org.netbeans.modules.soa.mappercore.SelectionModel;
import org.netbeans.modules.soa.mappercore.model.GraphSubset;
import org.netbeans.modules.soa.mappercore.model.MapperModel;

public class CutMapperAction
extends MapperKeyboardAction {
    public CutMapperAction(Canvas canvas) {
        super(canvas);
        this.putValue("Name", "Cut");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 128));
    }

    public String getActionKey() {
        return "Cut-Action";
    }

    public KeyStroke[] getShortcuts() {
        return new KeyStroke[]{KeyStroke.getKeyStroke(88, 128), KeyStroke.getKeyStroke(127, 64), KeyStroke.getKeyStroke(8, 256)};
    }

    public void actionPerformed(ActionEvent actionEvent) {
        SelectionModel selectionModel = this.canvas.getSelectionModel();
        TreePath treePath = selectionModel.getSelectedPath();
        if (treePath == null) {
            return;
        }
        MapperModel mapperModel = this.canvas.getMapperModel();
        GraphSubset graphSubset = selectionModel.getSelectedSubset();
        if (graphSubset != null) {
            this.canvas.setBufferCopyPaste(selectionModel.getSelectedSubset());
            mapperModel.delete(treePath, graphSubset);
        }
    }
}

