/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import javax.swing.Icon;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.groovy.grailsproject.SourceCategory;
import org.netbeans.modules.groovy.grailsproject.ui.wizards.GrailsArtifacts;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class GrailsSources
implements Sources {
    private final FileObject projectDir;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

    GrailsSources(FileObject fileObject) {
        this.projectDir = fileObject;
    }

    public SourceGroup[] getSourceGroups(String string) {
        if ("generic".equals(string)) {
            return new SourceGroup[]{new Group(SourceCategory.NONE, this.projectDir, this.projectDir.getName())};
        }
        if ("java".equals(string)) {
            return new SourceGroup[]{new Group(SourceCategory.SRC_JAVA, this.projectDir.getFileObject("src/java"), NbBundle.getMessage(GrailsSources.class, (String)"LBL_SrcJava"))};
        }
        if (string.startsWith(".")) {
            return new SourceGroup[0];
        }
        FileObject fileObject = this.projectDir.getFileObject(string);
        if (fileObject == null) {
            return new SourceGroup[]{new Group(SourceCategory.NONE, null, "")};
        }
        SourceCategory sourceCategory = GrailsArtifacts.getCategoryForFolder(this.projectDir, fileObject);
        switch (sourceCategory) {
            case CONFIGURATION: {
                return new SourceGroup[]{new Group(sourceCategory, fileObject, NbBundle.getMessage(GrailsSources.class, (String)"LBL_grails-app_conf"))};
            }
            case CONTROLLERS: {
                return new SourceGroup[]{new Group(sourceCategory, fileObject, NbBundle.getMessage(GrailsSources.class, (String)"LBL_grails-app_controllers"))};
            }
            case DOMAIN: {
                return new SourceGroup[]{new Group(sourceCategory, fileObject, NbBundle.getMessage(GrailsSources.class, (String)"LBL_grails-app_domain"))};
            }
            case INTEGRATION_TESTS: {
                return new SourceGroup[]{new Group(sourceCategory, fileObject, NbBundle.getMessage(GrailsSources.class, (String)"LBL_IntegrationTests"))};
            }
            case LIB: {
                return new SourceGroup[]{new Group(sourceCategory, fileObject, NbBundle.getMessage(GrailsSources.class, (String)"LBL_lib"))};
            }
            case MESSAGES: {
                return new SourceGroup[]{new Group(sourceCategory, fileObject, NbBundle.getMessage(GrailsSources.class, (String)"LBL_grails-app_i18n"))};
            }
            case SCRIPTS: {
                return new SourceGroup[]{new Group(sourceCategory, fileObject, NbBundle.getMessage(GrailsSources.class, (String)"LBL_scripts"))};
            }
            case SERVICES: {
                return new SourceGroup[]{new Group(sourceCategory, fileObject, NbBundle.getMessage(GrailsSources.class, (String)"LBL_grails-app_services"))};
            }
            case SRC_GROOVY: {
                return new SourceGroup[]{new Group(sourceCategory, fileObject, NbBundle.getMessage(GrailsSources.class, (String)"LBL_SrcGroovy"))};
            }
            case SRC_JAVA: {
                return new SourceGroup[]{new Group(sourceCategory, fileObject, NbBundle.getMessage(GrailsSources.class, (String)"LBL_SrcJava"))};
            }
            case TAGLIB: {
                return new SourceGroup[]{new Group(sourceCategory, fileObject, NbBundle.getMessage(GrailsSources.class, (String)"LBL_grails-app_taglib"))};
            }
            case UNIT_TESTS: {
                return new SourceGroup[]{new Group(sourceCategory, fileObject, NbBundle.getMessage(GrailsSources.class, (String)"LBL_UnitTests"))};
            }
            case UTIL: {
                return new SourceGroup[]{new Group(sourceCategory, fileObject, NbBundle.getMessage(GrailsSources.class, (String)"LBL_grails-app_utils"))};
            }
            case VIEWS: {
                return new SourceGroup[]{new Group(sourceCategory, fileObject, NbBundle.getMessage(GrailsSources.class, (String)"LBL_grails-app_views"))};
            }
            case WEBAPP: {
                return new SourceGroup[]{new Group(sourceCategory, fileObject, NbBundle.getMessage(GrailsSources.class, (String)"LBL_web-app"))};
            }
        }
        return new SourceGroup[]{new Group(SourceCategory.NONE, this.projectDir.getFileObject(string), string)};
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    private final class Group
    implements SourceGroup {
        private final FileObject loc;
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private final String displayName;
        private final SourceCategory category;

        public Group(SourceCategory sourceCategory, FileObject fileObject, String string) {
            this.loc = fileObject;
            this.displayName = string;
            this.category = sourceCategory;
        }

        public SourceCategory getSourceCategory() {
            return this.category;
        }

        public FileObject getRootFolder() {
            return this.loc;
        }

        public String getName() {
            String string = this.loc.getPath();
            return string.length() > 0 ? string : "generic";
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Icon getIcon(boolean bl) {
            return null;
        }

        public boolean contains(FileObject fileObject) throws IllegalArgumentException {
            if (fileObject == this.loc) {
                return true;
            }
            String string = FileUtil.getRelativePath((FileObject)this.loc, (FileObject)fileObject);
            if (string == null) {
                throw new IllegalArgumentException();
            }
            if (fileObject.isFolder()) {
                string = string + File.separator;
            }
            if (fileObject.isFolder() && fileObject != GrailsSources.this.projectDir && ProjectManager.getDefault().isProject(fileObject)) {
                return false;
            }
            File file = FileUtil.toFile((FileObject)fileObject);
            return file == null || SharabilityQuery.getSharability((File)file) != 2;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }

        public String toString() {
            return "GrailsSources.Group[name=" + this.getName() + ",rootFolder=" + this.getRootFolder() + "]";
        }
    }
}

