/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject;

import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.groovy.grailsproject.GrailsActionProvider;
import org.netbeans.modules.groovy.grailsproject.GrailsProjectOperations;
import org.netbeans.modules.groovy.grailsproject.GrailsServerState;
import org.netbeans.modules.groovy.grailsproject.GrailsSources;
import org.netbeans.modules.groovy.grailsproject.classpath.ClassPathProviderImpl;
import org.netbeans.modules.groovy.grailsproject.classpath.SourceRoots;
import org.netbeans.modules.groovy.grailsproject.queries.GrailsProjectEncodingQueryImpl;
import org.netbeans.modules.groovy.grailsproject.ui.GrailsLogicalViewProvider;
import org.netbeans.modules.groovy.grailsproject.ui.GrailsProjectCustomizerProvider;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.netbeans.modules.gsfpath.spi.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.ProjectState;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.openidex.search.SearchInfo;
import org.openidex.search.SearchInfoFactory;
import org.w3c.dom.Element;

public final class GrailsProject
implements Project {
    private final FileObject projectDir;
    private final ProjectState projectState;
    private final LogicalViewProvider logicalView;
    private final ClassPathProviderImpl cpProvider;
    private SourceRoots sourceRoots;
    private SourceRoots testRoots;
    private Lookup lookup;
    private final Logger LOG = Logger.getLogger(GrailsProject.class.getName());

    public GrailsProject(FileObject fileObject, ProjectState projectState) {
        this.projectDir = fileObject;
        this.projectState = projectState;
        this.logicalView = new GrailsLogicalViewProvider(this);
        this.cpProvider = new ClassPathProviderImpl(this.getSourceRoots(), this.getTestSourceRoots(), FileUtil.toFile((FileObject)fileObject));
    }

    public FileObject getProjectDirectory() {
        return this.projectDir;
    }

    public ProjectState getProjectState() {
        return this.projectState;
    }

    public Lookup getLookup() {
        if (this.lookup == null) {
            this.lookup = Lookups.fixed((Object[])new Object[]{this, this.projectState, new Info(), new GrailsActionProvider(this), new GrailsSources(this.projectDir), new GrailsServerState(this, this.getProjectDirectory().getName()), new GrailsProjectCustomizerProvider(this), new GrailsProjectOperations(this), new GrailsProjectEncodingQueryImpl(), new OpenHook(), new AuxiliaryConfigurationImpl(), this.getSearchInfo(this.projectDir), this.logicalView, this.cpProvider});
        }
        return this.lookup;
    }

    SearchInfo getSearchInfo(FileObject fileObject) {
        assert (fileObject != null);
        String[] stringArray = new String[]{"test", "src", "grails-app", "scripts"};
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        String string = FileUtil.getFileDisplayName((FileObject)fileObject) + File.separatorChar;
        this.LOG.log(Level.FINEST, "basedir = " + string);
        for (String string2 : stringArray) {
            this.LOG.log(Level.FINEST, "dir = " + string2);
            File file = new File(string + string2);
            if (file != null) {
                if (!file.isDirectory()) continue;
                arrayList.add(FileUtil.toFileObject((File)file));
                continue;
            }
            this.LOG.log(Level.FINEST, "Problem creating file = " + string + string2);
        }
        this.LOG.log(Level.FINEST, "foList: " + arrayList);
        String[] stringArray2 = arrayList.toArray(new FileObject[arrayList.size()]);
        assert (stringArray2.length == arrayList.size());
        return SearchInfoFactory.createSearchInfo((FileObject[])stringArray2, (boolean)true, null);
    }

    public synchronized SourceRoots getSourceRoots() {
        if (this.sourceRoots == null) {
            this.sourceRoots = new SourceRoots(this.projectDir);
        }
        return this.sourceRoots;
    }

    public synchronized SourceRoots getTestSourceRoots() {
        if (this.testRoots == null) {
            this.testRoots = new SourceRoots(this.projectDir);
        }
        return this.testRoots;
    }

    private static class AuxiliaryConfigurationImpl
    implements AuxiliaryConfiguration {
        private AuxiliaryConfigurationImpl() {
        }

        public Element getConfigurationFragment(String string, String string2, boolean bl) {
            return null;
        }

        public void putConfigurationFragment(Element element, boolean bl) throws IllegalArgumentException {
        }

        public boolean removeConfigurationFragment(String string, String string2, boolean bl) throws IllegalArgumentException {
            return false;
        }
    }

    private class OpenHook
    extends ProjectOpenedHook {
        private ClassPath cp;

        private OpenHook() {
        }

        protected void projectOpened() {
            org.netbeans.api.java.classpath.ClassPath[] classPathArray = GrailsProject.this.cpProvider.getProjectClassPaths("classpath/source");
            GlobalPathRegistry.getDefault().register("classpath/boot", GrailsProject.this.cpProvider.getProjectClassPaths("classpath/boot"));
            GlobalPathRegistry.getDefault().register("classpath/compile", GrailsProject.this.cpProvider.getProjectClassPaths("classpath/compile"));
            GlobalPathRegistry.getDefault().register("classpath/source", classPathArray);
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            for (org.netbeans.api.java.classpath.ClassPath classPath : classPathArray) {
                arrayList.addAll(Arrays.asList(classPath.getRoots()));
            }
            this.cp = ClassPathSupport.createClassPath((FileObject[])arrayList.toArray(new FileObject[arrayList.size()]));
            org.netbeans.modules.gsfpath.api.classpath.GlobalPathRegistry.getDefault().register("classpath/source", new ClassPath[]{this.cp});
        }

        protected void projectClosed() {
            GlobalPathRegistry.getDefault().unregister("classpath/boot", GrailsProject.this.cpProvider.getProjectClassPaths("classpath/boot"));
            GlobalPathRegistry.getDefault().unregister("classpath/compile", GrailsProject.this.cpProvider.getProjectClassPaths("classpath/compile"));
            GlobalPathRegistry.getDefault().unregister("classpath/source", GrailsProject.this.cpProvider.getProjectClassPaths("classpath/source"));
            if (this.cp != null) {
                org.netbeans.modules.gsfpath.api.classpath.GlobalPathRegistry.getDefault().unregister("classpath/source", new ClassPath[]{this.cp});
            }
        }
    }

    private final class Info
    implements ProjectInformation {
        private Info() {
        }

        public Icon getIcon() {
            Image image = Utilities.loadImage((String)"org/netbeans/modules/groovy/grailsproject/resources/GrailsIcon16x16.png");
            return new ImageIcon(image);
        }

        public String getName() {
            return GrailsProject.this.getProjectDirectory().getName();
        }

        public String getDisplayName() {
            return this.getName();
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public Project getProject() {
            return GrailsProject.this;
        }
    }
}

