/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.pull;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.pull.PullAction;
import org.netbeans.modules.mercurial.ui.repository.Repository;
import org.netbeans.modules.mercurial.ui.wizards.CloneRepositoryWizardPanel;
import org.netbeans.modules.mercurial.util.HgProjectUtils;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PullOtherAction
extends ContextAction
implements PropertyChangeListener {
    private final VCSContext context;
    private Repository repository = null;
    private JButton pullButton = null;
    private JButton cancelButton = null;

    public PullOtherAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    public void performAction(ActionEvent actionEvent) {
        String string;
        File file = HgUtils.getRootFile(this.context);
        if (file == null) {
            return;
        }
        if (this.repository == null) {
            int n = 102;
            string = NbBundle.getMessage(CloneRepositoryWizardPanel.class, (String)"CTL_Repository_Location");
            this.repository = new Repository(n, string, true);
            this.repository.addPropertyChangeListener(this);
        }
        this.pullButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.pullButton, (String)NbBundle.getMessage(PullOtherAction.class, (String)"CTL_Pull_Action_Pull"));
        this.pullButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PullOtherAction.class, (String)"ACSD_Pull_Action_Pull"));
        this.pullButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PullOtherAction.class, (String)"ACSN_Pull_Action_Pull"));
        this.cancelButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)NbBundle.getMessage(PullOtherAction.class, (String)"CTL_Pull_Action_Cancel"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PullOtherAction.class, (String)"ACSD_Pull_Action_Cancel"));
        this.cancelButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PullOtherAction.class, (String)"ACSN_Pull_Action_Cancel"));
        this.pullButton.setEnabled(false);
        Object object = this.repository.show(NbBundle.getMessage(PullOtherAction.class, (String)"CTL_PullDialog_Title"), new HelpCtx(PullOtherAction.class), new Object[]{this.pullButton, this.cancelButton}, true, "hg.pull.dialog");
        if (object == this.pullButton) {
            string = this.repository.getSelectedRC().getUrl();
            PullOtherAction.pull(this.context, file, string);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("valid")) {
            this.pullButton.setEnabled(this.repository.isValid());
        }
    }

    public static void pull(final VCSContext vCSContext, final File file, final String string) {
        if (file == null || string == null) {
            return;
        }
        String string2 = file.getAbsolutePath();
        final String string3 = NbBundle.getMessage(PullAction.class, (String)"MSG_EXTERNAL_REPOSITORY");
        final String string4 = HgProjectUtils.getProjectName(file);
        RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(file);
        HgProgressSupport hgProgressSupport = new HgProgressSupport(){

            public void perform() {
                PullAction.performPull(PullAction.PullType.OTHER, vCSContext, file, string, string3, string4, this.getLogger());
            }
        };
        hgProgressSupport.start(requestProcessor, string2, NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_PROGRESS"));
    }

    public boolean isEnabled() {
        return HgUtils.getRootFile(this.context) != null;
    }
}

