/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.io.File;
import java.io.IOException;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.util.HgCommand;

public class VersionsCache {
    private static VersionsCache instance;

    private VersionsCache() {
    }

    public static synchronized VersionsCache getInstance() {
        if (instance == null) {
            instance = new VersionsCache();
        }
        return instance;
    }

    public File getFileRevision(File file, String string) throws IOException {
        if (string.equals("-1")) {
            return null;
        }
        File file2 = Mercurial.getInstance().getTopmostManagedParent(file);
        if ("BASE".equals(string)) {
            try {
                File file3 = File.createTempFile("tmp", "-" + file.getName());
                file3.deleteOnExit();
                HgCommand.doCat(file2, file, file3, null);
                if (file3.length() == 0L) {
                    return null;
                }
                return file3;
            }
            catch (HgException hgException) {
                IOException iOException = new IOException();
                iOException.initCause(hgException);
                throw iOException;
            }
        }
        if ("LOCAL".equals(string)) {
            return file;
        }
        try {
            File file4 = File.createTempFile("tmp", "-" + file.getName());
            file4.deleteOnExit();
            HgCommand.doCat(file2, file, file4, string, null);
            if (file4.length() == 0L) {
                return null;
            }
            return file4;
        }
        catch (HgException hgException) {
            IOException iOException = new IOException();
            iOException.initCause(hgException);
            throw iOException;
        }
    }
}

