/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.mobility.project.ui.wizard.Utils;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ProjectPanel
extends JPanel {
    private static final Dimension PREF_DIM = new Dimension(500, 340);
    public static final String PROJECT_NAME = "ProjectName";
    public static final String PROJECTS_HOME = "ProjectsHome";
    public static final String PROJECT_LOCATION = "ProjectLocation";
    public static final String PROJECT_MAIN = "setAsMain";
    public static final String PROJECT_CREATE_MIDLET = "CreateMidlet";
    public static final String PROJECT_COPY_SOURCES = "CopySources";
    private JButton bBrowse;
    private ButtonGroup buttonGroup1;
    private JCheckBox cCreateMIDlet;
    private JCheckBox cMainProject;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel2;
    private JRadioButton jRadioCopySrc;
    private JRadioButton jRadioEmptySrc;
    private JSeparator jSeparator1;
    private JTextField tCreated;
    private JTextField tHome;
    private JTextField tName;

    public ProjectPanel(boolean bl, boolean bl2, boolean bl3) {
        this.initComponents();
        this.initAccessibility();
        this.cCreateMIDlet.setVisible(bl);
        this.cMainProject.setVisible(bl2);
        this.cMainProject.setSelected(true);
        this.jLabel4.setVisible(bl3);
        this.jRadioCopySrc.setVisible(bl3);
        this.jRadioEmptySrc.setVisible(bl3);
    }

    public void addNotify() {
        super.addNotify();
        this.tName.requestFocus();
    }

    public void addListeners(DocumentListener documentListener, ItemListener itemListener) {
        this.tName.getDocument().addDocumentListener(documentListener);
        this.tHome.getDocument().addDocumentListener(documentListener);
        this.cMainProject.addItemListener(itemListener);
        this.cCreateMIDlet.addItemListener(itemListener);
    }

    public void removeListeners(DocumentListener documentListener, ItemListener itemListener) {
        this.tName.getDocument().removeDocumentListener(documentListener);
        this.tHome.getDocument().removeDocumentListener(documentListener);
        this.cMainProject.removeItemListener(itemListener);
        this.cCreateMIDlet.removeItemListener(itemListener);
    }

    private static String camelize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                bl = true;
                continue;
            }
            if (bl) {
                c = Character.toUpperCase(c);
                bl = false;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public void readData(WizardDescriptor wizardDescriptor) {
        String string = (String)wizardDescriptor.getProperty(PROJECT_NAME);
        if (string == null) {
            string = "My Project";
        }
        this.tName.setText(ProjectPanel.camelize(string));
        File file = (File)wizardDescriptor.getProperty(PROJECT_LOCATION);
        if (file != null) {
            this.tCreated.setText(file.getAbsolutePath());
        } else {
            File file2 = ProjectChooser.getProjectsFolder();
            this.tHome.setText(file2 != null ? file2.getAbsolutePath() : System.getProperty("user.home", ""));
            if (this.testIfProjectNameExists()) {
                String string2 = this.getProjectName();
                if (string2.endsWith("1")) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                int n = 2;
                while (true) {
                    this.tName.setText(string2 + n);
                    if (!this.testIfProjectNameExists()) break;
                    ++n;
                }
            }
            this.tName.selectAll();
        }
        Boolean bl = (Boolean)wizardDescriptor.getProperty(PROJECT_MAIN);
        this.cMainProject.setSelected(bl == null ? true : bl);
        bl = (Boolean)wizardDescriptor.getProperty(PROJECT_CREATE_MIDLET);
        this.cCreateMIDlet.setSelected(bl == null ? true : bl);
        bl = (Boolean)wizardDescriptor.getProperty(PROJECT_COPY_SOURCES);
        this.jRadioEmptySrc.setSelected(bl == null ? true : bl == false);
        this.jRadioCopySrc.setSelected(bl == null ? false : bl);
    }

    private boolean testIfProjectNameExists() {
        boolean bl;
        File file = new File(this.getProjectsHome());
        boolean bl2 = bl = file.exists() && file.isDirectory() && file.canWrite();
        if (!bl) {
            return false;
        }
        return new File(file, this.getProjectName()).exists();
    }

    public void storeData(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty(PROJECT_NAME, (Object)this.tName.getText().trim());
        wizardDescriptor.putProperty(PROJECTS_HOME, (Object)this.tHome.getText());
        wizardDescriptor.putProperty(PROJECT_LOCATION, (Object)new File(this.tCreated.getText()).getAbsoluteFile());
        wizardDescriptor.putProperty(PROJECT_MAIN, (Object)(this.cMainProject.isVisible() && this.cMainProject.isSelected() ? 1 : 0));
        wizardDescriptor.putProperty(PROJECT_CREATE_MIDLET, (Object)(this.cCreateMIDlet.isVisible() && this.cCreateMIDlet.isSelected() ? 1 : 0));
        wizardDescriptor.putProperty(PROJECT_COPY_SOURCES, (Object)(this.jRadioCopySrc.isVisible() && this.jRadioCopySrc.isSelected() ? 1 : 0));
    }

    public String getProjectName() {
        return this.tName.getText().trim();
    }

    public String getProjectsHome() {
        return this.tHome.getText();
    }

    public void setCreated(String string) {
        this.tCreated.setText(string);
    }

    public String getCreated() {
        return this.tCreated.getText();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.tName = new JTextField();
        this.jLabel2 = new JLabel();
        this.tHome = new JTextField();
        this.bBrowse = new JButton();
        this.jLabel3 = new JLabel();
        this.tCreated = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.cMainProject = new JCheckBox();
        this.cCreateMIDlet = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.jRadioEmptySrc = new JRadioButton();
        this.jRadioCopySrc = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.setName(NbBundle.getMessage(ProjectPanel.class, (String)"TITLE_Project"));
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.tName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ProjectPanel.class, (String)"LBL_Project_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 6, 6);
        this.add((Component)this.tName, gridBagConstraints);
        this.jLabel2.setLabelFor(this.tHome);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ProjectPanel.class, (String)"LBL_Projects_Home"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 6, 6);
        this.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 6, 6);
        this.add((Component)this.tHome, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bBrowse, (String)NbBundle.getMessage(ProjectPanel.class, (String)"LBL_Project_Browse"));
        this.bBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectPanel.this.bBrowseActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 6, 0);
        this.add((Component)this.bBrowse, gridBagConstraints);
        this.jLabel3.setLabelFor(this.tCreated);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(ProjectPanel.class, (String)"LBL_Project_Created"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 6, 6);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.tCreated.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 6, 6);
        this.add((Component)this.tCreated, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 12, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.cMainProject.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cMainProject, (String)NbBundle.getMessage(ProjectPanel.class, (String)"LBL_Project_SetAsMainProject"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 6, 0);
        this.add((Component)this.cMainProject, gridBagConstraints);
        this.cCreateMIDlet.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cCreateMIDlet, (String)NbBundle.getMessage(ProjectPanel.class, (String)"LBL_Project_CreateMIDlet"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 6, 0);
        this.add((Component)this.cCreateMIDlet, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(ProjectPanel.class, (String)"LBL_ProjectSources"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 6);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioEmptySrc);
        this.jRadioEmptySrc.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioEmptySrc, (String)NbBundle.getMessage(ProjectPanel.class, (String)"LBL_EmptySources"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.jRadioEmptySrc, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioCopySrc);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioCopySrc, (String)NbBundle.getMessage(ProjectPanel.class, (String)"LBL_CopySources"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 6, 0);
        this.add((Component)this.jRadioCopySrc, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectPanel.class, (String)"ACSN_Project"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectPanel.class, (String)"ACSD_Project"));
    }

    public Dimension getPreferredSize() {
        return PREF_DIM;
    }

    private void bBrowseActionPerformed(ActionEvent actionEvent) {
        String string = Utils.browseFolder(this, this.tHome.getText(), NbBundle.getMessage(ProjectPanel.class, (String)"TITLE_Project_Home"));
        if (string != null) {
            this.tHome.setText(string);
        }
    }

    public static class WizardPanel
    implements WizardDescriptor.FinishablePanel,
    DocumentListener,
    ItemListener {
        ProjectPanel component;
        TemplateWizard wizard;
        Collection<ChangeListener> listeners = new ArrayList<ChangeListener>();
        boolean valid = false;
        boolean showCreateMIDlet;
        boolean showSetAsMain;
        boolean showCopySources;

        public WizardPanel(boolean bl, boolean bl2) {
            this(bl, bl2, false);
        }

        public WizardPanel(boolean bl, boolean bl2, boolean bl3) {
            this.showCreateMIDlet = bl;
            this.showSetAsMain = bl2;
            this.showCopySources = bl3;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.listeners.add(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.listeners.remove(changeListener);
        }

        public Component getComponent() {
            if (this.component == null) {
                this.component = new ProjectPanel(this.showCreateMIDlet, this.showSetAsMain, this.showCopySources);
                this.component.addListeners(this, this);
                this.checkValid();
            }
            return this.component;
        }

        public HelpCtx getHelp() {
            return new HelpCtx(ProjectPanel.class);
        }

        public boolean isFinishPanel() {
            return true;
        }

        public void showError(String string) {
            if (this.wizard != null) {
                this.wizard.putProperty("WizardPanel_errorMessage", (Object)string);
            }
        }

        private boolean isLatin1(String string) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c >= ' ' && c <= '\u007f') continue;
                return false;
            }
            return true;
        }

        private File getCanonicalFile(File file) {
            try {
                return file.getCanonicalFile();
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public boolean isValid() {
            File file;
            if (this.component.getProjectName().length() == 0) {
                this.showError(NbBundle.getMessage(ProjectPanel.class, (String)"ERR_Project_InvalidProjectsName"));
                return false;
            }
            File file2 = this.getCanonicalFile(new File(this.component.getProjectsHome()).getAbsoluteFile());
            if (file2 == null) {
                this.showError(NbBundle.getMessage(ProjectPanel.class, (String)"ERR_Project_InvalidProjectsHome"));
                return false;
            }
            File file3 = this.getCanonicalFile(new File(this.component.getCreated()).getAbsoluteFile());
            if (file3 == null) {
                this.showError(NbBundle.getMessage(ProjectPanel.class, (String)"ERR_Project_InvalidProjectsName"));
                return false;
            }
            for (file = file3; file != null && !file.exists(); file = file.getParentFile()) {
            }
            if (file == null || !file.canWrite()) {
                this.showError(NbBundle.getMessage(ProjectPanel.class, (String)"ERR_Project_ProjectFolderReadOnly"));
                return false;
            }
            if (FileUtil.toFileObject((File)file) == null) {
                this.showError(NbBundle.getMessage(ProjectPanel.class, (String)"ERR_Project_InvalidProjectsHome"));
                return false;
            }
            File[] fileArray = file3.listFiles();
            if (file3.exists() && fileArray != null && fileArray.length > 0) {
                this.showError(NbBundle.getMessage(ProjectPanel.class, (String)"ERR_Project_ProjectAlreadyExists"));
                return false;
            }
            if (!this.isLatin1(this.component.getProjectName())) {
                this.showError(NbBundle.getMessage(ProjectPanel.class, (String)"WARN_Project_InvalidCharacters"));
            } else {
                this.showError(null);
            }
            return true;
        }

        public void readSettings(Object object) {
            this.wizard = (TemplateWizard)object;
            ((ProjectPanel)this.getComponent()).readData((WizardDescriptor)this.wizard);
            Component component = this.getComponent();
            Object object2 = ((JComponent)component).getClientProperty("NewProjectWizard_Title");
            if (object2 != null) {
                this.wizard.putProperty("NewProjectWizard_Title", object2);
            }
        }

        public void storeSettings(Object object) {
            this.wizard = (TemplateWizard)object;
            ((ProjectPanel)this.getComponent()).storeData((WizardDescriptor)this.wizard);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireStateChange() {
            ChangeListener[] changeListenerArray;
            Object object = this;
            synchronized (object) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                changeListenerArray = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            }
            object = new ChangeEvent(this);
            for (int i = 0; i < changeListenerArray.length; ++i) {
                changeListenerArray[i].stateChanged((ChangeEvent)object);
            }
        }

        void checkValid() {
            this.component.setCreated(this.component.getProjectsHome() + File.separator + this.component.getProjectName());
            if (this.isValid() != this.valid) {
                this.valid ^= true;
                this.fireStateChange();
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.checkValid();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.checkValid();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.checkValid();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
        }
    }
}

