/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.SwingUtilities;
import org.netbeans.modules.websvc.manager.WebServiceManager;
import org.netbeans.modules.websvc.manager.model.WebServiceData;
import org.netbeans.modules.websvc.manager.model.WebServiceListModel;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlData;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlDataManager;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class WsdlDataManagerImpl
implements WsdlDataManager {
    public WsdlData getWsdlData(String string, String string2, boolean bl) {
        return WebServiceListModel.getInstance().getWebServiceData(string, string2, bl);
    }

    public WsdlData addWsdlData(String string, String string2) {
        final WebServiceData webServiceData = new WebServiceData(string, "default");
        webServiceData.setPackageName(string2);
        webServiceData.setResolved(false);
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    WebServiceManager.getInstance().addWebService(webServiceData, true);
                }
                catch (IOException iOException) {
                    WsdlDataManagerImpl.this.handleException(iOException);
                }
            }
        };
        RequestProcessor.getDefault().post(runnable);
        return webServiceData;
    }

    public void removeWsdlData(String string, String string2) {
        WebServiceData webServiceData = WebServiceListModel.getInstance().findWebServiceData(string, string2, true);
        if (webServiceData != null) {
            WebServiceManager.getInstance().removeWebService(webServiceData);
        }
    }

    public WsdlData findWsdlData(String string, String string2) {
        return WebServiceListModel.getInstance().findWebServiceData(string, string2, true);
    }

    public void refresh(WsdlData wsdlData) {
        if (wsdlData instanceof WebServiceData) {
            final WebServiceData webServiceData = (WebServiceData)wsdlData;
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        WebServiceManager.getInstance().refreshWebService(webServiceData);
                    }
                    catch (IOException iOException) {
                        WsdlDataManagerImpl.this.handleException(iOException);
                    }
                }
            };
            RequestProcessor.getDefault().post(runnable);
        }
    }

    private void handleException(final Exception exception) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (exception instanceof FileNotFoundException) {
                    String string = NbBundle.getMessage(WebServiceListModel.class, (String)"INVALID_URL");
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                } else {
                    String string = exception != null ? exception.getLocalizedMessage() : null;
                    String string2 = exception != null ? exception.getClass().getName() + " - " + string : null;
                    String string3 = NbBundle.getMessage(WebServiceListModel.class, (String)"WS_ADD_ERROR") + "\n\n" + string2;
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string3);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                }
            }
        });
    }
}

