/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.spi;

import java.awt.Image;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.modules.web.core.syntax.spi.JSPColoringData;
import org.netbeans.modules.web.jsps.parserapi.JspParserAPI;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public abstract class JspContextInfo {
    public static final String CONTEXT_NAME = "/J2EE/JSPSyntaxColoring/";
    private static Hashtable<String, JspContextInfo> instances = new Hashtable();

    public static synchronized JspContextInfo getContextInfo(FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        JspContextInfo jspContextInfo = instances.get(fileObject.getMIMEType());
        if (jspContextInfo == null) {
            FileObject fileObject2 = Repository.getDefault().getDefaultFileSystem().findResource(CONTEXT_NAME + fileObject.getMIMEType());
            if (fileObject2 != null) {
                try {
                    DataFolder dataFolder = (DataFolder)DataObject.find((FileObject)fileObject2).getCookie(DataFolder.class);
                    DataObject[] dataObjectArray = dataFolder.getChildren();
                    for (int i = 0; i < dataObjectArray.length; ++i) {
                        InstanceCookie instanceCookie = (InstanceCookie)dataObjectArray[i].getCookie(InstanceCookie.class);
                        Object object = instanceCookie.instanceCreate();
                        if (!(object instanceof JspContextInfo)) continue;
                        jspContextInfo = (JspContextInfo)object;
                        instances.put(fileObject.getMIMEType(), jspContextInfo);
                    }
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    Logger.getLogger("global").log(Level.WARNING, null, dataObjectNotFoundException);
                }
                catch (IOException iOException) {
                    Logger.getLogger("global").log(Level.WARNING, null, iOException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Logger.getLogger("global").log(Level.WARNING, null, classNotFoundException);
                }
            }
            if (jspContextInfo == null) {
                Logger.getLogger("global").log(Level.WARNING, null, new Exception(NbBundle.getBundle(JspContextInfo.class).getString("EXC_JspContextInfoNotInstalled")));
            }
        }
        return jspContextInfo;
    }

    public abstract JSPColoringData getJSPColoringData(Document var1, FileObject var2);

    public abstract JspParserAPI.ParseResult getCachedParseResult(Document var1, FileObject var2, boolean var3, boolean var4, boolean var5);

    public abstract JspParserAPI.ParseResult getCachedParseResult(Document var1, FileObject var2, boolean var3, boolean var4);

    public abstract JspParserAPI.JspOpenInfo getCachedOpenInfo(Document var1, FileObject var2, boolean var3);

    public abstract URLClassLoader getModuleClassLoader(Document var1, FileObject var2);

    public abstract FileObject guessWebModuleRoot(Document var1, FileObject var2);

    public abstract Map getTaglibMap(Document var1, FileObject var2);

    public abstract Image getIcon(Document var1, FileObject var2);
}

