/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.completion;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.modules.web.core.syntax.JSPKit;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.core.syntax.SyntaxElement;
import org.netbeans.modules.web.core.syntax.completion.AttrSupports;
import org.netbeans.modules.web.core.syntax.completion.AttributeValueSupport;
import org.netbeans.modules.web.core.syntax.completion.ELExpression;
import org.netbeans.modules.web.core.syntax.completion.ELFunctions;
import org.netbeans.modules.web.core.syntax.completion.ELImplicitObjects;
import org.netbeans.modules.web.core.syntax.completion.JspCompletionItem;
import org.netbeans.modules.web.core.syntax.completion.ResultItem;
import org.netbeans.modules.web.core.syntax.deprecated.JspTagTokenContext;
import org.netbeans.modules.web.jsps.parserapi.PageInfo;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.openide.util.NbBundle;

public class JspCompletionQuery {
    private static final Set<String> stdXMLEntities = new TreeSet<String>();

    public CompletionQuery.Result query(JTextComponent jTextComponent, int n) {
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        JspSyntaxSupport jspSyntaxSupport = JspSyntaxSupport.get((Document)baseDocument);
        try {
            SyntaxElement syntaxElement = jspSyntaxSupport.getElementChain(n);
            if (syntaxElement == null) {
                return null;
            }
            switch (syntaxElement.getCompletionContext()) {
                case 1: {
                    return this.queryJspTag(jTextComponent, n, jspSyntaxSupport, (SyntaxElement.Tag)syntaxElement);
                }
                case 2: {
                    CompletionData completionData = this.queryJspEndTag(n, jspSyntaxSupport, (SyntaxElement.EndTag)syntaxElement, baseDocument);
                    return this.result(jTextComponent, n, completionData);
                }
                case 7: {
                    return this.queryJspDirectiveInScriptlet(jTextComponent, n, jspSyntaxSupport, syntaxElement, baseDocument);
                }
                case 3: {
                    return this.queryJspDirective(jTextComponent, n, jspSyntaxSupport, (SyntaxElement.Directive)syntaxElement, baseDocument);
                }
                case 9: {
                    return this.queryEL(jTextComponent, n, jspSyntaxSupport, syntaxElement, baseDocument);
                }
                case 6: {
                    CompletionData completionData = this.queryJspTagInContent(n, jspSyntaxSupport, baseDocument);
                    CompletionQuery.Result result = this.queryJspDirectiveInContent(jTextComponent, n, jspSyntaxSupport, baseDocument);
                    if (completionData.completionItems.isEmpty() && result.getData().isEmpty()) {
                        return null;
                    }
                    CompletionQuery.Result result2 = this.result(jTextComponent, n, completionData);
                    ArrayList arrayList = new ArrayList();
                    arrayList.addAll(result.getData());
                    arrayList.addAll(result2.getData());
                    JspCompletionResult jspCompletionResult = new JspCompletionResult(jTextComponent, NbBundle.getMessage(JSPKit.class, (String)"CTL_JSP_Completion_Title"), arrayList, n, completionData.removeLength, -1);
                    return jspCompletionResult;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return null;
    }

    private void filterNonStandardXMLEntities(List list, List list2) {
        for (CompletionQuery.ResultItem resultItem : list2) {
            String string = resultItem.getItemText();
            boolean bl = false;
            if (string.startsWith("&") && string.endsWith(";") && !stdXMLEntities.contains(string)) {
                bl = true;
            }
            if (bl) continue;
            list.add(resultItem);
        }
    }

    private void setResultItemsOffset(List list, int n, int n2) {
        for (Object e : list) {
            if (!(e instanceof ResultItem)) continue;
            ((ResultItem)e).setSubstituteOffset(n2 - n);
        }
    }

    private void setResultItemsOffset(CompletionData completionData, int n) {
        this.setResultItemsOffset(completionData.completionItems, completionData.removeLength, n);
    }

    protected CompletionQuery.Result queryJspTag(JTextComponent jTextComponent, int n, JspSyntaxSupport jspSyntaxSupport, SyntaxElement.Tag tag) throws BadLocationException {
        Object object;
        String string;
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        ArrayList<CompletionItem> arrayList = new ArrayList<CompletionItem>();
        int n2 = 0;
        TokenItem tokenItem = jspSyntaxSupport.getItemAtOrBefore(n);
        if (tokenItem == null) {
            return this.result(jTextComponent, n, new CompletionData(arrayList, 0));
        }
        TokenID tokenID = tokenItem.getTokenID();
        String string2 = tokenItem.getImage().substring(0, n - tokenItem.getOffset());
        String string3 = tokenItem.getImage().trim();
        if (tokenID == JspTagTokenContext.SYMBOL) {
            if (string2.equals("<")) {
                n2 = 0;
                this.addTagPrefixItems(jspSyntaxSupport, arrayList, jspSyntaxSupport.getTagPrefixes(""));
            }
            if (string2.endsWith("\"") && (string = this.findAttributeForValue(jspSyntaxSupport, tokenItem)) != null && (object = AttributeValueSupport.getSupport(true, tag.getName(), string)) != null) {
                return ((AttributeValueSupport)object).getResult(jTextComponent, n, jspSyntaxSupport, tag, "");
            }
            if (string2.endsWith(">") && !string2.endsWith("/>")) {
                arrayList.add(jspSyntaxSupport.getAutocompletedEndTag(n));
            }
        }
        if (tokenID == JspTagTokenContext.TAG || tokenID == JspTagTokenContext.WHITESPACE || tokenID == JspTagTokenContext.EOL) {
            if (this.isBlank(string2.charAt(string2.length() - 1)) || string2.equals("\n")) {
                n2 = 0;
                this.addAttributeItems(jspSyntaxSupport, arrayList, tag, jspSyntaxSupport.getTagAttributes(tag.getName(), ""), null);
            } else {
                int n3 = string2.indexOf(":");
                if (n3 == -1) {
                    n2 = string2.length();
                    this.addTagPrefixItems(jspSyntaxSupport, arrayList, jspSyntaxSupport.getTagPrefixes(string2));
                } else {
                    object = string2.substring(0, n3);
                    n2 = string2.length();
                    this.addTagPrefixItems(jspSyntaxSupport, arrayList, (String)object, jspSyntaxSupport.getTags(string2), tag);
                }
            }
        }
        if (tokenID == JspTagTokenContext.ATTRIBUTE) {
            if (this.isBlank(string2.charAt(string2.length() - 1))) {
                n2 = 0;
                this.addAttributeItems(jspSyntaxSupport, arrayList, tag, jspSyntaxSupport.getTagAttributes(tag.getName(), ""), null);
            } else {
                n2 = string2.length();
                this.addAttributeItems(jspSyntaxSupport, arrayList, tag, jspSyntaxSupport.getTagAttributes(tag.getName(), string2), string3);
            }
        }
        if (tokenID == JspTagTokenContext.ATTR_VALUE) {
            AttributeValueSupport attributeValueSupport;
            string = string2.trim();
            if (string.length() == 0) {
                return this.result(jTextComponent, n, new CompletionData(arrayList, 0));
            }
            for (tokenItem = tokenItem.getPrevious(); tokenItem != null && tokenItem.getTokenID() == JspTagTokenContext.ATTR_VALUE; tokenItem = tokenItem.getPrevious()) {
                string = tokenItem.getImage() + string;
            }
            string = string.substring(1);
            n2 = string.length();
            object = this.findAttributeForValue(jspSyntaxSupport, tokenItem);
            if (object != null && (attributeValueSupport = AttributeValueSupport.getSupport(true, tag.getName(), (String)object)) != null) {
                CompletionQuery.Result result = attributeValueSupport.getResult(jTextComponent, n, jspSyntaxSupport, tag, string);
                if (!(attributeValueSupport instanceof AttrSupports.FilenameSupport)) {
                    this.setResultItemsOffset(result.getData(), string.length(), n);
                }
                return result;
            }
        }
        return this.result(jTextComponent, n, new CompletionData(arrayList, n2));
    }

    protected CompletionData queryJspEndTag(int n, JspSyntaxSupport jspSyntaxSupport, SyntaxElement.EndTag endTag, BaseDocument baseDocument) throws BadLocationException {
        ArrayList arrayList = new ArrayList();
        int n2 = 0;
        TokenItem tokenItem = jspSyntaxSupport.getItemAtOrBefore(n);
        if (tokenItem == null) {
            return new CompletionData(arrayList, 0);
        }
        TokenID tokenID = tokenItem.getTokenID();
        String string = tokenItem.getImage().substring(0, n - tokenItem.getOffset());
        n2 = string.length();
        return new CompletionData(jspSyntaxSupport.getPossibleEndTags(n, string), n2);
    }

    protected CompletionQuery.Result queryEL(JTextComponent jTextComponent, int n, JspSyntaxSupport jspSyntaxSupport, SyntaxElement syntaxElement, BaseDocument baseDocument) throws BadLocationException {
        ELExpression eLExpression = new ELExpression(jspSyntaxSupport);
        ArrayList<CompletionItem> arrayList = new ArrayList<CompletionItem>();
        switch (eLExpression.parse(n)) {
            case 1: {
                for (ELImplicitObjects.ELImplicitObject eLImplicitObject : ELImplicitObjects.getELImplicitObjects(eLExpression.getReplace())) {
                    arrayList.add(new JspCompletionItem.ELImplicitObject(eLImplicitObject.getName(), eLImplicitObject.getType()));
                }
                PageInfo.BeanData[] beanDataArray = jspSyntaxSupport.getBeanData();
                if (beanDataArray != null) {
                    for (int i = 0; i < beanDataArray.length; ++i) {
                        if (!beanDataArray[i].getId().startsWith(eLExpression.getReplace())) continue;
                        arrayList.add(new JspCompletionItem.ELBean(beanDataArray[i].getId(), beanDataArray[i].getClassName()));
                    }
                }
                List list = ELFunctions.getFunctions(jspSyntaxSupport, eLExpression.getReplace());
                for (ELFunctions.Function function : list) {
                    arrayList.add(new JspCompletionItem.ELFunction(function.getPrefix(), function.getName(), function.getReturnType(), function.getParameters()));
                }
                break;
            }
            case 2: 
            case 3: {
                List<CompletionItem> list = eLExpression.getPropertyCompletionItems(eLExpression.getObjectClass());
                arrayList.addAll(list);
            }
        }
        return this.result(jTextComponent, n, new CompletionData(arrayList, eLExpression.getReplace().length()));
    }

    protected CompletionQuery.Result queryJspDirectiveInScriptlet(JTextComponent jTextComponent, int n, JspSyntaxSupport jspSyntaxSupport, SyntaxElement syntaxElement, BaseDocument baseDocument) throws BadLocationException {
        ArrayList arrayList = new ArrayList();
        TokenItem tokenItem = jspSyntaxSupport.getItemAtOrBefore(n);
        if (tokenItem == null) {
            return this.result(jTextComponent, n, new CompletionData(arrayList, 0));
        }
        TokenID tokenID = tokenItem.getTokenID();
        String string = tokenItem.getImage().substring(0, n - tokenItem.getOffset());
        if (tokenID == JspTagTokenContext.SYMBOL2 && string.equals("<%")) {
            this.addDirectiveItems(jspSyntaxSupport, arrayList, jspSyntaxSupport.getDirectives(""));
        }
        return this.result(jTextComponent, n, new CompletionData(arrayList, 1));
    }

    protected CompletionQuery.Result queryJspDirective(JTextComponent jTextComponent, int n, JspSyntaxSupport jspSyntaxSupport, SyntaxElement.Directive directive, BaseDocument baseDocument) throws BadLocationException {
        TokenID tokenID;
        Object object;
        Object object2;
        String string;
        ArrayList arrayList = new ArrayList();
        int n2 = 0;
        TokenItem tokenItem = jspSyntaxSupport.getItemAtOrBefore(n);
        if (tokenItem == null) {
            return this.result(jTextComponent, n, new CompletionData(arrayList, 0));
        }
        TokenID tokenID2 = tokenItem.getTokenID();
        String string2 = tokenItem.getImage().substring(0, n - tokenItem.getOffset());
        String string3 = tokenItem.getImage().trim();
        if (tokenID2.getNumericID() == 4) {
            if (string2.startsWith("<")) {
                n2 = string2.length() - 1;
                this.addDirectiveItems(jspSyntaxSupport, arrayList, jspSyntaxSupport.getDirectives(""));
            }
            if (string2.endsWith("\"") && (string = this.findAttributeForValue(jspSyntaxSupport, tokenItem)) != null && (object2 = AttributeValueSupport.getSupport(false, directive.getName(), string)) != null) {
                return ((AttributeValueSupport)object2).getResult(jTextComponent, n, jspSyntaxSupport, directive, "");
            }
        }
        if (tokenID2.getNumericID() == 3 || tokenID2.getNumericID() == 11 || tokenID2.getNumericID() == 9) {
            if (this.isBlank(string2.charAt(string2.length() - 1)) || string2.equals("\n")) {
                string = tokenItem.getPrevious();
                object2 = string.getTokenID();
                object = string.getImage().trim();
                if (object2.getNumericID() == 3 || object2.getNumericID() == 8 || object2.getNumericID() == 11 || object2.getNumericID() == 9) {
                    n2 = 0;
                    this.addAttributeItems(jspSyntaxSupport, arrayList, directive, jspSyntaxSupport.getDirectiveAttributes(directive.getName(), ""), null);
                } else if (object2.getNumericID() == 4 && ((String)object).equals("<%@")) {
                    n2 = string2.length() + 2;
                    this.addDirectiveItems(jspSyntaxSupport, arrayList, jspSyntaxSupport.getDirectives(""));
                }
            } else {
                Object e;
                List list;
                boolean bl = true;
                int n3 = 0;
                object = tokenItem.getPrevious();
                tokenID = object.getTokenID();
                if (tokenID.getNumericID() == 3 && "".equals(object.getImage().trim())) {
                    n3 = object.getImage().length();
                }
                if ((list = jspSyntaxSupport.getDirectives(string2)).size() == 1 && (e = list.get(0)) instanceof TagInfo && ((TagInfo)e).getTagName().equalsIgnoreCase(string2)) {
                    bl = false;
                }
                if (bl) {
                    n2 = n3 + string2.length() + 2;
                    this.addDirectiveItems(jspSyntaxSupport, arrayList, list);
                }
            }
        }
        if (tokenID2.getNumericID() == 7) {
            if (this.isBlank(string2.charAt(string2.length() - 1))) {
                n2 = 0;
                this.addAttributeItems(jspSyntaxSupport, arrayList, directive, jspSyntaxSupport.getDirectiveAttributes(directive.getName(), ""), null);
            } else {
                n2 = string2.length();
                this.addAttributeItems(jspSyntaxSupport, arrayList, directive, jspSyntaxSupport.getDirectiveAttributes(directive.getName(), string2), string3);
            }
        }
        if (tokenID2.getNumericID() == 8) {
            String string4 = string2;
            for (tokenItem = tokenItem.getPrevious(); tokenItem != null && (tokenItem.getTokenID().getNumericID() == 8 || tokenItem.getTokenID().getNumericID() == 9); tokenItem = tokenItem.getPrevious()) {
                string4 = tokenItem.getImage() + string4;
            }
            string4 = string4.substring(1);
            n2 = string4.length();
            String string5 = this.findAttributeForValue(jspSyntaxSupport, tokenItem);
            if (string5 != null && (object = AttributeValueSupport.getSupport(false, directive.getName(), string5)) != null) {
                tokenID = ((AttributeValueSupport)object).getResult(jTextComponent, n, jspSyntaxSupport, directive, string4);
                if (!(object instanceof AttrSupports.FilenameSupport)) {
                    this.setResultItemsOffset(tokenID.getData(), string4.length(), n);
                }
                return tokenID;
            }
        }
        return this.result(jTextComponent, n, new CompletionData(arrayList, n2));
    }

    protected CompletionData queryJspTagInContent(int n, JspSyntaxSupport jspSyntaxSupport, BaseDocument baseDocument) throws BadLocationException {
        List list = new ArrayList();
        int n2 = 0;
        TokenItem tokenItem = jspSyntaxSupport.getItemAtOrBefore(n);
        if (tokenItem == null) {
            return new CompletionData(list, 0);
        }
        String string = tokenItem.getImage().substring(0, n - tokenItem.getOffset() >= tokenItem.getImage().length() ? tokenItem.getImage().length() : n - tokenItem.getOffset());
        int n3 = string.lastIndexOf(60);
        if (n3 != -1) {
            string = string.substring(n3 + 1);
        }
        while (n3 == -1) {
            if ((tokenItem = tokenItem.getPrevious()) == null) {
                return new CompletionData(list, 0);
            }
            String string2 = tokenItem.getImage();
            n3 = string2.lastIndexOf(60);
            string = n3 != -1 ? string2.substring(n3 + 1) + string : string2 + string;
            if (string.length() <= 20) continue;
            return new CompletionData(list, 0);
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
            list = jspSyntaxSupport.getPossibleEndTags(n, string, true);
        } else {
            this.addTagPrefixItems(jspSyntaxSupport, list, jspSyntaxSupport.getTagPrefixes(string));
        }
        n2 = string.length();
        return new CompletionData(list, n2);
    }

    protected CompletionQuery.Result queryJspDirectiveInContent(JTextComponent jTextComponent, int n, JspSyntaxSupport jspSyntaxSupport, BaseDocument baseDocument) throws BadLocationException {
        ArrayList arrayList = new ArrayList();
        int n2 = 0;
        TokenItem tokenItem = jspSyntaxSupport.getItemAtOrBefore(n);
        if (tokenItem == null) {
            return this.result(jTextComponent, n, new CompletionData(arrayList, 0));
        }
        String string = tokenItem.getImage().substring(0, n - tokenItem.getOffset() >= tokenItem.getImage().length() ? tokenItem.getImage().length() : n - tokenItem.getOffset());
        if (!string.equals("<") && !string.equals("<%")) {
            return this.result(jTextComponent, n, new CompletionData(arrayList, 0));
        }
        n2 = "<%".equals(string) ? 1 : 0;
        this.addDirectiveItems(jspSyntaxSupport, arrayList, jspSyntaxSupport.getDirectives(""));
        return this.result(jTextComponent, n, new CompletionData(arrayList, n2));
    }

    private boolean isBlank(char c) {
        return c == ' ';
    }

    protected String findAttributeForValue(JspSyntaxSupport jspSyntaxSupport, TokenItem tokenItem) {
        while (tokenItem != null && tokenItem.getTokenID().getNumericID() == 8) {
            tokenItem = tokenItem.getPrevious();
        }
        String string = "";
        while (tokenItem != null && tokenItem.getTokenID().getNumericID() == 4) {
            string = tokenItem.getImage() + string;
            tokenItem = tokenItem.getPrevious();
        }
        if (!jspSyntaxSupport.isValueBeginning(string)) {
            return null;
        }
        String string2 = "";
        while (tokenItem != null && tokenItem.getImage().trim().length() == 0) {
            tokenItem = tokenItem.getPrevious();
        }
        while (tokenItem != null && tokenItem.getTokenID().getNumericID() == 7) {
            string2 = tokenItem.getImage() + string2;
            tokenItem = tokenItem.getPrevious();
        }
        if (string2.trim().length() > 0) {
            return string2.trim();
        }
        return null;
    }

    private void addTagPrefixItems(JspSyntaxSupport jspSyntaxSupport, List list, String string, List list2, SyntaxElement.Tag tag) {
        for (int i = 0; i < list2.size(); ++i) {
            Object e = list2.get(i);
            if (e instanceof TagInfo) {
                list.add(new JspCompletionItem.PrefixTag(string, (TagInfo)e, tag));
                continue;
            }
            list.add(new JspCompletionItem.PrefixTag(string + ":" + (String)e));
        }
    }

    private void addTagPrefixItems(JspSyntaxSupport jspSyntaxSupport, List list, List list2) {
        for (int i = 0; i < list2.size(); ++i) {
            String string = (String)list2.get(i);
            List list3 = jspSyntaxSupport.getTags(string, "");
            for (int j = 0; j < list3.size(); ++j) {
                Object e = list3.get(j);
                if (e instanceof TagInfo) {
                    list.add(new JspCompletionItem.PrefixTag(string, (TagInfo)e));
                    continue;
                }
                list.add(new JspCompletionItem.PrefixTag(string + ":" + (String)e));
            }
        }
    }

    private void addDirectiveItems(JspSyntaxSupport jspSyntaxSupport, List list, List list2) {
        for (int i = 0; i < list2.size(); ++i) {
            Object e = list2.get(i);
            if (e instanceof TagInfo) {
                TagInfo tagInfo = (TagInfo)e;
                list.add(new JspCompletionItem.Directive(tagInfo.getTagName(), tagInfo));
                continue;
            }
            list.add(new JspCompletionItem.Directive((String)e));
        }
    }

    private void addAttributeItems(JspSyntaxSupport jspSyntaxSupport, List list, SyntaxElement.TagDirective tagDirective, List list2, String string) {
        for (int i = 0; i < list2.size(); ++i) {
            Object e = list2.get(i);
            String string2 = e instanceof TagAttributeInfo ? ((TagAttributeInfo)e).getName() : (String)e;
            boolean bl = tagDirective.getAttributes().keySet().contains(string2);
            if (bl && !string2.equalsIgnoreCase(string) && (string == null || !string2.startsWith(string) || string2.length() <= string.length() || bl)) continue;
            if (e instanceof TagAttributeInfo) {
                if ("taglib".equalsIgnoreCase(tagDirective.getName())) {
                    if (!string2.equalsIgnoreCase("prefix") && (!string2.equalsIgnoreCase("uri") || tagDirective.getAttributes().keySet().contains("tagdir")) && (!string2.equalsIgnoreCase("tagdir") || tagDirective.getAttributes().keySet().contains("uri"))) continue;
                    list.add(new JspCompletionItem.Attribute((TagAttributeInfo)e));
                    continue;
                }
                list.add(new JspCompletionItem.Attribute((TagAttributeInfo)e));
                continue;
            }
            list.add(new JspCompletionItem.Attribute((String)e));
        }
    }

    private CompletionQuery.Result result(JTextComponent jTextComponent, int n, CompletionData completionData) {
        this.setResultItemsOffset(completionData, n);
        return new JspCompletionResult(jTextComponent, NbBundle.getMessage(JSPKit.class, (String)"CTL_JSP_Completion_Title"), completionData.completionItems, n, completionData.removeLength, -1);
    }

    static {
        stdXMLEntities.add("&lt;");
        stdXMLEntities.add("&gt;");
        stdXMLEntities.add("&apos;");
        stdXMLEntities.add("&quot;");
        stdXMLEntities.add("&amp;");
    }

    public static class JspCompletionResult
    extends CompletionQuery.DefaultResult
    implements SubstituteOffsetProvider {
        private int substituteOffset;

        public JspCompletionResult(JTextComponent jTextComponent, String string, List list, int n, int n2, int n3) {
            super(jTextComponent, string, list, n, n2);
            this.substituteOffset = n3 == -1 ? n - n2 : n3;
        }

        public int getSubstituteOffset() {
            return this.substituteOffset;
        }
    }

    static interface SubstituteOffsetProvider {
        public int getSubstituteOffset();
    }

    public static class CompletionData {
        public List completionItems;
        public int removeLength;

        public CompletionData(List list, int n) {
            this.completionItems = list;
            this.removeLength = n;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("------ completion items, remove " + this.removeLength + " : ----------\n");
            for (int i = 0; i < this.completionItems.size(); ++i) {
                CompletionQuery.DefaultResultItem defaultResultItem = (CompletionQuery.DefaultResultItem)this.completionItems.get(i);
                stringBuffer.append(defaultResultItem.getItemText());
                stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }
    }
}

