/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.html.HTMLCompletionQuery;
import org.netbeans.editor.ext.html.HTMLSyntaxSupport;
import org.netbeans.editor.ext.html.HTMLTokenContext;
import org.netbeans.editor.ext.java.JavaTokenContext;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.web.core.syntax.JspUtils;
import org.netbeans.modules.web.core.syntax.SyntaxElement;
import org.netbeans.modules.web.core.syntax.completion.JspCompletionItem;
import org.netbeans.modules.web.core.syntax.deprecated.ELTokenContext;
import org.netbeans.modules.web.core.syntax.deprecated.JspDirectiveTokenContext;
import org.netbeans.modules.web.core.syntax.deprecated.JspMultiTokenContext;
import org.netbeans.modules.web.core.syntax.deprecated.JspTagTokenContext;
import org.netbeans.modules.web.core.syntax.spi.JspContextInfo;
import org.netbeans.modules.web.jsps.parserapi.JspParserAPI;
import org.netbeans.modules.web.jsps.parserapi.PageInfo;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.modules.InstalledFileLocator;
import org.openide.text.CloneableEditorSupport;

public class JspSyntaxSupport
extends ExtSyntaxSupport {
    static final Logger err = Logger.getLogger("org.netbeans.modules.web.jspsyntax");
    public static final int TAG_COMPLETION_CONTEXT = 1;
    public static final int ENDTAG_COMPLETION_CONTEXT = 2;
    public static final int DIRECTIVE_COMPLETION_CONTEXT = 3;
    public static final int COMMENT_COMPLETION_CONTEXT = 4;
    public static final int TEXT_COMPLETION_CONTEXT = 5;
    public static final int CONTENTL_COMPLETION_CONTEXT = 6;
    public static final int SCRIPTINGL_COMPLETION_CONTEXT = 7;
    public static final int ERROR_COMPLETION_CONTEXT = 8;
    public static final int EL_COMPLETION_CONTEXT = 9;
    private static final String STANDARD_JSP_PREFIX = "jsp";
    private static TagInfo[] standardJspTagDatas;
    private static TagInfo[] standardTagTagDatas;
    private static TagInfo[] xmlJspTagDatas;
    private static TagInfo[] xmlTagFileTagDatas;
    private static TagInfo[] directiveJspData;
    private static TagInfo[] directiveTagFileData;
    private static HashMap helpMap;
    private static final TokenID[] JSP_BRACKET_SKIP_TOKENS;
    protected FileObject fobj = null;
    private ExtSyntaxSupport contentLanguageSyntaxSupport = null;
    private boolean useCustomBracketFinder = true;
    private static final TagNameComparator TAG_NAME_COMPARATOR;

    public static synchronized JspSyntaxSupport get(Document document) {
        JspSyntaxSupport jspSyntaxSupport = (JspSyntaxSupport)((Object)document.getProperty(JspSyntaxSupport.class));
        if (jspSyntaxSupport == null) {
            jspSyntaxSupport = new JspSyntaxSupport((BaseDocument)document);
            document.putProperty(JspSyntaxSupport.class, (Object)jspSyntaxSupport);
        }
        return jspSyntaxSupport;
    }

    public JspSyntaxSupport(BaseDocument baseDocument) {
        super(baseDocument);
        if (baseDocument != null) {
            DataObject dataObject = NbEditorUtilities.getDataObject((Document)baseDocument);
            this.fobj = dataObject != null ? NbEditorUtilities.getDataObject((Document)baseDocument).getPrimaryFile() : null;
        }
    }

    public String[] getImports() {
        JspParserAPI.ParseResult parseResult = this.getParseResult();
        if (parseResult != null) {
            PageInfo pageInfo = parseResult.getPageInfo();
            if (pageInfo == null) {
                err.log(Level.WARNING, null, new NullPointerException("PageInfo obtained from JspParserAPI.ParseResult is null!"));
                return null;
            }
            List list = pageInfo.getImports();
            return list.toArray(new String[list.size()]);
        }
        return null;
    }

    public boolean isXmlSyntax() {
        JspContextInfo jspContextInfo = JspContextInfo.getContextInfo(this.fobj);
        if (jspContextInfo == null) {
            return false;
        }
        JspParserAPI.JspOpenInfo jspOpenInfo = jspContextInfo.getCachedOpenInfo((Document)this.getDocument(), this.fobj, false);
        if (jspOpenInfo == null) {
            return false;
        }
        return jspOpenInfo.isXmlSyntax();
    }

    protected JspParserAPI.ParseResult getParseResult() {
        JspParserAPI.ParseResult parseResult = JspUtils.getCachedParseResult((Document)this.getDocument(), this.fobj, true, false);
        if (parseResult == null) {
            parseResult = JspUtils.getCachedParseResult((Document)this.getDocument(), this.fobj, false, false);
        }
        return parseResult;
    }

    private Map getPrefixMapper() {
        JspParserAPI.ParseResult parseResult = this.getParseResult();
        Map map = null;
        if (parseResult != null && parseResult.getPageInfo() != null) {
            if (parseResult.getPageInfo().getXMLPrefixMapper().size() > 0) {
                map = parseResult.getPageInfo().getApproxXmlPrefixMapper();
                if (map.size() == 0) {
                    map = parseResult.getPageInfo().getXMLPrefixMapper();
                }
                map.putAll(parseResult.getPageInfo().getJspPrefixMapper());
            } else {
                map = parseResult.getPageInfo().getJspPrefixMapper();
            }
        }
        return map;
    }

    private Map getTagLibraries() {
        this.getTagLibraryMappings();
        JspParserAPI.ParseResult parseResult = JspUtils.getCachedParseResult((Document)this.getDocument(), this.fobj, false, true, true);
        if (parseResult != null) {
            return parseResult.getPageInfo().getTagLibraries();
        }
        return null;
    }

    private TagInfo[] getSortedTagInfos(TagInfo[] tagInfoArray) {
        Arrays.sort(tagInfoArray, new Comparator(){

            public int compare(Object object, Object object2) {
                String string;
                TagInfo tagInfo = (TagInfo)object;
                TagInfo tagInfo2 = (TagInfo)object2;
                String string2 = tagInfo.getDisplayName() == null ? tagInfo.getTagName() : tagInfo.getDisplayName();
                String string3 = string = tagInfo2.getDisplayName() == null ? tagInfo2.getTagName() : tagInfo2.getDisplayName();
                if (string2 == null || string == null) {
                    return 0;
                }
                return string2.compareTo(string);
            }

            public boolean equals(Object object) {
                return object.equals(this);
            }
        });
        return tagInfoArray;
    }

    private TagLibraryInfo getTagLibrary(String string) {
        Map map;
        Object v;
        Map map2 = this.getPrefixMapper();
        if (map2 != null && (v = map2.get(string)) != null && (map = this.getTagLibraries()) != null) {
            return (TagLibraryInfo)map.get(v);
        }
        return null;
    }

    protected SyntaxSupport createSyntaxSupport(Class clazz) {
        SyntaxSupport syntaxSupport = super.createSyntaxSupport(clazz);
        if (syntaxSupport != null) {
            return syntaxSupport;
        }
        EditorKit editorKit = CloneableEditorSupport.getEditorKit((String)JspUtils.getContentLanguage());
        if (editorKit instanceof BaseKit && (syntaxSupport = ((BaseKit)editorKit).createSyntaxSupport(this.getDocument())) != null) {
            return syntaxSupport;
        }
        editorKit = CloneableEditorSupport.getEditorKit((String)JspUtils.getScriptingLanguage());
        if (editorKit instanceof BaseKit && (syntaxSupport = ((BaseKit)editorKit).createSyntaxSupport(this.getDocument())) != null) {
            return syntaxSupport;
        }
        return null;
    }

    protected ExtSyntaxSupport getContentLanguageSyntaxSupport() {
        SyntaxSupport syntaxSupport;
        if (this.contentLanguageSyntaxSupport != null) {
            return this.contentLanguageSyntaxSupport;
        }
        EditorKit editorKit = JEditorPane.createEditorKitForContentType(JspUtils.getContentLanguage());
        if (editorKit instanceof BaseKit && (syntaxSupport = ((BaseKit)editorKit).createSyntaxSupport(this.getDocument())) != null && syntaxSupport instanceof ExtSyntaxSupport) {
            this.contentLanguageSyntaxSupport = (ExtSyntaxSupport)syntaxSupport;
            return this.contentLanguageSyntaxSupport;
        }
        return (ExtSyntaxSupport)this.get(HTMLSyntaxSupport.class);
    }

    public int checkCompletion(JTextComponent jTextComponent, String string, boolean bl) {
        ExtSyntaxSupport extSyntaxSupport;
        char c = string.charAt(0);
        TokenItem tokenItem = null;
        try {
            tokenItem = this.getItemAtOrBefore(jTextComponent.getCaret().getDot());
        }
        catch (BadLocationException badLocationException) {
            return 4;
        }
        if (tokenItem == null) {
            return 4;
        }
        TokenContextPath tokenContextPath = tokenItem.getTokenContextPath();
        if (tokenContextPath.contains(HTMLTokenContext.contextPath)) {
            if (err.isLoggable(Level.FINE)) {
                err.log(Level.FINE, "CONTENTL_COMPLETION_CONTEXT");
            }
            if ((extSyntaxSupport = this.getContentLanguageSyntaxSupport()) != null) {
                return extSyntaxSupport.checkCompletion(jTextComponent, string, bl);
            }
        }
        if (tokenContextPath.contains(JavaTokenContext.contextPath)) {
            return 1;
        }
        if (tokenContextPath.contains(JspTagTokenContext.contextPath)) {
            extSyntaxSupport = tokenItem;
            int n = 80;
            do {
                if (extSyntaxSupport.getTokenID() == JspTagTokenContext.ERROR) {
                    return 4;
                }
                String string2 = extSyntaxSupport.getImage();
                if (string2.equals("%>")) {
                    return 4;
                }
                if (extSyntaxSupport.getImage().startsWith("<%")) {
                    if (err.isLoggable(Level.FINE)) {
                        err.log(Level.FINE, "DIRECTIVE_COMPLETION_CONTEXT");
                    }
                    if (!bl && c == '=' && extSyntaxSupport.getImage().equals("<%")) {
                        return 0;
                    }
                    if (!bl && c == '%' || c == '@' || c == ' ') {
                        return 0;
                    }
                    if (bl && c == '=' || c == '>') {
                        return 4;
                    }
                    return bl ? 3 : 1;
                }
                if (extSyntaxSupport.getImage().equals("<")) {
                    if (err.isLoggable(Level.FINE)) {
                        err.log(Level.FINE, "TAG_COMPLETION_CONTEXT");
                    }
                    if (!bl && c == ' ' || c == ':') {
                        return 0;
                    }
                    if (bl && c == '>') {
                        return 4;
                    }
                    return bl ? 3 : 1;
                }
                if (extSyntaxSupport.getImage().equals("</")) {
                    if (err.isLoggable(Level.FINE)) {
                        err.log(Level.FINE, "ENDTAG_COMPLETION_CONTEXT");
                    }
                    if (bl && c == '>') {
                        return 4;
                    }
                    return bl ? 3 : 1;
                }
                if (!extSyntaxSupport.getTokenContextPath().contains(JspTagTokenContext.contextPath)) {
                    if (!err.isLoggable(Level.FINE)) break;
                    err.log(Level.FINE, "We are out of jsp tag without finding any tag start token!");
                    break;
                }
                if (extSyntaxSupport.getImage().equals(">")) {
                    try {
                        SyntaxElement syntaxElement = this.getElementChain(extSyntaxSupport.getOffset());
                        if (syntaxElement != null && syntaxElement instanceof SyntaxElement.Tag) {
                            return 0;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    return 4;
                }
                extSyntaxSupport = extSyntaxSupport.getPrevious();
            } while (n-- > 0 && extSyntaxSupport != null);
        }
        if (tokenContextPath.contains(ELTokenContext.contextPath) && c == '.') {
            return 0;
        }
        return 4;
    }

    private final int getTokenEnd(TokenItem tokenItem) {
        if (tokenItem == null) {
            return 0;
        }
        return tokenItem.getOffset() + tokenItem.getImage().length();
    }

    public final List filterList(List list, String string) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            String string2 = e instanceof TagInfo ? ((TagInfo)e).getTagName() : (e instanceof TagAttributeInfo ? ((TagAttributeInfo)e).getName() : (String)e);
            if (string2 == null || !string2.startsWith(string)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public final List getTagPrefixes(String string) {
        return this.filterList(this.getAllTagPrefixes(), string);
    }

    public final List getTags(String string) {
        int n = string.indexOf(":");
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        return this.getTags(string.substring(0, n), string.substring(n + 1));
    }

    public final List getTags(String string, String string2) {
        return this.filterList(this.getAllTags(string), string2);
    }

    public final List getTagAttributes(String string, String string2) {
        int n = string.indexOf(":");
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        return this.getTagAttributes(string.substring(0, n), string.substring(n + 1), string2);
    }

    protected final List getTagAttributes(String string, String string2, String string3) {
        return this.filterList(this.getAllTagAttributes(string, string2), string3);
    }

    public final List getDirectives(String string) {
        return this.filterList(this.getAllDirectives(), string);
    }

    public final List getDirectiveAttributes(String string, String string2) {
        return this.filterList(this.getAllDirectiveAttributes(string), string2);
    }

    protected List getAllTagPrefixes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(STANDARD_JSP_PREFIX);
        Map map = this.getPrefixMapper();
        if (map != null) {
            TreeSet treeSet = new TreeSet();
            treeSet.addAll(map.keySet());
            treeSet.remove(STANDARD_JSP_PREFIX);
            arrayList.addAll(treeSet);
        }
        return arrayList;
    }

    private TagInfo[] getAllTagInfos(TagLibraryInfo tagLibraryInfo) {
        TagInfo[] tagInfoArray = new TagInfo[]{};
        if (tagLibraryInfo != null) {
            int n;
            int n2 = 0;
            int n3 = 0;
            TagInfo[] tagInfoArray2 = tagLibraryInfo.getTags();
            TagFileInfo[] tagFileInfoArray = tagLibraryInfo.getTagFiles();
            if (tagInfoArray2 != null) {
                n3 = n2 = tagInfoArray2.length;
            }
            if (tagFileInfoArray != null) {
                n3 += tagFileInfoArray.length;
            }
            tagInfoArray = new TagInfo[n3];
            if (tagInfoArray2 != null) {
                for (n = 0; n < n2; ++n) {
                    tagInfoArray[n] = tagInfoArray2[n];
                }
            }
            if (tagFileInfoArray != null) {
                for (n = 0; n < tagFileInfoArray.length; ++n) {
                    tagInfoArray[n2 + n] = tagFileInfoArray[n].getTagInfo();
                }
            }
        }
        return tagInfoArray;
    }

    protected List getAllTags(String string) {
        ArrayList<Object> arrayList;
        block7: {
            TagLibraryInfo tagLibraryInfo;
            arrayList = new ArrayList<Object>();
            JspSyntaxSupport.initCompletionData();
            if (STANDARD_JSP_PREFIX.equals(string)) {
                tagLibraryInfo = this.getTagInfos();
                for (int i = 0; i < ((TagLibraryInfo)tagLibraryInfo).length; ++i) {
                    arrayList.add(tagLibraryInfo[i]);
                }
            }
            tagLibraryInfo = this.getTagLibrary(string);
            TagInfo[] tagInfoArray = null;
            if (tagLibraryInfo != null) {
                tagInfoArray = this.getAllTagInfos(tagLibraryInfo);
            }
            if (tagInfoArray == null) break block7;
            tagInfoArray = this.getSortedTagInfos(tagInfoArray);
            String string2 = (String)helpMap.get(tagLibraryInfo.getURI());
            if (string2 != null && !string2.equals("")) {
                for (int i = 0; i < tagInfoArray.length; ++i) {
                    arrayList.add(new TagInfo(tagInfoArray[i].getTagName(), tagInfoArray[i].getTagClassName(), tagInfoArray[i].getBodyContent(), string2 + tagInfoArray[i].getTagName() + ".html#tag-start-" + tagInfoArray[i].getTagName() + "#tag-end-" + tagInfoArray[i].getTagName(), tagLibraryInfo, tagInfoArray[i].getTagExtraInfo(), tagInfoArray[i].getAttributes(), tagInfoArray[i].getDisplayName(), tagInfoArray[i].getSmallIcon(), tagInfoArray[i].getLargeIcon(), tagInfoArray[i].getTagVariableInfos(), tagInfoArray[i].hasDynamicAttributes()));
                }
            } else {
                for (int i = 0; i < tagInfoArray.length; ++i) {
                    arrayList.add(tagInfoArray[i]);
                }
            }
        }
        return arrayList;
    }

    protected List getAllTagAttributes(String string, String string2) {
        ArrayList<TagAttributeInfo> arrayList;
        block9: {
            TagAttributeInfo[] tagAttributeInfoArray;
            TagLibraryInfo tagLibraryInfo;
            arrayList = new ArrayList<TagAttributeInfo>();
            JspSyntaxSupport.initCompletionData();
            if (STANDARD_JSP_PREFIX.equals(string)) {
                tagLibraryInfo = this.getTagInfos();
                for (int i = 0; i < ((TagLibraryInfo)tagLibraryInfo).length; ++i) {
                    if (!tagLibraryInfo[i].getTagName().equals(string2)) continue;
                    tagAttributeInfoArray = tagLibraryInfo[i].getAttributes();
                    for (int j = 0; j < tagAttributeInfoArray.length; ++j) {
                        arrayList.add(tagAttributeInfoArray[j]);
                    }
                    break;
                }
            }
            if ((tagLibraryInfo = this.getTagLibrary(string)) == null) break block9;
            TagInfo tagInfo = tagLibraryInfo.getTag(string2);
            if (tagInfo == null && (tagAttributeInfoArray = tagLibraryInfo.getTagFile(string2)) != null) {
                tagInfo = tagAttributeInfoArray.getTagInfo();
            }
            if (tagInfo != null) {
                tagAttributeInfoArray = tagInfo.getAttributes();
                String string3 = (String)helpMap.get(tagInfo.getTagLibrary().getURI());
                if (string3 != null && !string3.equals("")) {
                    for (int i = 0; i < tagAttributeInfoArray.length; ++i) {
                        arrayList.add(new TagAttributeInfo(tagAttributeInfoArray[i].getName(), tagAttributeInfoArray[i].isRequired(), string3 + tagInfo.getTagName() + ".html#attribute-start-" + tagAttributeInfoArray[i].getName() + "#attribute-end-" + tagAttributeInfoArray[i].getName(), tagAttributeInfoArray[i].canBeRequestTime(), tagAttributeInfoArray[i].isFragment()));
                    }
                } else {
                    for (int i = 0; i < tagAttributeInfoArray.length; ++i) {
                        arrayList.add(tagAttributeInfoArray[i]);
                    }
                }
            }
        }
        return arrayList;
    }

    protected List getAllDirectives() {
        JspSyntaxSupport.initCompletionData();
        ArrayList<TagInfo> arrayList = new ArrayList<TagInfo>();
        if (this.isXmlSyntax()) {
            return arrayList;
        }
        TagInfo[] tagInfoArray = NbEditorUtilities.getMimeType((Document)this.getDocument()).equals("text/x-tag") ? directiveTagFileData : directiveJspData;
        for (int i = 0; i < tagInfoArray.length; ++i) {
            arrayList.add(tagInfoArray[i]);
        }
        return arrayList;
    }

    protected List getAllDirectiveAttributes(String string) {
        JspSyntaxSupport.initCompletionData();
        ArrayList<TagAttributeInfo> arrayList = new ArrayList<TagAttributeInfo>();
        if (this.isXmlSyntax()) {
            return arrayList;
        }
        TagInfo[] tagInfoArray = NbEditorUtilities.getMimeType((Document)this.getDocument()).equals("text/x-tag") ? directiveTagFileData : directiveJspData;
        for (int i = 0; i < tagInfoArray.length; ++i) {
            if (!tagInfoArray[i].getTagName().equals(string)) continue;
            TagAttributeInfo[] tagAttributeInfoArray = tagInfoArray[i].getAttributes();
            for (int j = 0; j < tagAttributeInfoArray.length; ++j) {
                arrayList.add(tagAttributeInfoArray[j]);
            }
            break;
        }
        return arrayList;
    }

    public PageInfo.BeanData[] getBeanData() {
        PageInfo pageInfo;
        JspParserAPI.ParseResult parseResult = this.getParseResult();
        if (parseResult != null && (pageInfo = parseResult.getPageInfo()) != null) {
            return pageInfo.getBeans();
        }
        return null;
    }

    public boolean isErrorPage() {
        JspParserAPI.ParseResult parseResult = this.getParseResult();
        if (parseResult != null && parseResult.getPageInfo() != null) {
            return parseResult.getPageInfo().isErrorPage();
        }
        return false;
    }

    public Map getTagLibraryMappings() {
        if (this.fobj == null) {
            return null;
        }
        return JspUtils.getTaglibMap((Document)this.getDocument(), this.fobj);
    }

    private static void initHelp() {
        if (helpMap == null) {
            URL uRL;
            String string = "";
            File file = InstalledFileLocator.getDefault().locate("docs/jstl11-doc.zip", null, false);
            if (file != null) {
                try {
                    uRL = file.toURL();
                    uRL = FileUtil.getArchiveRoot((URL)uRL);
                    string = uRL.toString();
                }
                catch (MalformedURLException malformedURLException) {
                    err.log(Level.WARNING, null, malformedURLException);
                }
            }
            helpMap = new HashMap();
            helpMap.put("http://java.sun.com/jsp/jstl/core", string + "c/");
            helpMap.put("http://java.sun.com/jstl/core", string + "c/");
            helpMap.put("http://java.sun.com/jstl/core_rt", string + "c_rt/");
            helpMap.put("http://java.sun.com/jsp/jstl/fmt", string + "fmt/");
            helpMap.put("http://java.sun.com/jstl/fmt", string + "fmt/");
            helpMap.put("http://java.sun.com/jstl/fmt_rt", string + "fmt_rt/");
            helpMap.put("http://java.sun.com/jsp/jstl/functions", string + "fn/");
            helpMap.put("http://java.sun.com/jstl/functions", string + "fn/");
            helpMap.put("http://jakarta.apache.org/taglibs/standard/permittedTaglibs", string + "permittedTaglibs/");
            helpMap.put("http://jakarta.apache.org/taglibs/standard/scriptfree", string + "scriptfree/");
            helpMap.put("http://java.sun.com/jsp/jstl/sql", string + "sql/");
            helpMap.put("http://java.sun.com/jstl/sql", string + "sql/");
            helpMap.put("http://java.sun.com/jstl/sql_rt", string + "sql_rt/");
            helpMap.put("http://java.sun.com/jsp/jstl/xml", string + "x/");
            helpMap.put("http://java.sun.com/jstl/xml", string + "x/");
            helpMap.put("http://java.sun.com/jstl/xml_rt", string + "x_rt/");
            file = InstalledFileLocator.getDefault().locate("docs/jsf12-tlddoc.zip", null, false);
            if (file != null) {
                try {
                    uRL = file.toURL();
                    uRL = FileUtil.getArchiveRoot((URL)uRL);
                    string = uRL.toString();
                    helpMap.put("http://java.sun.com/jsf/html", string + "h/");
                    helpMap.put("http://java.sun.com/jsf/core", string + "f/");
                }
                catch (MalformedURLException malformedURLException) {
                    err.log(Level.WARNING, null, malformedURLException);
                }
            }
            if ((file = InstalledFileLocator.getDefault().locate("docs/struts-tags.zip", null, false)) != null) {
                try {
                    uRL = file.toURL();
                    uRL = FileUtil.getArchiveRoot((URL)uRL);
                    string = uRL.toString();
                    helpMap.put("http://jakarta.apache.org/struts/tags-bean", string + "bean/");
                    helpMap.put("http://struts.apache.org/tags-bean", string + "bean/");
                    helpMap.put("/WEB-INF/struts-bean.tld", string + "bean/");
                    helpMap.put("http://jakarta.apache.org/struts/tags-html", string + "html/");
                    helpMap.put("http://struts.apache.org/tags-html", string + "html/");
                    helpMap.put("/WEB-INF/struts-html.tld", string + "html/");
                    helpMap.put("http://jakarta.apache.org/struts/tags-logic", string + "logic/");
                    helpMap.put("http://struts.apache.org/tags-logic", string + "logic/");
                    helpMap.put("/WEB-INF/struts-logic.tld", string + "logic/");
                    helpMap.put("http://jakarta.apache.org/struts/tags-nested", string + "nested/");
                    helpMap.put("http://struts.apache.org/tags-nested", string + "nested/");
                    helpMap.put("/WEB-INF/struts-nested.tld", string + "nested/");
                    helpMap.put("http://jakarta.apache.org/struts/tags-tiles", string + "tiles/");
                    helpMap.put("http://struts.apache.org/tags-tiles", string + "tiles/");
                    helpMap.put("/WEB-INF/struts-tiles.tld", string + "tiles/");
                }
                catch (MalformedURLException malformedURLException) {
                    err.log(Level.WARNING, null, malformedURLException);
                }
            }
        }
    }

    private static void initCompletionData() {
        Serializable serializable;
        if (helpMap == null) {
            JspSyntaxSupport.initHelp();
        }
        String string = "";
        if (standardJspTagDatas == null) {
            serializable = InstalledFileLocator.getDefault().locate("docs/syntaxref20.zip", null, true);
            if (serializable != null) {
                try {
                    URL uRL = ((File)serializable).toURL();
                    uRL = FileUtil.getArchiveRoot((URL)uRL);
                    string = uRL.toString();
                }
                catch (MalformedURLException malformedURLException) {
                    err.log(Level.WARNING, null, malformedURLException);
                }
            }
            standardJspTagDatas = new TagInfo[]{new TagInfo("attribute", null, "JSP", string + "syntaxref2014.html", null, null, new TagAttributeInfo[]{new TagAttributeInfo("name", true, string + "syntaxref2014.html#1003581#1006483", false), new TagAttributeInfo("trim", false, string + "syntaxref2014.html#1006483#1003583", false)}), new TagInfo("body", null, "JSP", string + "syntaxref2015.html#1006731#1003768", null, null, new TagAttributeInfo[0]), new TagInfo("element", null, "JSP", string + "syntaxref2016.html#1003696#1003708", null, null, new TagAttributeInfo[]{new TagAttributeInfo("name", true, string + "syntaxref2016.html#1003706#1003708", false)}), new TagInfo("expression", null, "JSP", string + "syntaxref205.html#1004353#11268", null, null, new TagAttributeInfo[0]), new TagInfo("fallback", null, "JSP", string + "syntaxref2023.html#11583#19029", null, null, new TagAttributeInfo[0]), new TagInfo("forward", null, "JSP", string + "syntaxref2018.html#1003349#15708", null, null, new TagAttributeInfo[]{new TagAttributeInfo("page", true, string + "syntaxref2018.html#15704#15708", true)}), new TagInfo("getProperty", null, "empty", string + "syntaxref2019.html#8820#9201", null, null, new TagAttributeInfo[]{new TagAttributeInfo("name", true, string + "syntaxref2019.html#15748#10919", false), new TagAttributeInfo("property", true, string + "syntaxref2019.html#10919#19482", false)}), new TagInfo("include", null, "JSP", string + "syntaxref2020.html#8828#9228", null, null, new TagAttributeInfo[]{new TagAttributeInfo("flush", true, string + "syntaxref2020.html#17145#18376", false), new TagAttributeInfo("page", true, string + "syntaxref2020.html#10930#17145", true)}), new TagInfo("param", null, "empty", string + "syntaxref2023.html#11538#11583", null, null, new TagAttributeInfo[]{new TagAttributeInfo("name", true, string + "syntaxref2023.html#11538#11583", false), new TagAttributeInfo("value", true, string + "syntaxref2023.html#11538#11583", true)}), new TagInfo("params", null, "JSP", string + "syntaxref2023.html#11538#11583", null, null, new TagAttributeInfo[0]), new TagInfo("plugin", null, "JSP", string + "syntaxref2023.html#1004158#19029", null, null, new TagAttributeInfo[]{new TagAttributeInfo("align", false, string + "syntaxref2023.html#11516#11518", false), new TagAttributeInfo("archive", false, string + "syntaxref2023.html#11553#11516", false), new TagAttributeInfo("code", true, string + "syntaxref2023.html#11514#11515", false), new TagAttributeInfo("codebase", true, string + "syntaxref2023.html#11515#11547", false), new TagAttributeInfo("height", false, string + "syntaxref2023.html#11518#11568", false), new TagAttributeInfo("hspace", false, string + "syntaxref2023.html#11568#11520", false), new TagAttributeInfo("iepluginurl", false, string + "syntaxref2023.html#11526#11538", false), new TagAttributeInfo("jreversion", false, string + "syntaxref2023.html#11520#11525", false), new TagAttributeInfo("name", false, string + "syntaxref2023.html#11547#11553", false), new TagAttributeInfo("nspluginurl", false, string + "syntaxref2023.html#11525#11526", false), new TagAttributeInfo("type", true, string + "syntaxref2023.html#10935#11514", false), new TagAttributeInfo("vspace", false, string + "syntaxref2023.html#11568#11520", false), new TagAttributeInfo("width", false, string + "syntaxref2023.html#11518#11568", false)}), new TagInfo("setProperty", null, "empty", string + "syntaxref2025.html#8856#9329", null, null, new TagAttributeInfo[]{new TagAttributeInfo("name", true, string + "syntaxref2025.html#17612#1001786", true), new TagAttributeInfo("param", false, string + "syntaxref2025.html#9919#20483", false), new TagAttributeInfo("property", false, string + "syntaxref2025.html#1001786#9329", false), new TagAttributeInfo("value", false, string + "syntaxref2025.html#20483#9329", true)}), new TagInfo("text", null, "JSP", string + "syntaxref2026.html", null, null, new TagAttributeInfo[0]), new TagInfo("useBean", null, "JSP", string + "syntaxref2027.html#8865#9359", null, null, new TagAttributeInfo[]{new TagAttributeInfo("beanName", false, string + "syntaxref2027.html#15804#9359", false), new TagAttributeInfo("class", false, string + "syntaxref2027.html#10968#19433", false), new TagAttributeInfo("id", true, string + "syntaxref2027.html#10964#10966", false), new TagAttributeInfo("scope", true, string + "syntaxref2027.html#10966#10968", false), new TagAttributeInfo("type", false, string + "syntaxref2027.html#19433#18019", false)})};
            standardTagTagDatas = new TagInfo[standardJspTagDatas.length + 2];
            JspSyntaxSupport.standardTagTagDatas[0] = standardJspTagDatas[0];
            JspSyntaxSupport.standardTagTagDatas[1] = standardJspTagDatas[1];
            JspSyntaxSupport.standardTagTagDatas[2] = new TagInfo("doBody", null, "empty", string + "syntaxref2017.html", null, null, new TagAttributeInfo[]{new TagAttributeInfo("scope", false, string + "syntaxref2017.html#1006246#syntaxref20.html", false), new TagAttributeInfo("var", false, string + "syntaxref2017.html#1006234#1006240", false), new TagAttributeInfo("varReader", false, string + "syntaxref2017.html#1006240#1006246", false)});
            JspSyntaxSupport.standardTagTagDatas[3] = standardJspTagDatas[2];
            JspSyntaxSupport.standardTagTagDatas[4] = standardJspTagDatas[3];
            JspSyntaxSupport.standardTagTagDatas[5] = standardJspTagDatas[4];
            JspSyntaxSupport.standardTagTagDatas[6] = standardJspTagDatas[5];
            JspSyntaxSupport.standardTagTagDatas[7] = standardJspTagDatas[6];
            JspSyntaxSupport.standardTagTagDatas[8] = standardJspTagDatas[7];
            JspSyntaxSupport.standardTagTagDatas[9] = new TagInfo("invoke", null, "JSP", string + "syntaxref2021.html#8837#1003634", null, null, new TagAttributeInfo[]{new TagAttributeInfo("fragment", true, string + "syntaxref2021.html#1007359#1007361", false), new TagAttributeInfo("scope", false, string + "syntaxref2021.html#1007373#1003634", false), new TagAttributeInfo("var", false, string + "syntaxref2021.html#1007361#1007367", false), new TagAttributeInfo("varReader", false, string + "syntaxref2021.html#1007367#1007373", false)});
            JspSyntaxSupport.standardTagTagDatas[10] = standardJspTagDatas[8];
            JspSyntaxSupport.standardTagTagDatas[11] = standardJspTagDatas[9];
            JspSyntaxSupport.standardTagTagDatas[12] = standardJspTagDatas[10];
            JspSyntaxSupport.standardTagTagDatas[13] = standardJspTagDatas[11];
            JspSyntaxSupport.standardTagTagDatas[14] = standardJspTagDatas[12];
            JspSyntaxSupport.standardTagTagDatas[15] = standardJspTagDatas[13];
        }
        if (directiveJspData == null) {
            directiveJspData = new TagInfo[]{new TagInfo("include", null, "empty", string + "syntaxref209.html#1003408#8975", null, null, new TagAttributeInfo[]{new TagAttributeInfo("file", true, string + "syntaxref209.html#16836#10636", false)}), new TagInfo("page", null, "empty", string + "syntaxref2010.html", null, null, new TagAttributeInfo[]{new TagAttributeInfo("autoFlush", false, string + "syntaxref2010.html#15673#15675", false), new TagAttributeInfo("buffer", false, string + "syntaxref2010.html#15671#15673", false), new TagAttributeInfo("contentType", false, string + "syntaxref2010.html#15683#1001361", false), new TagAttributeInfo("errorPage", false, string + "syntaxref2010.html#15679#15681", false), new TagAttributeInfo("extends", false, string + "syntaxref2010.html#15665#16862", false), new TagAttributeInfo("import", false, string + "syntaxref2010.html#16862#15669", false), new TagAttributeInfo("info", false, string + "syntaxref2010.html#15677#15679", false), new TagAttributeInfo("isELIgnored", false, string + "syntaxref2010.html#1011216#18865", false), new TagAttributeInfo("isErrorPage", false, string + "syntaxref2010.html#15681#15683", false), new TagAttributeInfo("isThreadSafe", false, string + "syntaxref2010.html#15675#15677", false), new TagAttributeInfo("language", false, string + "syntaxref2010.html#15663#15665", false), new TagAttributeInfo("pageEncoding", false, string + "syntaxref2010.html#1001361#1011216", false), new TagAttributeInfo("session", false, string + "syntaxref2010.html#15669#15671", false)}), new TagInfo("taglib", null, "empty", string + "syntaxref2012.html#1003416#1002041", null, null, new TagAttributeInfo[]{new TagAttributeInfo("prefix", true, string + "syntaxref2012.html#1011290#1002041", false), new TagAttributeInfo("uri", false, string + "syntaxref2012.html#10721#1011294", false), new TagAttributeInfo("tagdir", false, string + "syntaxref2012.html#1011294#1011290", false)})};
        }
        if (directiveTagFileData == null) {
            directiveTagFileData = new TagInfo[]{new TagInfo("attribute", null, "empty", string + "syntaxref208.html", null, null, new TagAttributeInfo[]{new TagAttributeInfo("description", false, string + "syntaxref208.html#1004672", false), new TagAttributeInfo("fragment", false, string + "syntaxref208.html#1004657#1004666", false), new TagAttributeInfo("name", true, string + "syntaxref208.html#1004648#1004655", false), new TagAttributeInfo("required", false, string + "syntaxref208.html#1004655#1004657", false), new TagAttributeInfo("rtexprvalue", false, string + "syntaxref208.html#1004666#1004669", false), new TagAttributeInfo("type", false, string + "syntaxref208.html#1004669#1004672", false)}), directiveJspData[0], new TagInfo("tag", null, "empty", string + "syntaxref2011.html", null, null, new TagAttributeInfo[]{new TagAttributeInfo("body-content", false, string + "syntaxref2011.html#1005164#005172", false), new TagAttributeInfo("description", false, string + "syntaxref2011.html#1005196#1005198", false), new TagAttributeInfo("display-name", false, string + "syntaxref2011.html#1005161#1005164", false), new TagAttributeInfo("dynamic-attributes", false, string + "syntaxref2011.html#005172#1005190", false), new TagAttributeInfo("example", false, string + "syntaxref2011.html#1005198#1005201", false), new TagAttributeInfo("import", false, string + "syntaxref2011.html#1005203#1005209", false), new TagAttributeInfo("isELIgnored", false, string + "syntaxref2011.html#1005214#1005291#1005291", false), new TagAttributeInfo("large-icon", false, string + "syntaxref2011.html#1005193#1005196", false), new TagAttributeInfo("language", false, string + "syntaxref2011.html#1005201#1005203", false), new TagAttributeInfo("pageEncoding", false, string + "syntaxref2011.html#1005209#1005214", false), new TagAttributeInfo("small-icon", false, string + "syntaxref2011.html#1005190#1005193", false)}), directiveJspData[2], new TagInfo("variable", null, "empty", string + "syntaxref2013.html#15694#1003563", null, null, new TagAttributeInfo[]{new TagAttributeInfo("alias", false, string + "syntaxref2013.html#1005914#1005956", false), new TagAttributeInfo("declare", false, string + "syntaxref2013.html#1006001#1006019", false), new TagAttributeInfo("description", false, string + "syntaxref2013.html#1005991#1003563", false), new TagAttributeInfo("name-given", false, string + "syntaxref2013.html#1003561#1005914", false), new TagAttributeInfo("scope", false, string + "syntaxref2013.html#1006019#1005991", false), new TagAttributeInfo("variable-class", false, string + "syntaxref2013.html#1005956#1006001", false)})};
        }
        if (xmlJspTagDatas == null) {
            int n;
            TagInfo[] tagInfoArray = new TagInfo[]{new TagInfo("declaration", null, "JSP", string + "syntaxref204.html#10983#10991", null, null, new TagAttributeInfo[0]), new TagInfo("output", null, "JSP", string + "syntaxref2022.html#1004130#1007521", null, null, new TagAttributeInfo[]{new TagAttributeInfo("doctype-public", false, "url + syntaxref2022.html#1007534#1007521", false), new TagAttributeInfo("doctype-root-element", false, "url + syntaxref2022.html#1007528#1007532", false), new TagAttributeInfo("doctype-system", false, string + "syntaxref2022.html#1007532#1007534", false), new TagAttributeInfo("omit-xml-declaration", false, string + "syntaxref2022.html#1007525#1007528", false)}), new TagInfo("scriptlet", null, "JSP", string + "syntaxref206.html#10996#11007", null, null, new TagAttributeInfo[0]), new TagInfo("root", null, "JSP", string + "syntaxref2024.html#1003283#1003311", null, null, new TagAttributeInfo[]{new TagAttributeInfo("version", false, string + "syntaxref2024.html#1003299#1003301", false), new TagAttributeInfo("xmlns:jsp", false, string + "syntaxref2024.html#1003297#1003299", false), new TagAttributeInfo("xmlns:x", false, string + "syntaxref2024.html#1003301#1003311", false)})};
            xmlJspTagDatas = new TagInfo[]{new TagInfo("directive.page", null, "empty", directiveJspData[1].getInfoString(), null, null, directiveJspData[1].getAttributes()), new TagInfo("directive.include", null, "empty", directiveJspData[1].getInfoString(), null, null, directiveJspData[0].getAttributes())};
            serializable = new ArrayList();
            for (n = 0; n < xmlJspTagDatas.length; ++n) {
                ((ArrayList)serializable).add(xmlJspTagDatas[n]);
            }
            for (n = 0; n < standardJspTagDatas.length; ++n) {
                ((ArrayList)serializable).add(standardJspTagDatas[n]);
            }
            for (n = 0; n < tagInfoArray.length; ++n) {
                ((ArrayList)serializable).add(tagInfoArray[n]);
            }
            Collections.sort(serializable, TAG_NAME_COMPARATOR);
            xmlJspTagDatas = new TagInfo[((ArrayList)serializable).size()];
            for (n = 0; n < ((ArrayList)serializable).size(); ++n) {
                JspSyntaxSupport.xmlJspTagDatas[n] = (TagInfo)((ArrayList)serializable).get(n);
            }
            xmlTagFileTagDatas = new TagInfo[]{new TagInfo("directive.tag", null, "empty", directiveTagFileData[2].getInfoString(), null, null, directiveTagFileData[2].getAttributes()), new TagInfo("directive.attribute", null, "empty", directiveTagFileData[0].getInfoString(), null, null, directiveTagFileData[0].getAttributes()), new TagInfo("directive.variable", null, "empty", directiveTagFileData[4].getInfoString(), null, null, directiveTagFileData[4].getAttributes()), new TagInfo("directive.include", null, "empty", directiveJspData[1].getInfoString(), null, null, directiveJspData[0].getAttributes())};
            serializable = new ArrayList();
            for (n = 0; n < xmlTagFileTagDatas.length; ++n) {
                ((ArrayList)serializable).add(xmlTagFileTagDatas[n]);
            }
            for (n = 0; n < standardTagTagDatas.length; ++n) {
                ((ArrayList)serializable).add(standardTagTagDatas[n]);
            }
            for (n = 0; n < tagInfoArray.length; ++n) {
                ((ArrayList)serializable).add(tagInfoArray[n]);
            }
            Collections.sort(serializable, TAG_NAME_COMPARATOR);
            xmlTagFileTagDatas = new TagInfo[((ArrayList)serializable).size()];
            for (n = 0; n < ((ArrayList)serializable).size(); ++n) {
                JspSyntaxSupport.xmlTagFileTagDatas[n] = (TagInfo)((ArrayList)serializable).get(n);
            }
        }
    }

    private TagInfo[] getTagInfos() {
        TagInfo[] tagInfoArray = this.fobj != null && ("text/x-jsp".equals(this.fobj.getMIMEType()) || "text/x-tag".equals(this.fobj.getMIMEType())) ? (this.isXmlSyntax() ? (NbEditorUtilities.getMimeType((Document)this.getDocument()).equals("text/x-tag") ? xmlTagFileTagDatas : xmlJspTagDatas) : (NbEditorUtilities.getMimeType((Document)this.getDocument()).equals("text/x-tag") ? standardTagTagDatas : standardJspTagDatas)) : new TagInfo[]{};
        return tagInfoArray;
    }

    public String toString() {
        return this.printJspCompletionInfo();
    }

    private String printJspCompletionInfo() {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TAGS\n");
        List list = this.getTagPrefixes("");
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            stringBuffer.append("  " + string + "\n");
            object2 = this.getTags(string, "");
            for (int j = 0; j < object2.size(); ++j) {
                int n;
                Object object3;
                if (object2.get(j) instanceof TagInfo) {
                    object3 = (TagInfo)object2.get(j);
                    stringBuffer.append("    " + object3.getTagName() + "\n");
                    object = object3.getAttributes();
                    for (n = 0; n < ((TagAttributeInfo[])object).length; ++n) {
                        stringBuffer.append("      " + object[n].getName() + "\n");
                    }
                    continue;
                }
                object3 = (String)object2.get(j);
                stringBuffer.append("    " + (String)object3 + "\n");
                object = this.getTagAttributes(string, (String)object3, "");
                for (n = 0; n < object.size(); ++n) {
                    String string2 = (String)object.get(n);
                    stringBuffer.append("      " + string2 + "\n");
                }
            }
        }
        stringBuffer.append("DIRECTIVES\n");
        List list2 = this.getDirectives("");
        for (int i = 0; i < list2.size(); ++i) {
            int n;
            Object object4;
            if (list2.get(i) instanceof TagInfo) {
                object2 = (TagInfo)list2.get(i);
                stringBuffer.append("    " + object2.getTagName() + "\n");
                object4 = object2.getAttributes();
                for (n = 0; n < ((TagAttributeInfo[])object4).length; ++n) {
                    stringBuffer.append("      " + object4[n].getName() + "\n");
                }
                continue;
            }
            object2 = (String)list2.get(i);
            stringBuffer.append("  " + (String)object2 + "\n");
            object4 = this.getDirectiveAttributes((String)object2, "");
            for (n = 0; n < object4.size(); ++n) {
                object = (TagAttributeInfo[])object4.get(n);
                stringBuffer.append("      " + (String)object + "\n");
            }
        }
        return stringBuffer.toString();
    }

    @Deprecated
    public TokenItem getItemAtOrBefore(int n) throws BadLocationException {
        TokenItem tokenItem;
        TokenItem tokenItem2 = null;
        int n2 = 100;
        while (tokenItem2 == null) {
            tokenItem2 = n < this.getDocument().getLength() ? this.getTokenChain(n, Math.min(n + n2, this.getDocument().getLength())) : this.getTokenChain(Math.max(n - 50, 0), n);
            if (n2++ <= 1000) continue;
        }
        if (tokenItem2 == null) {
            return null;
        }
        while (true) {
            if ((tokenItem = tokenItem2.getNext()) == null) {
                tokenItem = tokenItem2;
                break;
            }
            if (tokenItem.getOffset() > n) {
                tokenItem = tokenItem2;
                break;
            }
            tokenItem2 = tokenItem;
        }
        TokenItem tokenItem3 = tokenItem.getOffset() == n ? tokenItem.getPrevious() : tokenItem;
        TokenID tokenID = tokenItem3 == null ? tokenItem.getTokenID() : tokenItem3.getTokenID();
        return tokenItem3;
    }

    public SyntaxElement getElementChain(int n) throws BadLocationException {
        TokenItem tokenItem = this.getItemAtOrBefore(n);
        if (tokenItem == null) {
            return null;
        }
        TokenID tokenID = tokenItem.getTokenID();
        if (tokenID == JspTagTokenContext.ERROR || tokenID == JspTagTokenContext.TEXT || tokenID == JspMultiTokenContext.ERROR || tokenID == JspDirectiveTokenContext.ERROR || tokenID == JspDirectiveTokenContext.TEXT) {
            return null;
        }
        if (tokenID == JspTagTokenContext.COMMENT || tokenID == JspDirectiveTokenContext.COMMENT) {
            return this.getCommentChain(tokenItem, n);
        }
        if (tokenItem.getTokenContextPath().contains(ELTokenContext.contextPath)) {
            return this.getELChain(tokenItem, n);
        }
        if (tokenID == JspTagTokenContext.SYMBOL2 || tokenID == JspDirectiveTokenContext.SYMBOL2) {
            if (this.isScriptStartToken(tokenItem)) {
                return this.getScriptingChain(tokenItem, n);
            }
            if (this.getTokenEnd(tokenItem) == n && this.isScriptEndToken(tokenItem)) {
                TokenItem tokenItem2 = tokenItem.getNext();
                if (!this.isTagDirToken(tokenItem)) {
                    return this.getContentChain(tokenItem, n);
                }
            }
            return null;
        }
        if (tokenID == JspTagTokenContext.TAG || tokenID == JspTagTokenContext.SYMBOL || tokenID == JspTagTokenContext.ATTRIBUTE || tokenID == JspTagTokenContext.ATTR_VALUE || tokenID == JspTagTokenContext.WHITESPACE || tokenID == JspTagTokenContext.EOL || tokenID == JspDirectiveTokenContext.TAG || tokenID == JspDirectiveTokenContext.SYMBOL || tokenID == JspDirectiveTokenContext.ATTRIBUTE || tokenID == JspDirectiveTokenContext.ATTR_VALUE || tokenID == JspDirectiveTokenContext.WHITESPACE || tokenID == JspDirectiveTokenContext.EOL) {
            TokenItem tokenItem3 = tokenItem;
            while (true) {
                if (tokenItem3 == null) {
                    return null;
                }
                if (tokenItem3.getTokenID() == JspTagTokenContext.SYMBOL || tokenItem3.getTokenID() == JspDirectiveTokenContext.SYMBOL) {
                    if (tokenItem3.getImage().equals("<")) {
                        return this.getTagOrDirectiveChain(true, tokenItem3, n);
                    }
                    if (tokenItem3.getImage().equals("</")) {
                        return this.getEndTagChain(tokenItem3, n);
                    }
                    if (tokenItem3.getImage().equals("<%@")) {
                        return this.getTagOrDirectiveChain(false, tokenItem3, n);
                    }
                }
                if (tokenItem3.getTokenID() == JspTagTokenContext.ERROR || tokenItem3.getTokenID() == JspDirectiveTokenContext.ERROR) {
                    return null;
                }
                if (tokenItem3.getTokenID() == JspTagTokenContext.COMMENT || tokenItem3.getTokenID() == JspDirectiveTokenContext.COMMENT) {
                    return null;
                }
                tokenItem3 = tokenItem3.getPrevious();
            }
        }
        if (this.isScriptingOrContentToken(tokenItem)) {
            TokenItem tokenItem4 = tokenItem;
            do {
                if (tokenItem4.getPrevious() != null) continue;
                return this.getContentChain(tokenItem4, n);
            } while (this.isScriptingOrContentToken(tokenItem4 = tokenItem4.getPrevious()) && tokenItem4.getTokenID() != JspTagTokenContext.COMMENT && tokenItem4.getTokenID() != JspDirectiveTokenContext.COMMENT && !tokenItem4.getTokenContextPath().contains(ELTokenContext.contextPath));
            if (this.isScriptStartToken(tokenItem4)) {
                return this.getScriptingChain(tokenItem4.getNext(), n);
            }
            return this.getContentChain(tokenItem4.getNext(), n);
        }
        return null;
    }

    private boolean isScriptStartToken(TokenItem tokenItem) {
        String string;
        if (tokenItem == null) {
            return false;
        }
        TokenID tokenID = tokenItem.getTokenID();
        return !(tokenID != JspTagTokenContext.SYMBOL2 && tokenID != JspDirectiveTokenContext.SYMBOL2 || !(string = tokenItem.getImage()).equals("<%") && !string.equals("<%=") && !string.equals("<%!"));
    }

    private boolean isScriptEndToken(TokenItem tokenItem) {
        String string;
        if (tokenItem == null) {
            return false;
        }
        TokenID tokenID = tokenItem.getTokenID();
        return (tokenID == JspTagTokenContext.SYMBOL2 || tokenID == JspDirectiveTokenContext.SYMBOL2) && (string = tokenItem.getImage()).equals("%>");
    }

    private boolean isInnerTagDirToken(TokenItem tokenItem) {
        String string;
        if (!this.isTagDirToken(tokenItem)) {
            return false;
        }
        TokenID tokenID = tokenItem.getTokenID();
        return tokenID != JspTagTokenContext.SYMBOL && tokenID != JspDirectiveTokenContext.SYMBOL || !(string = tokenItem.getImage()).equals("<") && !string.equals("</") && !string.equals("<%@") && !string.equals("%>") && !string.equals(">") && !string.equals("/>");
    }

    private boolean isTagDirToken(TokenItem tokenItem) {
        if (tokenItem == null) {
            return false;
        }
        TokenID tokenID = tokenItem.getTokenID();
        if (tokenID == null) {
            return false;
        }
        return tokenID == JspTagTokenContext.TEXT || tokenID == JspTagTokenContext.ERROR || tokenID == JspTagTokenContext.TAG || tokenID == JspTagTokenContext.SYMBOL || tokenID == JspTagTokenContext.ATTRIBUTE || tokenID == JspTagTokenContext.ATTR_VALUE || tokenID == JspTagTokenContext.WHITESPACE || tokenID == JspTagTokenContext.EOL || tokenID == JspDirectiveTokenContext.TEXT || tokenID == JspDirectiveTokenContext.ERROR || tokenID == JspDirectiveTokenContext.TAG || tokenID == JspDirectiveTokenContext.SYMBOL || tokenID == JspDirectiveTokenContext.ATTRIBUTE || tokenID == JspDirectiveTokenContext.ATTR_VALUE || tokenID == JspDirectiveTokenContext.WHITESPACE || tokenID == JspDirectiveTokenContext.EOL;
    }

    private boolean isScriptingOrContentToken(TokenItem tokenItem) {
        if (tokenItem == null) {
            return true;
        }
        TokenID tokenID = tokenItem.getTokenID();
        if (tokenID == null) {
            return true;
        }
        return tokenID != JspTagTokenContext.TEXT && tokenID != JspTagTokenContext.ERROR && tokenID != JspTagTokenContext.TAG && tokenID != JspTagTokenContext.SYMBOL && tokenID != JspTagTokenContext.ATTRIBUTE && tokenID != JspTagTokenContext.ATTR_VALUE && tokenID != JspTagTokenContext.SYMBOL2 && tokenID != JspTagTokenContext.EOL && tokenID != JspDirectiveTokenContext.TEXT && tokenID != JspDirectiveTokenContext.ERROR && tokenID != JspDirectiveTokenContext.TAG && tokenID != JspDirectiveTokenContext.SYMBOL && tokenID != JspDirectiveTokenContext.ATTRIBUTE && tokenID != JspDirectiveTokenContext.ATTR_VALUE && tokenID != JspDirectiveTokenContext.SYMBOL2 && tokenID != JspDirectiveTokenContext.EOL && tokenID != JspMultiTokenContext.ERROR;
    }

    public boolean isValueBeginning(String string) {
        if (string.trim().endsWith("\"\"")) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '=' || c == '\"') continue;
            return false;
        }
        return true;
    }

    private SyntaxElement getCommentChain(TokenItem tokenItem, int n) {
        TokenItem tokenItem2 = null;
        TokenItem tokenItem3 = tokenItem;
        do {
            if (tokenItem3 == null || !tokenItem3.getImage().startsWith("<%--")) continue;
            tokenItem2 = tokenItem3;
            break;
        } while ((tokenItem3 = tokenItem3.getPrevious()) != null);
        if (tokenItem2 == null) {
            return null;
        }
        TokenItem tokenItem4 = null;
        TokenItem tokenItem5 = tokenItem;
        tokenItem3 = tokenItem;
        do {
            if (tokenItem3 != null && tokenItem3.getImage().endsWith("--%>")) {
                tokenItem4 = tokenItem3;
                break;
            }
            tokenItem5 = tokenItem3;
        } while ((tokenItem3 = tokenItem3.getNext()) != null);
        if (tokenItem4 == null) {
            tokenItem4 = tokenItem5;
        }
        return new SyntaxElement.Comment(this, tokenItem2.getOffset(), this.getTokenEnd(tokenItem4));
    }

    private SyntaxElement getELChain(TokenItem tokenItem, int n) {
        TokenItem tokenItem2 = tokenItem;
        TokenItem tokenItem3 = null;
        do {
            tokenItem3 = tokenItem2;
        } while ((tokenItem2 = tokenItem2.getPrevious()) != null && tokenItem2.getTokenContextPath().contains(ELTokenContext.contextPath));
        TokenItem tokenItem4 = null;
        tokenItem2 = tokenItem;
        do {
            tokenItem4 = tokenItem2;
        } while ((tokenItem2 = tokenItem2.getNext()) != null && tokenItem2.getTokenContextPath().contains(ELTokenContext.contextPath));
        return new SyntaxElement.ExpressionLanguage(this, tokenItem3.getOffset(), this.getTokenEnd(tokenItem4));
    }

    private SyntaxElement getTagOrDirectiveChain(boolean bl, TokenItem tokenItem, int n) {
        TokenItem tokenItem2;
        String string = this.getWholeWord(tokenItem2, (TokenID)JspTagTokenContext.TAG);
        for (tokenItem2 = tokenItem.getNext(); tokenItem2 != null && (tokenItem2.getTokenID().getNumericID() == 3 || tokenItem2.getTokenID().getNumericID() == 11); tokenItem2 = tokenItem2.getNext()) {
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        while (this.isInnerTagDirToken(tokenItem2)) {
            if (tokenItem2.getTokenID().getNumericID() == 7) {
                String string2 = this.getWholeWord(tokenItem2, (TokenID)JspTagTokenContext.ATTRIBUTE);
                while (tokenItem2 != null && tokenItem2.getTokenID().getNumericID() == 7) {
                    tokenItem2 = tokenItem2.getNext();
                }
                while (tokenItem2 != null && tokenItem2.getTokenID().getNumericID() == 4 && this.isValueBeginning(tokenItem2.getImage())) {
                    tokenItem2 = tokenItem2.getNext();
                }
                StringBuffer stringBuffer = new StringBuffer();
                while (tokenItem2 != null && (tokenItem2.getTokenID().getNumericID() == 8 || tokenItem2.getTokenID().getNumericID() == 9)) {
                    stringBuffer.append(tokenItem2.getImage());
                    if (tokenItem2 != null && tokenItem2.getTokenID().getNumericID() == 5) {
                        for (tokenItem2 = tokenItem2.getNext(); !this.isScriptEndToken(tokenItem2) && tokenItem2 != null; tokenItem2 = tokenItem2.getNext()) {
                            stringBuffer.append(tokenItem2.getImage());
                        }
                        if (tokenItem2 != null) {
                            stringBuffer.append(tokenItem2.getImage());
                            tokenItem2 = tokenItem2.getNext();
                        }
                    }
                    if (tokenItem2 == null || !tokenItem2.getTokenContextPath().contains(ELTokenContext.contextPath)) continue;
                    while (tokenItem2.getTokenContextPath().contains(ELTokenContext.contextPath) && (tokenItem2 = tokenItem2.getNext()) != null) {
                        stringBuffer.append(tokenItem2.getImage());
                    }
                }
                String string3 = stringBuffer.toString();
                if (string3.startsWith("\"")) {
                    string3 = string3.substring(1);
                }
                if (string3.endsWith("\"")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                treeMap.put(string2, string3);
                continue;
            }
            if (tokenItem2.getTokenID().getNumericID() == 5) {
                while (!this.isScriptEndToken(tokenItem2) && tokenItem2 != null) {
                    tokenItem2 = tokenItem2.getNext();
                }
                if (tokenItem2 == null) continue;
                tokenItem2 = tokenItem2.getNext();
                continue;
            }
            tokenItem2 = tokenItem2.getNext();
        }
        if (bl) {
            boolean bl2 = false;
            if (tokenItem2 != null) {
                bl2 = tokenItem2.getImage().equals("/>");
            }
            return new SyntaxElement.Tag(this, tokenItem.getOffset(), tokenItem2 != null ? this.getTokenEnd(tokenItem2) : this.getDocument().getLength(), string, treeMap, bl2);
        }
        return new SyntaxElement.Directive(this, tokenItem.getOffset(), tokenItem2 != null ? this.getTokenEnd(tokenItem2) : this.getDocument().getLength(), string, treeMap);
    }

    private SyntaxElement getEndTagChain(TokenItem tokenItem, int n) {
        TokenItem tokenItem2;
        String string = this.getWholeWord(tokenItem2, (TokenID)JspTagTokenContext.TAG);
        for (tokenItem2 = tokenItem.getNext(); tokenItem2 != null && tokenItem2.getTokenID() == JspTagTokenContext.TAG; tokenItem2 = tokenItem2.getNext()) {
        }
        while (this.isInnerTagDirToken(tokenItem2)) {
            tokenItem2 = tokenItem2.getNext();
        }
        return new SyntaxElement.EndTag(this, tokenItem.getOffset(), this.getTokenEnd(tokenItem2), string);
    }

    private String getWholeWord(TokenItem tokenItem, TokenID tokenID) {
        StringBuffer stringBuffer = new StringBuffer();
        while (tokenItem != null && tokenItem.getTokenID().getNumericID() == tokenID.getNumericID()) {
            stringBuffer.append(tokenItem.getImage());
            tokenItem = tokenItem.getNext();
        }
        return stringBuffer.toString().trim();
    }

    private SyntaxElement getScriptingChain(TokenItem tokenItem, int n) {
        if (tokenItem == null) {
            return new SyntaxElement.ScriptingL(this, this.getDocument().getLength(), this.getDocument().getLength());
        }
        TokenItem tokenItem2 = tokenItem;
        TokenItem tokenItem3;
        while ((tokenItem3 = tokenItem2.getNext()) != null) {
            if (!this.isScriptingOrContentToken(tokenItem3)) {
                return new SyntaxElement.ScriptingL(this, tokenItem.getOffset(), this.getTokenEnd(tokenItem3));
            }
            tokenItem2 = tokenItem3;
        }
        return new SyntaxElement.ScriptingL(this, tokenItem.getOffset(), this.getDocument().getLength());
    }

    private SyntaxElement getContentChain(TokenItem tokenItem, int n) {
        if (tokenItem == null) {
            return new SyntaxElement.ContentL(this, this.getDocument().getLength(), this.getDocument().getLength());
        }
        TokenItem tokenItem2 = tokenItem;
        TokenItem tokenItem3;
        while ((tokenItem3 = tokenItem2.getNext()) != null) {
            if (!this.isScriptingOrContentToken(tokenItem3) || tokenItem3.getTokenID() == JspTagTokenContext.COMMENT || tokenItem3.getTokenID() == JspDirectiveTokenContext.COMMENT || tokenItem3.getTokenContextPath().contains(ELTokenContext.contextPath)) {
                return new SyntaxElement.ContentL(this, tokenItem.getOffset(), this.getTokenEnd(tokenItem2));
            }
            tokenItem2 = tokenItem3;
        }
        return new SyntaxElement.ContentL(this, tokenItem.getOffset(), this.getDocument().getLength());
    }

    SyntaxElement getPreviousElement(int n) throws BadLocationException {
        if (n == 0) {
            return null;
        }
        SyntaxElement syntaxElement = null;
        --n;
        do {
            if ((syntaxElement = this.getElementChain(n)) != null) continue;
            TokenItem tokenItem = this.getItemAtOrBefore(n);
            if (tokenItem == null) {
                return null;
            }
            n = tokenItem.getOffset() - 1;
        } while (syntaxElement == null && n >= 0);
        return syntaxElement;
    }

    SyntaxElement getNextElement(int n) throws BadLocationException {
        int n2 = this.getDocument().getLength();
        if (n >= n2) {
            return null;
        }
        SyntaxElement syntaxElement = null;
        ++n;
        do {
            if ((syntaxElement = this.getElementChain(n)) != null) continue;
            TokenItem tokenItem = this.getItemAtOrBefore(n);
            if (tokenItem == null) {
                return null;
            }
            n = this.getTokenEnd(tokenItem) + 1;
        } while (syntaxElement == null && n < n2);
        return syntaxElement;
    }

    public List getPossibleEndTags(int n, String string) throws BadLocationException {
        return this.getPossibleEndTags(n, string, false);
    }

    /*
     * Unable to fully structure code
     */
    public List getPossibleEndTags(int var1_1, String var2_2, boolean var3_3) throws BadLocationException {
        var4_4 = this.getElementChain(var1_1);
        var5_5 = new Stack<String>();
        var6_6 = new ArrayList<JspCompletionItem.Tag>();
        var7_7 = new HashSet<String>();
        if (var4_4 != null) {
            var4_4 = var4_4.getPrevious();
        } else if (var1_1 > 0) {
            var4_4 = this.getElementChain(var1_1 - 1);
        } else {
            return var6_6;
        }
        while (var4_4 != null) {
            block13: {
                block15: {
                    block14: {
                        block12: {
                            if (!(var4_4 instanceof SyntaxElement.EndTag)) break block12;
                            var5_5.push(((SyntaxElement.EndTag)var4_4).getName());
                            break block13;
                        }
                        if (!(var4_4 instanceof SyntaxElement.Tag) || (var8_8 = (SyntaxElement.Tag)var4_4).isClosed()) break block13;
                        var9_9 = var8_8.getName();
                        var10_10 = var9_9.substring(0, var9_9.indexOf(58));
                        var11_11 = var9_9.substring(var9_9.indexOf(58) + 1);
                        var12_12 = null;
                        var13_13 = this.getTagLibrary(var10_10);
                        if (var13_13 != null && (var12_12 = var13_13.getTag(var11_11)) == null && (var14_14 = var13_13.getTagFile(var11_11)) != null) {
                            var12_12 = var14_14.getTagInfo();
                        }
                        if ("jsp".equals(var10_10)) {
                            JspSyntaxSupport.initCompletionData();
                            var14_14 = this.getTagInfos();
                            for (var15_15 = 0; var15_15 < ((TagFileInfo)var14_14).length; ++var15_15) {
                                if (!var14_14[var15_15].getTagName().equals(var11_11)) continue;
                                var12_12 = var14_14[var15_15];
                                break;
                            }
                        }
                        if (var12_12 == null) break block13;
                        if (!var5_5.empty()) break block14;
                        if (!var9_9.startsWith(var2_2) || var7_7.contains(var9_9)) break block15;
                        var7_7.add(var9_9);
                        if (!var12_12.getBodyContent().equalsIgnoreCase("empty")) {
                            var6_6.add(new JspCompletionItem.Tag("/" + var9_9, var12_12));
                            if (var3_3) {
                                break;
                            } else {
                                ** GOTO lbl44
                            }
                        }
                        break block13;
lbl44:
                        // 2 sources

                        break block15;
                    }
                    if (var5_5.peek().equals(var9_9)) {
                        var5_5.pop();
                    }
                }
                if (var12_12.getBodyContent().equalsIgnoreCase("empty")) {
                    // empty if block
                }
            }
            var4_4 = var4_4.getPrevious();
        }
        return var6_6;
    }

    public CompletionItem getAutocompletedEndTag(int n) {
        try {
            SyntaxElement syntaxElement = this.getElementChain(n - 1);
            if (syntaxElement != null && syntaxElement instanceof SyntaxElement.Tag) {
                String string = ((SyntaxElement.Tag)syntaxElement).getName();
                return new HTMLCompletionQuery.AutocompleteEndTagItem(string, n, false);
            }
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger("global").log(Level.INFO, null, badLocationException);
        }
        return null;
    }

    public FileObject getFileObject() {
        return this.fobj;
    }

    protected ExtSyntaxSupport.BracketFinder getMatchingBracketFinder(char c) {
        if (this.useCustomBracketFinder) {
            BracketFinder bracketFinder = new BracketFinder(c);
            return bracketFinder.isValid() ? bracketFinder : null;
        }
        return super.getMatchingBracketFinder(c);
    }

    public int[] findMatchingBlock(int n, boolean bl) throws BadLocationException {
        int[] nArray = null;
        TokenItem tokenItem = this.getItemAtOrBefore(n < this.getDocument().getLength() ? n + 1 : n);
        if (tokenItem != null) {
            if (tokenItem.getTokenContextPath().contains(HTMLTokenContext.contextPath)) {
                nArray = this.getContentLanguageSyntaxSupport().findMatchingBlock(n, bl);
            } else {
                if (tokenItem.getTokenID() == JspTagTokenContext.COMMENT) {
                    return this.findMatchingJspComment(tokenItem, n);
                }
                if (tokenItem.getTokenContextPath().contains(JspTagTokenContext.contextPath) && tokenItem.getTokenID().getNumericID() == 5) {
                    return this.findMatchingScripletDelimiter(tokenItem);
                }
                if (tokenItem.getTokenContextPath().contains(JspTagTokenContext.contextPath)) {
                    return this.findMatchingTag(tokenItem);
                }
                this.useCustomBracketFinder = !this.isScriptingOrContentToken(tokenItem);
                nArray = super.findMatchingBlock(n, bl);
            }
        }
        return nArray;
    }

    private int[] findMatchingJspComment(TokenItem tokenItem, int n) {
        block5: {
            String string;
            block4: {
                string = tokenItem.getImage();
                if (!string.startsWith("<%--") || n >= tokenItem.getOffset() + "<%--".length()) break block4;
                while (tokenItem != null && (tokenItem.getTokenID() == JspTagTokenContext.COMMENT || tokenItem.getTokenID() == JspTagTokenContext.EOL)) {
                    if (tokenItem.getImage().endsWith("--%>")) {
                        int n2 = tokenItem.getOffset() + tokenItem.getImage().length() - "--%>".length();
                        int n3 = tokenItem.getOffset() + tokenItem.getImage().length();
                        return new int[]{n2, n3};
                    }
                    tokenItem = tokenItem.getNext();
                }
                break block5;
            }
            if (!string.endsWith("--%>") || n < tokenItem.getOffset() + tokenItem.getImage().length() - "--%>".length()) break block5;
            while (tokenItem != null && (tokenItem.getTokenID() == JspTagTokenContext.COMMENT || tokenItem.getTokenID() == JspTagTokenContext.EOL)) {
                if (tokenItem.getImage().startsWith("<%--")) {
                    int n4 = tokenItem.getOffset();
                    int n5 = tokenItem.getOffset() + "<%--".length();
                    return new int[]{n4, n5};
                }
                tokenItem = tokenItem.getPrevious();
            }
        }
        return null;
    }

    private int[] findMatchingScripletDelimiter(TokenItem tokenItem) {
        if (tokenItem.getImage().charAt(0) == '<') {
            while (!((tokenItem = tokenItem.getNext()) == null || tokenItem.getTokenContextPath().contains(JspTagTokenContext.contextPath) && tokenItem.getTokenID().getNumericID() == 5)) {
            }
        } else {
            while (!((tokenItem = tokenItem.getPrevious()) == null || tokenItem.getTokenContextPath().contains(JspTagTokenContext.contextPath) && tokenItem.getTokenID().getNumericID() == 5)) {
            }
        }
        if (tokenItem != null) {
            return new int[]{tokenItem.getOffset(), tokenItem.getOffset() + tokenItem.getImage().length()};
        }
        return null;
    }

    private int[] findMatchingTag(TokenItem tokenItem) {
        block27: {
            String string;
            int n;
            block28: {
                if (tokenItem != null && tokenItem.getTokenID().getNumericID() == 4 && tokenItem.getImage().charAt(tokenItem.getImage().length() - 1) == '>') {
                    tokenItem = tokenItem.getPrevious();
                }
                boolean bl = false;
                if (tokenItem != null && (tokenItem.getTokenID().getNumericID() == 3 && tokenItem.getImage().trim().length() > 0 || tokenItem.getTokenID().getNumericID() == 4 && tokenItem.getImage().charAt(0) == '<')) {
                    if (tokenItem.getTokenID().getNumericID() == 4) {
                        while (tokenItem != null && (tokenItem.getTokenID().getNumericID() != 3 || tokenItem.getImage().trim().length() <= 0)) {
                            tokenItem = tokenItem.getNext();
                        }
                    }
                    bl = true;
                } else if (tokenItem != null && (tokenItem.getTokenID().getNumericID() != 3 || tokenItem.getImage().trim().length() <= 0)) {
                    for (tokenItem = tokenItem.getPrevious(); !(tokenItem == null || tokenItem.getTokenID().getNumericID() == 3 && tokenItem.getImage().trim().length() > 0 || tokenItem.getTokenID().getNumericID() == 4 && tokenItem.getImage().charAt(tokenItem.getImage().length() - 1) == '>'); tokenItem = tokenItem.getPrevious()) {
                    }
                    if (tokenItem != null && tokenItem.getTokenID().getNumericID() == 3) {
                        bl = true;
                    }
                }
                if (tokenItem == null || tokenItem.getTokenID().getNumericID() != 3 || !bl) break block27;
                n = 0;
                string = tokenItem.getImage().trim();
                while (tokenItem != null && tokenItem.getTokenID().getNumericID() != 4) {
                    tokenItem = tokenItem.getPrevious();
                }
                if (tokenItem == null) {
                    return null;
                }
                if (tokenItem.getImage().length() != 2 || tokenItem.getImage().charAt(1) != '/') break block28;
                while (tokenItem != null) {
                    if (tokenItem.getTokenID().getNumericID() == 3 && tokenItem.getImage().trim().equals(string)) {
                        while (tokenItem != null && tokenItem.getTokenID().getNumericID() != 4) {
                            tokenItem = tokenItem.getPrevious();
                        }
                        if (tokenItem != null) {
                            if (tokenItem.getImage().length() == 1) {
                                if (n == 0) {
                                    int n2 = tokenItem.getOffset();
                                    tokenItem = tokenItem.getNext();
                                    int n3 = tokenItem.getOffset() + tokenItem.getImage().length();
                                    TokenItem tokenItem2 = tokenItem.getNext();
                                    if (tokenItem2 != null && tokenItem2.getTokenID() == JspTagTokenContext.SYMBOL && tokenItem2.getImage().endsWith(">")) {
                                        n3 += tokenItem2.getImage().length();
                                    }
                                    return new int[]{n2, n3};
                                }
                                ++n;
                            }
                            if (tokenItem.getImage().length() == 2) {
                                --n;
                            }
                        }
                    }
                    tokenItem = tokenItem.getPrevious();
                }
                break block27;
            }
            if (tokenItem.getImage().length() != 1 || tokenItem.getImage().charAt(0) != '<') break block27;
            n = 1;
            while (tokenItem != null) {
                if (tokenItem.getTokenID().getNumericID() == 3 && tokenItem.getImage().trim().equals(string)) {
                    TokenItem tokenItem3 = tokenItem;
                    while (tokenItem != null && tokenItem.getTokenID().getNumericID() != 4) {
                        tokenItem = tokenItem.getPrevious();
                    }
                    if (tokenItem != null) {
                        if (tokenItem.getImage().length() == 2) {
                            if (n == 0) {
                                int n4 = tokenItem.getOffset();
                                int n5 = tokenItem3.getOffset() + tokenItem3.getImage().length() + 1;
                                for (tokenItem = tokenItem.getNext(); tokenItem != null && (tokenItem.getTokenID().getNumericID() != 4 || tokenItem.getImage().charAt(0) != '>'); tokenItem = tokenItem.getNext()) {
                                }
                                if (tokenItem != null) {
                                    n5 = tokenItem.getOffset() + 1;
                                }
                                return new int[]{n4, n5};
                            }
                            ++n;
                        }
                        if (tokenItem.getImage().length() == 1) {
                            --n;
                        }
                    }
                    tokenItem = tokenItem3;
                }
                tokenItem = tokenItem.getNext();
            }
        }
        return null;
    }

    public boolean isSingletonTag(TokenItem tokenItem) {
        for (TokenItem tokenItem2 = tokenItem; tokenItem2 != null; tokenItem2 = tokenItem2.getNext()) {
            if (tokenItem2.getTokenID() == JspTagTokenContext.SYMBOL) {
                if ("/>".equals(tokenItem2.getImage())) {
                    return true;
                }
                if (">".equals(tokenItem2.getImage())) {
                    return false;
                }
            }
            if (tokenItem2.getTokenID() == JspTagTokenContext.TEXT) break;
        }
        return false;
    }

    protected TokenID[] getBracketSkipTokens() {
        return JSP_BRACKET_SKIP_TOKENS;
    }

    public static TokenSequence tokenSequence(TokenHierarchy tokenHierarchy, Language language, int n) {
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence(language);
        if (tokenSequence == null) {
            tokenSequence = tokenHierarchy.tokenSequence();
            int n2 = tokenSequence.move(n);
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                return null;
            }
            tokenSequence = tokenSequence.embedded(language);
        }
        return tokenSequence;
    }

    static {
        helpMap = null;
        JSP_BRACKET_SKIP_TOKENS = new TokenID[]{JavaTokenContext.LINE_COMMENT, JavaTokenContext.BLOCK_COMMENT, JavaTokenContext.CHAR_LITERAL, JavaTokenContext.STRING_LITERAL, JspTagTokenContext.ATTR_VALUE, JspTagTokenContext.COMMENT};
        TAG_NAME_COMPARATOR = new TagNameComparator();
    }

    private static class TagNameComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (object == object2 || object == null || object2 == null) {
                return 0;
            }
            String string = ((TagInfo)object).getTagName();
            String string2 = ((TagInfo)object2).getTagName();
            if (string == null || string2 == null) {
                return 0;
            }
            return string.compareTo(string2);
        }
    }

    public class BracketFinder
    extends ExtSyntaxSupport.BracketFinder {
        BracketFinder(char c) {
            super((ExtSyntaxSupport)JspSyntaxSupport.this, c);
        }

        protected boolean updateStatus() {
            if (super.updateStatus()) {
                return true;
            }
            boolean bl = true;
            switch (this.bracketChar) {
                case '<': {
                    this.matchChar = (char)62;
                    this.moveCount = 1;
                    break;
                }
                case '>': {
                    this.matchChar = (char)60;
                    this.moveCount = -1;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }

        boolean isValid() {
            return this.moveCount != 0;
        }
    }
}

