/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.palette;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.spi.palette.PaletteController;
import org.netbeans.spi.palette.PaletteTopComponent;
import org.netbeans.spi.palette.PaletteVisibility;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PaletteSwitch
implements Runnable,
LookupListener {
    static final String PROP_PALETTE_CONTENTS = "component_palette_contents";
    private static PaletteSwitch theInstance;
    private PropertyChangeListener registryListener;
    private PropertyChangeSupport propertySupport;
    private PaletteController currentPalette;
    private Lookup.Result lookupRes;
    private Map<TopComponent, Lookup.Result> watchedLkpResults = new HashMap<TopComponent, Lookup.Result>(3);

    private PaletteSwitch() {
        this.propertySupport = new PropertyChangeSupport(this);
    }

    public static synchronized PaletteSwitch getDefault() {
        if (null == theInstance) {
            theInstance = new PaletteSwitch();
        }
        return theInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startListening() {
        PaletteSwitch paletteSwitch = theInstance;
        synchronized (paletteSwitch) {
            if (null == this.registryListener) {
                this.registryListener = this.createRegistryListener();
                TopComponent.getRegistry().addPropertyChangeListener(this.registryListener);
                this.switchLookupListener();
                this.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopListening() {
        PaletteSwitch paletteSwitch = theInstance;
        synchronized (paletteSwitch) {
            if (null != this.registryListener) {
                TopComponent.getRegistry().removePropertyChangeListener(this.registryListener);
                this.registryListener = null;
                this.currentPalette = null;
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public PaletteController getCurrentPalette() {
        return this.currentPalette;
    }

    @Override
    public void run() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this);
            return;
        }
        PaletteController paletteController = this.currentPalette;
        this.currentPalette = this.findPalette();
        this.showHidePaletteTopComponent(paletteController, this.currentPalette);
        this.propertySupport.firePropertyChange(PROP_PALETTE_CONTENTS, paletteController, this.currentPalette);
    }

    private PaletteController findPalette() {
        TopComponent.Registry registry = TopComponent.getRegistry();
        TopComponent topComponent = registry.getActivated();
        PaletteController paletteController = this.getPaletteFromTopComponent(topComponent, true);
        ArrayList<PaletteController> arrayList = new ArrayList<PaletteController>(3);
        if (null == paletteController) {
            Set set = registry.getOpened();
            for (TopComponent topComponent2 : set) {
                paletteController = this.getPaletteFromTopComponent(topComponent2, true);
                if (null == paletteController) continue;
                arrayList.add(paletteController);
            }
            if (null != this.currentPalette && (arrayList.contains(this.currentPalette) || this.isPaletteMaximized())) {
                paletteController = this.currentPalette;
            } else if (arrayList.size() > 0) {
                paletteController = (PaletteController)arrayList.get(0);
            }
        }
        return paletteController;
    }

    private boolean isPaletteMaximized() {
        boolean bl = true;
        boolean bl2 = false;
        TopComponent.Registry registry = TopComponent.getRegistry();
        Set set = registry.getOpened();
        for (TopComponent topComponent : set) {
            PaletteController paletteController;
            if (topComponent.isShowing() && !(topComponent instanceof PaletteTopComponent)) {
                bl = false;
                break;
            }
            if (bl2 || null == (paletteController = this.getPaletteFromTopComponent(topComponent, false)) || paletteController != this.currentPalette) continue;
            bl2 = true;
        }
        return bl && bl2;
    }

    PaletteController getPaletteFromTopComponent(TopComponent topComponent, boolean bl) {
        DataObject dataObject;
        Node[] nodeArray;
        if (null == topComponent || !topComponent.isShowing() && bl) {
            return null;
        }
        if (!WindowManager.getDefault().isEditorTopComponent(topComponent)) {
            return null;
        }
        PaletteController paletteController = (PaletteController)topComponent.getLookup().lookup(PaletteController.class);
        if (null == paletteController && topComponent.isOpened() && null != (nodeArray = topComponent.getActivatedNodes()) && nodeArray.length > 0 && null != (dataObject = (DataObject)nodeArray[0].getLookup().lookup(DataObject.class))) {
            while (dataObject instanceof DataShadow) {
                dataObject = ((DataShadow)dataObject).getOriginal();
            }
            FileObject fileObject = dataObject.getPrimaryFile();
            if (!fileObject.isVirtual()) {
                String string = fileObject.getMIMEType();
                paletteController = this.getPaletteFromMimeType(string);
            }
        }
        return paletteController;
    }

    PaletteController getPaletteFromMimeType(String string) {
        MimePath mimePath = MimePath.get((String)string);
        Lookup lookup = MimeLookup.getLookup((MimePath)mimePath);
        return (PaletteController)lookup.lookup(PaletteController.class);
    }

    private void showHidePaletteTopComponent(PaletteController paletteController, PaletteController paletteController2) {
        if (paletteController == paletteController2 && null != paletteController2) {
            return;
        }
        WindowManager windowManager = WindowManager.getDefault();
        TopComponent topComponent = windowManager.findTopComponent("CommonPalette");
        if (null == topComponent) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Cannot find CommonPalette component.");
            topComponent = PaletteTopComponent.getDefault();
        }
        if (PaletteVisibility.isVisible(paletteController2) || PaletteVisibility.isVisible(null)) {
            if (!topComponent.isOpened()) {
                topComponent.open();
            }
            PaletteVisibility.setVisible(paletteController2, true);
        } else if (topComponent.isOpened()) {
            topComponent.close();
        }
    }

    private boolean isGroupOpenHack(TopComponentGroup topComponentGroup) {
        try {
            for (Method method : topComponentGroup.getClass().getDeclaredMethods()) {
                if (!method.getName().equals("isOpened")) continue;
                method.setAccessible(true);
                Object object = method.invoke((Object)topComponentGroup, new Object[0]);
                if (!(object instanceof Boolean)) continue;
                return (Boolean)object;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void switchLookupListener() {
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (null != this.lookupRes) {
            this.lookupRes.removeLookupListener((LookupListener)this);
            this.lookupRes = null;
        }
        if (null != topComponent) {
            this.lookupRes = topComponent.getLookup().lookup(new Lookup.Template(PaletteController.class));
            this.lookupRes.addLookupListener((LookupListener)this);
            this.lookupRes.allItems();
        }
    }

    private PropertyChangeListener createRegistryListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("currentNodes".equals(propertyChangeEvent.getPropertyName()) || "opened".equals(propertyChangeEvent.getPropertyName()) || "activated".equals(propertyChangeEvent.getPropertyName())) {
                    if ("activated".equals(propertyChangeEvent.getPropertyName()) || "opened".equals(propertyChangeEvent.getPropertyName())) {
                        PaletteSwitch.this.watchOpenedEditors();
                    }
                    if ("activated".equals(propertyChangeEvent.getPropertyName())) {
                        PaletteSwitch.this.switchLookupListener();
                    }
                    PaletteSwitch.this.run();
                }
            }
        };
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.run();
    }

    private void watchOpenedEditors() {
        Lookup.Result result;
        ArrayList<TopComponent> arrayList = this.findShowingEditors();
        ArrayList<TopComponent> arrayList2 = new ArrayList<TopComponent>(arrayList);
        arrayList2.removeAll(this.watchedLkpResults.keySet());
        ArrayList<TopComponent> arrayList3 = new ArrayList<TopComponent>(this.watchedLkpResults.keySet());
        arrayList3.removeAll(arrayList);
        for (TopComponent topComponent : arrayList3) {
            result = this.watchedLkpResults.get(topComponent);
            if (null == result) continue;
            result.removeLookupListener((LookupListener)this);
            this.watchedLkpResults.remove(topComponent);
        }
        for (TopComponent topComponent : arrayList2) {
            result = topComponent.getLookup().lookup(new Lookup.Template(PaletteController.class));
            result.addLookupListener((LookupListener)this);
            result.allItems();
            this.watchedLkpResults.put(topComponent, result);
        }
    }

    private ArrayList<TopComponent> findShowingEditors() {
        ArrayList<TopComponent> arrayList = new ArrayList<TopComponent>(3);
        WindowManager windowManager = WindowManager.getDefault();
        for (TopComponent topComponent : TopComponent.getRegistry().getOpened()) {
            if (!topComponent.isShowing() || !windowManager.isEditorTopComponent(topComponent)) continue;
            arrayList.add(topComponent);
        }
        return arrayList;
    }
}

