/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jruby.ast.IfNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.EditList;
import org.netbeans.modules.gsf.api.Hint;
import org.netbeans.modules.gsf.api.HintSeverity;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.PreviewableFix;
import org.netbeans.modules.gsf.api.Rule;
import org.netbeans.modules.gsf.api.RuleContext;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.ConvertIfToUnless;
import org.netbeans.modules.ruby.hints.infrastructure.RubyAstRule;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertConditionals
extends RubyAstRule {
    @Override
    public Set<NodeType> getKinds() {
        return Collections.singleton(NodeType.IFNODE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(RubyRuleContext rubyRuleContext, List<Hint> list) {
        ConvertToModifier convertToModifier;
        TokenSequence tokenSequence;
        Node node = rubyRuleContext.node;
        CompilationInfo compilationInfo = rubyRuleContext.compilationInfo;
        IfNode ifNode = (IfNode)node;
        if (ifNode.getCondition() == null) {
            return;
        }
        Node node2 = ifNode.getThenBody();
        Node node3 = ifNode.getElseBody();
        if (node2 != null && node3 != null) {
            return;
        }
        if (node2 == null && node3 == null) {
            return;
        }
        if (ifNode.getElseBody() != null && ifNode.getElseBody().nodeId == NodeType.IFNODE) {
            return;
        }
        int n = ifNode.getPosition().getStartOffset();
        if (node2 != null && (node2.nodeId == NodeType.BLOCKNODE || node2.getPosition().getStartOffset() <= n)) {
            return;
        }
        if (node3 != null && (node3.nodeId == NodeType.BLOCKNODE || node3.getPosition().getStartOffset() <= n)) {
            return;
        }
        BaseDocument baseDocument = rubyRuleContext.doc;
        try {
            int n2 = ConvertIfToUnless.findKeywordOffset(rubyRuleContext, ifNode);
            if (n2 == -1 || n2 > baseDocument.getLength() - 1) {
                return;
            }
            char c = baseDocument.getText(n2, 1).charAt(0);
            if (c != 'i' && c != 'u') {
                return;
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        OffsetRange offsetRange = AstUtilities.getRange((Node)node);
        if (RubyUtils.isRhtmlDocument((Document)baseDocument) || RubyUtils.isYamlDocument((Document)baseDocument)) {
            if ((offsetRange = LexUtilities.getLexerOffsets((CompilationInfo)compilationInfo, (OffsetRange)offsetRange)) == OffsetRange.NONE) {
                return;
            }
            try {
                baseDocument.readLock();
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
                tokenSequence = tokenHierarchy.tokenSequence();
                tokenSequence.move(offsetRange.getStart());
                if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                    return;
                }
                if (tokenSequence.offset() + tokenSequence.token().length() < offsetRange.getEnd()) {
                    return;
                }
            }
            finally {
                baseDocument.readUnlock();
            }
        }
        if ((convertToModifier = new ConvertToModifier(rubyRuleContext, ifNode)).getEditList() == null) {
            return;
        }
        tokenSequence = Collections.singletonList(convertToModifier);
        String string = NbBundle.getMessage(ConvertConditionals.class, (String)"ConvertConditionals");
        Hint hint = new Hint((Rule)this, string, compilationInfo.getFileObject(), offsetRange, (List)tokenSequence, 500);
        list.add(hint);
    }

    public String getId() {
        return "ConvertConditionals";
    }

    public String getDescription() {
        return NbBundle.getMessage(ConvertConditionals.class, (String)"ConvertConditionalsDesc");
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    public boolean appliesTo(RuleContext ruleContext) {
        return true;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ConvertConditionals.class, (String)"ConvertConditionals");
    }

    public boolean showInTasklist() {
        return false;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.CURRENT_LINE_WARNING;
    }

    private class ConvertToModifier
    implements PreviewableFix {
        private final RubyRuleContext context;
        private IfNode ifNode;

        public ConvertToModifier(RubyRuleContext rubyRuleContext, IfNode ifNode) {
            this.context = rubyRuleContext;
            this.ifNode = ifNode;
        }

        public String getDescription() {
            return NbBundle.getMessage(ConvertConditionals.class, (String)"ConvertConditionalsFix");
        }

        public void implement() throws Exception {
            EditList editList = this.getEditList();
            if (editList != null) {
                editList.apply();
            }
        }

        public EditList getEditList() {
            try {
                boolean bl;
                BaseDocument baseDocument = this.context.doc;
                Node node = this.ifNode.getThenBody();
                boolean bl2 = bl = node != null;
                if (node == null) {
                    node = this.ifNode.getElseBody();
                }
                CompilationInfo compilationInfo = this.context.compilationInfo;
                OffsetRange offsetRange = AstUtilities.getRange((Node)node);
                if ((offsetRange = LexUtilities.getLexerOffsets((CompilationInfo)compilationInfo, (OffsetRange)offsetRange)) == OffsetRange.NONE) {
                    return null;
                }
                String string = baseDocument.getText(offsetRange.getStart(), offsetRange.getLength()).trim();
                if (string.endsWith(";")) {
                    string = string.substring(0, string.length() - 1);
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string);
                stringBuilder.append(" ");
                stringBuilder.append(bl ? "if" : "unless");
                stringBuilder.append(" ");
                OffsetRange offsetRange2 = AstUtilities.getRange((Node)this.ifNode.getCondition());
                offsetRange2 = LexUtilities.getLexerOffsets((CompilationInfo)compilationInfo, (OffsetRange)offsetRange2);
                if (offsetRange2 == OffsetRange.NONE) {
                    return null;
                }
                stringBuilder.append(baseDocument.getText(offsetRange2.getStart(), offsetRange2.getLength()));
                OffsetRange offsetRange3 = AstUtilities.getRange((Node)this.ifNode);
                offsetRange3 = LexUtilities.getLexerOffsets((CompilationInfo)compilationInfo, (OffsetRange)offsetRange3);
                if (offsetRange3 == OffsetRange.NONE) {
                    return null;
                }
                return new EditList(baseDocument).replace(offsetRange3.getStart(), offsetRange3.getLength(), stringBuilder.toString(), false, 0);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
                return null;
            }
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean canPreview() {
            return true;
        }
    }
}

