/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.servicetag;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.netbeans.modules.servicetag.LinuxSystemEnvironment;
import org.netbeans.modules.servicetag.SolarisSystemEnvironment;
import org.netbeans.modules.servicetag.WindowsSystemEnvironment;

public class SystemEnvironment {
    private String hostname;
    private String hostId;
    private String osName;
    private String osVersion;
    private String osArchitecture;
    private String systemModel;
    private String systemManufacturer;
    private String cpuManufacturer;
    private String serialNumber;
    private static SystemEnvironment sysEnv = null;

    public static synchronized SystemEnvironment getSystemEnvironment() {
        if (sysEnv == null) {
            String string = System.getProperty("os.name");
            sysEnv = string.equals("SunOS") ? new SolarisSystemEnvironment() : (string.equals("Linux") ? new LinuxSystemEnvironment() : (string.startsWith("Windows") ? new WindowsSystemEnvironment() : new SystemEnvironment()));
        }
        return sysEnv;
    }

    SystemEnvironment() {
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            this.hostname = "Unknown host";
        }
        this.hostId = "";
        this.osName = System.getProperty("os.name");
        this.osVersion = System.getProperty("os.version");
        this.osArchitecture = System.getProperty("os.arch");
        this.systemModel = "";
        this.systemManufacturer = "";
        this.cpuManufacturer = "";
        this.serialNumber = "";
    }

    public void setHostname(String string) {
        this.hostname = string;
    }

    public void setOsName(String string) {
        this.osName = string;
    }

    public void setOsVersion(String string) {
        this.osVersion = string;
    }

    public void setOsArchitecture(String string) {
        this.osArchitecture = string;
    }

    public void setSystemModel(String string) {
        this.systemModel = string;
    }

    public void setSystemManufacturer(String string) {
        this.systemManufacturer = string;
    }

    public void setCpuManufacturer(String string) {
        this.cpuManufacturer = string;
    }

    public void setSerialNumber(String string) {
        this.serialNumber = string;
    }

    public void setHostId(String string) {
        if (string == null || string.equals("null")) {
            string = "";
        }
        if (string.length() > 16) {
            string = string.substring(0, 16);
        }
        this.hostId = string;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getOsName() {
        return this.osName;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getOsArchitecture() {
        return this.osArchitecture;
    }

    public String getSystemModel() {
        return this.systemModel;
    }

    public String getSystemManufacturer() {
        return this.systemManufacturer;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getHostId() {
        return this.hostId;
    }

    public String getCpuManufacturer() {
        return this.cpuManufacturer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCommandOutput(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        Process process = null;
        try {
            String string;
            ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
            process = processBuilder.start();
            process.waitFor();
            if (process.exitValue() == 0) {
                bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    if ((string = string.trim()).length() <= 0) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append(string);
                }
            }
            string = stringBuilder.toString();
            return string;
        }
        catch (InterruptedException interruptedException) {
            if (process != null) {
                process.destroy();
            }
            String string = "";
            return string;
        }
        catch (Exception exception) {
            String string = "";
            return string;
        }
        finally {
            if (process != null) {
                try {
                    process.getErrorStream().close();
                }
                catch (IOException iOException) {}
                try {
                    process.getInputStream().close();
                }
                catch (IOException iOException) {}
                try {
                    process.getOutputStream().close();
                }
                catch (IOException iOException) {}
                process = null;
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getFileContent(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if ((string2 = string2.trim()).length() <= 0) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append(string2);
            }
            String string3 = stringBuilder.toString();
            return string3;
        }
        catch (Exception exception) {
            String string4 = "";
            return string4;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

