/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.TargetModuleID;
import org.netbeans.modules.j2ee.deployment.common.api.EjbChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeApplication;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ModuleChangeReporter;
import org.netbeans.modules.j2ee.deployment.execution.DeploymentTarget;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.TargetModule;
import org.netbeans.modules.j2ee.deployment.plugins.api.AppChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.plugins.api.DeploymentChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerProgress;
import org.netbeans.modules.j2ee.deployment.plugins.spi.IncrementalDeployment;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerFileDistributor
extends ServerProgress {
    private final ServerInstance instance;
    private final DeploymentTarget dtarget;
    private final IncrementalDeployment incremental;
    private Iterator rootModuleFiles;
    private Map childModuleFiles;
    private Map childModuleMap;
    private static final Logger LOGGER = Logger.getLogger(ServerFileDistributor.class.getName());
    static Map j2eeTypeMap = null;

    public ServerFileDistributor(ServerInstance serverInstance, DeploymentTarget deploymentTarget) {
        super(serverInstance);
        this.instance = serverInstance;
        this.dtarget = deploymentTarget;
        this.incremental = serverInstance.getIncrementalDeployment();
        try {
            J2eeModule j2eeModule = deploymentTarget.getModule();
            this.rootModuleFiles = j2eeModule.getArchiveContents();
            if (j2eeModule instanceof J2eeApplication) {
                this.childModuleFiles = new HashMap();
                this.childModuleMap = new HashMap();
                J2eeModule[] j2eeModuleArray = ((J2eeApplication)j2eeModule).getModules();
                for (int i = 0; i < j2eeModuleArray.length; ++i) {
                    Iterator iterator = j2eeModuleArray[i].getArchiveContents();
                    if (iterator != null) {
                        this.childModuleFiles.put(j2eeModuleArray[i].getUrl(), iterator);
                    }
                    this.childModuleMap.put(j2eeModuleArray[i].getUrl(), j2eeModuleArray[i]);
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    static synchronized List getDescriptorPath(J2eeModule j2eeModule) {
        if (j2eeTypeMap == null) {
            j2eeTypeMap = new HashMap();
            j2eeTypeMap.put(J2eeModule.EJB, Arrays.asList("META-INF/ejb-jar.xml", "META-INF/webservices.xml"));
            j2eeTypeMap.put(J2eeModule.WAR, Arrays.asList("WEB-INF/web.xml", "WEB-INF/webservices.xml"));
            j2eeTypeMap.put(J2eeModule.CLIENT, Arrays.asList("META-INF/application-client.xml"));
            j2eeTypeMap.put(J2eeModule.CONN, Arrays.asList("META-INF/ra.xml"));
            j2eeTypeMap.put(J2eeModule.EAR, Arrays.asList("META-INF/application.xml"));
        }
        return (List)j2eeTypeMap.get(j2eeModule.getModuleType());
    }

    private J2eeModule getJ2eeModule(TargetModuleID targetModuleID) {
        if (targetModuleID.getParentTargetModuleID() == null) {
            return this.dtarget.getModule();
        }
        String string = this.incremental.getModuleUrl(targetModuleID);
        return (J2eeModule)this.childModuleMap.get(string);
    }

    private AppChanges createModuleChangeDescriptor(TargetModuleID targetModuleID) {
        J2eeModule j2eeModule = this.getJ2eeModule(targetModuleID);
        List list = ServerFileDistributor.getDescriptorPath(j2eeModule);
        ModuleType moduleType = (ModuleType)j2eeModule.getModuleType();
        List<String> list2 = Arrays.asList(this.instance.getServer().getDeploymentPlanFiles(moduleType));
        return new AppChanges(list, list2, moduleType);
    }

    public AppChangeDescriptor distribute(TargetModule targetModule, ModuleChangeReporter moduleChangeReporter) throws IOException {
        long l = targetModule.getTimestamp();
        TargetModuleID[] targetModuleIDArray = targetModule.getChildTargetModuleID();
        AppChanges appChanges = new AppChanges();
        File file = null;
        for (int i = 0; targetModuleIDArray != null && i < targetModuleIDArray.length; ++i) {
            String string = this.incremental.getModuleUrl(targetModuleIDArray[i]);
            file = this.incremental.getDirectoryForModule(targetModuleIDArray[i]);
            Iterator iterator = (Iterator)this.childModuleFiles.get(string);
            if (file == null) {
                appChanges.record(this._distribute(targetModuleIDArray[i], l));
                continue;
            }
            if (null == iterator) continue;
            appChanges.record(this._distribute(iterator, file, targetModuleIDArray[i], l));
        }
        file = this.incremental.getDirectoryForModule(targetModule.delegate());
        if (file == null) {
            appChanges.record(this._distribute(targetModule.delegate(), l));
        } else {
            appChanges.record(this._distribute(this.rootModuleFiles, file, targetModule.delegate(), l));
        }
        if (moduleChangeReporter != null) {
            appChanges.record(moduleChangeReporter, l);
        }
        this.setStatusDistributeCompleted(NbBundle.getMessage(ServerFileDistributor.class, (String)"MSG_DoneIncrementalDeploy", (Object)targetModule.getModuleID()));
        return appChanges;
    }

    public DeploymentChangeDescriptor distributeOnSave(TargetModule targetModule, ModuleChangeReporter moduleChangeReporter, Iterable<File> iterable) throws IOException {
        long l = targetModule.getTimestamp();
        TargetModuleID[] targetModuleIDArray = targetModule.getChildTargetModuleID();
        AppChanges appChanges = new AppChanges();
        File file = null;
        for (int i = 0; targetModuleIDArray != null && i < targetModuleIDArray.length; ++i) {
            String string = this.incremental.getModuleUrl(targetModuleIDArray[i]);
            file = this.incremental.getDirectoryForModule(targetModuleIDArray[i]);
            if (file == null) {
                appChanges.record(this._distributeOnSave(targetModuleIDArray[i], iterable));
                continue;
            }
            Iterator iterator = (Iterator)this.childModuleFiles.get(string);
            if (iterator == null) continue;
            appChanges.record(this._distributeOnSave(file, targetModuleIDArray[i], iterable));
        }
        file = this.incremental.getDirectoryForModule(targetModule.delegate());
        if (file == null) {
            appChanges.record(this._distributeOnSave(targetModule.delegate(), iterable));
        } else {
            appChanges.record(this._distributeOnSave(file, targetModule.delegate(), iterable));
        }
        if (moduleChangeReporter != null) {
            appChanges.record(moduleChangeReporter, l);
        }
        this.setStatusDistributeCompleted(NbBundle.getMessage(ServerFileDistributor.class, (String)"MSG_DoneIncrementalDeploy", (Object)targetModule.getModuleID()));
        return Accessor.getDefault().newDescriptor(appChanges);
    }

    public AppChanges _test_distribute(Iterator iterator, File file, TargetModuleID targetModuleID, long l) throws IOException {
        return this._distribute(iterator, file, targetModuleID, l);
    }

    private AppChanges _distribute(TargetModuleID targetModuleID, long l) throws IOException {
        AppChanges appChanges = this.createModuleChangeDescriptor(targetModuleID);
        this.setStatusDistributeRunning(NbBundle.getMessage(ServerFileDistributor.class, (String)"MSG_RunningIncrementalDeploy", (Object)targetModuleID));
        Iterator iterator = this.getJ2eeModule(targetModuleID).getArchiveContents();
        Date date = new Date(l);
        while (iterator.hasNext()) {
            J2eeModule.RootedEntry rootedEntry = (J2eeModule.RootedEntry)iterator.next();
            FileObject fileObject = rootedEntry.getFileObject();
            if (fileObject.isFolder()) continue;
            fileObject.refresh();
            if (!fileObject.lastModified().after(date)) continue;
            String string = rootedEntry.getRelativePath();
            appChanges.record(string);
        }
        return appChanges;
    }

    private AppChanges _distributeOnSave(TargetModuleID targetModuleID, Iterable<File> iterable) throws IOException {
        AppChanges appChanges = this.createModuleChangeDescriptor(targetModuleID);
        this.setStatusDistributeRunning(NbBundle.getMessage(ServerFileDistributor.class, (String)"MSG_RunningIncrementalDeploy", (Object)targetModuleID));
        FileObject fileObject = this.getJ2eeModule(targetModuleID).getContentDirectory();
        assert (fileObject != null);
        File file = FileUtil.toFile((FileObject)fileObject);
        assert (file != null);
        for (File file2 : iterable) {
            String string;
            FileObject fileObject2 = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file2));
            if (fileObject2 == null || fileObject2.isFolder() || (string = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2)) == null) continue;
            appChanges.record(file, string);
        }
        return appChanges;
    }

    private AppChanges _distribute(Iterator iterator, File file, TargetModuleID targetModuleID, long l) throws IOException {
        AppChanges appChanges = this.createModuleChangeDescriptor(targetModuleID);
        if (iterator == null) {
            Logger.getLogger("global").log(Level.SEVERE, "There is no contents for " + targetModuleID);
            throw new IOException(NbBundle.getMessage(ServerFileDistributor.class, (String)"MSG_NoContents", (Object)targetModuleID));
        }
        this.setStatusDistributeRunning(NbBundle.getMessage(ServerFileDistributor.class, (String)"MSG_RunningIncrementalDeploy", (Object)targetModuleID));
        try {
            File[] fileArray;
            Object object;
            String[] stringArray;
            Iterator iterator2;
            File file2 = this.incremental.getDirectoryForModule(targetModuleID);
            FileObject fileObject = FileUtil.createFolder((File)file);
            Enumeration enumeration = fileObject.getChildren(true);
            HashMap<String, Iterator> hashMap = new HashMap<String, Iterator>();
            int n = fileObject.getPath().length();
            while (enumeration.hasMoreElements()) {
                iterator2 = (FileObject)enumeration.nextElement();
                hashMap.put(iterator2.getPath().substring(n + 1), iterator2);
            }
            iterator2 = iterator;
            while (iterator2.hasNext()) {
                stringArray = (String[])iterator2.next();
                object = stringArray.getRelativePath();
                fileArray = stringArray.getFileObject();
                FileObject fileObject2 = (FileObject)hashMap.get(object);
                if (fileArray.isFolder()) {
                    hashMap.remove(object);
                    continue;
                }
                ServerFileDistributor.createOrReplace((FileObject)fileArray, fileObject2, fileObject, (String)object, appChanges, hashMap, true, l);
            }
            iterator2 = (ModuleType)this.dtarget.getModule().getModuleType();
            stringArray = this.instance.getServer().getDeploymentPlanFiles(iterator2);
            object = this.dtarget.getConfigurationFile();
            if (stringArray == null || stringArray.length == 0) {
                return appChanges;
            }
            fileArray = new File[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                fileArray[i] = new File(FileUtil.toFile((FileObject)fileObject), stringArray[i]);
                if (!fileArray[i].exists() || fileArray[i].lastModified() <= ((File)object).lastModified()) continue;
                appChanges.record(stringArray[i]);
            }
            return appChanges;
        }
        catch (Exception exception) {
            String string = NbBundle.getMessage(ServerFileDistributor.class, (String)"MSG_IncrementalDeployFailed", (Object)exception);
            this.setStatusDistributeFailed(string);
            throw new RuntimeException(string, exception);
        }
    }

    private AppChanges _distributeOnSave(File file, TargetModuleID targetModuleID, Iterable<File> iterable) throws IOException {
        AppChanges appChanges = this.createModuleChangeDescriptor(targetModuleID);
        this.setStatusDistributeRunning(NbBundle.getMessage(ServerFileDistributor.class, (String)"MSG_RunningIncrementalDeploy", (Object)targetModuleID));
        try {
            File[] fileArray;
            Object object;
            FileObject fileObject;
            FileObject fileObject2 = FileUtil.createFolder((File)file);
            Enumeration enumeration = fileObject2.getChildren(true);
            HashMap<String, FileObject> hashMap = new HashMap<String, FileObject>();
            int n = fileObject2.getPath().length();
            while (enumeration.hasMoreElements()) {
                fileObject = (FileObject)enumeration.nextElement();
                hashMap.put(fileObject.getPath().substring(n + 1), fileObject);
            }
            fileObject = this.getJ2eeModule(targetModuleID).getContentDirectory();
            assert (fileObject != null);
            for (File stringArray2 : iterable) {
                object = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)stringArray2));
                if (object == null || (fileArray = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)object)) == null) continue;
                FileObject i = (FileObject)hashMap.get(fileArray);
                if (object.isFolder()) {
                    hashMap.remove(fileArray);
                    continue;
                }
                ServerFileDistributor.createOrReplace((FileObject)object, i, fileObject2, (String)fileArray, appChanges, hashMap, false, 0L);
            }
            ModuleType moduleType = (ModuleType)this.dtarget.getModule().getModuleType();
            String[] stringArray = this.instance.getServer().getDeploymentPlanFiles(moduleType);
            object = this.dtarget.getConfigurationFile();
            if (stringArray == null || stringArray.length == 0) {
                return appChanges;
            }
            fileArray = new File[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = FileUtil.toFile((FileObject)fileObject2);
                assert (file2 != null);
                fileArray[i] = new File(file2, stringArray[i]);
                if (!fileArray[i].exists() || fileArray[i].lastModified() <= ((File)object).lastModified()) continue;
                appChanges.record(file2, stringArray[i]);
            }
            return appChanges;
        }
        catch (Exception exception) {
            String string = NbBundle.getMessage(ServerFileDistributor.class, (String)"MSG_IncrementalDeployFailed", (Object)exception);
            this.setStatusDistributeFailed(string);
            throw new RuntimeException(string, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createOrReplace(FileObject fileObject, FileObject fileObject2, FileObject fileObject3, String string, AppChanges appChanges, Map map, boolean bl, long l) throws IOException {
        OutputStream outputStream = null;
        InputStream inputStream = null;
        File file = FileUtil.toFile((FileObject)fileObject3);
        Date date = new Date(l);
        try {
            FileObject fileObject4;
            if (null == fileObject2) {
                fileObject2 = fileObject3.getFileObject(string);
            }
            if (fileObject2 == null) {
                fileObject4 = ServerFileDistributor.findOrCreateParentFolder(fileObject3, string);
            } else {
                map.remove(string);
                if (fileObject2.equals(fileObject) && fileObject2.lastModified().after(date)) {
                    appChanges.record(file, string);
                }
                if (bl && !fileObject.lastModified().after(fileObject2.lastModified())) {
                    return;
                }
                if (fileObject2.equals(fileObject)) {
                    return;
                }
                fileObject4 = fileObject2.getParent();
                outputStream = fileObject2.getOutputStream();
            }
            appChanges.record(file, string);
            if (null == outputStream) {
                FileUtil.copyFile((FileObject)fileObject, (FileObject)fileObject4, (String)fileObject.getName());
            } else {
                inputStream = fileObject.getInputStream();
                FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.WARNING, null, iOException);
                }
            }
            if (null != outputStream) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.WARNING, null, iOException);
                }
            }
        }
    }

    public static FileObject findOrCreateParentFolder(FileObject fileObject, String string) throws IOException {
        File file = new File(string).getParentFile();
        if (file == null) {
            return fileObject;
        }
        FileObject fileObject2 = FileUtil.createFolder((FileObject)fileObject, (String)file.getPath());
        if (fileObject2.isData()) {
            Logger.getLogger(ServerFileDistributor.class.getName()).finer("found file " + fileObject2.getPath() + "when a folder was expecetd");
            fileObject2 = null;
        }
        return fileObject2;
    }

    private void setStatusDistributeRunning(String string) {
        this.notify(this.createRunningProgressEvent(CommandType.DISTRIBUTE, string));
    }

    private void setStatusDistributeFailed(String string) {
        this.notify(this.createFailedProgressEvent(CommandType.DISTRIBUTE, string));
    }

    private void setStatusDistributeCompleted(String string) {
        this.notify(this.createCompletedProgressEvent(CommandType.DISTRIBUTE, string));
    }

    public static abstract class Accessor {
        private static volatile Accessor accessor;

        public static void setDefault(Accessor accessor) {
            if (Accessor.accessor != null) {
                throw new IllegalStateException("Already initialized accessor");
            }
            Accessor.accessor = accessor;
        }

        public static Accessor getDefault() {
            block4: {
                if (accessor != null) {
                    return accessor;
                }
                Class<DeploymentChangeDescriptor> clazz = DeploymentChangeDescriptor.class;
                try {
                    Class.forName(clazz.getName(), true, clazz.getClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError((Object)classNotFoundException);
                }
            }
            assert (accessor != null) : "The accessor field must be initialized";
            return accessor;
        }

        public abstract DeploymentChangeDescriptor newDescriptor(AppChanges var1);
    }

    public static final class AppChanges
    implements AppChangeDescriptor {
        private boolean descriptorChanged = false;
        private boolean serverDescriptorChanged = false;
        private boolean classesChanged = false;
        private boolean manifestChanged = false;
        private boolean ejbsChanged = false;
        private List changedEjbs = Collections.EMPTY_LIST;
        private ModuleType moduleType = null;
        private List changedFiles = new ArrayList();
        private List descriptorRelativePaths;
        private List serverDescriptorRelativePaths;

        AppChanges() {
        }

        AppChanges(List list, List list2, ModuleType moduleType) {
            this.descriptorRelativePaths = list;
            this.serverDescriptorRelativePaths = list2;
            this.moduleType = moduleType;
        }

        private void record(AppChanges appChanges) {
            List<String> list;
            if (!this.descriptorChanged) {
                this.descriptorChanged = appChanges.descriptorChanged();
            }
            if (!this.serverDescriptorChanged) {
                this.serverDescriptorChanged = appChanges.serverDescriptorChanged();
            }
            if (!this.classesChanged) {
                this.classesChanged = appChanges.classesChanged();
            }
            if (!this.manifestChanged) {
                this.manifestChanged = appChanges.manifestChanged();
            }
            if (!this.ejbsChanged) {
                this.ejbsChanged = appChanges.ejbsChanged();
            }
            if ((list = Arrays.asList(appChanges.getChangedEjbs())).size() > 0) {
                this.changedEjbs.addAll(list);
            }
            this.changedFiles.addAll(appChanges.changedFiles);
        }

        private void record(String string) {
            this.record(null, string);
        }

        private void record(File file, String string) {
            if (file != null) {
                this.changedFiles.add(new File(file, string));
            } else {
                this.changedFiles.add(new File(string));
            }
            if (!this.classesChanged) {
                boolean bl;
                boolean bl2;
                boolean bl3 = bl2 = !this.moduleType.equals(ModuleType.WAR) && !string.startsWith("META-INF") || string.startsWith("WEB-INF/classes/");
                if (this.moduleType.equals(ModuleType.EAR)) {
                    bl2 = false;
                }
                boolean bl4 = !this.moduleType.equals(ModuleType.WAR) || string.startsWith("WEB-INF/lib/");
                boolean bl5 = bl = bl4 && (string.endsWith(".jar") || string.endsWith(".zip"));
                if (bl2 || bl) {
                    this.classesChanged = true;
                    return;
                }
            }
            if (!this.descriptorChanged && (this.descriptorRelativePaths != null && this.descriptorRelativePaths.contains(string) || string.startsWith("WEB-INF") && (string.endsWith(".tld") || string.endsWith(".xml") || string.endsWith(".dtd")))) {
                this.descriptorChanged = true;
                return;
            }
            if (!this.serverDescriptorChanged && this.serverDescriptorRelativePaths != null && this.serverDescriptorRelativePaths.contains(string)) {
                this.serverDescriptorChanged = true;
                return;
            }
            if (!this.manifestChanged && string.equals("META-INF/MANIFEST.MF")) {
                this.manifestChanged = true;
                return;
            }
        }

        private void record(ModuleChangeReporter moduleChangeReporter, long l) {
            EjbChangeDescriptor ejbChangeDescriptor = moduleChangeReporter.getEjbChanges(l);
            this.ejbsChanged = ejbChangeDescriptor.ejbsChanged();
            String[] stringArray = ejbChangeDescriptor.getChangedEjbs();
            if (stringArray != null && stringArray.length > 0) {
                this.changedEjbs.addAll(Arrays.asList(stringArray));
            }
            if (!this.manifestChanged) {
                this.manifestChanged = moduleChangeReporter.isManifestChanged(l);
            }
        }

        public boolean classesChanged() {
            return this.classesChanged;
        }

        public boolean descriptorChanged() {
            return this.descriptorChanged;
        }

        public boolean manifestChanged() {
            return this.manifestChanged;
        }

        public boolean serverDescriptorChanged() {
            return this.serverDescriptorChanged;
        }

        public boolean ejbsChanged() {
            return this.ejbsChanged;
        }

        public String[] getChangedEjbs() {
            return this.changedEjbs.toArray(new String[0]);
        }

        public File[] getChangedFiles() {
            return this.changedFiles.toArray(new File[this.changedFiles.size()]);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(super.toString());
            stringBuilder.append(" [");
            for (File file : this.getChangedFiles()) {
                stringBuilder.append(file.getAbsolutePath()).append(", ");
            }
            if (this.getChangedFiles().length > 0) {
                stringBuilder.setLength(stringBuilder.length() - 2);
            }
            stringBuilder.append("], ");
            stringBuilder.append("classesChanged=").append(this.classesChanged());
            stringBuilder.append(", ");
            stringBuilder.append("descriptorChanged=").append(this.descriptorChanged());
            stringBuilder.append(", ");
            stringBuilder.append("ejbsChanged=").append(this.ejbsChanged());
            stringBuilder.append(", ");
            stringBuilder.append("manifestChanged=").append(this.manifestChanged());
            stringBuilder.append(", ");
            stringBuilder.append("serverDescriptorChanged=").append(this.serverDescriptorChanged());
            return stringBuilder.toString();
        }
    }
}

