/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.execution.DeploymentTarget;
import org.netbeans.modules.j2ee.deployment.impl.ServerException;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.TargetModule;
import org.netbeans.modules.j2ee.deployment.impl.TargetServer;
import org.netbeans.modules.j2ee.deployment.impl.projects.DeploymentTargetImpl;
import org.netbeans.modules.j2ee.deployment.impl.ui.ProgressUI;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeployOnSaveManager {
    private static final Logger LOGGER = Logger.getLogger(DeployOnSaveManager.class.getName());
    private static final int DELAY = 300;
    private static DeployOnSaveManager instance;
    private final ExecutorService EXECUTOR = Executors.newFixedThreadPool(1, new ThreadFactory(){

        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    });
    private Map<J2eeModuleProvider, Set<File>> toDeploy = new HashMap<J2eeModuleProvider, Set<File>>();
    private Map<J2eeModuleProvider, DeploymentState> lastDeploymentStates = new HashMap<J2eeModuleProvider, DeploymentState>();
    private Future<?> current;

    private DeployOnSaveManager() {
    }

    public static synchronized DeployOnSaveManager getDefault() {
        if (instance == null) {
            instance = new DeployOnSaveManager();
        }
        return instance;
    }

    public static boolean isServerStateSupported(ServerInstance serverInstance) {
        return serverInstance.isRunning() && !serverInstance.isSuspended();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyInitialDeployment(J2eeModuleProvider j2eeModuleProvider) {
        DeployOnSaveManager deployOnSaveManager = this;
        synchronized (deployOnSaveManager) {
            if (!this.lastDeploymentStates.containsKey(j2eeModuleProvider)) {
                this.lastDeploymentStates.put(j2eeModuleProvider, DeploymentState.MODULE_UPDATED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitChangedArtifacts(J2eeModuleProvider j2eeModuleProvider, Iterable<File> iterable) {
        assert (j2eeModuleProvider != null);
        assert (iterable != null);
        DeployOnSaveManager deployOnSaveManager = this;
        synchronized (deployOnSaveManager) {
            Set<File> set = this.toDeploy.get(j2eeModuleProvider);
            if (set == null) {
                set = new HashSet<File>();
                this.toDeploy.put(j2eeModuleProvider, set);
            }
            for (File file : iterable) {
                set.add(file);
            }
            boolean bl = true;
            if (this.current != null && !this.current.isDone()) {
                this.current.cancel(false);
                bl = false;
            }
            this.current = this.EXECUTOR.submit(new DeployTask(bl));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DeployTask
    implements Runnable {
        private final boolean delayed;

        public DeployTask(boolean bl) {
            this.delayed = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map map;
            if (this.delayed) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.log(Level.INFO, null, interruptedException);
                    return;
                }
            }
            LOGGER.log(Level.FINE, "Performing pending deployments");
            DeployOnSaveManager deployOnSaveManager = DeployOnSaveManager.this;
            synchronized (deployOnSaveManager) {
                if (DeployOnSaveManager.this.toDeploy.isEmpty()) {
                    return;
                }
                map = DeployOnSaveManager.this.toDeploy;
                DeployOnSaveManager.this.toDeploy = new HashMap();
            }
            for (Map.Entry entry : map.entrySet()) {
                if (((Set)entry.getValue()).isEmpty()) continue;
                this.notifyServer((J2eeModuleProvider)entry.getKey(), (Iterable)entry.getValue());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyServer(J2eeModuleProvider j2eeModuleProvider, Iterable<File> iterable) {
            DeploymentState deploymentState;
            Object iOException;
            Object object;
            Object object4;
            if (LOGGER.isLoggable(Level.FINEST)) {
                object4 = new StringBuilder("Artifacts updated: [");
                for (File object32 : iterable) {
                    ((StringBuilder)object4).append(object32.getAbsolutePath()).append(",");
                }
                ((StringBuilder)object4).setLength(((StringBuilder)object4).length() - 1);
                ((StringBuilder)object4).append("]");
                LOGGER.log(Level.FINEST, ((StringBuilder)object4).toString());
            }
            Object object5 = this;
            synchronized (object5) {
                object4 = (DeploymentState)((Object)DeployOnSaveManager.this.lastDeploymentStates.get(j2eeModuleProvider));
                if (object4 == null) {
                    object4 = DeploymentState.MODULE_NOT_DEPLOYED;
                }
            }
            object5 = new DeploymentTargetImpl(j2eeModuleProvider, null);
            TargetServer targetServer = new TargetServer((DeploymentTarget)object5);
            if (object4 == null || object4 == DeploymentState.DEPLOYMENT_FAILED || object4 == DeploymentState.SERVER_STATE_UNSUPPORTED && DeployOnSaveManager.isServerStateSupported(((DeploymentTargetImpl)object5).getServer().getServerInstance())) {
                object = new ProgressUI(NbBundle.getMessage(TargetServer.class, (String)"MSG_DeployOnSave", (Object)j2eeModuleProvider.getDeploymentName()), false);
                ((ProgressUI)object).start(0);
                try {
                    iOException = targetServer.deploy((ProgressUI)object, true);
                    if (iOException == null || ((TargetModule[])iOException).length <= 0) {
                        deploymentState = DeploymentState.DEPLOYMENT_FAILED;
                    }
                    deploymentState = DeploymentState.MODULE_UPDATED;
                }
                catch (IOException serverException) {
                    LOGGER.log(Level.INFO, null, serverException);
                    deploymentState = DeploymentState.DEPLOYMENT_FAILED;
                }
                catch (ServerException serverException) {
                    LOGGER.log(Level.INFO, null, serverException);
                    deploymentState = DeploymentState.DEPLOYMENT_FAILED;
                }
                finally {
                    ((ProgressUI)object).finish();
                }
            } else {
                deploymentState = targetServer.notifyArtifactsUpdated(j2eeModuleProvider, iterable);
            }
            object = null;
            switch (deploymentState) {
                case MODULE_UPDATED: {
                    object = NbBundle.getMessage(DeployOnSaveManager.class, (String)"MSG_DeployOnSave_Deployed", (Object)j2eeModuleProvider.getDeploymentName());
                    break;
                }
                case DEPLOYMENT_FAILED: {
                    object = NbBundle.getMessage(DeployOnSaveManager.class, (String)"MSG_DeployOnSave_Failed", (Object)j2eeModuleProvider.getDeploymentName());
                    break;
                }
                case SERVER_STATE_UNSUPPORTED: {
                    object = NbBundle.getMessage(DeployOnSaveManager.class, (String)"MSG_DeployOnSave_Unsupported", (Object)j2eeModuleProvider.getDeploymentName());
                    break;
                }
                default: {
                    object = null;
                }
            }
            if (object != null) {
                StatusDisplayer.getDefault().setStatusText((String)object);
            }
            LOGGER.log(Level.FINE, "Deployment state {0}", (Object)deploymentState);
            iOException = this;
            synchronized (iOException) {
                DeployOnSaveManager.this.lastDeploymentStates.put(j2eeModuleProvider, deploymentState);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DeploymentState {
        MODULE_NOT_DEPLOYED,
        MODULE_UPDATED,
        MODULE_HOT_SWAPPED,
        DEPLOYMENT_FAILED,
        SERVER_STATE_UNSUPPORTED;

    }
}

