/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.gems;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class GemProgressPanel
extends JPanel {
    private InputHandler inputHandler;
    private JPanel detailsPanel;
    private JScrollPane detailsScrollPane;
    private JLabel messageLabel;
    private JTextArea outputArea;
    private JCheckBox outputToggle;
    private JProgressBar progressBar;
    private OutputStream processInput;

    public GemProgressPanel(String string) {
        this.initComponents();
        this.messageLabel.setText(string);
        this.inputHandler = new InputHandler();
        this.inputHandler.attach(this.outputArea);
    }

    public void appendOutput(final String string) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GemProgressPanel.this.appendOutput(string);
                }
            });
            return;
        }
        this.outputArea.setEditable(true);
        Document document = this.outputArea.getDocument();
        if (document != null) {
            try {
                document.insertString(document.getLength(), string + "\n", null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void done(String string) {
        this.messageLabel.setText(string);
        this.progressBar.setIndeterminate(false);
        this.progressBar.getModel().setValue(this.progressBar.getModel().getMaximum());
        this.outputArea.setEditable(false);
        this.inputHandler.detach();
    }

    private void initComponents() {
        this.messageLabel = new JLabel();
        JSeparator jSeparator = new JSeparator();
        this.outputToggle = new JCheckBox();
        this.progressBar = new JProgressBar();
        this.detailsPanel = new JPanel();
        this.detailsScrollPane = new JScrollPane();
        this.outputArea = new JTextArea();
        Mnemonics.setLocalizedText((JLabel)this.messageLabel, (String)NbBundle.getMessage(GemProgressPanel.class, (String)"GemProgressPanel.messageLabel.text"));
        this.outputToggle.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.outputToggle, (String)NbBundle.getMessage(GemProgressPanel.class, (String)"GemProgressPanel.outputToggle.text"));
        this.outputToggle.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.outputToggle.setEnabled(false);
        this.outputToggle.setMargin(new Insets(0, 0, 0, 0));
        this.outputToggle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GemProgressPanel.this.outputToggleActionPerformed(actionEvent);
            }
        });
        this.progressBar.setIndeterminate(true);
        this.detailsPanel.setLayout(new BorderLayout());
        this.outputArea.setColumns(20);
        this.outputArea.setEditable(false);
        this.outputArea.setLineWrap(true);
        this.outputArea.setRows(6);
        this.detailsScrollPane.setViewportView(this.outputArea);
        this.outputArea.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GemProgressPanel.class, (String)"GemProgressPanel.outputArea.AccessibleContext.accessibleName"));
        this.outputArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemProgressPanel.class, (String)"GemProgressPanel.outputArea.AccessibleContext.accessibleDescription"));
        this.detailsPanel.add((Component)this.detailsScrollPane, "Center");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.messageLabel).addContainerGap(389, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.progressBar, -1, 391, Short.MAX_VALUE).add(22, 22, 22)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.outputToggle).addContainerGap(303, Short.MAX_VALUE)).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.detailsPanel, -1, 401, Short.MAX_VALUE).add((Component)jSeparator, -1, 401, Short.MAX_VALUE)).addContainerGap()))));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.messageLabel).addPreferredGap(0).add((Component)this.progressBar, -2, -1, -2).addPreferredGap(0).add((Component)jSeparator, -2, 10, -2).addPreferredGap(0).add((Component)this.outputToggle).addPreferredGap(0).add((Component)this.detailsPanel, -1, 231, Short.MAX_VALUE).addContainerGap()));
    }

    private void outputToggleActionPerformed(ActionEvent actionEvent) {
        if (this.outputToggle.isSelected()) {
            this.detailsPanel.add((Component)this.detailsScrollPane, "Center");
        } else {
            this.detailsPanel.remove(this.detailsScrollPane);
        }
        this.detailsPanel.invalidate();
        this.invalidate();
        this.revalidate();
        this.validate();
        this.repaint();
    }

    public void setProcessInput(OutputStream outputStream) {
        this.processInput = outputStream;
    }

    private class InputHandler
    implements KeyListener {
        private JTextComponent textComponent;
        private int startOffset;

        private InputHandler() {
        }

        private void detach() {
            this.textComponent.removeKeyListener(this);
        }

        private void attach(final JTextComponent jTextComponent) {
            this.textComponent = jTextComponent;
            jTextComponent.addKeyListener(this);
            if (jTextComponent.getDocument() instanceof AbstractDocument) {
                ((AbstractDocument)jTextComponent.getDocument()).setDocumentFilter(new DocumentFilter(){

                    public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
                        if (n >= InputHandler.this.startOffset) {
                            super.insertString(filterBypass, n, string, attributeSet);
                        }
                        jTextComponent.getCaret().setVisible(true);
                    }

                    public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
                        if (n >= InputHandler.this.startOffset) {
                            super.remove(filterBypass, n, n2);
                        }
                    }

                    public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
                        if (n >= InputHandler.this.startOffset) {
                            super.replace(filterBypass, n, n2, string, attributeSet);
                        }
                    }
                });
            }
        }

        private String getLastLine(Document document) throws BadLocationException {
            StringBuilder stringBuilder = new StringBuilder();
            String string = null;
            int n = 1;
            while (!"\n".equals(string = this.getLastChar(document, n))) {
                stringBuilder.append(string);
                ++n;
            }
            return stringBuilder.reverse().append('\n').toString();
        }

        private String getLastChar(Document document, int n) throws BadLocationException {
            return document.getText(document.getLength() - n, 1);
        }

        private String getLastChar(Document document) throws BadLocationException {
            return this.getLastChar(document, 1);
        }

        public void keyPressed(KeyEvent keyEvent) {
            try {
                switch (keyEvent.getKeyCode()) {
                    case 10: {
                        try {
                            GemProgressPanel.this.processInput.write(this.getLastLine(this.textComponent.getDocument()).getBytes());
                            GemProgressPanel.this.processInput.flush();
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                        }
                        break;
                    }
                    case 8: {
                        Document document = this.textComponent.getDocument();
                        if ("\n".equals(this.getLastChar(document))) break;
                        this.startOffset = document.getLength() - 1;
                        document.remove(this.startOffset, 1);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.textComponent.setCaretPosition(this.textComponent.getDocument().getLength());
            this.startOffset = this.textComponent.getDocument().getLength();
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

