/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.gems;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.netbeans.modules.ruby.platform.gems.Gem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GemListModel
extends AbstractListModel
implements ComboBoxModel {
    private final List<Gem> gems;
    private List<Gem> filtered;
    private Object selectedGem;

    GemListModel(List<Gem> list, String string) {
        this.gems = list;
        this.filtered = list;
        this.applyFilter(string);
    }

    void applyFilter(String string) {
        if (string == null || string.length() == 0) {
            this.filtered = this.gems;
        } else {
            Pattern pattern = null;
            String string2 = null;
            if (string.indexOf(42) != -1 || string.indexOf(94) != -1 || string.indexOf(36) != -1) {
                try {
                    pattern = Pattern.compile(string, 2);
                }
                catch (PatternSyntaxException patternSyntaxException) {}
            } else {
                string2 = string.toLowerCase(Locale.ENGLISH);
            }
            this.filtered = new ArrayList<Gem>();
            for (Gem gem : this.gems) {
                if (pattern == null) {
                    if (string2 != null) {
                        String string3;
                        String string4 = gem.getName().toLowerCase();
                        if (string4.indexOf(string2) != -1) {
                            this.filtered.add(gem);
                            continue;
                        }
                        if (gem.getDescription() == null || (string3 = gem.getDescription().toLowerCase()).indexOf(string2) == -1) continue;
                        this.filtered.add(gem);
                        continue;
                    }
                    this.filtered.add(gem);
                    continue;
                }
                if (!pattern.matcher(gem.getName()).find() && (gem.getDescription() == null || !pattern.matcher(gem.getDescription()).find())) continue;
                this.filtered.add(gem);
            }
        }
        this.fireContentsChanged(this, -1, -1);
    }

    public int getAllSize() {
        return this.gems.size();
    }

    @Override
    public int getSize() {
        return this.filtered.size();
    }

    @Override
    public Object getElementAt(int n) {
        return this.filtered.get(n);
    }

    @Override
    public void setSelectedItem(Object object) {
        this.selectedGem = object;
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedGem;
    }
}

