/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.execution;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.ruby.platform.execution.ExecutionService;
import org.netbeans.modules.ruby.platform.execution.RerunAction;
import org.netbeans.modules.ruby.platform.execution.StopAction;
import org.openide.util.Exceptions;
import org.openide.windows.InputOutput;

final class FreeIOHandler {
    private static final Map<InputOutput, Data> FREE_IOS = new WeakHashMap<InputOutput, Data>();
    private final InputOutput io;
    private final Data data;

    private FreeIOHandler(InputOutput inputOutput, Data data) {
        this.io = inputOutput;
        this.data = data;
    }

    InputOutput getIO() {
        return this.io;
    }

    String getDisplayName() {
        return this.data.displayName;
    }

    StopAction getStopAction() {
        return this.data.stopAction;
    }

    RerunAction getRerunAction() {
        return this.data.rerunAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addFreeIO(InputOutput inputOutput, String string, StopAction stopAction, RerunAction rerunAction) {
        Map<InputOutput, Data> map = FREE_IOS;
        synchronized (map) {
            FREE_IOS.put(inputOutput, new Data(string, stopAction, rerunAction));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FreeIOHandler findFreeIO(String string) {
        FreeIOHandler freeIOHandler = null;
        Map<InputOutput, Data> map = FREE_IOS;
        synchronized (map) {
            Iterator<Map.Entry<InputOutput, Data>> iterator = FREE_IOS.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<InputOutput, Data> entry = iterator.next();
                InputOutput inputOutput = entry.getKey();
                Data data = entry.getValue();
                if (inputOutput.isClosed()) {
                    iterator.remove();
                    continue;
                }
                if (freeIOHandler != null || !ExecutionService.isAppropriateName(string, data.displayName)) continue;
                freeIOHandler = new FreeIOHandler(inputOutput, data);
                try {
                    inputOutput.getOut().reset();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                iterator.remove();
            }
        }
        return freeIOHandler;
    }

    private static class Data {
        final String displayName;
        final StopAction stopAction;
        final RerunAction rerunAction;

        Data(String string, StopAction stopAction, RerunAction rerunAction) {
            this.displayName = string;
            this.stopAction = stopAction;
            this.rerunAction = rerunAction;
        }
    }
}

