/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.util;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.HibernateException;
import org.hibernate.connection.ConnectionProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;

public class CustomJDBCConnectionProvider
implements ConnectionProvider {
    private Connection connection = null;
    private Properties connectionProperties = null;
    private Logger logger = Logger.getLogger(CustomJDBCConnectionProvider.class.getName());

    public void configure(Properties properties) throws HibernateException {
        this.connectionProperties = properties;
    }

    public Connection getConnection() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.logger.info("Connection already established.. returing");
            return this.connection;
        }
        try {
            String string = this.connectionProperties.getProperty("hibernate.connection.driver_class");
            String string2 = this.connectionProperties.getProperty("hibernate.connection.url");
            String string3 = this.connectionProperties.getProperty("hibernate.connection.username");
            String string4 = this.connectionProperties.getProperty("hibernate.connection.password");
            if (string == null) {
                string = this.connectionProperties.getProperty("connection.driver_class");
            }
            if (string2 == null) {
                string2 = this.connectionProperties.getProperty("connection.url");
            }
            if (string3 == null) {
                string3 = this.connectionProperties.getProperty("connection.username");
            }
            if (string4 == null) {
                string4 = this.connectionProperties.getProperty("connection.password");
            }
            if (string4 == null) {
                string4 = "";
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = classLoader.loadClass(string);
            Driver driver = (Driver)clazz.newInstance();
            this.logger.info("Loaded JDBC driver ");
            Properties properties = new Properties();
            properties.setProperty("user", string3);
            properties.setProperty("password", string4);
            this.connection = driver.connect(string2, properties);
            this.logger.info("Got connection.. returning");
            properties = null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logger.log(Level.INFO, "DB Driver class not found during connection creation.", classNotFoundException);
            NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)classNotFoundException);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
        }
        catch (InstantiationException instantiationException) {
            this.logger.log(Level.INFO, "Cannot instantiate driver class.", instantiationException);
            NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)instantiationException);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.logger.log(Level.INFO, "Illegal access during connection creation.", illegalAccessException);
            NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)illegalAccessException);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
        }
        catch (SQLException sQLException) {
            this.logger.log(Level.INFO, "DB connection error.", sQLException);
            NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)sQLException);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
        }
        return this.connection;
    }

    public void closeConnection(Connection connection) throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public void close() throws HibernateException {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                Exceptions.printStackTrace((Throwable)sQLException);
            }
        }
    }

    public boolean supportsAggressiveRelease() {
        return true;
    }
}

