/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.io.IOException;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.hibernate.completion.HibernateCompletionDocumentation;
import org.netbeans.modules.hibernate.editor.HibernateEditorUtil;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HibernateCompletionItem
implements CompletionItem {
    protected int substitutionOffset;
    public static final String COLOR_END = "</font>";
    public static final String STRIKE = "<s>";
    public static final String STRIKE_END = "</s>";
    public static final String BOLD = "<b>";
    public static final String BOLD_END = "</b>";

    public static HibernateCompletionItem createAttribValueItem(int n, String string, String string2) {
        return new AttribValueItem(n, string, string2);
    }

    public static HibernateCompletionItem createPackageItem(int n, String string, boolean bl) {
        return new PackageItem(n, string, bl);
    }

    public static HibernateCompletionItem createTypeItem(int n, TypeElement typeElement, ElementHandle<TypeElement> elementHandle, boolean bl, boolean bl2) {
        return new ClassItem(n, typeElement, elementHandle, bl, bl2);
    }

    public static HibernateCompletionItem createClassPropertyItem(int n, VariableElement variableElement, ElementHandle<VariableElement> elementHandle, boolean bl) {
        return new ClassPropertyItem(n, variableElement, elementHandle, bl);
    }

    public static HibernateCompletionItem createDatabaseTableItem(int n, String string) {
        return new DatabaseTableItem(n, string);
    }

    public static HibernateCompletionItem createDatabaseColumnItem(int n, String string, boolean bl) {
        return new DatabaseColumnItem(n, string, bl);
    }

    public static HibernateCompletionItem createCascadeStyleItem(int n, String string, String string2) {
        return new CascadeStyleItem(n, string, string2);
    }

    public static HibernateCompletionItem createHbMappingFileItem(int n, String string) {
        return new HbMappingFileItem(n, string);
    }

    public static HibernateCompletionItem createHbPropertyValueItem(int n, String string) {
        return new HbPropertyValueItem(n, string);
    }

    protected HibernateCompletionItem(int n) {
        this.substitutionOffset = n;
    }

    public void defaultAction(JTextComponent jTextComponent) {
        if (jTextComponent != null) {
            Completion.get().hideDocumentation();
            Completion.get().hideCompletion();
            int n = jTextComponent.getSelectionEnd();
            this.substituteText(jTextComponent, this.substitutionOffset, n - this.substitutionOffset, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void substituteText(JTextComponent jTextComponent, int n, int n2, String string) {
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        CharSequence charSequence = this.getInsertPrefix();
        String string2 = ((Object)charSequence).toString();
        if (string != null) {
            string2 = string2 + string;
        }
        baseDocument.atomicLock();
        try {
            Position position = baseDocument.createPosition(n);
            baseDocument.remove(n, n2);
            baseDocument.insertString(position.getOffset(), string2.toString(), null);
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            baseDocument.atomicUnlock();
        }
    }

    protected CharSequence getSubstitutionText() {
        return this.getInsertPrefix();
    }

    public void processKeyEvent(KeyEvent keyEvent) {
    }

    public int getPreferredWidth(Graphics graphics, Font font) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)graphics, (Font)font);
    }

    public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
        CompletionUtilities.renderHtml((ImageIcon)this.getIcon(), (String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)graphics, (Font)font, (Color)color, (int)n, (int)n2, (boolean)bl);
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent jTextComponent) {
        this.defaultAction(jTextComponent);
        return true;
    }

    protected String getLeftHtmlText() {
        return null;
    }

    protected String getRightHtmlText() {
        return null;
    }

    protected ImageIcon getIcon() {
        return null;
    }

    public abstract String getDisplayText();

    public static int getImportanceLevel(String string) {
        int n = 50;
        if (string.startsWith("java.lang") || string.startsWith("java.util")) {
            n -= 10;
        } else if (string.startsWith("org.omg") || string.startsWith("org.apache")) {
            n += 10;
        } else if (string.startsWith("com.sun") || string.startsWith("com.ibm") || string.startsWith("com.apple")) {
            n += 20;
        } else if (string.startsWith("sun") || string.startsWith("sunw") || string.startsWith("netscape")) {
            n += 30;
        }
        return n;
    }

    public static CharSequence getElementName(Element element, boolean bl) {
        if (element == null || element.asType().getKind() == TypeKind.NONE) {
            return "";
        }
        return (CharSequence)new ElementNameVisitor().visit(element, bl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ElementNameVisitor
    extends SimpleElementVisitor6<StringBuilder, Boolean> {
        private ElementNameVisitor() {
            super(new StringBuilder());
        }

        @Override
        public StringBuilder visitPackage(PackageElement packageElement, Boolean bl) {
            return ((StringBuilder)this.DEFAULT_VALUE).append((bl != false ? packageElement.getQualifiedName() : packageElement.getSimpleName()).toString());
        }

        @Override
        public StringBuilder visitType(TypeElement typeElement, Boolean bl) {
            return ((StringBuilder)this.DEFAULT_VALUE).append((bl != false ? typeElement.getQualifiedName() : typeElement.getSimpleName()).toString());
        }
    }

    private static class HbPropertyValueItem
    extends HibernateCompletionItem {
        private String displayText;

        public HbPropertyValueItem(int n, String string) {
            super(n);
            this.displayText = string;
        }

        public int getSortPriority() {
            if (this.displayText.startsWith("--")) {
                return 101;
            }
            if (this.displayText.equals("true")) {
                return 98;
            }
            if (this.displayText.equals("false")) {
                return 99;
            }
            return 100;
        }

        public CharSequence getSortText() {
            return this.displayText;
        }

        public CharSequence getInsertPrefix() {
            return this.displayText;
        }

        public String getDisplayText() {
            return this.displayText;
        }

        protected String getLeftHtmlText() {
            return this.displayText;
        }
    }

    private static class HbMappingFileItem
    extends HibernateCompletionItem {
        private static final String HB_MAPPING_ICON = "org/netbeans/modules/hibernate/resources/hibernate-mapping.png";
        private String displayText;

        public HbMappingFileItem(int n, String string) {
            super(n);
            this.displayText = string;
        }

        public int getSortPriority() {
            return 100;
        }

        public CharSequence getSortText() {
            return this.displayText;
        }

        public CharSequence getInsertPrefix() {
            return this.displayText;
        }

        public String getDisplayText() {
            return this.displayText;
        }

        protected String getLeftHtmlText() {
            return this.displayText;
        }

        protected ImageIcon getIcon() {
            return new ImageIcon(Utilities.loadImage((String)HB_MAPPING_ICON));
        }
    }

    private static class CascadeStyleItem
    extends HibernateCompletionItem {
        private String displayText;
        private String docText;

        public CascadeStyleItem(int n, String string, String string2) {
            super(n);
            this.displayText = string;
            this.docText = string2;
        }

        public int getSortPriority() {
            return 100;
        }

        public CharSequence getSortText() {
            return this.displayText;
        }

        public CharSequence getInsertPrefix() {
            return this.displayText;
        }

        public String getDisplayText() {
            return this.displayText;
        }

        protected String getLeftHtmlText() {
            return this.displayText;
        }

        public void processKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getID() == 400 && keyEvent.getKeyChar() == ',') {
                Completion.get().hideDocumentation();
                JTextComponent jTextComponent = (JTextComponent)keyEvent.getSource();
                int n = jTextComponent.getSelectionEnd();
                this.substituteText(jTextComponent, this.substitutionOffset, n - this.substitutionOffset, Character.toString(keyEvent.getKeyChar()));
                Completion.get().showCompletion();
                keyEvent.consume();
            }
        }

        public CompletionTask createDocumentationTask() {
            return new AsyncCompletionTask(new AsyncCompletionQuery(){

                protected void query(CompletionResultSet completionResultSet, Document document, int n) {
                    if (CascadeStyleItem.this.docText != null) {
                        HibernateCompletionDocumentation hibernateCompletionDocumentation = HibernateCompletionDocumentation.getAttribValueDoc(CascadeStyleItem.this.docText);
                        completionResultSet.setDocumentation((CompletionDocumentation)hibernateCompletionDocumentation);
                    }
                    completionResultSet.finish();
                }
            });
        }
    }

    private static class DatabaseColumnItem
    extends HibernateCompletionItem {
        private static final String COLUMN_ICON = "org/netbeans/modules/hibernate/resources/completion/column.gif";
        private static final String PK_COLUMN_ICON = "org/netbeans/modules/hibernate/resources/completion/columnPrimary.gif";
        private String displayText;
        private boolean pk;

        public DatabaseColumnItem(int n, String string, boolean bl) {
            super(n);
            this.displayText = string;
            this.pk = bl;
        }

        public int getSortPriority() {
            if (this.pk) {
                return 1;
            }
            return 5;
        }

        public CharSequence getSortText() {
            return this.displayText;
        }

        public CharSequence getInsertPrefix() {
            return this.displayText;
        }

        public String getDisplayText() {
            return this.displayText;
        }

        protected String getLeftHtmlText() {
            return this.displayText;
        }

        protected ImageIcon getIcon() {
            if (this.pk) {
                return new ImageIcon(Utilities.loadImage((String)PK_COLUMN_ICON));
            }
            return new ImageIcon(Utilities.loadImage((String)COLUMN_ICON));
        }
    }

    private static class DatabaseTableItem
    extends HibernateCompletionItem {
        private static final String TABLE_ICON = "org/netbeans/modules/hibernate/resources/completion/table.gif";
        private String displayText;

        public DatabaseTableItem(int n, String string) {
            super(n);
            this.displayText = string;
        }

        public int getSortPriority() {
            return 100;
        }

        public CharSequence getSortText() {
            return this.displayText;
        }

        public CharSequence getInsertPrefix() {
            return this.displayText;
        }

        public String getDisplayText() {
            return this.displayText;
        }

        protected String getLeftHtmlText() {
            return this.displayText;
        }

        protected ImageIcon getIcon() {
            return new ImageIcon(Utilities.loadImage((String)TABLE_ICON));
        }
    }

    private static class AttribValueItem
    extends HibernateCompletionItem {
        private String displayText;
        private String docText;

        public AttribValueItem(int n, String string, String string2) {
            super(n);
            this.displayText = string;
            this.docText = string2;
        }

        public int getSortPriority() {
            return 100;
        }

        public CharSequence getSortText() {
            return this.displayText;
        }

        public CharSequence getInsertPrefix() {
            return this.displayText;
        }

        public String getDisplayText() {
            return this.displayText;
        }

        protected String getLeftHtmlText() {
            return this.displayText;
        }

        public CompletionTask createDocumentationTask() {
            return new AsyncCompletionTask(new AsyncCompletionQuery(){

                protected void query(CompletionResultSet completionResultSet, Document document, int n) {
                    if (AttribValueItem.this.docText != null) {
                        HibernateCompletionDocumentation hibernateCompletionDocumentation = HibernateCompletionDocumentation.getAttribValueDoc(AttribValueItem.this.docText);
                        completionResultSet.setDocumentation((CompletionDocumentation)hibernateCompletionDocumentation);
                    }
                    completionResultSet.finish();
                }
            });
        }
    }

    private static class PackageItem
    extends HibernateCompletionItem {
        private static final String PACKAGE = "org/netbeans/modules/java/editor/resources/package.gif";
        private static final String PACKAGE_COLOR = "<font color=#005600>";
        private static ImageIcon icon;
        private boolean deprecated;
        private String simpleName;
        private String sortText;
        private String leftText;

        public PackageItem(int n, String string, boolean bl) {
            super(n);
            int n2 = string.lastIndexOf(46);
            this.simpleName = n2 < 0 ? string : string.substring(n2 + 1);
            this.deprecated = bl;
            this.sortText = this.simpleName + "#" + string;
        }

        public int getSortPriority() {
            return 100;
        }

        public CharSequence getSortText() {
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        public void processKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getID() == 400 && keyEvent.getKeyChar() == '.') {
                Completion.get().hideDocumentation();
                JTextComponent jTextComponent = (JTextComponent)keyEvent.getSource();
                int n = jTextComponent.getSelectionEnd();
                this.substituteText(jTextComponent, this.substitutionOffset, n - this.substitutionOffset, Character.toString(keyEvent.getKeyChar()));
                Completion.get().showCompletion();
                keyEvent.consume();
            }
        }

        public String getDisplayText() {
            return this.simpleName;
        }

        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = new ImageIcon(Utilities.loadImage((String)PACKAGE));
            }
            return icon;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(PACKAGE_COLOR);
                if (this.deprecated) {
                    stringBuilder.append(HibernateCompletionItem.STRIKE);
                }
                stringBuilder.append(this.simpleName);
                if (this.deprecated) {
                    stringBuilder.append(HibernateCompletionItem.STRIKE_END);
                }
                stringBuilder.append(HibernateCompletionItem.COLOR_END);
                this.leftText = stringBuilder.toString();
            }
            return this.leftText;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassItem
    extends HibernateCompletionItem {
        private static final String CLASS = "org/netbeans/modules/editor/resources/completion/class_16.png";
        private static final String CLASS_COLOR = "<font color=#560000>";
        private static final String PKG_COLOR = "<font color=#808080>";
        private ElementHandle<TypeElement> elemHandle;
        private boolean deprecated;
        private String displayName;
        private String enclName;
        private String sortText;
        private String leftText;
        private boolean smartItem;

        public ClassItem(int n, TypeElement typeElement, ElementHandle<TypeElement> elementHandle, boolean bl, boolean bl2) {
            super(n);
            this.elemHandle = elementHandle;
            this.deprecated = bl;
            this.displayName = bl2 ? typeElement.getSimpleName().toString() : this.getRelativeName(typeElement);
            this.enclName = ((Object)ClassItem.getElementName(typeElement.getEnclosingElement(), true)).toString();
            this.sortText = this.displayName + ClassItem.getImportanceLevel(this.enclName) + "#" + this.enclName;
            this.smartItem = bl2;
        }

        private String getRelativeName(TypeElement typeElement) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(typeElement.getSimpleName().toString());
            Element element = typeElement.getEnclosingElement();
            while (element.getKind() != ElementKind.PACKAGE) {
                stringBuilder.insert(0, element.getSimpleName().toString() + "$");
                element = element.getEnclosingElement();
            }
            return stringBuilder.toString();
        }

        public int getSortPriority() {
            return 100;
        }

        public CharSequence getSortText() {
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return this.smartItem ? "" : this.elemHandle.getBinaryName();
        }

        @Override
        public String getDisplayText() {
            return this.displayName;
        }

        @Override
        protected CharSequence getSubstitutionText() {
            return this.elemHandle.getBinaryName();
        }

        @Override
        public boolean instantSubstitution(JTextComponent jTextComponent) {
            return false;
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.getColor());
                if (this.deprecated) {
                    stringBuilder.append(HibernateCompletionItem.STRIKE);
                }
                stringBuilder.append(this.displayName);
                if (this.deprecated) {
                    stringBuilder.append(HibernateCompletionItem.STRIKE_END);
                }
                if (this.smartItem && this.enclName != null && this.enclName.length() > 0) {
                    stringBuilder.append(HibernateCompletionItem.COLOR_END);
                    stringBuilder.append(PKG_COLOR);
                    stringBuilder.append(" (");
                    stringBuilder.append(this.enclName);
                    stringBuilder.append(")");
                }
                stringBuilder.append(HibernateCompletionItem.COLOR_END);
                this.leftText = stringBuilder.toString();
            }
            return this.leftText;
        }

        protected String getColor() {
            return CLASS_COLOR;
        }

        @Override
        protected ImageIcon getIcon() {
            return new ImageIcon(Utilities.loadImage((String)CLASS));
        }

        @Override
        public CompletionTask createDocumentationTask() {
            return new AsyncCompletionTask(new AsyncCompletionQuery(){

                protected void query(final CompletionResultSet completionResultSet, Document document, int n) {
                    try {
                        JavaSource javaSource = HibernateEditorUtil.getJavaSource(document);
                        if (javaSource == null) {
                            return;
                        }
                        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                            public void run(CompilationController compilationController) throws Exception {
                                compilationController.toPhase(JavaSource.Phase.RESOLVED);
                                Element element = ClassItem.this.elemHandle.resolve((CompilationInfo)compilationController);
                                if (element == null) {
                                    return;
                                }
                                HibernateCompletionDocumentation hibernateCompletionDocumentation = HibernateCompletionDocumentation.createJavaDoc(compilationController, element);
                                completionResultSet.setDocumentation((CompletionDocumentation)hibernateCompletionDocumentation);
                            }
                        }, false);
                        completionResultSet.finish();
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            }, EditorRegistry.lastFocusedComponent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassPropertyItem
    extends HibernateCompletionItem {
        private static final String FIELD_ICON = "org/netbeans/modules/editor/resources/completion/field_16.png";
        private ElementHandle<VariableElement> elemHandle;
        private boolean deprecated;
        private String displayName;

        public ClassPropertyItem(int n, VariableElement variableElement, ElementHandle<VariableElement> elementHandle, boolean bl) {
            super(n);
            this.elemHandle = elementHandle;
            this.deprecated = bl;
            this.displayName = variableElement.getSimpleName().toString();
        }

        public int getSortPriority() {
            return 100;
        }

        public CharSequence getSortText() {
            return this.displayName;
        }

        public CharSequence getInsertPrefix() {
            return this.displayName;
        }

        @Override
        public String getDisplayText() {
            return this.displayName;
        }

        @Override
        protected String getLeftHtmlText() {
            return this.displayName;
        }

        @Override
        protected ImageIcon getIcon() {
            return new ImageIcon(Utilities.loadImage((String)FIELD_ICON));
        }

        @Override
        public CompletionTask createDocumentationTask() {
            return new AsyncCompletionTask(new AsyncCompletionQuery(){

                protected void query(final CompletionResultSet completionResultSet, Document document, int n) {
                    try {
                        JavaSource javaSource = HibernateEditorUtil.getJavaSource(document);
                        if (javaSource == null) {
                            return;
                        }
                        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                            public void run(CompilationController compilationController) throws Exception {
                                compilationController.toPhase(JavaSource.Phase.RESOLVED);
                                Element element = ClassPropertyItem.this.elemHandle.resolve((CompilationInfo)compilationController);
                                if (element == null) {
                                    return;
                                }
                                HibernateCompletionDocumentation hibernateCompletionDocumentation = HibernateCompletionDocumentation.createJavaDoc(compilationController, element);
                                completionResultSet.setDocumentation((CompletionDocumentation)hibernateCompletionDocumentation);
                            }
                        }, false);
                        completionResultSet.finish();
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            }, EditorRegistry.lastFocusedComponent());
        }
    }
}

