/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.updateprovider;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.Utilities;
import org.netbeans.modules.autoupdate.updateprovider.InstalledModuleItem;
import org.netbeans.modules.autoupdate.updateprovider.ModuleItem;
import org.netbeans.modules.autoupdate.updateprovider.UpdateItemImpl;
import org.netbeans.spi.autoupdate.UpdateItem;
import org.netbeans.spi.autoupdate.UpdateLicense;
import org.openide.modules.ModuleInfo;
import org.openide.util.Exceptions;
import org.openide.util.WeakSet;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleItem {
    protected Node declaratingNode;
    public static final String LICENSE = "license";
    static final Set<Node> declaratingNodes = new WeakSet();

    public SimpleItem(Node node) {
        this.declaratingNode = node;
        declaratingNodes.add(this.declaratingNode);
    }

    public abstract UpdateItem toUpdateItem(Map<String, String> var1, String var2);

    public UpdateItem toUpdateItem(Map<String, String> map, File file) {
        throw new UnsupportedOperationException();
    }

    public abstract String getId();

    static String getAttribute(Node node, String string) {
        Node node2 = node.getAttributes().getNamedItem(string);
        return node2 == null ? null : node2.getNodeValue();
    }

    private static Set<String> readDependencies(String string, String string2) {
        HashSet<String> hashSet = new HashSet<String>();
        if (string == null) {
            Logger.getLogger(SimpleItem.class.getName()).log(Level.INFO, "Each feature needs own modules, but " + string2 + " has " + string);
        }
        if (string == null) {
            return hashSet;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), ",");
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(stringTokenizer.nextToken());
        }
        return hashSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class License
    extends SimpleItem {
        public static final String LICENSE_ID = "name";
        private String licenceId;
        private String licenseContent;

        public License(Node node) {
            super(node);
            assert (this.declaratingNode != null) : "declaratingNode must be declared";
            this.licenceId = License.getAttribute(this.declaratingNode, LICENSE_ID);
            NodeList nodeList = this.declaratingNode.getChildNodes();
            if (nodeList == null) {
                Logger.getLogger(SimpleItem.class.getName()).log(Level.WARNING, "License " + License.getAttribute(this.declaratingNode, LICENSE_ID) + " doesn't contain any data.");
            }
            if (nodeList.getLength() != 1) {
                Logger.getLogger(SimpleItem.class.getName()).log(Level.WARNING, "License " + License.getAttribute(this.declaratingNode, LICENSE_ID) + " contains more(" + nodeList.getLength() + "x) instances of license content. " + "Reopen the issue 111578.");
            }
            this.licenseContent = nodeList.item(0).getNodeValue();
            this.declaratingNode = null;
        }

        public String getLicenseId() {
            assert (this.licenceId != null) : "licenceId cannot be null";
            return this.licenceId;
        }

        public String getLicenseContent() {
            assert (this.licenseContent != null) : "licenseContent for " + this.licenceId + " cannot be null";
            return this.licenseContent;
        }

        @Override
        public UpdateItem toUpdateItem(Map<String, String> map, String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Localization
    extends SimpleItem {
        public static final String CODE_NAME_BASE = "codenamebase";
        public static final String DISTRIBUTION = "distribution";
        public static final String DOWNLOAD_SIZE = "downloadsize";
        public static final String NEEDS_RESTART = "needsrestart";
        public static final String MODULE_AUTHOR = "moduleauthor";
        public static final String RELEASE_DATE = "releasedate";
        public static final String IS_GLOBAL = "global";
        public static final String TARGET_CLUSTER = "targetcluster";
        public static final String LOCALE = "langcode";
        public static final String BRANDING = "brandingcode";
        public static final String MODULE_SPECIFICATION = "module_spec_version";
        public static final String MODULE_MAJOR_VERSION = "module_major_version";
        public static final String LOCALIZED_MODULE_NAME = "OpenIDE-Module-Name";
        public static final String LOCALIZED_MODULE_DESCRIPTION = "OpenIDE-Module-Long-Description";
        private String specificationVersion;
        private String moduleCodeName;
        private String locale;
        private String branding;
        private String category;

        public Localization(Node node, String string) {
            super(node);
            this.category = string;
        }

        @Override
        public UpdateItem toUpdateItem(Map<String, String> map, String string) {
            URL uRL;
            String string2;
            String string3;
            String string4;
            block5: {
                assert (this.declaratingNode != null) : "declaratingNode must be declared";
                this.moduleCodeName = Localization.getAttribute(this.declaratingNode, CODE_NAME_BASE);
                String string5 = Localization.getAttribute(this.declaratingNode, DISTRIBUTION);
                string4 = Localization.getAttribute(this.declaratingNode, NEEDS_RESTART);
                string3 = Localization.getAttribute(this.declaratingNode, IS_GLOBAL);
                string2 = Localization.getAttribute(this.declaratingNode, TARGET_CLUSTER);
                uRL = null;
                try {
                    uRL = new URL(string5);
                }
                catch (MalformedURLException malformedURLException) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError((Object)malformedURLException);
                }
            }
            Boolean bl = string4 == null || string4.trim().length() == 0 ? null : Boolean.valueOf(string4);
            Boolean bl2 = string3 == null || string3.trim().length() == 0 ? null : Boolean.valueOf(string3);
            NodeList nodeList = ((Element)this.declaratingNode).getElementsByTagName("l10n");
            assert (nodeList != null && nodeList.getLength() == 1) : "TAG_MANIFEST in module " + this.moduleCodeName + " should contains one and only one list, but was " + nodeList.getLength();
            assert (1 == nodeList.item(0).getNodeType());
            Node node = nodeList.item(0);
            this.locale = Localization.getAttribute(node, LOCALE);
            this.branding = Localization.getAttribute(node, BRANDING);
            String string6 = this.moduleCodeName + '_' + this.locale + '_' + this.branding;
            this.specificationVersion = "1.0";
            String string7 = Localization.getAttribute(this.declaratingNode, SimpleItem.LICENSE);
            String string8 = map.get(string7);
            UpdateLicense updateLicense = UpdateLicense.createUpdateLicense(string7, string8);
            UpdateItem updateItem = UpdateItem.createLocalization(string6, this.specificationVersion, Localization.getAttribute(this.declaratingNode, MODULE_SPECIFICATION), this.locale != null && this.locale.length() > 0 ? new Locale(this.locale) : null, this.branding != null && this.branding.length() > 0 ? this.branding : null, Localization.getAttribute(this.declaratingNode, LOCALIZED_MODULE_NAME), Localization.getAttribute(this.declaratingNode, LOCALIZED_MODULE_DESCRIPTION), this.category, uRL, bl, bl2, string2, updateLicense);
            this.declaratingNode = null;
            return updateItem;
        }

        @Override
        public String getId() {
            return this.moduleCodeName + '_' + this.specificationVersion + '_' + this.locale + '_' + this.branding;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InstalledModule
    extends SimpleItem {
        private ModuleInfo info;

        public InstalledModule(ModuleInfo moduleInfo) {
            super(null);
            if (moduleInfo == null) {
                throw new IllegalArgumentException("ModuleInfo must found while constructing InstalledModule.");
            }
            this.info = moduleInfo;
        }

        @Override
        public UpdateItem toUpdateItem(Map<String, String> map, String string) {
            InstalledModuleItem installedModuleItem = new InstalledModuleItem(this.info.getCodeNameBase(), this.info.getSpecificationVersion() == null ? null : this.info.getSpecificationVersion().toString(), this.info, null, null, string);
            return Utilities.createUpdateItem(installedModuleItem);
        }

        @Override
        public String getId() {
            return this.info.getCodeName() + '_' + this.info.getSpecificationVersion();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Module
    extends SimpleItem {
        public static final String CODE_NAME_BASE = "codenamebase";
        public static final String HOMEPAGE = "homepage";
        public static final String DISTRIBUTION = "distribution";
        public static final String DOWNLOAD_SIZE = "downloadsize";
        public static final String NEEDS_RESTART = "needsrestart";
        public static final String MODULE_AUTHOR = "moduleauthor";
        public static final String RELEASE_DATE = "releasedate";
        public static final String IS_GLOBAL = "global";
        public static final String TARGET_CLUSTER = "targetcluster";
        public static final String ATTR_SPECIFICATION_VERSION = "OpenIDE-Module-Specification-Version";
        public static final String IS_EAGER = "eager";
        public static final String IS_AUTOLOAD = "autoload";
        public static final String MODULE_NOTIFICATION = "module_notification";
        private String moduleCodeName;
        private String specVersion;
        private String category;

        public Module(Node node, String string) {
            super(node);
            this.category = string;
        }

        private static String getSpecificationVersion(Node node) {
            NodeList nodeList = ((Element)node).getElementsByTagName("manifest");
            assert (nodeList != null && nodeList.getLength() == 1) : "TAG_MANIFEST should contains one and only one list.";
            assert (1 == nodeList.item(0).getNodeType());
            String string = null;
            NamedNodeMap namedNodeMap = nodeList.item(0).getAttributes();
            Manifest manifest = new Manifest();
            Attributes attributes = manifest.getMainAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                attributes.put(new Attributes.Name(attr.getName()), attr.getValue());
                if (!ATTR_SPECIFICATION_VERSION.equals(attr.getName())) continue;
                string = attr.getValue();
            }
            return string;
        }

        private static Manifest getManifest(Node node) {
            NodeList nodeList = ((Element)node).getElementsByTagName("manifest");
            assert (nodeList != null && nodeList.getLength() == 1) : "TAG_MANIFEST should contains one and only one list.";
            assert (1 == nodeList.item(0).getNodeType());
            NamedNodeMap namedNodeMap = nodeList.item(0).getAttributes();
            Manifest manifest = new Manifest();
            Attributes attributes = manifest.getMainAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                attributes.put(new Attributes.Name(attr.getName()), attr.getValue());
            }
            return manifest;
        }

        private static String getModuleNotfication(Node node) {
            NodeList nodeList = ((Element)node).getElementsByTagName(MODULE_NOTIFICATION);
            if (nodeList == null || nodeList.getLength() == 0) {
                return null;
            }
            assert (nodeList != null && nodeList.getLength() == 1) : "MODULE_NOTIFICATION should contains one and only one list.";
            assert (1 == nodeList.item(0).getNodeType());
            return nodeList.item(0).getChildNodes().item(0).getNodeValue();
        }

        private static String getModuleCodeName(Node node) {
            return Module.getAttribute(node, CODE_NAME_BASE);
        }

        @Override
        public UpdateItem toUpdateItem(Map<String, String> map, String string) {
            return this.toUpdateItem(map, null, string);
        }

        @Override
        public UpdateItem toUpdateItem(Map<String, String> map, File file) {
            String string = Utilities.formatDate(new Date(file.lastModified()));
            return this.toUpdateItem(map, file, string);
        }

        private URL getDistribution(File file) {
            URL uRL = null;
            try {
                if (file != null) {
                    uRL = file.toURI().toURL();
                } else {
                    String string = Module.getAttribute(this.declaratingNode, DISTRIBUTION);
                    if (string != null && string.length() > 0) {
                        URI uRI = new URI(string);
                        if (!uRI.isAbsolute()) {
                            uRI = new URI(this.declaratingNode.getBaseURI()).resolve(uRI);
                        }
                        uRL = uRI.toURL();
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
            catch (URISyntaxException uRISyntaxException) {
                Exceptions.printStackTrace((Throwable)uRISyntaxException);
            }
            return uRL;
        }

        private UpdateItem toUpdateItem(Map<String, String> map, File file, String string) {
            assert (this.declaratingNode != null) : "declaratingNode must be declared";
            URL uRL = null;
            this.moduleCodeName = Module.getModuleCodeName(this.declaratingNode);
            uRL = this.getDistribution(file);
            String string2 = Module.getAttribute(this.declaratingNode, NEEDS_RESTART);
            String string3 = Module.getAttribute(this.declaratingNode, IS_GLOBAL);
            String string4 = Module.getAttribute(this.declaratingNode, TARGET_CLUSTER);
            String string5 = Module.getAttribute(this.declaratingNode, HOMEPAGE);
            String string6 = file != null && file.exists() ? String.valueOf(file.length()) : Module.getAttribute(this.declaratingNode, DOWNLOAD_SIZE);
            String string7 = Module.getAttribute(this.declaratingNode, MODULE_AUTHOR);
            String string8 = Module.getAttribute(this.declaratingNode, RELEASE_DATE);
            String string9 = Module.getAttribute(this.declaratingNode, IS_EAGER);
            String string10 = Module.getAttribute(this.declaratingNode, IS_AUTOLOAD);
            if (string8 == null || string8.length() == 0) {
                string8 = string;
            }
            Boolean bl = string2 == null || string2.trim().length() == 0 ? null : Boolean.valueOf(string2);
            Boolean bl2 = string3 == null || string3.trim().length() == 0 ? null : Boolean.valueOf(string3);
            Boolean bl3 = Boolean.parseBoolean(string9);
            Boolean bl4 = Boolean.parseBoolean(string10);
            this.specVersion = Module.getSpecificationVersion(this.declaratingNode);
            Manifest manifest = Module.getManifest(this.declaratingNode);
            String string11 = Module.getAttribute(this.declaratingNode, SimpleItem.LICENSE);
            String string12 = map.get(string11);
            UpdateLicense updateLicense = UpdateLicense.createUpdateLicense(string11, string12);
            UpdateItem updateItem = UpdateItem.createModule(this.moduleCodeName, this.specVersion, uRL, string7, string6, string5, string8, this.category, manifest, bl3, bl4, bl, bl2, string4, updateLicense);
            UpdateItemImpl updateItemImpl = Trampoline.SPI.impl(updateItem);
            ((ModuleItem)updateItemImpl).setModuleNotification(Module.getModuleNotfication(this.declaratingNode));
            this.declaratingNode = null;
            return updateItem;
        }

        @Override
        public String getId() {
            return this.moduleCodeName + '_' + this.specVersion;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Feature
    extends SimpleItem {
        public static final String CODE_NAME_BASE = "codename";
        public static final String SPECIFICATION_VERSION = "version";
        public static final String MODULE_DEPENDENCIES = "module-dependencies";
        public static final String DISPLAY_NAME = "displayname";
        public static final String DESCRIPTION = "description";
        private String codeName;
        private String version;
        private String category;

        public Feature(Node node, String string) {
            super(node);
            this.codeName = Feature.getAttribute(this.declaratingNode, CODE_NAME_BASE);
            this.version = Feature.getAttribute(this.declaratingNode, SPECIFICATION_VERSION);
            this.category = string;
        }

        @Override
        public UpdateItem toUpdateItem(Map<String, String> map, String string) {
            assert (this.declaratingNode != null) : "declaratingNode must be declared";
            String string2 = Feature.getAttribute(this.declaratingNode, MODULE_DEPENDENCIES);
            UpdateItem updateItem = UpdateItem.createFeature(Feature.getAttribute(this.declaratingNode, CODE_NAME_BASE), Feature.getAttribute(this.declaratingNode, SPECIFICATION_VERSION), SimpleItem.readDependencies(string2, Feature.getAttribute(this.declaratingNode, CODE_NAME_BASE)), Feature.getAttribute(this.declaratingNode, DISPLAY_NAME), Feature.getAttribute(this.declaratingNode, DESCRIPTION), this.category);
            this.declaratingNode = null;
            return updateItem;
        }

        @Override
        public String getId() {
            return this.codeName + '_' + this.version;
        }
    }
}

