/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.autoupdate.services.FeatureUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.ModuleDeleterImpl;
import org.netbeans.modules.autoupdate.services.ModuleUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.NativeComponentUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateElementImpl;
import org.netbeans.modules.autoupdate.services.UpdateUnitFactory;
import org.netbeans.modules.autoupdate.services.UpdateUnitImpl;
import org.netbeans.modules.autoupdate.services.Utilities;
import org.netbeans.spi.autoupdate.CustomInstaller;
import org.openide.LifecycleManager;
import org.openide.modules.ModuleInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OperationSupportImpl {
    private static final OperationSupportImpl FOR_INSTALL = new ForInstall();
    private static final OperationSupportImpl FOR_UPDATE = new ForUpdate();
    private static final OperationSupportImpl FOR_ENABLE = new ForEnable();
    private static final OperationSupportImpl FOR_DISABLE = new ForDisable();
    private static final OperationSupportImpl FOR_DIRECT_DISABLE = new ForDirectDisable();
    private static final OperationSupportImpl FOR_UNINSTALL = new ForUninstall();
    private static final OperationSupportImpl FOR_DIRECT_UNINSTALL = new ForDirectUninstall();
    private static final OperationSupportImpl FOR_CUSTOM_INSTALL = new ForCustomInstall();
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.autoupdate.services.OperationSupportImpl");

    public static OperationSupportImpl forInstall() {
        return FOR_INSTALL;
    }

    public static OperationSupportImpl forUpdate() {
        return FOR_UPDATE;
    }

    public static OperationSupportImpl forUninstall() {
        return FOR_UNINSTALL;
    }

    public static OperationSupportImpl forDirectUninstall() {
        return FOR_DIRECT_UNINSTALL;
    }

    public static OperationSupportImpl forEnable() {
        return FOR_ENABLE;
    }

    public static OperationSupportImpl forDisable() {
        return FOR_DISABLE;
    }

    public static OperationSupportImpl forDirectDisable() {
        return FOR_DIRECT_DISABLE;
    }

    public static OperationSupportImpl forCustomInstall() {
        return FOR_CUSTOM_INSTALL;
    }

    public abstract Boolean doOperation(ProgressHandle var1, OperationContainer<?> var2) throws OperationException;

    public abstract void doCancel() throws OperationException;

    public abstract void doRestart(OperationSupport.Restarter var1, ProgressHandle var2) throws OperationException;

    public abstract void doRestartLater(OperationSupport.Restarter var1);

    private OperationSupportImpl() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForCustomInstall
    extends OperationSupportImpl {
        private ForCustomInstall() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Boolean doOperation(ProgressHandle progressHandle, OperationContainer<?> operationContainer) throws OperationException {
            try {
                List<OperationContainer.OperationInfo<?>> list = operationContainer.listAll();
                ArrayList<NativeComponentUpdateElementImpl> arrayList = new ArrayList<NativeComponentUpdateElementImpl>();
                for (OperationContainer.OperationInfo<?> object : list) {
                    UpdateElementImpl updateElementImpl = Trampoline.API.impl(object.getUpdateElement());
                    assert (updateElementImpl instanceof NativeComponentUpdateElementImpl) : "Impl of " + object.getUpdateElement() + " instanceof NativeComponentUpdateElementImpl.";
                    arrayList.add((NativeComponentUpdateElementImpl)updateElementImpl);
                }
                assert (arrayList != null) : "Some elements with custom installer found.";
                boolean bl = false;
                for (NativeComponentUpdateElementImpl nativeComponentUpdateElementImpl : arrayList) {
                    CustomInstaller customInstaller = nativeComponentUpdateElementImpl.getInstallInfo().getCustomInstaller();
                    assert (customInstaller != null) : "CustomInstaller must found for " + nativeComponentUpdateElementImpl.getUpdateElement();
                    bl = customInstaller.install(nativeComponentUpdateElementImpl.getCodeName(), nativeComponentUpdateElementImpl.getSpecificationVersion() == null ? null : nativeComponentUpdateElementImpl.getSpecificationVersion().toString(), progressHandle);
                    if (bl) {
                        UpdateUnitImpl updateUnitImpl = Trampoline.API.impl(nativeComponentUpdateElementImpl.getUpdateUnit());
                        updateUnitImpl.setInstalled(nativeComponentUpdateElementImpl.getUpdateElement());
                        continue;
                    }
                    throw new OperationException(OperationException.ERROR_TYPE.INSTALL, nativeComponentUpdateElementImpl.getDisplayName());
                }
            }
            finally {
                if (progressHandle != null) {
                    progressHandle.finish();
                }
            }
            return false;
        }

        @Override
        public void doCancel() throws OperationException {
            assert (false) : "Not supported yet";
        }

        @Override
        public void doRestart(OperationSupport.Restarter restarter, ProgressHandle progressHandle) throws OperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void doRestartLater(OperationSupport.Restarter restarter) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static class ForUpdate
    extends OperationSupportImpl {
        private ForUpdate() {
        }

        public synchronized Boolean doOperation(ProgressHandle progressHandle, OperationContainer operationContainer) throws OperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void doCancel() throws OperationException {
            assert (false) : "Not supported yet";
        }

        public void doRestart(OperationSupport.Restarter restarter, ProgressHandle progressHandle) throws OperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void doRestartLater(OperationSupport.Restarter restarter) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static class ForInstall
    extends OperationSupportImpl {
        private ForInstall() {
        }

        public synchronized Boolean doOperation(ProgressHandle progressHandle, OperationContainer operationContainer) throws OperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void doCancel() throws OperationException {
            assert (false) : "Not supported yet";
        }

        public void doRestart(OperationSupport.Restarter restarter, ProgressHandle progressHandle) throws OperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void doRestartLater(OperationSupport.Restarter restarter) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForDirectUninstall
    extends OperationSupportImpl {
        private ForDirectUninstall() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Boolean doOperation(ProgressHandle progressHandle, OperationContainer<?> operationContainer) throws OperationException {
            try {
                Object object;
                if (progressHandle != null) {
                    progressHandle.start();
                }
                ModuleDeleterImpl moduleDeleterImpl = new ModuleDeleterImpl();
                List<OperationContainer.OperationInfo<?>> list = operationContainer.listAll();
                HashSet<ModuleInfo> hashSet = new HashSet<ModuleInfo>();
                HashSet<UpdateUnit> hashSet2 = new HashSet<UpdateUnit>();
                HashSet<UpdateUnit> hashSet3 = new HashSet<UpdateUnit>();
                block9: for (OperationContainer.OperationInfo<?> object2 : list) {
                    object = object2.getUpdateElement();
                    UpdateElementImpl updateElementImpl = Trampoline.API.impl((UpdateElement)object);
                    switch (updateElementImpl.getType()) {
                        case KIT_MODULE: 
                        case MODULE: {
                            hashSet.add(((ModuleUpdateElementImpl)updateElementImpl).getModuleInfo());
                            hashSet2.add(updateElementImpl.getUpdateUnit());
                            continue block9;
                        }
                        case STANDALONE_MODULE: 
                        case FEATURE: {
                            for (ModuleUpdateElementImpl moduleUpdateElementImpl : ((FeatureUpdateElementImpl)updateElementImpl).getContainedModuleElements()) {
                                hashSet.add(moduleUpdateElementImpl.getModuleInfo());
                                if (moduleUpdateElementImpl.getUpdateUnit().getInstalled() == null) continue;
                                hashSet2.add(moduleUpdateElementImpl.getUpdateUnit());
                            }
                            hashSet3.add(((UpdateElement)object).getUpdateUnit());
                            continue block9;
                        }
                    }
                    assert (false) : "Not supported for impl " + updateElementImpl;
                }
                try {
                    moduleDeleterImpl.delete(hashSet.toArray(new ModuleInfo[0]), progressHandle);
                }
                catch (IOException iOException) {
                    throw new OperationException(OperationException.ERROR_TYPE.UNINSTALL, iOException);
                }
                for (UpdateUnit updateUnit : hashSet2) {
                    assert (updateUnit.getInstalled() != null) : "Module " + updateUnit + " is installed while doing uninstall.";
                    LOGGER.log(Level.FINE, "Module was uninstalled " + updateUnit.getCodeName());
                    object = Trampoline.API.impl(updateUnit);
                    ((UpdateUnitImpl)object).setAsUninstalled();
                }
                for (UpdateUnit updateUnit : hashSet3) {
                    assert (updateUnit.getInstalled() != null) : "Feature " + updateUnit + " is installed while doing uninstall.";
                    LOGGER.log(Level.FINE, "Feature was uninstalled " + updateUnit.getCodeName());
                    object = Trampoline.API.impl(updateUnit);
                    ((UpdateUnitImpl)object).setAsUninstalled();
                }
            }
            finally {
                if (progressHandle != null) {
                    progressHandle.finish();
                }
            }
            return false;
        }

        @Override
        public void doCancel() throws OperationException {
            assert (false) : "Not supported yet";
        }

        @Override
        public void doRestart(OperationSupport.Restarter restarter, ProgressHandle progressHandle) throws OperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void doRestartLater(OperationSupport.Restarter restarter) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForUninstall
    extends OperationSupportImpl {
        private Collection<File> files4remove = null;
        private Collection<UpdateElement> affectedModules = null;

        private ForUninstall() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Boolean doOperation(ProgressHandle progressHandle, OperationContainer<?> operationContainer) throws OperationException {
            try {
                if (progressHandle != null) {
                    progressHandle.start();
                }
                ModuleDeleterImpl moduleDeleterImpl = new ModuleDeleterImpl();
                List<OperationContainer.OperationInfo<?>> list = operationContainer.listAll();
                HashSet<ModuleInfo> hashSet = new HashSet<ModuleInfo>();
                this.affectedModules = new HashSet<UpdateElement>();
                block9: for (OperationContainer.OperationInfo<?> operationInfo : list) {
                    UpdateElement updateElement = operationInfo.getUpdateElement();
                    UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
                    switch (updateElementImpl.getType()) {
                        case KIT_MODULE: 
                        case MODULE: {
                            hashSet.add(((ModuleUpdateElementImpl)updateElementImpl).getModuleInfo());
                            this.affectedModules.add(updateElementImpl.getUpdateElement());
                            break;
                        }
                        case STANDALONE_MODULE: 
                        case FEATURE: {
                            for (ModuleUpdateElementImpl moduleUpdateElementImpl : ((FeatureUpdateElementImpl)updateElementImpl).getContainedModuleElements()) {
                                hashSet.add(moduleUpdateElementImpl.getModuleInfo());
                                if (moduleUpdateElementImpl.getUpdateUnit().getInstalled() == null) continue;
                                this.affectedModules.add(moduleUpdateElementImpl.getUpdateElement());
                            }
                            continue block9;
                        }
                        default: {
                            assert (false) : "Not supported for impl " + updateElementImpl;
                            continue block9;
                        }
                    }
                }
                try {
                    this.files4remove = moduleDeleterImpl.markForDelete(hashSet, progressHandle);
                }
                catch (IOException iOException) {
                    throw new OperationException(OperationException.ERROR_TYPE.UNINSTALL, iOException);
                }
            }
            finally {
                if (progressHandle != null) {
                    progressHandle.finish();
                }
            }
            return true;
        }

        @Override
        public void doCancel() throws OperationException {
            if (this.files4remove != null) {
                this.files4remove = null;
            }
            if (this.affectedModules != null) {
                this.affectedModules = null;
            }
        }

        @Override
        public void doRestart(OperationSupport.Restarter restarter, ProgressHandle progressHandle) throws OperationException {
            Utilities.writeFileMarkedForDelete(this.files4remove);
            Utilities.deleteAllDoLater();
            LifecycleManager.getDefault().exit();
            this.doRestartLater(restarter);
        }

        @Override
        public void doRestartLater(OperationSupport.Restarter restarter) {
            Utilities.writeFileMarkedForDelete(this.files4remove);
            for (UpdateElement updateElement : this.affectedModules) {
                UpdateUnitFactory.getDefault().scheduleForRestart(updateElement);
            }
            Utilities.writeDeactivateLater(this.files4remove);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForDirectDisable
    extends OperationSupportImpl {
        private ForDirectDisable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Boolean doOperation(ProgressHandle progressHandle, OperationContainer<?> operationContainer) throws OperationException {
            try {
                if (progressHandle != null) {
                    progressHandle.start();
                }
                ModuleManager moduleManager = null;
                List<OperationContainer.OperationInfo<?>> list = operationContainer.listAll();
                HashSet<ModuleInfo> hashSet = new HashSet<ModuleInfo>();
                for (OperationContainer.OperationInfo<?> object : list) {
                    UpdateElementImpl updateElementImpl = Trampoline.API.impl(object.getUpdateElement());
                    hashSet.addAll(updateElementImpl.getModuleInfos());
                }
                HashSet hashSet2 = new HashSet();
                for (ModuleInfo moduleInfo : hashSet) {
                    Module module = Utilities.toModule(moduleInfo);
                    if (Utilities.canDisable(module)) {
                        hashSet2.add(module);
                        LOGGER.log(Level.FINE, "Module will be disabled " + module.getCodeNameBase());
                    }
                    if (moduleManager != null) continue;
                    moduleManager = module.getManager();
                }
                assert (moduleManager != null);
                moduleManager.disable((Set)hashSet2);
            }
            finally {
                if (progressHandle != null) {
                    progressHandle.finish();
                }
            }
            return false;
        }

        @Override
        public void doCancel() throws OperationException {
            assert (false) : "Not supported yet";
        }

        @Override
        public void doRestart(OperationSupport.Restarter restarter, ProgressHandle progressHandle) throws OperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void doRestartLater(OperationSupport.Restarter restarter) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForDisable
    extends OperationSupportImpl {
        private Collection<File> controlFileForDisable = null;
        private Collection<UpdateElement> affectedModules = null;

        private ForDisable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Boolean doOperation(ProgressHandle progressHandle, OperationContainer<?> operationContainer) throws OperationException {
            try {
                if (progressHandle != null) {
                    progressHandle.start();
                }
                ModuleManager moduleManager = null;
                List<OperationContainer.OperationInfo<?>> list = operationContainer.listAll();
                this.affectedModules = new HashSet<UpdateElement>();
                HashSet<ModuleInfo> hashSet = new HashSet<ModuleInfo>();
                for (OperationContainer.OperationInfo<?> object2 : list) {
                    UpdateElementImpl updateElementImpl = Trampoline.API.impl(object2.getUpdateElement());
                    this.affectedModules.add(object2.getUpdateElement());
                    hashSet.addAll(updateElementImpl.getModuleInfos());
                }
                HashSet hashSet2 = new HashSet();
                for (ModuleInfo moduleInfo : hashSet) {
                    Module module = Utilities.toModule(moduleInfo);
                    if (Utilities.canDisable(module)) {
                        hashSet2.add(module);
                        LOGGER.log(Level.FINE, "Mark module " + module.getCodeNameBase() + " for disable.");
                    }
                    if (moduleManager != null) continue;
                    moduleManager = module.getManager();
                }
                assert (moduleManager != null);
                ModuleDeleterImpl moduleDeleterImpl = new ModuleDeleterImpl();
                this.controlFileForDisable = moduleDeleterImpl.markForDisable(hashSet2, progressHandle);
            }
            finally {
                if (progressHandle != null) {
                    progressHandle.finish();
                }
            }
            return true;
        }

        @Override
        public void doCancel() throws OperationException {
            if (this.controlFileForDisable != null) {
                this.controlFileForDisable = null;
            }
            if (this.affectedModules != null) {
                this.affectedModules = null;
            }
        }

        @Override
        public void doRestart(OperationSupport.Restarter restarter, ProgressHandle progressHandle) throws OperationException {
            Utilities.writeFileMarkedForDisable(this.controlFileForDisable);
            Utilities.deleteAllDoLater();
            LifecycleManager.getDefault().exit();
            this.doRestartLater(restarter);
        }

        @Override
        public void doRestartLater(OperationSupport.Restarter restarter) {
            Utilities.writeFileMarkedForDisable(this.controlFileForDisable);
            for (UpdateElement updateElement : this.affectedModules) {
                UpdateUnitFactory.getDefault().scheduleForRestart(updateElement);
            }
            Utilities.writeDeactivateLater(this.controlFileForDisable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForEnable
    extends OperationSupportImpl {
        private ForEnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Boolean doOperation(ProgressHandle progressHandle, OperationContainer<?> operationContainer) throws OperationException {
            try {
                if (progressHandle != null) {
                    progressHandle.start();
                }
                ModuleManager moduleManager = null;
                List<OperationContainer.OperationInfo<?>> list = operationContainer.listAll();
                HashSet<ModuleInfo> hashSet = new HashSet<ModuleInfo>();
                for (OperationContainer.OperationInfo<?> object : list) {
                    UpdateElementImpl updateElementImpl = Trampoline.API.impl(object.getUpdateElement());
                    hashSet.addAll(updateElementImpl.getModuleInfos());
                }
                HashSet hashSet2 = new HashSet();
                for (ModuleInfo moduleInfo : hashSet) {
                    Module module = Utilities.toModule(moduleInfo);
                    if (Utilities.canEnable(module)) {
                        hashSet2.add(module);
                        LOGGER.log(Level.FINE, "Module will be enabled " + module.getCodeNameBase());
                    }
                    if (moduleManager != null) continue;
                    moduleManager = module.getManager();
                }
                assert (moduleManager != null);
                ForEnable.enable(moduleManager, hashSet2);
            }
            finally {
                if (progressHandle != null) {
                    progressHandle.finish();
                }
            }
            return false;
        }

        @Override
        public void doCancel() throws OperationException {
            assert (false) : "Not supported yet";
        }

        private static boolean enable(ModuleManager moduleManager, Set<Module> set) throws OperationException {
            boolean bl = false;
            try {
                moduleManager.enable(set);
                bl = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new OperationException(OperationException.ERROR_TYPE.ENABLE, illegalArgumentException);
            }
            catch (InvalidException invalidException) {
                throw new OperationException(OperationException.ERROR_TYPE.ENABLE, (Exception)((Object)invalidException));
            }
            return bl;
        }

        @Override
        public void doRestart(OperationSupport.Restarter restarter, ProgressHandle progressHandle) throws OperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void doRestartLater(OperationSupport.Restarter restarter) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

