/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import javax.swing.event.EventListenerList;
import javax.swing.tree.TreeNode;
import org.openide.explorer.view.NodeModel;
import org.openide.explorer.view.VisualizerEvent;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class VisualizerChildren {
    public static final VisualizerChildren EMPTY = new VisualizerChildren();
    public final VisualizerNode parent;
    private final List<VisualizerNode> visNodes;
    private List<Node> snapshot;
    private static final int prefetchCount = Math.max(Integer.getInteger("org.openide.explorer.VisualizerChildren.prefetchCount", 50), 0);

    private VisualizerChildren() {
        this.visNodes = Collections.EMPTY_LIST;
        this.parent = null;
    }

    public VisualizerChildren(VisualizerNode visualizerNode, int n, List<Node> list) {
        int n2;
        this.parent = visualizerNode;
        this.visNodes = new ArrayList<VisualizerNode>(n);
        int n3 = Math.min(prefetchCount, n);
        for (n2 = 0; n2 < n3; ++n2) {
            VisualizerNode visualizerNode2 = VisualizerNode.getVisualizer(this, list.get(n2));
            this.visNodes.add(visualizerNode2);
        }
        for (n2 = n3; n2 < n; ++n2) {
            this.visNodes.add(null);
        }
        this.snapshot = list;
    }

    private final boolean recomputeIndexes(VisualizerNode visualizerNode) {
        VisualizerNode visualizerNode2;
        int n;
        assert (visualizerNode == null || this.parent == visualizerNode.getParent()) : "tn must be our child!";
        boolean bl = false;
        for (n = 0; n < this.visNodes.size(); ++n) {
            visualizerNode2 = this.visNodes.get(n);
            if (visualizerNode2 == null) continue;
            visualizerNode2.indexOf = n;
            bl = true;
        }
        if (visualizerNode != null && visualizerNode.indexOf == -1) {
            n = 0;
            while (n < this.visNodes.size()) {
                visualizerNode2 = (VisualizerNode)this.getChildAt(n);
                visualizerNode2.indexOf = n++;
                if (visualizerNode2 != visualizerNode) continue;
                return bl;
            }
        }
        return bl;
    }

    public TreeNode getChildAt(int n) {
        if (n >= this.visNodes.size()) {
            return VisualizerNode.EMPTY;
        }
        VisualizerNode visualizerNode = this.visNodes.get(n);
        if (visualizerNode == null) {
            Node node = this.snapshot.get(n);
            visualizerNode = VisualizerNode.getVisualizer(this, node);
            visualizerNode.indexOf = n;
            this.visNodes.set(n, visualizerNode);
        }
        return visualizerNode;
    }

    public int getChildCount() {
        return this.visNodes.size();
    }

    public Enumeration children() {
        return new Enumeration(){
            private int index;

            public boolean hasMoreElements() {
                return this.index < VisualizerChildren.this.visNodes.size();
            }

            public Object nextElement() {
                return VisualizerChildren.this.getChildAt(this.index++);
            }
        };
    }

    public int getIndex(TreeNode treeNode) {
        VisualizerNode visualizerNode = (VisualizerNode)treeNode;
        if (visualizerNode.getParent() != this.parent) {
            return -1;
        }
        if (visualizerNode.indexOf == -1) {
            this.recomputeIndexes(visualizerNode);
        }
        assert (visualizerNode.indexOf != -1) : this.dumpIndexes(visualizerNode);
        return visualizerNode.indexOf;
    }

    final String dumpIndexes(VisualizerNode visualizerNode) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("EMPTY: " + (visualizerNode == VisualizerNode.EMPTY) + ", Lazy: " + this.snapshot.getClass().getName().endsWith("LazySnapshot"));
        stringBuilder.append("\nSeeking for: ").append(visualizerNode.toId());
        stringBuilder.append("\nwith parent: ").append((VisualizerNode)visualizerNode.getParent() != null ? ((VisualizerNode)visualizerNode.getParent()).toId() : "null");
        stringBuilder.append("\nSeeking in : ").append(this.parent != null ? this.parent.toId() : "null").append("\n");
        for (int i = 0; i < this.visNodes.size(); ++i) {
            VisualizerNode visualizerNode2 = this.visNodes.get(i);
            stringBuilder.append("  ").append(i);
            if (visualizerNode2 != null) {
                stringBuilder.append(" = ").append(visualizerNode2.toId());
            } else {
                stringBuilder.append(" = null");
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public void added(VisualizerEvent.Added added) {
        if (this != this.parent.getChildren()) {
            return;
        }
        this.snapshot = added.originalEvent.getSnapshot();
        ListIterator<VisualizerNode> listIterator = this.visNodes.listIterator();
        boolean bl = !listIterator.hasNext();
        int[] nArray = added.getArray();
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            while (n++ < nArray[i]) {
                listIterator.next();
            }
            listIterator.add(null);
        }
        boolean bl2 = this.recomputeIndexes(null);
        for (VisualizerNode visualizerNode = this.parent; visualizerNode != null; visualizerNode = (VisualizerNode)visualizerNode.getParent()) {
            Object[] objectArray = visualizerNode.getListenerList();
            for (int i = objectArray.length - 1; i >= 0; i -= 2) {
                ((NodeModel)objectArray[i]).added(added);
            }
        }
        if (bl) {
            this.parent.notifyVisualizerChildrenChange(bl2, this);
        }
    }

    public void removed(VisualizerEvent.Removed removed) {
        Object[] objectArray;
        if (this != this.parent.getChildren()) {
            return;
        }
        this.snapshot = removed.originalEvent.getSnapshot();
        int[] nArray = removed.getArray();
        if (nArray.length == 0) {
            return;
        }
        for (int i = nArray.length - 1; i >= 0; --i) {
            objectArray = this.visNodes.remove(nArray[i]);
            removed.removed.add((VisualizerNode)(objectArray != null ? objectArray : VisualizerNode.EMPTY));
        }
        this.recomputeIndexes(null);
        for (VisualizerNode visualizerNode = this.parent; visualizerNode != null; visualizerNode = (VisualizerNode)visualizerNode.getParent()) {
            objectArray = visualizerNode.getListenerList();
            for (int i = objectArray.length - 1; i >= 0; i -= 2) {
                ((NodeModel)objectArray[i]).removed(removed);
            }
        }
        if (this.visNodes.isEmpty()) {
            this.parent.notifyVisualizerChildrenChange(true, this);
        }
    }

    private int[] reorderByComparator(Comparator<VisualizerNode> comparator) {
        VisualizerNode[] visualizerNodeArray = this.visNodes.toArray(new VisualizerNode[this.visNodes.size()]);
        Arrays.sort(visualizerNodeArray, comparator);
        int[] nArray = new int[visualizerNodeArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.visNodes.indexOf(visualizerNodeArray[i]);
        }
        this.visNodes.clear();
        this.visNodes.addAll(Arrays.asList(visualizerNodeArray));
        return nArray;
    }

    public void reordered(VisualizerEvent.Reordered reordered) {
        Object[] objectArray;
        Object object;
        if (this != this.parent.getChildren()) {
            return;
        }
        if (reordered.originalEvent != null) {
            this.snapshot = reordered.originalEvent.getSnapshot();
        }
        if (reordered.getComparator() != null) {
            reordered.array = this.reorderByComparator(reordered.getComparator());
        } else {
            object = reordered.getArray();
            objectArray = this.visNodes.toArray(new VisualizerNode[this.visNodes.size()]);
            VisualizerNode[] visualizerNodeArray = new VisualizerNode[objectArray.length];
            int n = ((Object)object).length;
            try {
                for (int i = 0; i < n; ++i) {
                    Object object2 = objectArray[i];
                    Object object3 = object[i];
                    if (visualizerNodeArray[object3] != null) {
                        System.err.println("Writing to this index for the second time: " + (int)object3);
                        System.err.println("Length of indxs array: " + ((Object)object).length);
                        System.err.println("Length of actual array: " + objectArray.length);
                        System.err.println("Indices of reorder event:");
                        int n2 = 0;
                        while (i < ((Object)object).length) {
                            System.err.println("\t" + (int)object[n2]);
                            ++n2;
                        }
                        Thread.dumpStack();
                        return;
                    }
                    visualizerNodeArray[object3] = object2;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                arrayIndexOutOfBoundsException.printStackTrace();
                System.err.println("Length of actual array: " + objectArray.length);
                System.err.println("Indices of reorder event:");
                for (int i = 0; i < ((Object)object).length; ++i) {
                    System.err.println("\t" + (int)object[i]);
                }
                return;
            }
            this.visNodes.clear();
            this.visNodes.addAll(Arrays.asList(visualizerNodeArray));
        }
        this.recomputeIndexes(null);
        for (object = (Object)this.parent; object != null; object = (VisualizerNode)((VisualizerNode)object).getParent()) {
            objectArray = ((EventListenerList)object).getListenerList();
            for (int i = objectArray.length - 1; i >= 0; i -= 2) {
                ((NodeModel)objectArray[i]).reordered(reordered);
            }
        }
    }
}

