/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.ListModel;
import org.openide.explorer.view.NodeModel;
import org.openide.explorer.view.VisualizerEvent;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Mutex;

public class NodeListModel
extends AbstractListModel
implements ComboBoxModel {
    static final long serialVersionUID = -1926931095895356820L;
    private transient Listener listener;
    private transient VisualizerNode parent = VisualizerNode.EMPTY;
    private transient Object selectedObject = VisualizerNode.EMPTY;
    private transient int size;
    private int depth = 1;
    private Map<VisualizerNode, Info> childrenCount;

    public NodeListModel() {
        this.clearChildrenCount();
    }

    public NodeListModel(Node node) {
        this();
        this.setNode(node);
    }

    public void setNode(final Node node) {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                if (!Children.MUTEX.isReadAccess() && !Children.MUTEX.isWriteAccess()) {
                    Children.MUTEX.readAccess((Runnable)this);
                    return;
                }
                VisualizerNode visualizerNode = VisualizerNode.getVisualizer(null, node);
                if (visualizerNode == NodeListModel.this.parent) {
                    return;
                }
                NodeListModel.this.removeAll();
                NodeListModel.this.parent.removeNodeModel(NodeListModel.this.listener());
                NodeListModel.this.parent = visualizerNode;
                NodeListModel.this.selectedObject = visualizerNode;
                NodeListModel.this.clearChildrenCount();
                NodeListModel.this.addAll();
                NodeListModel.this.parent.addNodeModel(NodeListModel.this.listener());
            }
        });
    }

    public void setDepth(int n) {
        if (n != this.depth) {
            this.depth = n;
            this.clearChildrenCount();
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    NodeListModel.this.removeAll();
                    NodeListModel.this.addAll();
                }
            });
        }
    }

    public int getDepth() {
        return this.depth;
    }

    private Listener listener() {
        if (this.listener == null) {
            this.listener = new Listener(this);
        }
        return this.listener;
    }

    public int getSize() {
        int n = this.findSize(this.parent, -1, this.depth);
        return n;
    }

    public Object getElementAt(int n) {
        return this.findElementAt(this.parent, n, -1, this.depth);
    }

    public int getIndex(Object object) {
        this.getSize();
        Info info = this.childrenCount.get(object);
        return info == null ? -1 : info.index;
    }

    public void setSelectedItem(Object object) {
        if (this.selectedObject != object) {
            this.selectedObject = object;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    public Object getSelectedItem() {
        return this.selectedObject;
    }

    private void clearChildrenCount() {
        this.childrenCount = new HashMap<VisualizerNode, Info>(17);
    }

    private int findSize(VisualizerNode visualizerNode, int n, int n2) {
        Info info = this.childrenCount.get(visualizerNode);
        if (info != null) {
            return info.childrenCount;
        }
        int n3 = 0;
        info = new Info();
        info.depth = n2;
        info.index = n;
        if (n2-- > 0) {
            Enumeration enumeration = visualizerNode.getChildren().children();
            while (enumeration.hasMoreElements()) {
                VisualizerNode visualizerNode2 = (VisualizerNode)enumeration.nextElement();
                ++n3;
                n3 += this.findSize(visualizerNode2, n + n3, n2);
            }
        }
        info.childrenCount = n3;
        this.childrenCount.put(visualizerNode, info);
        return n3;
    }

    private VisualizerNode findElementAt(VisualizerNode visualizerNode, int n, int n2, int n3) {
        if (--n3 == 0) {
            return (VisualizerNode)visualizerNode.getChildAt(n);
        }
        Enumeration enumeration = visualizerNode.getChildren().children();
        while (enumeration.hasMoreElements()) {
            int n4;
            VisualizerNode visualizerNode2 = (VisualizerNode)enumeration.nextElement();
            if (n-- == 0) {
                return visualizerNode2;
            }
            if (n < (n4 = this.findSize(visualizerNode2, ++n2, n3))) {
                return this.findElementAt(visualizerNode2, n, n2, n3);
            }
            n -= n4;
            n2 += n4;
        }
        return visualizerNode;
    }

    static int findVisualizerDepth(ListModel listModel, VisualizerNode visualizerNode) {
        if (listModel instanceof NodeListModel) {
            NodeListModel nodeListModel = (NodeListModel)listModel;
            Info info = nodeListModel.childrenCount.get(visualizerNode);
            if (info != null) {
                return nodeListModel.depth - info.depth - 1;
            }
        }
        return 0;
    }

    final void addAll() {
        this.size = this.getSize();
        if (this.size > 0) {
            this.fireIntervalAdded(this, 0, this.size - 1);
        }
    }

    final void removeAll() {
        if (this.size > 0) {
            this.fireIntervalRemoved(this, 0, this.size - 1);
        }
    }

    final void changeAll() {
        this.size = this.getSize();
        if (this.size > 0) {
            this.fireContentsChanged(this, 0, this.size - 1);
        }
        this.clearChildrenCount();
    }

    final void added(VisualizerEvent.Added added) {
        VisualizerNode visualizerNode = added.getVisualizer();
        int[] nArray = added.getArray();
        if (this.cachedDepth(visualizerNode) <= 0 || nArray.length == 0) {
            return;
        }
        this.clearChildrenCount();
        this.size = this.getSize();
        int n = this.parent == visualizerNode ? 0 : this.getIndex(visualizerNode);
        this.fireIntervalAdded(this, nArray[0] + n, nArray[nArray.length - 1] + n);
    }

    final void removed(VisualizerEvent.Removed removed) {
        VisualizerNode visualizerNode = removed.getVisualizer();
        int[] nArray = removed.getArray();
        if (this.cachedDepth(visualizerNode) <= 0 || nArray.length == 0) {
            return;
        }
        this.clearChildrenCount();
        int n = this.parent == visualizerNode ? 0 : this.getIndex(visualizerNode);
        this.fireIntervalRemoved(this, nArray[0] + n, nArray[nArray.length - 1] + n);
    }

    final void update(VisualizerNode visualizerNode) {
        this.getSize();
        Info info = this.childrenCount.get(visualizerNode);
        if (info != null) {
            this.fireContentsChanged(this, info.index, info.index);
        }
    }

    private int cachedDepth(VisualizerNode visualizerNode) {
        this.getSize();
        Info info = this.childrenCount.get(visualizerNode);
        if (info != null) {
            return info.depth;
        }
        return -1;
    }

    private static final class Info {
        public int childrenCount;
        public int depth;
        public int index;

        Info() {
        }

        public String toString() {
            return "Info[childrenCount=" + this.childrenCount + ", depth=" + this.depth + ", index=" + this.index;
        }
    }

    private static final class Listener
    implements NodeModel {
        private Reference<NodeListModel> model;

        public Listener(NodeListModel nodeListModel) {
            this.model = new WeakReference<NodeListModel>(nodeListModel);
        }

        private NodeListModel get(VisualizerEvent visualizerEvent) {
            NodeListModel nodeListModel = this.model.get();
            if (nodeListModel == null && visualizerEvent != null) {
                visualizerEvent.getVisualizer().removeNodeModel(this);
                return null;
            }
            return nodeListModel;
        }

        public void added(VisualizerEvent.Added added) {
            NodeListModel nodeListModel = this.get(added);
            if (nodeListModel == null) {
                return;
            }
            nodeListModel.added(added);
        }

        public void removed(VisualizerEvent.Removed removed) {
            NodeListModel nodeListModel = this.get(removed);
            if (nodeListModel == null) {
                return;
            }
            nodeListModel.removed(removed);
        }

        public void reordered(VisualizerEvent.Reordered reordered) {
            NodeListModel nodeListModel = this.get(reordered);
            if (nodeListModel == null) {
                return;
            }
            nodeListModel.changeAll();
        }

        public void update(VisualizerNode visualizerNode) {
            NodeListModel nodeListModel = this.get(null);
            if (nodeListModel == null) {
                return;
            }
            nodeListModel.update(visualizerNode);
        }

        public void structuralChange(VisualizerNode visualizerNode) {
            NodeListModel nodeListModel = this.get(null);
            if (nodeListModel == null) {
                return;
            }
            nodeListModel.changeAll();
        }
    }
}

