/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormEditorSupport;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class RADComponentRenameRefactoringSupport {
    private String newName = "";
    private RADComponent component = null;

    public RADComponent getComponent() {
        return this.component;
    }

    public void setComponent(RADComponent rADComponent) {
        this.component = rADComponent;
    }

    public RADComponentRenameRefactoringSupport(String string) {
        this.newName = string;
    }

    public void doRenameRefactoring() {
        FormDataObject formDataObject = FormEditor.getFormDataObject(this.component.getFormModel());
        if (formDataObject != null) {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)formDataObject.getPrimaryFile());
            try {
                MemberVisitor memberVisitor = new MemberVisitor(null, this.component.getName());
                javaSource.runUserActionTask((Task)memberVisitor, true);
                if (memberVisitor.getHandle() == null) {
                    return;
                }
                FormEditorSupport formEditorSupport = formDataObject.getFormEditorSupport();
                if (formEditorSupport.isModified()) {
                    formEditorSupport.saveDocument();
                }
                Lookup lookup = Lookups.singleton((Object)memberVisitor.getHandle());
                RefactoringSession refactoringSession = RefactoringSession.create((String)"Change variable name");
                RenameRefactoring renameRefactoring = new RenameRefactoring(lookup);
                Problem problem = renameRefactoring.preCheck();
                if (problem != null && problem.isFatal()) {
                    Logger.getLogger("global").log(Level.WARNING, "There were problems trying to perform the refactoring.");
                }
                Problem problem2 = null;
                if (!(problem != null && problem.isFatal() || RADComponentRenameRefactoringSupport.emptyOrWhite(this.newName))) {
                    renameRefactoring.setNewName(this.newName);
                    problem2 = renameRefactoring.prepare(refactoringSession);
                }
                if (!(problem2 != null && problem2.isFatal() || RADComponentRenameRefactoringSupport.emptyOrWhite(this.newName))) {
                    refactoringSession.doRefactoring(true);
                }
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.SEVERE, iOException.getMessage(), iOException);
            }
        }
    }

    private static boolean emptyOrWhite(String string) {
        if (string == null) {
            return true;
        }
        return string.trim().length() < 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MemberVisitor
    extends TreePathScanner<Void, Void>
    implements CancellableTask<CompilationController> {
        private CompilationInfo info;
        private String member = null;
        private TreePathHandle handle = null;

        public TreePathHandle getHandle() {
            return this.handle;
        }

        public void setHandle(TreePathHandle treePathHandle) {
            this.handle = treePathHandle;
        }

        public MemberVisitor(CompilationInfo compilationInfo, String string) {
            this.info = compilationInfo;
            this.member = string;
        }

        @Override
        public Void visitClass(ClassTree classTree, Void void_) {
            List<? extends Tree> list = classTree.getMembers();
            for (Tree tree : list) {
                TreePath treePath;
                Trees trees;
                Element element;
                String string;
                if (tree.getKind() != Tree.Kind.VARIABLE || !(string = (element = (trees = this.info.getTrees()).getElement(treePath = new TreePath(this.getCurrentPath(), tree))).getSimpleName().toString()).equals(this.member)) continue;
                this.handle = TreePathHandle.create((TreePath)treePath, (CompilationInfo)this.info);
            }
            return null;
        }

        public void cancel() {
        }

        public void run(CompilationController compilationController) throws IOException {
            this.info = compilationController;
            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            this.scan(compilationController.getCompilationUnit(), null);
        }
    }
}

