/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.dirchooser;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JFileChooser;
import javax.swing.tree.DefaultMutableTreeNode;
import org.netbeans.api.project.ProjectManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public class DirectoryNode
extends DefaultMutableTreeNode {
    public static final int SINGLE_SELECTION = 0;
    public static final int DIG_IN_SELECTION = 4;
    static final FileNameComparator FILE_NAME_COMPARATOR = new FileNameComparator();
    private File directory;
    private boolean isDir;
    private boolean loaded;
    private boolean interim;
    private boolean isSelected;
    private boolean isEditable;
    private boolean expanded;

    public DirectoryNode(File file) {
        this(file, true, false, false, false);
    }

    public DirectoryNode(File file, boolean bl) {
        this(file, bl, false, false, false);
    }

    public DirectoryNode(File file, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(file, bl);
        this.directory = file;
        this.isDir = this.directory.isDirectory();
        this.isSelected = bl2;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public File getFile() {
        return this.directory;
    }

    public void setFile(File file) {
        this.setUserObject(file);
        this.directory = file;
        this.loaded = false;
    }

    public void setSelected(boolean bl) {
        this.isSelected = bl;
    }

    public boolean isLeaf() {
        return !this.isDir;
    }

    public boolean getAllowsChildren() {
        return this.isDir;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public boolean loadChildren(JFileChooser jFileChooser, boolean bl) {
        if (!this.loaded) {
            ArrayList arrayList = this.getFiles(jFileChooser);
            if (arrayList.size() == 0) {
                return false;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                File file = (File)arrayList.get(i);
                if (!jFileChooser.accept(file)) continue;
                try {
                    DirectoryNode directoryNode = new DirectoryNode(file);
                    if (!bl) break;
                    this.add(directoryNode);
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    nullPointerException.printStackTrace();
                }
            }
            if (bl || this.getChildCount() > 0) {
                this.loaded = true;
            }
        }
        return this.loaded;
    }

    private ArrayList getFiles(JFileChooser jFileChooser) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (this.directory == null || !this.directory.exists()) {
            return arrayList;
        }
        File[] fileArray = jFileChooser.getFileSystemView().getFiles(this.directory, jFileChooser.isFileHidingEnabled());
        int n = jFileChooser.getFileSelectionMode();
        if (n == 1) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file = fileArray[i];
                if (!file.isDirectory()) continue;
                arrayList.add(file);
            }
            Collections.sort(arrayList, FILE_NAME_COMPARATOR);
        } else if (n == 2 || n == 0) {
            ArrayList<File> arrayList2 = new ArrayList<File>();
            ArrayList<File> arrayList3 = new ArrayList<File>();
            for (int i = 0; i < fileArray.length; ++i) {
                File file = fileArray[i];
                if (file.isDirectory()) {
                    arrayList2.add(file);
                    continue;
                }
                arrayList3.add(file);
            }
            Collections.sort(arrayList2, FILE_NAME_COMPARATOR);
            Collections.sort(arrayList3, FILE_NAME_COMPARATOR);
            arrayList.addAll(arrayList2);
            arrayList.addAll(arrayList3);
        }
        return arrayList;
    }

    public boolean isNetBeansProject() {
        return DirectoryNode.isNetBeansProject(this.directory);
    }

    public static boolean isNetBeansProject(File file) {
        FileObject fileObject;
        boolean bl = false;
        if (file != null && (fileObject = DirectoryNode.convertToValidDir(file)) != null) {
            bl = Utilities.isUnix() && fileObject.getParent() != null && fileObject.getParent().getParent() == null ? false : ProjectManager.getDefault().isProject(fileObject);
        }
        return bl;
    }

    private static FileObject convertToValidDir(File file) {
        File file2 = new File(file.getPath());
        if (file2 == null || file2.getParent() == null) {
            return null;
        }
        if (!file2.isDirectory()) {
            return null;
        }
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file2));
        return fileObject;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileNameComparator
    implements Comparator<File> {
        private FileNameComparator() {
        }

        @Override
        public int compare(File file, File file2) {
            return String.CASE_INSENSITIVE_ORDER.compare(file.getName(), file2.getName());
        }
    }

    private class DirectoryFilter
    implements FileFilter {
        private DirectoryFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory();
        }

        public String getDescription() {
            return "Directory";
        }
    }
}

