/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser;

import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import java_cup.runtime.Symbol;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.ParseEvent;
import org.netbeans.modules.gsf.api.ParseListener;
import org.netbeans.modules.gsf.api.Parser;
import org.netbeans.modules.gsf.api.ParserFile;
import org.netbeans.modules.gsf.api.PositionManager;
import org.netbeans.modules.gsf.api.SourceFileReader;
import org.netbeans.modules.gsf.api.TranslatedSource;
import org.netbeans.modules.php.editor.parser.ASTPHP5Parser;
import org.netbeans.modules.php.editor.parser.ASTPHP5Scanner;
import org.netbeans.modules.php.editor.parser.PHP5ErrorHandler;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.PHPPositionManager;
import org.netbeans.modules.php.editor.parser.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTError;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.EmptyStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;

public class GSFPHPParser
implements Parser {
    private PositionManager positionManager = null;
    private static final Logger LOGGER = Logger.getLogger(GSFPHPParser.class.getName());

    public void parseFiles(Parser.Job job) {
        LOGGER.fine("parseFiles " + job.toString());
        ParseListener parseListener = job.listener;
        SourceFileReader sourceFileReader = job.reader;
        for (ParserFile parserFile : job.files) {
            CharSequence charSequence;
            ParseEvent parseEvent = new ParseEvent(ParseEvent.Kind.PARSE, parserFile, null);
            job.listener.started(parseEvent);
            PHPParseResult pHPParseResult = null;
            try {
                charSequence = sourceFileReader.read(parserFile);
                String string = GSFPHPParser.asString(charSequence);
                int n = sourceFileReader.getCaretOffset(parserFile);
                if (n != -1 && job.translatedSource != null) {
                    n = job.translatedSource.getAstOffset(n);
                }
                LOGGER.fine("caretOffset: " + n);
                Context context = new Context(parserFile, parseListener, string, n, job.translatedSource);
                pHPParseResult = this.parseBuffer(context, Sanitize.NONE, null);
            }
            catch (Exception exception) {
                parseListener.exception(exception);
                LOGGER.fine("Exception during parsing: " + exception);
            }
            charSequence = new ParseEvent(ParseEvent.Kind.PARSE, parserFile, pHPParseResult);
            parseListener.finished((ParseEvent)charSequence);
        }
    }

    protected PHPParseResult parseBuffer(Context context, Sanitize sanitize, PHP5ErrorHandler pHP5ErrorHandler) throws Exception {
        PHPParseResult pHPParseResult;
        boolean bl = false;
        String string = context.source;
        if (pHP5ErrorHandler == null) {
            pHP5ErrorHandler = new PHP5ErrorHandler(context, this);
        }
        if (sanitize != Sanitize.NONE && sanitize != Sanitize.NEVER) {
            boolean bl2 = this.sanitizeSource(context, sanitize, pHP5ErrorHandler);
            if (bl2) {
                assert (context.sanitizedSource != null);
                bl = true;
                string = context.sanitizedSource;
            } else {
                return this.sanitize(context, sanitize, pHP5ErrorHandler);
            }
        }
        ASTPHP5Scanner aSTPHP5Scanner = new ASTPHP5Scanner(new StringReader(string), false);
        ASTPHP5Parser aSTPHP5Parser = new ASTPHP5Parser(aSTPHP5Scanner);
        if (!bl) {
            aSTPHP5Parser.setErrorHandler(pHP5ErrorHandler);
        } else {
            aSTPHP5Parser.setErrorHandler(null);
        }
        Symbol symbol = aSTPHP5Parser.parse();
        if (symbol != null) {
            Program program = null;
            if (symbol.value instanceof Program) {
                program = (Program)symbol.value;
                List<Statement> list = program.getStatements();
                boolean bl3 = false;
                for (Statement statement : list) {
                    if (statement instanceof ASTError || statement instanceof EmptyStatement) continue;
                    bl3 = true;
                    break;
                }
                pHPParseResult = bl3 ? new PHPParseResult(this, context.getFile(), program) : this.sanitize(context, sanitize, pHP5ErrorHandler);
            } else {
                LOGGER.fine("The parser value is not a Program: " + symbol.value);
                pHPParseResult = this.sanitize(context, sanitize, pHP5ErrorHandler);
            }
            if (!bl) {
                pHP5ErrorHandler.displaySyntaxErrors(program);
            }
        } else {
            pHPParseResult = this.sanitize(context, sanitize, pHP5ErrorHandler);
        }
        return pHPParseResult;
    }

    private boolean sanitizeSource(Context context, Sanitize sanitize, PHP5ErrorHandler pHP5ErrorHandler) {
        List<PHP5ErrorHandler.SyntaxError> list;
        if (sanitize == Sanitize.SYNTAX_ERROR_CURRENT && (list = pHP5ErrorHandler.getSyntaxErrors()).size() > 0) {
            PHP5ErrorHandler.SyntaxError syntaxError = list.get(0);
            String string = context.sanitized == Sanitize.NONE ? context.source : context.sanitizedSource;
            int n = syntaxError.getCurrentToken().right;
            int n2 = syntaxError.getCurrentToken().left;
            context.sanitizedSource = string.substring(0, n2) + Utils.getSpaces(n - n2) + string.substring(n);
            context.sanitizedRange = new OffsetRange(n2, n);
            return true;
        }
        if (sanitize == Sanitize.SYNTAX_ERROR_PREVIOUS && (list = pHP5ErrorHandler.getSyntaxErrors()).size() > 0) {
            PHP5ErrorHandler.SyntaxError syntaxError = list.get(0);
            String string = context.source;
            int n = syntaxError.getPreviousToken().right;
            int n3 = syntaxError.getPreviousToken().left;
            context.sanitizedSource = string.substring(0, n3) + Utils.getSpaces(n - n3) + string.substring(n);
            context.sanitizedRange = new OffsetRange(n3, n);
            return true;
        }
        if (sanitize == Sanitize.SYNTAX_ERROR_PREVIOUS_LINE && (list = pHP5ErrorHandler.getSyntaxErrors()).size() > 0) {
            PHP5ErrorHandler.SyntaxError syntaxError = list.get(0);
            String string = context.source;
            int n = Utils.getRowEnd(string, syntaxError.getPreviousToken().right);
            int n4 = Utils.getRowStart(string, syntaxError.getPreviousToken().left);
            context.sanitizedSource = string.substring(0, n4) + Utils.getSpaces(n - n4) + string.substring(n);
            context.sanitizedRange = new OffsetRange(n4, n);
            return true;
        }
        return false;
    }

    private PHPParseResult sanitize(Context context, Sanitize sanitize, PHP5ErrorHandler pHP5ErrorHandler) throws Exception {
        switch (sanitize) {
            case NONE: {
                return this.parseBuffer(context, Sanitize.SYNTAX_ERROR_CURRENT, pHP5ErrorHandler);
            }
            case SYNTAX_ERROR_CURRENT: {
                return this.parseBuffer(context, Sanitize.SYNTAX_ERROR_PREVIOUS, pHP5ErrorHandler);
            }
            case SYNTAX_ERROR_PREVIOUS: {
                return this.parseBuffer(context, Sanitize.SYNTAX_ERROR_PREVIOUS_LINE, pHP5ErrorHandler);
            }
        }
        int n = context.getSource().length();
        Program program = new Program(0, n, Collections.EMPTY_LIST, (List<Comment>)Collections.EMPTY_LIST);
        return new PHPParseResult(this, context.getFile(), program);
    }

    private static String asString(CharSequence charSequence) {
        if (charSequence instanceof String) {
            return (String)charSequence;
        }
        return ((Object)charSequence).toString();
    }

    public PositionManager getPositionManager() {
        if (this.positionManager == null) {
            this.positionManager = new PHPPositionManager();
        }
        return this.positionManager;
    }

    public static class Context {
        private final ParserFile file;
        private final ParseListener listener;
        private int errorOffset;
        private String source;
        private String sanitizedSource;
        private OffsetRange sanitizedRange = OffsetRange.NONE;
        private String sanitizedContents;
        private int caretOffset;
        private Sanitize sanitized = Sanitize.NONE;
        private TranslatedSource translatedSource;

        public Context(ParserFile parserFile, ParseListener parseListener, String string, int n, TranslatedSource translatedSource) {
            this.file = parserFile;
            this.listener = parseListener;
            this.source = string;
            this.caretOffset = n;
            this.translatedSource = translatedSource;
        }

        public String toString() {
            return "PHPParser.Context(" + this.getFile().toString() + ")";
        }

        public OffsetRange getSanitizedRange() {
            return this.sanitizedRange;
        }

        public Sanitize getSanitized() {
            return this.sanitized;
        }

        public String getSanitizedSource() {
            return this.sanitizedSource;
        }

        public int getErrorOffset() {
            return this.errorOffset;
        }

        public ParseListener getListener() {
            return this.listener;
        }

        public ParserFile getFile() {
            return this.file;
        }

        public String getSource() {
            return this.source;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sanitize {
        NEVER,
        NONE,
        SYNTAX_ERROR_CURRENT,
        SYNTAX_ERROR_PREVIOUS,
        SYNTAX_ERROR_PREVIOUS_LINE,
        EDITED_DOT,
        ERROR_DOT,
        BLOCK_START,
        ERROR_LINE,
        EDITED_LINE,
        MISSING_END;

    }
}

