/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.nav;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.Index;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.php.editor.index.IndexedClass;
import org.netbeans.modules.php.editor.index.IndexedConstant;
import org.netbeans.modules.php.editor.index.IndexedElement;
import org.netbeans.modules.php.editor.index.IndexedFunction;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.netbeans.modules.php.editor.nav.NavUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Dispatch;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.GlobalStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.Include;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.VariableBase;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Union2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemiAttribute
extends DefaultVisitor {
    private DefinitionScope global;
    private Stack<DefinitionScope> scopes = new Stack();
    private Map<ASTNode, AttributedElement> node2Element = new HashMap<ASTNode, AttributedElement>();
    private int offset;
    private CompilationInfo info;
    private Stack<ASTNode> nodes = new Stack();
    private Collection<IndexedElement> name2ElementCache;
    private static Map<CompilationInfo, SemiAttribute> info2Attr = new WeakHashMap<CompilationInfo, SemiAttribute>();

    public SemiAttribute(CompilationInfo compilationInfo) {
        this(compilationInfo, -1);
    }

    public SemiAttribute(CompilationInfo compilationInfo, int n) {
        this.offset = n;
        this.info = compilationInfo;
        this.global = new DefinitionScope();
        this.scopes.push(this.global);
    }

    @Override
    public void scan(ASTNode aSTNode) {
        if (aSTNode == null) {
            return;
        }
        if (this.offset != -1 && this.offset <= aSTNode.getStartOffset()) {
            throw new Stop();
        }
        this.nodes.push(aSTNode);
        super.scan(aSTNode);
        this.nodes.pop();
        if (this.offset != -1 && this.offset <= aSTNode.getEndOffset()) {
            throw new Stop();
        }
    }

    @Override
    public void visit(Program program) {
        this.performEnterPass(this.global, program.getStatements());
        super.visit(program);
    }

    @Override
    public void visit(Assignment assignment) {
        VariableBase variableBase = assignment.getLeftHandSide();
        if (variableBase instanceof Variable) {
            Identifier identifier;
            ClassElement classElement;
            Object object;
            Expression expression;
            ClassType classType = null;
            Expression expression2 = assignment.getRightHandSide();
            if (expression2 instanceof ClassInstanceCreation && (expression = ((ClassInstanceCreation)(object = (ClassInstanceCreation)expression2)).getClassName().getName()) instanceof Identifier && (classElement = (ClassElement)this.lookup((identifier = (Identifier)expression).getName(), AttributedElement.Kind.CLASS)) != null) {
                classType = new ClassType(classElement);
            }
            if ((object = SemiAttribute.extractVariableName((Variable)variableBase)) != null) {
                this.node2Element.put(variableBase, this.scopes.peek().enterWrite((String)object, AttributedElement.Kind.VARIABLE, variableBase, classType));
            }
        }
        super.visit(assignment);
    }

    @Override
    public void visit(FunctionDeclaration functionDeclaration) {
        DefinitionScope definitionScope = this.scopes.peek();
        if (!this.node2Element.containsKey(functionDeclaration)) {
            String string = functionDeclaration.getFunctionName().getName();
            assert (!definitionScope.classScope);
            this.node2Element.put(functionDeclaration, this.global.enterWrite(string, AttributedElement.Kind.FUNC, functionDeclaration));
        }
        this.scopes.push(new DefinitionScope());
        if (definitionScope.classScope) {
            assert (definitionScope.thisVar != null);
            this.scopes.peek().enter(definitionScope.thisVar.name, definitionScope.thisVar.getKind(), definitionScope.thisVar);
        }
        super.visit(functionDeclaration);
        this.scopes.pop();
    }

    @Override
    public void visit(FormalParameter formalParameter) {
        String string;
        if (formalParameter.getParameterName() instanceof Variable && (string = SemiAttribute.extractVariableName((Variable)formalParameter.getParameterName())) != null) {
            this.scopes.peek().enterWrite(string, AttributedElement.Kind.VARIABLE, formalParameter);
        }
        super.visit(formalParameter);
    }

    @Override
    public void visit(Variable variable) {
        String string;
        if (!this.node2Element.containsKey(variable) && (string = SemiAttribute.extractVariableName(variable)) != null) {
            this.node2Element.put(variable, this.lookup(string, AttributedElement.Kind.VARIABLE));
        }
        super.visit(variable);
    }

    @Override
    public void visit(FunctionInvocation functionInvocation) {
        Object object;
        Expression expression = functionInvocation.getFunctionName().getName();
        String string = null;
        if (expression instanceof Identifier) {
            string = ((Identifier)expression).getName();
        }
        if (expression instanceof Variable && (object = ((Variable)expression).getName()) instanceof Identifier) {
            string = ((Identifier)object).getName();
        }
        if (string != null) {
            String string2;
            Object object2;
            object = null;
            ASTNode aSTNode = this.nodes.pop();
            ASTNode aSTNode2 = this.nodes.peek();
            this.nodes.push(aSTNode);
            if (aSTNode2 instanceof MethodInvocation) {
                object2 = this.resolveTypeSimple((MethodInvocation)aSTNode2);
                if (object2 != null) {
                    object = ((ClassElement)object2).lookup(string, AttributedElement.Kind.FUNC);
                }
            } else {
                object = this.lookup(string, AttributedElement.Kind.FUNC);
            }
            this.node2Element.put(functionInvocation, (AttributedElement)object);
            if ("define".equals(string) && functionInvocation.getParameters().size() == 2 && (object2 = functionInvocation.getParameters().get(0)) instanceof Scalar && ((Scalar)object2).getScalarType() == Scalar.Type.STRING && NavUtils.isQuoted(string2 = ((Scalar)object2).getStringValue())) {
                this.node2Element.put((ASTNode)object2, this.global.enterWrite(NavUtils.dequote(string2), AttributedElement.Kind.CONST, (ASTNode)object2));
            }
        }
        if (this.node2Element.containsKey(functionInvocation)) {
            this.scan(functionInvocation.getParameters());
        } else {
            super.visit(functionInvocation);
        }
    }

    @Override
    public void visit(ClassDeclaration classDeclaration) {
        String string = classDeclaration.getName().getName();
        ClassElement classElement = (ClassElement)this.global.enterWrite(string, AttributedElement.Kind.CLASS, classDeclaration);
        this.node2Element.put(classDeclaration, classElement);
        if (classDeclaration.getSuperClass() != null) {
            classElement.superClass = (ClassElement)this.lookup(classDeclaration.getSuperClass().getName(), AttributedElement.Kind.CLASS);
        }
        this.scopes.push(classElement.enclosedElements);
        if (classDeclaration.getBody() != null) {
            this.performEnterPass(classElement.enclosedElements, classDeclaration.getBody().getStatements());
        }
        super.visit(classDeclaration);
        this.scopes.pop();
    }

    @Override
    public void visit(ClassInstanceCreation classInstanceCreation) {
        Expression expression = classInstanceCreation.getClassName().getName();
        if (expression instanceof Identifier) {
            this.node2Element.put(classInstanceCreation, this.lookup(((Identifier)expression).getName(), AttributedElement.Kind.CLASS));
        }
        super.visit(classInstanceCreation);
    }

    @Override
    public void visit(Include include) {
        FileObject fileObject = NavUtils.resolveInclude(this.info, include);
        if (fileObject != null) {
            this.enterInclude(fileObject);
        }
        super.visit(include);
    }

    @Override
    public void visit(GlobalStatement globalStatement) {
        for (Variable variable : globalStatement.getVariables()) {
            String string = SemiAttribute.extractVariableName(variable);
            if (string == null) continue;
            this.enterGlobalVariable(string);
        }
        super.visit(globalStatement);
    }

    @Override
    public void visit(Scalar scalar) {
        if (scalar.getScalarType() == Scalar.Type.STRING && !NavUtils.isQuoted(scalar.getStringValue())) {
            AttributedElement attributedElement = this.global.lookup(scalar.getStringValue(), AttributedElement.Kind.CONST);
            this.node2Element.put(scalar, attributedElement);
        }
        super.visit(scalar);
    }

    @Override
    public void visit(FieldAccess fieldAccess) {
        this.scan(fieldAccess.getDispatcher());
        ClassElement classElement = this.resolveTypeSimple(fieldAccess);
        String string = SemiAttribute.extractVariableName(fieldAccess.getField());
        if (classElement != null && string != null) {
            AttributedElement attributedElement = classElement.lookup(string, AttributedElement.Kind.VARIABLE);
            this.node2Element.put(fieldAccess, attributedElement);
            this.node2Element.put(fieldAccess.getField(), attributedElement);
        }
        this.scan(fieldAccess.getField());
    }

    private AttributedElement enterGlobalVariable(String string) {
        AttributedElement attributedElement = this.global.lookup(string, AttributedElement.Kind.VARIABLE);
        if (attributedElement == null) {
            attributedElement = this.global.enterWrite(string, AttributedElement.Kind.VARIABLE, (ASTNode)null);
        }
        this.scopes.peek().enter(string, AttributedElement.Kind.VARIABLE, attributedElement);
        return attributedElement;
    }

    @Override
    public void visit(ArrayAccess arrayAccess) {
        String string;
        Scalar scalar;
        String string2;
        if (arrayAccess.getName() instanceof Variable && arrayAccess.getIndex() instanceof Scalar && "GLOBALS".equals(string2 = SemiAttribute.extractVariableName((Variable)arrayAccess.getName())) && (scalar = (Scalar)arrayAccess.getIndex()).getScalarType() == Scalar.Type.STRING && NavUtils.isQuoted(string = scalar.getStringValue())) {
            this.node2Element.put(arrayAccess, this.enterGlobalVariable(NavUtils.dequote(string)));
        }
        super.visit(arrayAccess);
    }

    private AttributedElement lookup(String string, AttributedElement.Kind kind) {
        AttributedElement attributedElement;
        DefinitionScope definitionScope = this.scopes.peek();
        switch (kind) {
            case FUNC: 
            case CLASS: {
                attributedElement = this.global.lookup(string, kind);
                break;
            }
            default: {
                attributedElement = definitionScope.lookup(string, kind);
            }
        }
        if (attributedElement != null) {
            return attributedElement;
        }
        switch (kind) {
            case FUNC: 
            case CLASS: {
                return this.global.enterWrite(string, kind, (ASTNode)null);
            }
        }
        return definitionScope.enterWrite(string, kind, (ASTNode)null);
    }

    public Collection<AttributedElement> getGlobalElements(AttributedElement.Kind kind) {
        return this.global.getElements(kind);
    }

    public AttributedElement getElement(ASTNode aSTNode) {
        return this.node2Element.get(aSTNode);
    }

    public static PHPParseResult xxx(CompilationInfo compilationInfo) {
        return (PHPParseResult)compilationInfo.getEmbeddedResult("text/x-php5", 0);
    }

    public void enterInclude(FileObject fileObject) {
        PHPIndex pHPIndex;
        Index index;
        if (fileObject == null) {
            return;
        }
        if (this.name2ElementCache == null) {
            index = this.info.getIndex("text/x-php5");
            pHPIndex = PHPIndex.get(index);
            this.name2ElementCache = new LinkedList<IndexedElement>();
            this.name2ElementCache.addAll(pHPIndex.getFunctions(null, "", NameKind.PREFIX));
            this.name2ElementCache.addAll(pHPIndex.getConstants(null, "", NameKind.PREFIX));
            this.name2ElementCache.addAll(pHPIndex.getClasses(null, "", NameKind.PREFIX));
        }
        index = new HashSet();
        index.add(fileObject);
        pHPIndex = this.info.getIndex("text/x-php5");
        PHPIndex pHPIndex2 = PHPIndex.get((Index)pHPIndex);
        try {
            for (String object : pHPIndex2.getAllIncludes(SemiAttribute.xxx(this.info), fileObject.getURL().getPath())) {
                index.add(FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(object))));
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        index.remove(null);
        for (IndexedElement indexedElement : this.name2ElementCache) {
            ClassElement classElement;
            if (!index.contains(indexedElement.getFileObject())) continue;
            AttributedElement.Kind kind = null;
            if (indexedElement instanceof IndexedFunction) {
                kind = AttributedElement.Kind.FUNC;
            }
            if (indexedElement instanceof IndexedConstant) {
                kind = AttributedElement.Kind.CONST;
            }
            if (indexedElement instanceof IndexedClass && !(classElement = (ClassElement)this.global.enterWrite(indexedElement.getName(), AttributedElement.Kind.CLASS, indexedElement)).isInitialized()) {
                for (IndexedFunction indexedFunction : pHPIndex2.getAllMethods(null, indexedElement.getName(), "", NameKind.PREFIX, -1)) {
                    classElement.enclosedElements.enterWrite(indexedFunction.getName(), AttributedElement.Kind.FUNC, indexedFunction);
                }
                for (IndexedConstant indexedConstant : pHPIndex2.getAllProperties(null, indexedElement.getName(), "", NameKind.PREFIX, -1)) {
                    classElement.enclosedElements.enterWrite(indexedConstant.getName(), AttributedElement.Kind.CONST, indexedConstant);
                }
                classElement.initialized();
            }
            if (kind == null) continue;
            this.global.enterWrite(indexedElement.getName(), kind, indexedElement);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void performEnterPass(DefinitionScope definitionScope, Collection<? extends ASTNode> collection) {
        for (ASTNode aSTNode : collection) {
            void aSTNode2;
            if (aSTNode instanceof MethodDeclaration) {
                FunctionDeclaration functionDeclaration = ((MethodDeclaration)aSTNode).getFunction();
            }
            if (aSTNode2 instanceof FunctionDeclaration) {
                String string = ((FunctionDeclaration)aSTNode2).getFunctionName().getName();
                this.node2Element.put((ASTNode)aSTNode2, definitionScope.enterWrite(string, AttributedElement.Kind.FUNC, (ASTNode)aSTNode2));
            }
            if (!(aSTNode2 instanceof FieldsDeclaration)) continue;
            for (SingleFieldDeclaration singleFieldDeclaration : ((FieldsDeclaration)aSTNode2).getFields()) {
                String string = SemiAttribute.extractVariableName(singleFieldDeclaration.getName());
                if (string == null) continue;
                this.node2Element.put((ASTNode)aSTNode2, definitionScope.enterWrite(string, AttributedElement.Kind.VARIABLE, (ASTNode)aSTNode2));
            }
        }
    }

    public static SemiAttribute semiAttribute(CompilationInfo compilationInfo) {
        SemiAttribute semiAttribute = info2Attr.get(compilationInfo);
        if (semiAttribute == null) {
            long l = System.currentTimeMillis();
            semiAttribute = new SemiAttribute(compilationInfo);
            semiAttribute.scan(Utils.getRoot(compilationInfo));
            semiAttribute.info = null;
            info2Attr.put(compilationInfo, semiAttribute);
            long l2 = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "SemiAttribute global instance", new Object[]{compilationInfo.getFileObject(), semiAttribute});
            Logger.getLogger("TIMER").log(Level.FINE, "SemiAttribute global time", new Object[]{compilationInfo.getFileObject(), l2 - l});
        }
        return semiAttribute;
    }

    public static SemiAttribute semiAttribute(CompilationInfo compilationInfo, int n) {
        SemiAttribute semiAttribute = new SemiAttribute(compilationInfo, n);
        try {
            semiAttribute.scan(Utils.getRoot(compilationInfo));
        }
        catch (Stop stop) {
            // empty catch block
        }
        return semiAttribute;
    }

    private static String name(ASTNode aSTNode) {
        if (aSTNode instanceof Identifier) {
            return ((Identifier)aSTNode).getName();
        }
        return null;
    }

    public static String extractVariableName(Variable variable) {
        if (variable.getName() instanceof Identifier) {
            Identifier identifier = (Identifier)variable.getName();
            return identifier.getName();
        }
        return null;
    }

    private ClassElement resolveTypeSimple(Dispatch dispatch) {
        AttributedType attributedType;
        ClassElement classElement = null;
        AttributedElement attributedElement = this.node2Element.get(dispatch.getDispatcher());
        if (attributedElement != null && (attributedType = (AttributedType)attributedElement.writesTypes.get(attributedElement.getWrites().size() - 1)) instanceof ClassType) {
            classElement = ((ClassType)attributedType).getElement();
        }
        return classElement;
    }

    public static class ClassType
    extends AttributedType {
        private ClassElement element;

        public ClassType(ClassElement classElement) {
            this.element = classElement;
        }

        public ClassElement getElement() {
            return this.element;
        }

        public String getTypeName() {
            return this.getElement().getName();
        }
    }

    public static abstract class AttributedType {
        public abstract String getTypeName();
    }

    private static final class Stop
    extends Error {
        private Stop() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefinitionScope {
        private final Map<AttributedElement.Kind, Map<String, AttributedElement>> name2Writes = new HashMap<AttributedElement.Kind, Map<String, AttributedElement>>();
        private boolean classScope;
        private AttributedElement thisVar;

        public DefinitionScope() {
            this(null);
        }

        public DefinitionScope(ClassElement classElement) {
            boolean bl = this.classScope = classElement != null;
            if (this.classScope) {
                this.thisVar = this.enterWrite("this", AttributedElement.Kind.VARIABLE, (ASTNode)null, (AttributedType)new ClassType(classElement));
            }
        }

        public AttributedElement enterWrite(String string, AttributedElement.Kind kind, ASTNode aSTNode) {
            return this.enterWrite(string, kind, aSTNode, null);
        }

        public AttributedElement enterWrite(String string, AttributedElement.Kind kind, ASTNode aSTNode, AttributedType attributedType) {
            return this.enterWrite(string, kind, (Union2<ASTNode, IndexedElement>)Union2.createFirst((Object)aSTNode), attributedType);
        }

        public AttributedElement enterWrite(String string, AttributedElement.Kind kind, IndexedElement indexedElement) {
            return this.enterWrite(string, kind, (Union2<ASTNode, IndexedElement>)Union2.createSecond((Object)indexedElement), null);
        }

        public AttributedElement enterWrite(String string, AttributedElement.Kind kind, Union2<ASTNode, IndexedElement> union2, AttributedType attributedType) {
            AttributedElement attributedElement;
            Map<String, AttributedElement> map = this.name2Writes.get((Object)kind);
            if (map == null) {
                map = new HashMap<String, AttributedElement>();
                this.name2Writes.put(kind, map);
            }
            if ((attributedElement = map.get(string)) == null) {
                attributedElement = kind == AttributedElement.Kind.CLASS ? new ClassElement(union2, string, kind) : new AttributedElement(union2, string, kind, attributedType);
                map.put(string, attributedElement);
            } else {
                attributedElement.addWrite(union2, attributedType);
            }
            return attributedElement;
        }

        public AttributedElement enter(String string, AttributedElement.Kind kind, AttributedElement attributedElement) {
            Map<String, AttributedElement> map = this.name2Writes.get((Object)kind);
            if (map == null) {
                map = new HashMap<String, AttributedElement>();
                this.name2Writes.put(kind, map);
            }
            map.put(string, attributedElement);
            return attributedElement;
        }

        public AttributedElement lookup(String string, AttributedElement.Kind kind) {
            Map<String, AttributedElement> map = this.name2Writes.get((Object)kind);
            if (map == null) {
                return null;
            }
            return map.get(string);
        }

        public Collection<AttributedElement> getElements(AttributedElement.Kind kind) {
            Map<String, AttributedElement> map = this.name2Writes.get((Object)kind);
            if (map != null) {
                return Collections.unmodifiableCollection(map.values());
            }
            return Collections.emptyList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassElement
    extends AttributedElement {
        private final DefinitionScope enclosedElements = new DefinitionScope(this);
        private ClassElement superClass;
        private boolean initialized;

        public ClassElement(Union2<ASTNode, IndexedElement> union2, String string, AttributedElement.Kind kind) {
            super(union2, string, kind);
        }

        public AttributedElement lookup(String string, AttributedElement.Kind kind) {
            AttributedElement attributedElement = this.enclosedElements.lookup(string, kind);
            if (attributedElement != null) {
                return attributedElement;
            }
            if (this.superClass != null) {
                return this.superClass.lookup(string, kind);
            }
            return null;
        }

        public Collection<AttributedElement> getElements(AttributedElement.Kind kind) {
            ArrayList<AttributedElement> arrayList = new ArrayList<AttributedElement>();
            this.getElements0(arrayList, kind);
            return Collections.unmodifiableList(arrayList);
        }

        private void getElements0(List<AttributedElement> list, AttributedElement.Kind kind) {
            list.addAll(this.enclosedElements.getElements(kind));
            if (this.superClass != null) {
                this.superClass.getElements0(list, kind);
            }
        }

        boolean isInitialized() {
            return this.initialized;
        }

        void initialized() {
            this.initialized = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AttributedElement {
        private List<Union2<ASTNode, IndexedElement>> writes = new LinkedList<Union2<ASTNode, IndexedElement>>();
        private List<AttributedType> writesTypes = new LinkedList<AttributedType>();
        private String name;
        private Kind k;

        public AttributedElement(Union2<ASTNode, IndexedElement> union2, String string, Kind kind) {
            this(union2, string, kind, null);
        }

        public AttributedElement(Union2<ASTNode, IndexedElement> union2, String string, Kind kind, AttributedType attributedType) {
            this.writes.add(union2);
            this.writesTypes.add(attributedType);
            this.name = string;
            this.k = kind;
        }

        public List<Union2<ASTNode, IndexedElement>> getWrites() {
            return this.writes;
        }

        public Kind getKind() {
            return this.k;
        }

        public String getName() {
            return this.name;
        }

        void addWrite(Union2<ASTNode, IndexedElement> union2, AttributedType attributedType) {
            this.writes.add(union2);
            this.writesTypes.add(attributedType);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Kind {
            VARIABLE,
            FUNC,
            CLASS,
            CONST;

        }
    }
}

