/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.index;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.gsf.api.IndexDocument;
import org.netbeans.modules.gsf.api.IndexDocumentFactory;
import org.netbeans.modules.gsf.api.Indexer;
import org.netbeans.modules.gsf.api.ParserFile;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.ExpressionStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.Include;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocBlock;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTag;
import org.netbeans.modules.php.editor.parser.astnodes.ParenthesisExpression;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPIndexer
implements Indexer {
    static final boolean PREINDEXING = Boolean.getBoolean("gsf.preindexing");
    private static final FileSystem MEM_FS = FileUtil.createMemoryFileSystem();
    private static final Map<String, FileObject> EXT2FO = new HashMap<String, FileObject>();
    private static final Collection<String> INDEXABLE_EXTENSIONS = Arrays.asList("php", "php3", "php4", "php5", "phtml", "inc");
    static final String FIELD_BASE = "base";
    static final String FIELD_EXTEND = "extend";
    static final String FIELD_CLASS = "clz";
    static final String FIELD_IFACE = "iface";
    static final String FIELD_CONST = "const";
    static final String FIELD_CLASS_CONST = "clz.const";
    static final String FIELD_FIELD = "field";
    static final String FIELD_METHOD = "method";
    static final String FIELD_INCLUDE = "include";
    static final String FIELD_IDENTIFIER = "identifier";
    static final String FIELD_VAR = "var";
    private static FileObject preindexedDb;

    public boolean isIndexable(ParserFile parserFile) {
        if (INDEXABLE_EXTENSIONS.contains(parserFile.getExtension().toLowerCase())) {
            return true;
        }
        return this.isPhpFile(parserFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPhpFile(ParserFile parserFile) {
        FileObject fileObject = null;
        String string = parserFile.getExtension();
        Map<String, FileObject> map = EXT2FO;
        synchronized (map) {
            FileObject fileObject2 = fileObject = string != null ? EXT2FO.get(string) : null;
            if (fileObject == null) {
                try {
                    fileObject = FileUtil.createData((FileObject)MEM_FS.getRoot(), (String)parserFile.getNameExt());
                    if (string != null && fileObject != null) {
                        EXT2FO.put(string, fileObject);
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        assert (fileObject != null);
        return "text/x-php5".equals(fileObject.getMIMEType());
    }

    public String getPersistentUrl(File file) {
        try {
            String string = file.toURI().toURL().toExternalForm();
            return PHPIndex.getPreindexUrl(string);
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
            return file.getPath();
        }
    }

    public List<IndexDocument> index(ParserResult parserResult, IndexDocumentFactory indexDocumentFactory) throws IOException {
        PHPParseResult pHPParseResult = (PHPParseResult)parserResult;
        if (pHPParseResult.getProgram() == null) {
            return Collections.emptyList();
        }
        TreeAnalyzer treeAnalyzer = new TreeAnalyzer(pHPParseResult, indexDocumentFactory);
        treeAnalyzer.analyze();
        return treeAnalyzer.getDocuments();
    }

    public String getIndexVersion() {
        return "0.4.8";
    }

    public String getIndexerName() {
        return "php";
    }

    public File getPreindexedData() {
        return null;
    }

    public static void setPreindexedDb(FileObject fileObject) {
        preindexedDb = fileObject;
    }

    public FileObject getPreindexedDb() {
        return null;
    }

    public boolean acceptQueryPath(String string) {
        return string.indexOf("jsstubs") == -1 && string.indexOf("/ruby2/") == -1 && string.indexOf("/gems/") == -1 && string.indexOf("lib/ruby/") == -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TreeAnalyzer {
        private final ParserFile file;
        private String url;
        private final PHPParseResult result;
        private Program root;
        private IndexDocumentFactory factory;
        private List<IndexDocument> documents = new ArrayList<IndexDocument>();

        private TreeAnalyzer(PHPParseResult pHPParseResult, IndexDocumentFactory indexDocumentFactory) {
            this.result = pHPParseResult;
            this.file = pHPParseResult.getFile();
            this.factory = indexDocumentFactory;
            try {
                this.url = this.file.getFile().toURI().toURL().toExternalForm();
                this.url = PHPIndex.getPreindexUrl(this.url);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }

        List<IndexDocument> getDocuments() {
            return this.documents;
        }

        public void analyze() throws IOException {
            IndexDocument indexDocument = this.factory.createDocument(40);
            this.documents.add(indexDocument);
            this.root = this.result.getProgram();
            String string = null;
            try {
                string = this.result.getFile().getFileObject().getURL().toExternalForm();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
            assert (string.startsWith("file:"));
            String string2 = string.substring("file:".length());
            StringBuilder stringBuilder = new StringBuilder();
            for (Statement object2 : this.root.getStatements()) {
                ExpressionStatement expressionStatement;
                if (object2 instanceof FunctionDeclaration) {
                    this.indexFunction((FunctionDeclaration)object2, indexDocument);
                    continue;
                }
                if (object2 instanceof ExpressionStatement) {
                    Expression expression;
                    expressionStatement = (ExpressionStatement)object2;
                    if (expressionStatement.getExpression() instanceof Assignment) {
                        expression = (Assignment)expressionStatement.getExpression();
                        this.indexVarsInAssignment((Assignment)expression, indexDocument);
                    }
                    if (expressionStatement.getExpression() instanceof Include) {
                        Expression expression2;
                        expression = (Include)expressionStatement.getExpression();
                        Expression expression3 = ((Include)expression).getExpression();
                        if (expression3 instanceof ParenthesisExpression) {
                            expression2 = (ParenthesisExpression)((Include)expression).getExpression();
                            expression3 = ((ParenthesisExpression)expression2).getExpression();
                        }
                        if (expression3 instanceof Scalar) {
                            expression2 = (Scalar)expression3;
                            String string3 = ((Scalar)expression2).getStringValue();
                            String string4 = PHPIndex.resolveRelativeURL(string2, PHPIndex.dequote(string3));
                            stringBuilder.append(string4 + ";");
                        }
                    }
                    this.indexConstant(object2, indexDocument);
                    continue;
                }
                if (object2 instanceof ClassDeclaration) {
                    expressionStatement = this.factory.createDocument(10);
                    this.documents.add((IndexDocument)expressionStatement);
                    this.indexClass((ClassDeclaration)object2, (IndexDocument)expressionStatement);
                    continue;
                }
                if (!(object2 instanceof InterfaceDeclaration)) continue;
                expressionStatement = this.factory.createDocument(10);
                this.documents.add((IndexDocument)expressionStatement);
                this.indexInterface((InterfaceDeclaration)object2, (IndexDocument)expressionStatement);
            }
            indexDocument.addPair(PHPIndexer.FIELD_INCLUDE, stringBuilder.toString(), false);
            final IndexDocument indexDocument2 = this.factory.createDocument(10);
            this.documents.add(indexDocument2);
            DefaultVisitor defaultVisitor = new DefaultVisitor(){

                public void visit(Identifier identifier) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(identifier.getName().toLowerCase() + ";");
                    stringBuilder.append(identifier.getName() + ";");
                    stringBuilder.append(identifier.getStartOffset() + ";");
                    indexDocument2.addPair(PHPIndexer.FIELD_IDENTIFIER, stringBuilder.toString(), true);
                    super.visit(identifier);
                }
            };
            defaultVisitor.scan(this.root);
        }

        private void indexClass(ClassDeclaration classDeclaration, IndexDocument indexDocument) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(classDeclaration.getName().getName().toLowerCase() + ";");
            stringBuilder.append(classDeclaration.getName().getName() + ";");
            stringBuilder.append(classDeclaration.getStartOffset() + ";");
            String string = "";
            if (classDeclaration.getSuperClass() instanceof Identifier) {
                Identifier identifier = classDeclaration.getSuperClass();
                string = identifier.getName();
            }
            stringBuilder.append(string + ";");
            indexDocument.addPair(PHPIndexer.FIELD_CLASS, stringBuilder.toString(), true);
            for (Statement statement : classDeclaration.getBody().getStatements()) {
                Object object;
                Statement statement2;
                if (statement instanceof MethodDeclaration) {
                    statement2 = (MethodDeclaration)statement;
                    this.indexMethod(((MethodDeclaration)statement2).getFunction(), ((BodyDeclaration)statement2).getModifier(), indexDocument);
                    continue;
                }
                if (statement instanceof FieldsDeclaration) {
                    statement2 = (FieldsDeclaration)statement;
                    for (SingleFieldDeclaration singleFieldDeclaration : ((FieldsDeclaration)statement2).getFields()) {
                        if (!(singleFieldDeclaration.getName().getName() instanceof Identifier)) continue;
                        object = (Identifier)singleFieldDeclaration.getName().getName();
                        StringBuilder stringBuilder2 = new StringBuilder();
                        stringBuilder2.append(((Identifier)object).getName() + ";");
                        stringBuilder2.append(singleFieldDeclaration.getStartOffset() + ";");
                        stringBuilder2.append(((BodyDeclaration)statement2).getModifier() + ";");
                        indexDocument.addPair(PHPIndexer.FIELD_FIELD, stringBuilder2.toString(), false);
                    }
                    continue;
                }
                if (!(statement instanceof ClassConstantDeclaration)) continue;
                statement2 = (ClassConstantDeclaration)statement;
                for (Identifier identifier : ((ClassConstantDeclaration)statement2).getNames()) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append(identifier.getName() + ";");
                    ((StringBuilder)object).append(statement2.getStartOffset() + ";");
                    indexDocument.addPair(PHPIndexer.FIELD_CLASS_CONST, ((StringBuilder)object).toString(), false);
                }
            }
        }

        private void indexInterface(InterfaceDeclaration interfaceDeclaration, IndexDocument indexDocument) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(interfaceDeclaration.getName().getName().toLowerCase() + ";");
            stringBuilder.append(interfaceDeclaration.getName().getName() + ";");
            stringBuilder.append(interfaceDeclaration.getStartOffset() + ";");
            Iterator<ASTNode> iterator = interfaceDeclaration.getInterfaes().iterator();
            while (iterator.hasNext()) {
                Identifier aSTNode = iterator.next();
                stringBuilder.append(aSTNode.getName());
                if (!iterator.hasNext()) continue;
                stringBuilder.append(',');
            }
            stringBuilder.append(';');
            indexDocument.addPair(PHPIndexer.FIELD_IFACE, stringBuilder.toString(), true);
            for (Statement statement : interfaceDeclaration.getBody().getStatements()) {
                Object object;
                Statement statement2;
                if (statement instanceof MethodDeclaration) {
                    statement2 = (MethodDeclaration)statement;
                    this.indexMethod(((MethodDeclaration)statement2).getFunction(), ((BodyDeclaration)statement2).getModifier(), indexDocument);
                    continue;
                }
                if (statement instanceof FieldsDeclaration) {
                    statement2 = (FieldsDeclaration)statement;
                    for (SingleFieldDeclaration singleFieldDeclaration : ((FieldsDeclaration)statement2).getFields()) {
                        if (!(singleFieldDeclaration.getName().getName() instanceof Identifier)) continue;
                        object = (Identifier)singleFieldDeclaration.getName().getName();
                        StringBuilder stringBuilder2 = new StringBuilder();
                        stringBuilder2.append(((Identifier)object).getName() + ";");
                        stringBuilder2.append(singleFieldDeclaration.getStartOffset() + ";");
                        stringBuilder2.append(((BodyDeclaration)statement2).getModifier() + ";");
                        indexDocument.addPair(PHPIndexer.FIELD_FIELD, stringBuilder2.toString(), false);
                    }
                    continue;
                }
                if (!(statement instanceof ClassConstantDeclaration)) continue;
                statement2 = (ClassConstantDeclaration)statement;
                for (Identifier identifier : ((ClassConstantDeclaration)statement2).getNames()) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append(identifier.getName() + ";");
                    ((StringBuilder)object).append(statement2.getStartOffset() + ";");
                    indexDocument.addPair(PHPIndexer.FIELD_CLASS_CONST, ((StringBuilder)object).toString(), false);
                }
            }
        }

        private void indexVarsInAssignment(Assignment assignment, IndexDocument indexDocument) {
            Expression expression;
            if (assignment.getLeftHandSide() instanceof Variable) {
                expression = (Variable)assignment.getLeftHandSide();
                String string = CodeUtils.extractVariableTypeFromAssignment(assignment);
                String string2 = CodeUtils.extractVariableName((Variable)expression);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string2.toLowerCase() + ";" + string2 + ";");
                if (string != null) {
                    stringBuilder.append(string);
                }
                stringBuilder.append(";");
                stringBuilder.append(expression.getStartOffset() + ";");
                indexDocument.addPair(PHPIndexer.FIELD_VAR, stringBuilder.toString(), true);
            }
            if (assignment.getRightHandSide() instanceof Assignment) {
                expression = (Assignment)assignment.getRightHandSide();
                this.indexVarsInAssignment((Assignment)expression, indexDocument);
            }
        }

        private void indexConstant(Statement statement, IndexDocument indexDocument) {
            String string;
            char c;
            Expression expression;
            Identifier identifier;
            FunctionInvocation functionInvocation;
            ExpressionStatement expressionStatement = (ExpressionStatement)statement;
            Expression expression2 = expressionStatement.getExpression();
            if (expression2 instanceof FunctionInvocation && (functionInvocation = (FunctionInvocation)expression2).getFunctionName().getName() instanceof Identifier && "define".equals((identifier = (Identifier)functionInvocation.getFunctionName().getName()).getName()) && functionInvocation.getParameters().size() >= 2 && (expression = functionInvocation.getParameters().get(0)) instanceof Scalar && ((c = (string = ((Scalar)expression).getStringValue()).charAt(0)) == string.charAt(string.length() - 1) && c == '\'' || c == '\"')) {
                String string2 = PHPIndex.dequote(string);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string2.toLowerCase());
                stringBuilder.append(';');
                stringBuilder.append(string2);
                stringBuilder.append(';');
                stringBuilder.append(functionInvocation.getStartOffset());
                stringBuilder.append(';');
                indexDocument.addPair(PHPIndexer.FIELD_CONST, stringBuilder.toString(), true);
            }
        }

        private void indexFunction(FunctionDeclaration functionDeclaration, IndexDocument indexDocument) {
            StringBuilder stringBuilder = new StringBuilder(functionDeclaration.getFunctionName().getName().toLowerCase() + ";");
            stringBuilder.append(this.getBaseSignatureForFunctionDeclaration(functionDeclaration));
            indexDocument.addPair(PHPIndexer.FIELD_BASE, stringBuilder.toString(), true);
        }

        private void indexMethod(FunctionDeclaration functionDeclaration, int n, IndexDocument indexDocument) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getBaseSignatureForFunctionDeclaration(functionDeclaration));
            stringBuilder.append(n + ";");
            indexDocument.addPair(PHPIndexer.FIELD_METHOD, stringBuilder.toString(), false);
        }

        private String getBaseSignatureForFunctionDeclaration(FunctionDeclaration functionDeclaration) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(functionDeclaration.getFunctionName().getName() + ";");
            StringBuilder stringBuilder2 = new StringBuilder();
            int n = functionDeclaration.getFormalParameters().size();
            for (int i = 0; i < n; ++i) {
                FormalParameter formalParameter = functionDeclaration.getFormalParameters().get(i);
                String string = CodeUtils.getParamDisplayName(formalParameter);
                stringBuilder.append(string);
                if (i < n - 1) {
                    stringBuilder.append(",");
                }
                if (formalParameter.getDefaultValue() == null) continue;
                if (stringBuilder2.length() > 0) {
                    stringBuilder2.append(',');
                }
                stringBuilder2.append(Integer.toString(i));
            }
            stringBuilder.append(';');
            stringBuilder.append(functionDeclaration.getStartOffset() + ";");
            stringBuilder.append(stringBuilder2 + ";");
            String string = this.getTypeFromComment(functionDeclaration);
            if (string != null && !"mixed".equalsIgnoreCase(string)) {
                stringBuilder.append(string);
            }
            stringBuilder.append(";");
            return stringBuilder.toString();
        }

        private String getTypeFromComment(FunctionDeclaration functionDeclaration) {
            Comment comment = Utils.getCommentForNode(this.root, functionDeclaration);
            if (comment instanceof PHPDocBlock) {
                PHPDocBlock pHPDocBlock = (PHPDocBlock)comment;
                for (PHPDocTag pHPDocTag : pHPDocBlock.getTags()) {
                    if (pHPDocTag.getKind() != PHPDocTag.Type.RETURN) continue;
                    String[] stringArray = pHPDocTag.getValue().split("\\s+", 2);
                    if (stringArray.length <= 0) break;
                    String string = stringArray[0];
                    return string;
                }
            }
            return null;
        }
    }
}

