/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.index;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.Index;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.php.editor.index.IndexedClass;
import org.netbeans.modules.php.editor.index.IndexedConstant;
import org.netbeans.modules.php.editor.index.IndexedElement;
import org.netbeans.modules.php.editor.index.IndexedFunction;
import org.netbeans.modules.php.editor.index.IndexedInterface;
import org.netbeans.modules.php.editor.index.Signature;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPIndex {
    public static final int ANY_ATTR = -1;
    private static String clusterUrl = null;
    private static final String CLUSTER_URL = "cluster:";
    static final Set<Index.SearchScope> ALL_SCOPE = EnumSet.allOf(Index.SearchScope.class);
    static final Set<Index.SearchScope> SOURCE_SCOPE = EnumSet.of(Index.SearchScope.SOURCE);
    private static final Set<String> TERMS_BASE = Collections.singleton("base");
    private static final Set<String> TERMS_CONST = Collections.singleton("const");
    private final Index index;
    private WeakHashMap<PHPParseResult, HashMap<String, Collection<String>>> includesCache = new WeakHashMap();
    private WeakHashMap<PHPParseResult, HashMap<String, Boolean>> isReachableCache = new WeakHashMap();
    private WeakHashMap<PHPParseResult, HashMap<String, Boolean>> isSystemFileCache = new WeakHashMap();

    public PHPIndex(Index index) {
        this.index = index;
    }

    public static PHPIndex get(Index index) {
        return new PHPIndex(index);
    }

    private boolean search(String string, String string2, NameKind nameKind, Set<Index.SearchResult> set, Set<Index.SearchScope> set2, Set<String> set3) {
        try {
            this.index.search(string, string2, nameKind, set2, set, set3);
            return true;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return false;
        }
    }

    public static void setClusterUrl(String string) {
        clusterUrl = string;
    }

    static String getPreindexUrl(String string) {
        String string2 = PHPIndex.getClusterUrl();
        if (string.startsWith(string2)) {
            return CLUSTER_URL + string.substring(string2.length());
        }
        return string;
    }

    public static FileObject getFileObject(String string) {
        try {
            if (string.startsWith(CLUSTER_URL)) {
                string = PHPIndex.getClusterUrl() + string.substring(CLUSTER_URL.length());
            }
            URL uRL = new URL(string);
            return URLMapper.findFileObject((URL)uRL);
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
            return null;
        }
    }

    static String getClusterUrl() {
        if (clusterUrl == null) {
            File file = InstalledFileLocator.getDefault().locate("modules/org-netbeans-modules-javascript-editing.jar", null, false);
            if (file == null) {
                throw new RuntimeException("Can't find cluster");
            }
            file = new File(file.getParentFile().getParentFile().getAbsolutePath());
            try {
                file = file.getCanonicalFile();
                clusterUrl = file.toURI().toURL().toExternalForm();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return clusterUrl;
    }

    public Collection<IndexedConstant> getAllClassConstants(PHPParseResult pHPParseResult, String string, String string2, NameKind nameKind) {
        Object object;
        Object object2;
        ArrayList<IndexedConstant> arrayList = new ArrayList<IndexedConstant>();
        List<IndexedClass> list = this.getClassInheritanceLine(pHPParseResult, string);
        if (list != null) {
            object2 = list.iterator();
            while (object2.hasNext()) {
                object = (IndexedClass)object2.next();
                arrayList.addAll(this.getClassConstants(pHPParseResult, ((IndexedElement)object).getName(), string2, nameKind));
            }
        }
        if ((object2 = this.getInterfaceTree(pHPParseResult, string)) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                IndexedInterface indexedInterface = (IndexedInterface)object.next();
                arrayList.addAll(this.getClassConstants(pHPParseResult, indexedInterface.getName(), string2, nameKind));
            }
        }
        return arrayList;
    }

    public Collection<IndexedFunction> getAllMethods(PHPParseResult pHPParseResult, String string, String string2, NameKind nameKind, int n) {
        Object object;
        Object object2;
        ArrayList<IndexedFunction> arrayList = new ArrayList<IndexedFunction>();
        List<IndexedClass> list = this.getClassInheritanceLine(pHPParseResult, string);
        if (list != null) {
            object2 = list.iterator();
            while (object2.hasNext()) {
                object = (IndexedClass)object2.next();
                int n2 = list.get(0) == object ? n : n & 0xFFFFFFFD;
                arrayList.addAll(this.getMethods(pHPParseResult, ((IndexedElement)object).getName(), string2, nameKind, n2));
            }
        }
        if ((object2 = this.getInterfaceTree(pHPParseResult, string)) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                IndexedInterface indexedInterface = (IndexedInterface)object.next();
                arrayList.addAll(this.getMethods(pHPParseResult, indexedInterface.getName(), string2, nameKind, n));
            }
        }
        return arrayList;
    }

    public Collection<IndexedConstant> getAllProperties(PHPParseResult pHPParseResult, String string, String string2, NameKind nameKind, int n) {
        ArrayList<IndexedConstant> arrayList = new ArrayList<IndexedConstant>();
        List<IndexedClass> list = this.getClassInheritanceLine(pHPParseResult, string);
        if (list != null) {
            for (IndexedClass indexedClass : list) {
                int n2 = list.get(0) == indexedClass ? n : n & 0xFFFFFFFD;
                arrayList.addAll(this.getProperties(pHPParseResult, indexedClass.getName(), string2, NameKind.PREFIX, n2));
            }
        }
        return arrayList;
    }

    public List<IndexedClass> getClassInheritanceLine(PHPParseResult pHPParseResult, String string) {
        LinkedList<IndexedClass> linkedList = new LinkedList<IndexedClass>();
        TreeSet<String> treeSet = new TreeSet<String>();
        while (string != null && string.length() > 0 && !treeSet.contains(string)) {
            treeSet.add(string);
            Collection<IndexedClass> collection = this.getClasses(pHPParseResult, string, NameKind.EXACT_NAME);
            if (collection == null || collection.size() == 0) break;
            IndexedClass indexedClass = collection.toArray(new IndexedClass[collection.size()])[0];
            linkedList.add(indexedClass);
            string = indexedClass.getSuperClass();
        }
        return linkedList;
    }

    public Collection<IndexedConstant> getClassConstants(PHPParseResult pHPParseResult, String string, String string2, NameKind nameKind) {
        ArrayList<IndexedConstant> arrayList = new ArrayList<IndexedConstant>();
        Map<String, String> map = this.getTypeSpecificSignatures(string, "clz.const", string2, nameKind);
        for (String string3 : map.keySet()) {
            Signature signature = Signature.get(string3);
            String string4 = signature.string(0);
            int n = signature.integer(1);
            IndexedConstant indexedConstant = new IndexedConstant(string4, string, this, map.get(string3), n, n, null);
            arrayList.add(indexedConstant);
        }
        return arrayList;
    }

    public Collection<IndexedFunction> getMethods(PHPParseResult pHPParseResult, String string, String string2, NameKind nameKind, int n) {
        ArrayList<IndexedFunction> arrayList = new ArrayList<IndexedFunction>();
        Map<String, String> map = this.getTypeSpecificSignatures(string, "method", string2, nameKind);
        for (String string3 : map.keySet()) {
            Signature signature = Signature.get(string3);
            int n2 = signature.integer(5);
            if ((n2 & 7) == 0) {
                n2 |= 1;
            }
            if ((n2 & n) == 0) continue;
            String string4 = signature.string(0);
            String string5 = signature.string(1);
            int n3 = signature.integer(2);
            IndexedFunction indexedFunction = new IndexedFunction(string4, string, this, map.get(string3), string5, n3, n2, ElementKind.METHOD);
            int[] nArray = this.extractOptionalArgs(signature.string(3));
            indexedFunction.setOptionalArgs(nArray);
            indexedFunction.setReturnType(signature.string(4));
            arrayList.add(indexedFunction);
        }
        return arrayList;
    }

    public Collection<IndexedConstant> getProperties(PHPParseResult pHPParseResult, String string, String string2, NameKind nameKind, int n) {
        ArrayList<IndexedConstant> arrayList = new ArrayList<IndexedConstant>();
        Map<String, String> map = this.getTypeSpecificSignatures(string, "field", string2, nameKind);
        for (String string3 : map.keySet()) {
            Signature signature = Signature.get(string3);
            int n2 = signature.integer(2);
            if ((n2 & 7) == 0) {
                n2 |= 1;
            }
            if ((n2 & n) == 0) continue;
            String string4 = "$" + signature.string(0);
            int n3 = signature.integer(1);
            IndexedConstant indexedConstant = new IndexedConstant(string4, string, this, map.get(string3), n3, n2, null);
            arrayList.add(indexedConstant);
        }
        return arrayList;
    }

    private Map<String, String> getTypeSpecificSignatures(String string, String string2, String string3, NameKind nameKind) {
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string4 : new String[]{"clz", "iface"}) {
            this.search(string4, string.toLowerCase(), NameKind.PREFIX, hashSet, ALL_SCOPE, TERMS_BASE);
            for (Index.SearchResult searchResult : hashSet) {
                String[] stringArray = searchResult.getValues(string4);
                String[] stringArray2 = searchResult.getValues(string2);
                if (stringArray == null || stringArray2 == null) continue;
                assert (stringArray.length == 1);
                String string5 = PHPIndex.getSignatureItem(stringArray[0], 1);
                string5 = string5 != null ? string5.toLowerCase() : null;
                String string6 = searchResult.getPersistentUrl();
                if (!string.toLowerCase().equals(string5)) continue;
                for (String string7 : stringArray2) {
                    String string8 = PHPIndex.getSignatureItem(string7, 0);
                    if (!(nameKind == NameKind.CASE_INSENSITIVE_PREFIX && string8.toLowerCase().startsWith(string3.toLowerCase()) || nameKind == NameKind.PREFIX && string8.startsWith(string3)) && (nameKind != NameKind.EXACT_NAME || !string8.equals(string3))) continue;
                    hashMap.put(string7, string6);
                }
            }
        }
        return hashMap;
    }

    static String getSignatureItem(String string, int n) {
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (n2 == n) {
                for (int j = i; j < string.length(); ++j) {
                    c = string.charAt(j);
                    if (c != ';') continue;
                    return string.substring(i, j);
                }
            }
            if (c != ';') continue;
            ++n2;
        }
        return null;
    }

    public Collection<IndexedFunction> getFunctions(PHPParseResult pHPParseResult, String string, NameKind nameKind) {
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        ArrayList<IndexedFunction> arrayList = new ArrayList<IndexedFunction>();
        this.search("base", string.toLowerCase(), NameKind.PREFIX, hashSet, ALL_SCOPE, TERMS_BASE);
        for (Index.SearchResult searchResult : hashSet) {
            String[] stringArray;
            if (searchResult.getPersistentUrl() == null || (stringArray = searchResult.getValues("base")) == null) continue;
            for (String string2 : stringArray) {
                Signature signature = Signature.get(string2);
                String string3 = signature.string(1);
                if (nameKind == NameKind.PREFIX ? !string3.startsWith(string) : nameKind == NameKind.EXACT_NAME && !string3.equalsIgnoreCase(string)) continue;
                int n = signature.integer(3);
                String string4 = signature.string(2);
                IndexedFunction indexedFunction = new IndexedFunction(string3, null, this, searchResult.getPersistentUrl(), string4, n, 0, ElementKind.METHOD);
                int[] nArray = this.extractOptionalArgs(signature.string(4));
                indexedFunction.setOptionalArgs(nArray);
                indexedFunction.setResolved(pHPParseResult != null && this.isReachable(pHPParseResult, searchResult.getPersistentUrl()));
                arrayList.add(indexedFunction);
                indexedFunction.setReturnType(signature.string(5));
            }
        }
        return arrayList;
    }

    public Collection<IndexedConstant> getTopLevelVariables(PHPParseResult pHPParseResult, String string, NameKind nameKind) {
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        ArrayList<IndexedConstant> arrayList = new ArrayList<IndexedConstant>();
        this.search("var", string.toLowerCase(), NameKind.PREFIX, hashSet, ALL_SCOPE, TERMS_CONST);
        for (Index.SearchResult searchResult : hashSet) {
            String[] stringArray;
            if (searchResult.getPersistentUrl() == null || (stringArray = searchResult.getValues("var")) == null) continue;
            for (String string2 : stringArray) {
                Signature signature = Signature.get(string2);
                String string3 = signature.string(1);
                if (nameKind != NameKind.PREFIX ? nameKind == NameKind.EXACT_NAME && !string3.equals(string) : !string3.startsWith(string)) continue;
                String string4 = signature.string(2);
                string4 = string4.length() == 0 ? null : string4;
                int n = signature.integer(3);
                IndexedConstant indexedConstant = new IndexedConstant(string3, null, this, searchResult.getPersistentUrl(), n, 0, string4);
                indexedConstant.setResolved(pHPParseResult != null && this.isReachable(pHPParseResult, searchResult.getPersistentUrl()));
                arrayList.add(indexedConstant);
            }
        }
        return arrayList;
    }

    public Collection<IndexedConstant> getConstants(PHPParseResult pHPParseResult, String string, NameKind nameKind) {
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        ArrayList<IndexedConstant> arrayList = new ArrayList<IndexedConstant>();
        this.search("const", string.toLowerCase(), NameKind.PREFIX, hashSet, ALL_SCOPE, TERMS_CONST);
        for (Index.SearchResult searchResult : hashSet) {
            String[] stringArray;
            if (searchResult.getPersistentUrl() == null || (stringArray = searchResult.getValues("const")) == null) continue;
            for (String string2 : stringArray) {
                Signature signature = Signature.get(string2);
                String string3 = signature.string(1);
                if (nameKind == NameKind.PREFIX && !string3.startsWith(string)) continue;
                int n = signature.integer(2);
                IndexedConstant indexedConstant = new IndexedConstant(string3, null, this, searchResult.getPersistentUrl(), n, 0, null);
                indexedConstant.setResolved(pHPParseResult != null && this.isReachable(pHPParseResult, searchResult.getPersistentUrl()));
                arrayList.add(indexedConstant);
            }
        }
        return arrayList;
    }

    public Set<FileObject> filesWithIdentifiers(String string) {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        HashSet<Index.SearchResult> hashSet2 = new HashSet<Index.SearchResult>();
        this.search("identifier", string.toLowerCase(), NameKind.PREFIX, hashSet2, ALL_SCOPE, TERMS_BASE);
        for (Index.SearchResult searchResult : hashSet2) {
            hashSet.add(FileUtil.toFileObject((File)new File(URI.create(searchResult.getPersistentUrl()))));
        }
        return hashSet;
    }

    public Collection<IndexedClass> getClasses(PHPParseResult pHPParseResult, String string, NameKind nameKind) {
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        ArrayList<IndexedClass> arrayList = new ArrayList<IndexedClass>();
        this.search("clz", string.toLowerCase(), NameKind.PREFIX, hashSet, ALL_SCOPE, TERMS_BASE);
        for (Index.SearchResult searchResult : hashSet) {
            String[] stringArray;
            if (searchResult.getPersistentUrl() == null || (stringArray = searchResult.getValues("clz")) == null) continue;
            for (String string2 : stringArray) {
                Signature signature = Signature.get(string2);
                String string3 = signature.string(1);
                if (nameKind == NameKind.PREFIX ? !string3.toLowerCase().startsWith(string.toLowerCase()) : nameKind == NameKind.EXACT_NAME && !string3.toLowerCase().equals(string.toLowerCase())) continue;
                int n = signature.integer(2);
                String string4 = signature.string(3);
                IndexedClass indexedClass = new IndexedClass(string3, null, this, searchResult.getPersistentUrl(), string4, n, 0);
                indexedClass.setResolved(pHPParseResult != null && this.isReachable(pHPParseResult, searchResult.getPersistentUrl()));
                arrayList.add(indexedClass);
            }
        }
        return arrayList;
    }

    public Collection<IndexedInterface> getInterfaces(PHPParseResult pHPParseResult, String string, NameKind nameKind) {
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        ArrayList<IndexedInterface> arrayList = new ArrayList<IndexedInterface>();
        this.search("iface", string.toLowerCase(), NameKind.PREFIX, hashSet, ALL_SCOPE, TERMS_BASE);
        for (Index.SearchResult searchResult : hashSet) {
            String[] stringArray;
            if (searchResult.getPersistentUrl() == null || (stringArray = searchResult.getValues("iface")) == null) continue;
            for (String string2 : stringArray) {
                Signature signature = Signature.get(string2);
                String string3 = signature.string(1);
                if (nameKind == NameKind.PREFIX ? !string3.toLowerCase().startsWith(string.toLowerCase()) : nameKind == NameKind.EXACT_NAME && !string3.toLowerCase().equals(string.toLowerCase())) continue;
                int n = signature.integer(2);
                String[] stringArray2 = signature.string(3).split(",");
                IndexedInterface indexedInterface = new IndexedInterface(string3, null, this, searchResult.getPersistentUrl(), stringArray2, n, 0);
                indexedInterface.setResolved(pHPParseResult != null && this.isReachable(pHPParseResult, searchResult.getPersistentUrl()));
                arrayList.add(indexedInterface);
            }
        }
        return arrayList;
    }

    private Collection<IndexedInterface> getInterfaceTree(PHPParseResult pHPParseResult, String string) {
        ArrayList<IndexedInterface> arrayList = new ArrayList<IndexedInterface>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        TreeSet<String> treeSet = new TreeSet<String>(Collections.singleton(string));
        while (!treeSet.isEmpty()) {
            TreeSet<String> treeSet2 = new TreeSet<String>();
            for (String string2 : treeSet) {
                for (IndexedInterface indexedInterface : this.getInterfaces(pHPParseResult, string2, NameKind.EXACT_NAME)) {
                    arrayList.add(indexedInterface);
                    arrayList2.add(indexedInterface.getName());
                    for (String string3 : indexedInterface.getInterfaces()) {
                        if (arrayList2.contains(string3)) continue;
                        treeSet2.add(string3);
                    }
                }
            }
            treeSet.clear();
            treeSet.addAll(treeSet2);
        }
        return arrayList;
    }

    public Collection<String> getDirectIncludes(PHPParseResult pHPParseResult, String string) {
        assert (!string.startsWith("file:"));
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        this.search("filename", "file:" + string, NameKind.EXACT_NAME, hashSet, ALL_SCOPE, TERMS_BASE);
        for (Index.SearchResult searchResult : hashSet) {
            String[] stringArray;
            if (searchResult.getPersistentUrl() == null || (stringArray = searchResult.getValues("include")) == null) continue;
            for (String string2 : stringArray) {
                for (String string3 : string2.split(";")) {
                    if (string3.length() <= 0) continue;
                    arrayList.add(string3);
                }
            }
        }
        return arrayList;
    }

    public Collection<String> getAllIncludes(PHPParseResult pHPParseResult, String string) {
        Collection<String> collection;
        HashMap<String, Collection<String>> hashMap = this.includesCache.get((Object)pHPParseResult);
        if (hashMap != null) {
            collection = hashMap.get(string);
            if (collection != null) {
                return collection;
            }
        } else {
            hashMap = new HashMap();
            this.includesCache.put(pHPParseResult, hashMap);
        }
        collection = this.getAllIncludesImpl(pHPParseResult, string);
        hashMap.put(string, collection);
        return collection;
    }

    private Collection<String> getAllIncludesImpl(PHPParseResult pHPParseResult, String string) {
        TreeSet<String> treeSet = new TreeSet<String>();
        Collection<String> collection = this.getDirectIncludes(pHPParseResult, string);
        for (String string2 : collection) {
            treeSet.add(string2);
            treeSet.addAll(this.getAllIncludes(pHPParseResult, string2));
        }
        return Collections.unmodifiableCollection(treeSet);
    }

    public boolean isReachable(PHPParseResult pHPParseResult, String string) {
        HashMap<String, Boolean> hashMap = this.isReachableCache.get((Object)pHPParseResult);
        if (hashMap != null) {
            Boolean bl = hashMap.get(string);
            if (bl != null) {
                return bl;
            }
        } else {
            hashMap = new HashMap();
            this.isReachableCache.put(pHPParseResult, hashMap);
        }
        boolean bl = this.isReachableImpl(pHPParseResult, string);
        hashMap.put(string, new Boolean(bl));
        return bl;
    }

    private boolean isReachableImpl(PHPParseResult pHPParseResult, String string) {
        if (this.isSystemFile(pHPParseResult, string)) {
            return true;
        }
        String string2 = null;
        try {
            string2 = pHPParseResult.getFile().getFileObject().getURL().toExternalForm();
            if (string.equals(string2)) {
                return true;
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
        }
        Collection<String> collection = this.getAllIncludes(pHPParseResult, PHPIndex.fileURLToAbsPath(string2));
        return collection.contains(PHPIndex.fileURLToAbsPath(string));
    }

    private boolean isSystemFile(PHPParseResult pHPParseResult, String string) {
        HashMap<String, Boolean> hashMap = this.isSystemFileCache.get((Object)pHPParseResult);
        if (hashMap != null) {
            Boolean bl = hashMap.get(string);
            if (bl != null) {
                return bl;
            }
        } else {
            hashMap = new HashMap();
            this.isSystemFileCache.put(pHPParseResult, hashMap);
        }
        boolean bl = this.isSystemFileImpl(pHPParseResult, string);
        hashMap.put(string, new Boolean(bl));
        return bl;
    }

    private boolean isSystemFileImpl(PHPParseResult pHPParseResult, String string) {
        try {
            File file = new File(new URI(string));
            if (!file.exists()) {
                return false;
            }
            FileObject fileObject = FileUtil.toFileObject((File)file);
            PhpSourcePath.FileType fileType = PhpSourcePath.getFileType((FileObject)fileObject);
            if (fileType == PhpSourcePath.FileType.INTERNAL || fileType == PhpSourcePath.FileType.INCLUDE) {
                return true;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            Exceptions.printStackTrace((Throwable)uRISyntaxException);
        }
        return false;
    }

    private static String fileURLToAbsPath(String string) {
        assert (string.startsWith("file:")) : string + " doesn't start with 'file:'";
        return string.substring("file:".length());
    }

    static String dequote(String string) {
        assert (string.length() >= 2);
        assert (string.startsWith("\"") || string.startsWith("'"));
        assert (string.endsWith("\"") || string.endsWith("'"));
        return string.substring(1, string.length() - 1);
    }

    static String resolveRelativeURL(String string, String string2) {
        String string3;
        if (string2.startsWith("/")) {
            string3 = "/";
            string2 = string2.substring(1);
        } else {
            if (string == null || !string.startsWith("/")) {
                throw new IllegalArgumentException();
            }
            int n = (string = PHPIndex.resolveRelativeURL(null, string)).lastIndexOf(47);
            if (n == -1) {
                throw new IllegalArgumentException();
            }
            string3 = string.substring(0, n + 1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "/", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("/")) {
                if (string3.endsWith("/")) continue;
                string3 = string3 + "/";
                continue;
            }
            if (string4.equals("") || string4.equals(".")) continue;
            if (string4.equals("..")) {
                String string5 = string3.substring(0, string3.length() - 1);
                int n = string5.lastIndexOf("/");
                if (n == -1) continue;
                string3 = string5.substring(0, n + 1);
                continue;
            }
            string3 = string3 + string4;
        }
        return string3;
    }

    private int[] extractOptionalArgs(String string) {
        if (string.length() == 0) {
            return new int[0];
        }
        String[] stringArray = string.split(",");
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                nArray[i] = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println(String.format("*** couldnt parse '%s', part %d", string, i));
            }
        }
        return nArray;
    }
}

