/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.api.CodeCompletionContext;
import org.netbeans.modules.gsf.api.CodeCompletionHandler;
import org.netbeans.modules.gsf.api.CodeCompletionResult;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.CompletionProposal;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.gsf.api.ParameterInfo;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.DocRenderer;
import org.netbeans.modules.php.editor.PHPCompletionItem;
import org.netbeans.modules.php.editor.PHPCompletionResult;
import org.netbeans.modules.php.editor.PHPDOCCodeCompletion;
import org.netbeans.modules.php.editor.PredefinedSymbols;
import org.netbeans.modules.php.editor.index.IndexedClass;
import org.netbeans.modules.php.editor.index.IndexedConstant;
import org.netbeans.modules.php.editor.index.IndexedElement;
import org.netbeans.modules.php.editor.index.IndexedFunction;
import org.netbeans.modules.php.editor.index.IndexedInterface;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.nav.NavUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.DoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.ExpressionStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ForEachStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ForStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.GlobalStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.IfStatement;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Reference;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.editor.parser.astnodes.StaticStatement;
import org.netbeans.modules.php.editor.parser.astnodes.TypeDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.WhileStatement;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPCodeCompletion
implements CodeCompletionHandler {
    private static final Logger LOGGER = Logger.getLogger(PHPCodeCompletion.class.getName());
    private static final List<String> INVALID_PROPOSALS_FOR_CLS_MEMBERS = Arrays.asList("__construct", "__destruct");
    private static final List<String> METHOD_NAME_PROPOSALS = Arrays.asList("__construct()", "__destruct()");
    private static final List<String> CLASS_CONTEXT_KEYWORD_PROPOSAL = Arrays.asList("abstract", "const", "function", "private", "protected", "public", "static", "var");
    private static final List<String> INHERITANCE_KEYWORDS = Arrays.asList("extends", "implements");
    private static final List<PHPTokenId[]> NONE_TOKENCHAINS = Arrays.asList(new PHPTokenId[][]{{PHPTokenId.PHP_CLASS}, {PHPTokenId.PHP_CLASS, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_EXTENDS, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_IMPLEMENTS, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING, PHPTokenId.WHITESPACE}});
    private static final List<PHPTokenId[]> CLASS_NAME_TOKENCHAINS = Arrays.asList(new PHPTokenId[][]{{PHPTokenId.PHP_NEW}, {PHPTokenId.PHP_NEW, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_NEW, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_CLASS, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING, PHPTokenId.WHITESPACE, PHPTokenId.PHP_EXTENDS}, {PHPTokenId.PHP_CLASS, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING, PHPTokenId.WHITESPACE, PHPTokenId.PHP_EXTENDS, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_CLASS, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING, PHPTokenId.WHITESPACE, PHPTokenId.PHP_EXTENDS, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}});
    private static final List<PHPTokenId[]> INTERFACE_TOKENCHAINS = Arrays.asList(new PHPTokenId[][]{{PHPTokenId.PHP_IMPLEMENTS}, {PHPTokenId.PHP_IMPLEMENTS, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_INTERFACE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING, PHPTokenId.WHITESPACE, PHPTokenId.PHP_EXTENDS}, {PHPTokenId.PHP_INTERFACE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING, PHPTokenId.WHITESPACE, PHPTokenId.PHP_EXTENDS, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_INTERFACE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING, PHPTokenId.WHITESPACE, PHPTokenId.PHP_EXTENDS, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}});
    private static final List<PHPTokenId[]> TYPE_TOKENCHAINS = Arrays.asList(new PHPTokenId[][]{{PHPTokenId.PHP_FUNCTION, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING, PHPTokenId.PHP_TOKEN}, {PHPTokenId.PHP_FUNCTION, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING, PHPTokenId.WHITESPACE, PHPTokenId.PHP_TOKEN}});
    private static final List<PHPTokenId[]> CLASS_MEMBER_TOKENCHAINS = Arrays.asList(new PHPTokenId[][]{{PHPTokenId.PHP_OBJECT_OPERATOR}, {PHPTokenId.PHP_OBJECT_OPERATOR, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_OBJECT_OPERATOR, PHPTokenId.PHP_VARIABLE}, {PHPTokenId.PHP_OBJECT_OPERATOR, PHPTokenId.PHP_TOKEN}});
    private static final List<PHPTokenId[]> STATIC_CLASS_MEMBER_TOKENCHAINS = Arrays.asList(new PHPTokenId[][]{{PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM}, {PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM, PHPTokenId.PHP_VARIABLE}, {PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM, PHPTokenId.PHP_TOKEN}});
    private static final List<PHPTokenId[]> COMMENT_TOKENCHAINS = Arrays.asList(new PHPTokenId[][]{{PHPTokenId.PHP_COMMENT_START}, {PHPTokenId.PHP_COMMENT}, {PHPTokenId.PHP_LINE_COMMENT}});
    private static final List<PHPTokenId[]> PHPDOC_TOKENCHAINS = Arrays.asList(new PHPTokenId[][]{{PHPTokenId.PHPDOC_COMMENT_START}, {PHPTokenId.PHPDOC_COMMENT}});
    private static final List<PHPTokenId[]> INHERITANCE_TOKENCHAINS = Arrays.asList(new PHPTokenId[][]{{PHPTokenId.PHP_CLASS, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_CLASS, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_INTERFACE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_INTERFACE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}});
    private static final List<PHPTokenId[]> INHERITANCE_TOKENCHAINS_CONDITIONAL = Collections.singletonList(new PHPTokenId[]{PHPTokenId.PHP_CLASS, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING});
    private static final List<PHPTokenId[]> FUNCTION_TOKENCHAINS_CONDITIONAL = Collections.singletonList(new PHPTokenId[]{PHPTokenId.PHP_FUNCTION});
    private static final List<PHPTokenId[]> FUNCTION_TOKENCHAINS = Arrays.asList(new PHPTokenId[][]{{PHPTokenId.PHP_FUNCTION, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_FUNCTION, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}});
    private static final List<PHPTokenId[]> CLASS_CONTEXT_KEYWORDS_TOKENCHAINS = Arrays.asList(new PHPTokenId[][]{{PHPTokenId.PHP_PRIVATE}, {PHPTokenId.PHP_PRIVATE, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_PRIVATE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_PROTECTED}, {PHPTokenId.PHP_PROTECTED, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_PROTECTED, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_PUBLIC}, {PHPTokenId.PHP_PUBLIC, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_PUBLIC, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_STATIC}, {PHPTokenId.PHP_STATIC, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_STATIC, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_ABSTRACT}, {PHPTokenId.PHP_ABSTRACT, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_ABSTRACT, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_CURLY_OPEN}, {PHPTokenId.PHP_CURLY_CLOSE}, {PHPTokenId.PHP_CURLY_CLOSE, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_CURLY_CLOSE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_CURLY_OPEN}, {PHPTokenId.PHP_CURLY_OPEN, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_CURLY_OPEN, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_SEMICOLON}, {PHPTokenId.PHP_SEMICOLON, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_SEMICOLON, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}});
    private static final String[] PHP_KEYWORDS = new String[]{"__FILE__", "exception", "__LINE__", "array()", "class", "const", "continue", "die()", "echo()", "empty()", "endif", "eval()", "exit()", "for", "foreach", "function", "global", "if", "include()", "include_once()", "isset()", "list()", "new", "print()", "require()", "require_once()", "return()", "static", "switch", "unset()", "use", "var", "while", "__FUNCTION__", "__CLASS__", "__METHOD__", "final", "php_user_filter", "interface", "implements", "extends", "public", "private", "protected", "abstract", "clone", "try", "catch", "throw"};
    private static final String[] PHP_CLASS_KEYWORDS = new String[]{"$this->", "self::", "parent::"};
    private boolean caseSensitive;
    private NameKind nameKind;

    static CompletionContext findCompletionContext(CompilationInfo compilationInfo, int n) {
        Document document = compilationInfo.getDocument();
        if (document == null) {
            return CompletionContext.NONE;
        }
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        tokenSequence.move(n);
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return CompletionContext.NONE;
        }
        PHPTokenId pHPTokenId = (PHPTokenId)tokenSequence.token().id();
        int n2 = tokenSequence.token().offset(tokenHierarchy);
        switch (pHPTokenId) {
            case T_INLINE_HTML: {
                return CompletionContext.HTML;
            }
            case PHP_CONSTANT_ENCAPSED_STRING: {
                if (tokenSequence.token().text().charAt(0) == '\"') {
                    return CompletionContext.STRING;
                }
                return CompletionContext.NONE;
            }
        }
        if (PHPCodeCompletion.acceptTokenChains(tokenSequence, NONE_TOKENCHAINS)) {
            return CompletionContext.NONE;
        }
        if (PHPCodeCompletion.acceptTokenChains(tokenSequence, CLASS_NAME_TOKENCHAINS)) {
            return CompletionContext.CLASS_NAME;
        }
        if (PHPCodeCompletion.acceptTokenChains(tokenSequence, CLASS_MEMBER_TOKENCHAINS)) {
            return CompletionContext.CLASS_MEMBER;
        }
        if (PHPCodeCompletion.acceptTokenChains(tokenSequence, STATIC_CLASS_MEMBER_TOKENCHAINS)) {
            return CompletionContext.STATIC_CLASS_MEMBER;
        }
        if (PHPCodeCompletion.acceptTokenChains(tokenSequence, COMMENT_TOKENCHAINS)) {
            return CompletionContext.NONE;
        }
        if (PHPCodeCompletion.acceptTokenChains(tokenSequence, PHPDOC_TOKENCHAINS)) {
            return CompletionContext.PHPDOC;
        }
        if (PHPCodeCompletion.acceptTokenChains(tokenSequence, INHERITANCE_TOKENCHAINS)) {
            return CompletionContext.INHERITANCE;
        }
        if (PHPCodeCompletion.acceptTokenChains(tokenSequence, INHERITANCE_TOKENCHAINS_CONDITIONAL) && n2 != n) {
            return CompletionContext.INHERITANCE;
        }
        if (PHPCodeCompletion.acceptTokenChains(tokenSequence, INTERFACE_TOKENCHAINS)) {
            return CompletionContext.INTERFACE_NAME;
        }
        if (PHPCodeCompletion.acceptTokenChains(tokenSequence, TYPE_TOKENCHAINS)) {
            return CompletionContext.TYPE_NAME;
        }
        if (PHPCodeCompletion.isInsideClassDeclarationBlock(compilationInfo, n, tokenSequence)) {
            if (PHPCodeCompletion.acceptTokenChains(tokenSequence, CLASS_CONTEXT_KEYWORDS_TOKENCHAINS)) {
                return CompletionContext.CLASS_CONTEXT_KEYWORDS;
            }
            if (PHPCodeCompletion.acceptTokenChains(tokenSequence, FUNCTION_TOKENCHAINS)) {
                return CompletionContext.METHOD_NAME;
            }
            if (PHPCodeCompletion.acceptTokenChains(tokenSequence, FUNCTION_TOKENCHAINS_CONDITIONAL) && n2 != n) {
                return CompletionContext.METHOD_NAME;
            }
            return CompletionContext.NONE;
        }
        return CompletionContext.EXPRESSION;
    }

    private static boolean acceptTokenChains(TokenSequence tokenSequence, List<PHPTokenId[]> list) {
        int n = 0;
        for (PHPTokenId[] object : list) {
            if (n >= object.length) continue;
            n = object.length;
        }
        Token[] tokenArray = PHPCodeCompletion.getPreceedingTokens(tokenSequence, n);
        block1: for (PHPTokenId[] pHPTokenIdArray : list) {
            int n2 = tokenArray.length - pHPTokenIdArray.length;
            if (n2 < 0) continue;
            for (int i = 0; i < pHPTokenIdArray.length; ++i) {
                if (pHPTokenIdArray[i] != tokenArray[i + n2].id()) continue block1;
            }
            return true;
        }
        return false;
    }

    private static Token[] getPreceedingTokens(TokenSequence tokenSequence, int n) {
        int n2 = tokenSequence.offset();
        LinkedList<Token> linkedList = new LinkedList<Token>();
        for (int i = 0; i < n && tokenSequence.movePrevious(); ++i) {
            linkedList.addFirst(tokenSequence.token());
        }
        tokenSequence.move(n2);
        tokenSequence.moveNext();
        return linkedList.toArray(new Token[linkedList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean isInsideClassDeclarationBlock(CompilationInfo compilationInfo, int n, TokenSequence tokenSequence) {
        List<ASTNode> list = NavUtils.underCaret(compilationInfo, n);
        boolean bl = false;
        for (ASTNode aSTNode : list) {
            if (aSTNode instanceof FunctionDeclaration && !bl) {
                return false;
            }
            if (!(aSTNode instanceof MethodDeclaration)) continue;
            bl = true;
        }
        int n2 = tokenSequence.offset();
        try {
            int n3 = 0;
            int n4 = 0;
            while (tokenSequence.movePrevious()) {
                boolean bl2;
                Token token = tokenSequence.token();
                TokenId tokenId = token.id();
                if (tokenId.equals((Object)PHPTokenId.PHP_CURLY_OPEN)) {
                    ++n3;
                    continue;
                }
                if (tokenId.equals((Object)PHPTokenId.PHP_CURLY_CLOSE)) {
                    ++n4;
                    continue;
                }
                if ((tokenId.equals((Object)PHPTokenId.PHP_FUNCTION) || tokenId.equals((Object)PHPTokenId.PHP_WHILE) || tokenId.equals((Object)PHPTokenId.PHP_IF)) && n3 > n4) {
                    boolean bl3 = false;
                    return bl3;
                }
                if (!tokenId.equals((Object)PHPTokenId.PHP_CLASS)) continue;
                boolean bl4 = bl2 = n3 > 0 && (n3 + n4) % 2 == 1;
                return bl4;
            }
        }
        finally {
            tokenSequence.move(n2);
            tokenSequence.moveNext();
        }
        return false;
    }

    public CodeCompletionResult complete(CodeCompletionContext codeCompletionContext) {
        long l = 0L;
        if (LOGGER.isLoggable(Level.FINE)) {
            l = System.currentTimeMillis();
        }
        CompilationInfo compilationInfo = codeCompletionContext.getInfo();
        int n = codeCompletionContext.getCaretOffset();
        String string = codeCompletionContext.getPrefix();
        this.caseSensitive = codeCompletionContext.isCaseSensitive();
        this.nameKind = this.caseSensitive ? NameKind.PREFIX : NameKind.CASE_INSENSITIVE_PREFIX;
        ArrayList<CompletionProposal> arrayList = new ArrayList<CompletionProposal>();
        PHPParseResult pHPParseResult = (PHPParseResult)compilationInfo.getEmbeddedResult("text/x-php5", n);
        if (pHPParseResult.getProgram() == null) {
            return CodeCompletionResult.NONE;
        }
        CompletionContext completionContext = PHPCodeCompletion.findCompletionContext(compilationInfo, n);
        LOGGER.fine("CC context: " + (Object)((Object)completionContext));
        if (completionContext == CompletionContext.NONE) {
            return CodeCompletionResult.NONE;
        }
        PHPCompletionItem.CompletionRequest completionRequest = new PHPCompletionItem.CompletionRequest();
        completionRequest.anchor = n - string.length();
        completionRequest.result = pHPParseResult;
        completionRequest.info = compilationInfo;
        completionRequest.prefix = string;
        completionRequest.index = PHPIndex.get(completionRequest.info.getIndex("text/x-php5"));
        try {
            completionRequest.currentlyEditedFileURL = pHPParseResult.getFile().getFileObject().getURL().toString();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
        }
        switch (completionContext) {
            case EXPRESSION: {
                this.autoCompleteExpression(arrayList, completionRequest);
                break;
            }
            case HTML: {
                arrayList.add(new PHPCompletionItem.KeywordItem("<?php", completionRequest));
                arrayList.add(new PHPCompletionItem.KeywordItem("<?=", completionRequest));
                break;
            }
            case CLASS_NAME: {
                this.autoCompleteClassNames(arrayList, completionRequest);
                break;
            }
            case INTERFACE_NAME: {
                this.autoCompleteInterfaceNames(arrayList, completionRequest);
                break;
            }
            case TYPE_NAME: {
                this.autoCompleteClassNames(arrayList, completionRequest);
                this.autoCompleteInterfaceNames(arrayList, completionRequest);
                break;
            }
            case STRING: {
                arrayList.addAll(this.getVariableProposals(completionRequest.result.getProgram().getStatements(), completionRequest));
                break;
            }
            case CLASS_MEMBER: {
                this.autoCompleteClassMembers(arrayList, completionRequest, false);
                break;
            }
            case STATIC_CLASS_MEMBER: {
                this.autoCompleteClassMembers(arrayList, completionRequest, true);
                break;
            }
            case PHPDOC: {
                PHPDOCCodeCompletion.complete(arrayList, completionRequest);
                break;
            }
            case CLASS_CONTEXT_KEYWORDS: {
                this.autoCompleteKeywords(arrayList, completionRequest, CLASS_CONTEXT_KEYWORD_PROPOSAL);
                break;
            }
            case METHOD_NAME: {
                this.autoCompleteMethodName(arrayList, completionRequest);
                break;
            }
            case INHERITANCE: {
                this.autoCompleteKeywords(arrayList, completionRequest, INHERITANCE_KEYWORDS);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            long l2 = System.currentTimeMillis() - l;
            LOGGER.fine(String.format("complete() took %d ms, result contains %d items", l2, arrayList.size()));
        }
        return new PHPCompletionResult(codeCompletionContext, arrayList);
    }

    private void autoCompleteClassNames(List<CompletionProposal> list, PHPCompletionItem.CompletionRequest completionRequest) {
        for (IndexedClass indexedClass : completionRequest.index.getClasses(completionRequest.result, completionRequest.prefix, this.nameKind)) {
            list.add(new PHPCompletionItem.ClassItem(indexedClass, completionRequest));
        }
    }

    private void autoCompleteInterfaceNames(List<CompletionProposal> list, PHPCompletionItem.CompletionRequest completionRequest) {
        for (IndexedInterface indexedInterface : completionRequest.index.getInterfaces(completionRequest.result, completionRequest.prefix, this.nameKind)) {
            list.add(new PHPCompletionItem.InterfaceItem(indexedInterface, completionRequest));
        }
    }

    private void autoCompleteMethodName(List<CompletionProposal> list, PHPCompletionItem.CompletionRequest completionRequest) {
        for (String string : METHOD_NAME_PROPOSALS) {
            if (!string.startsWith(completionRequest.prefix)) continue;
            list.add(new PHPCompletionItem.SpecialFunctionItem(string, completionRequest));
        }
    }

    private void autoCompleteKeywords(List<CompletionProposal> list, PHPCompletionItem.CompletionRequest completionRequest, List<String> list2) {
        for (String string : list2) {
            if (!string.startsWith(completionRequest.prefix)) continue;
            list.add(new PHPCompletionItem.KeywordItem(string, completionRequest));
        }
    }

    private void autoCompleteClassMembers(List<CompletionProposal> list, PHPCompletionItem.CompletionRequest completionRequest, boolean bl) {
        block13: {
            Object object;
            Collection<IndexedConstant> collection;
            List<String> list2;
            String string;
            int n;
            boolean bl2;
            boolean bl3;
            block15: {
                String string2;
                block17: {
                    block16: {
                        block14: {
                            Document document = completionRequest.info.getDocument();
                            if (document == null) {
                                return;
                            }
                            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
                            TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
                            tokenSequence.move(completionRequest.anchor);
                            if (!tokenSequence.movePrevious()) break block13;
                            bl3 = !bl;
                            bl2 = true;
                            boolean bl4 = true;
                            n = 1;
                            if (tokenSequence.token().id() == PHPTokenId.WHITESPACE) {
                                bl4 = tokenSequence.movePrevious();
                            }
                            bl4 = tokenSequence.movePrevious();
                            string2 = ((Object)tokenSequence.token().text()).toString();
                            string = null;
                            list2 = INVALID_PROPOSALS_FOR_CLS_MEMBERS;
                            if (!string2.equals("self")) break block14;
                            collection = PHPCodeCompletion.findEnclosingClass(completionRequest.info, completionRequest.anchor);
                            if (collection == null) break block15;
                            string = ((TypeDeclaration)((Object)collection)).getName().getName();
                            bl3 = true;
                            bl = true;
                            bl2 = false;
                            n |= 6;
                            break block15;
                        }
                        if (!string2.equals("parent")) break block16;
                        list2 = Collections.emptyList();
                        collection = PHPCodeCompletion.findEnclosingClass(completionRequest.info, completionRequest.anchor);
                        if (collection == null || (object = ((ClassDeclaration)((Object)collection)).getSuperClass()) == null) break block15;
                        string = ((Identifier)object).getName();
                        bl3 = true;
                        bl = true;
                        n |= 4;
                        break block15;
                    }
                    if (!string2.equals("$this")) break block17;
                    collection = PHPCodeCompletion.findEnclosingClass(completionRequest.info, completionRequest.anchor);
                    if (collection == null) break block15;
                    string = ((TypeDeclaration)((Object)collection)).getName().getName();
                    bl = false;
                    bl3 = true;
                    n |= 6;
                    break block15;
                }
                if (bl) {
                    string = string2;
                } else {
                    collection = this.getVariables(completionRequest.result, completionRequest.index, completionRequest.result.getProgram().getStatements(), string2, completionRequest.anchor, completionRequest.currentlyEditedFileURL);
                    if (collection != null) {
                        for (IndexedConstant object22 : collection) {
                            if (!object22.getName().equals(string2)) continue;
                            string = object22.getTypeName();
                            break;
                        }
                    }
                }
            }
            if (string != null) {
                Object object2;
                collection = bl2 ? completionRequest.index.getAllMethods(completionRequest.result, string, completionRequest.prefix, this.nameKind, n) : completionRequest.index.getMethods(completionRequest.result, string, completionRequest.prefix, this.nameKind, n);
                for (IndexedFunction indexedFunction : collection) {
                    if ((!bl || !indexedFunction.isStatic()) && (!bl3 || indexedFunction.isStatic())) continue;
                    for (int i = 0; i <= indexedFunction.getOptionalArgs().length; ++i) {
                        if (list2.contains(indexedFunction.getName())) continue;
                        list.add(new PHPCompletionItem.FunctionItem(indexedFunction, completionRequest, i));
                    }
                }
                object = bl && completionRequest.prefix.startsWith("$") ? completionRequest.prefix.substring(1) : completionRequest.prefix;
                Collection<IndexedConstant> collection2 = bl2 ? completionRequest.index.getAllProperties(completionRequest.result, string, (String)object, this.nameKind, n) : completionRequest.index.getProperties(completionRequest.result, string, (String)object, this.nameKind, n);
                for (Object object3 : collection2) {
                    if ((!bl || !((IndexedElement)object3).isStatic()) && (!bl3 || ((IndexedElement)object3).isStatic())) continue;
                    object2 = new PHPCompletionItem.VariableItem((IndexedConstant)object3, completionRequest);
                    if (!bl) {
                        ((PHPCompletionItem.VariableItem)object2).doNotInsertDollarPrefix();
                    }
                    list.add((CompletionProposal)object2);
                }
                if (bl) {
                    Object object3;
                    Collection<IndexedConstant> collection3 = completionRequest.index.getAllClassConstants(completionRequest.result, string, completionRequest.prefix, this.nameKind);
                    object3 = collection3.iterator();
                    while (object3.hasNext()) {
                        object2 = (IndexedConstant)object3.next();
                        list.add(new PHPCompletionItem.VariableItem((IndexedConstant)object2, completionRequest));
                    }
                }
            }
        }
    }

    private static ClassDeclaration findEnclosingClass(CompilationInfo compilationInfo, int n) {
        List<ASTNode> list = NavUtils.underCaret(compilationInfo, n);
        for (ASTNode aSTNode : list) {
            if (!(aSTNode instanceof ClassDeclaration)) continue;
            return (ClassDeclaration)aSTNode;
        }
        return null;
    }

    private void autoCompleteExpression(List<CompletionProposal> list, PHPCompletionItem.CompletionRequest completionRequest) {
        for (String string : PHP_KEYWORDS) {
            if (!this.startsWith(string, completionRequest.prefix)) continue;
            list.add(new PHPCompletionItem.KeywordItem(string, completionRequest));
        }
        PHPIndex pHPIndex = completionRequest.index;
        for (IndexedFunction indexedFunction : pHPIndex.getFunctions(completionRequest.result, completionRequest.prefix, this.nameKind)) {
            for (int i = 0; i <= indexedFunction.getOptionalArgs().length; ++i) {
                list.add(new PHPCompletionItem.FunctionItem(indexedFunction, completionRequest, i));
            }
        }
        for (IndexedConstant indexedConstant : pHPIndex.getConstants(completionRequest.result, completionRequest.prefix, this.nameKind)) {
            list.add(new PHPCompletionItem.ConstantItem(indexedConstant, completionRequest));
        }
        list.addAll(this.getVariableProposals(completionRequest.result.getProgram().getStatements(), completionRequest));
        this.autoCompleteClassNames(list, completionRequest);
        ClassDeclaration classDeclaration = PHPCodeCompletion.findEnclosingClass(completionRequest.info, completionRequest.anchor);
        if (classDeclaration != null) {
            for (String string : PHP_CLASS_KEYWORDS) {
                if (!this.startsWith(string, completionRequest.prefix)) continue;
                list.add(new PHPCompletionItem.KeywordItem(string, completionRequest));
            }
        }
    }

    private Collection<CompletionProposal> getVariableProposals(Collection<Statement> collection, PHPCompletionItem.CompletionRequest completionRequest) {
        PHPCompletionItem pHPCompletionItem;
        ArrayList<CompletionProposal> arrayList = new ArrayList<CompletionProposal>();
        Collection<IndexedConstant> collection2 = this.getVariables(completionRequest.result, completionRequest.index, collection, completionRequest.prefix, completionRequest.anchor, completionRequest.currentlyEditedFileURL);
        for (IndexedConstant object : collection2) {
            pHPCompletionItem = new PHPCompletionItem.VariableItem(object, completionRequest);
            arrayList.add(pHPCompletionItem);
        }
        for (String string : PredefinedSymbols.SUPERGLOBALS) {
            if (!this.isPrefix("$" + string, completionRequest.prefix)) continue;
            pHPCompletionItem = new PHPCompletionItem.SuperGlobalItem(completionRequest, string);
            arrayList.add(pHPCompletionItem);
        }
        return arrayList;
    }

    public Collection<IndexedConstant> getVariables(PHPParseResult pHPParseResult, PHPIndex pHPIndex, Collection<Statement> collection, String string, int n, String string2) {
        Collection<IndexedConstant> collection2 = this.getLocalVariables(collection, string, n, string2);
        LinkedHashMap<String, IndexedConstant> linkedHashMap = new LinkedHashMap<String, IndexedConstant>();
        for (IndexedConstant indexedConstant : collection2) {
            linkedHashMap.put(indexedConstant.getName(), indexedConstant);
        }
        for (IndexedConstant indexedConstant : pHPIndex.getTopLevelVariables(pHPParseResult, string, NameKind.PREFIX)) {
            IndexedConstant indexedConstant2;
            IndexedConstant indexedConstant3;
            if (string2.equals(indexedConstant.getFilenameUrl()) || (indexedConstant3 = (IndexedConstant)linkedHashMap.get(indexedConstant.getName())) != null && indexedConstant3.getOffset() == indexedConstant.getOffset() || (indexedConstant2 = linkedHashMap.put(indexedConstant.getName(), indexedConstant)) == null || !collection2.contains(indexedConstant2)) continue;
            linkedHashMap.put(indexedConstant2.getName(), indexedConstant2);
        }
        for (IndexedConstant indexedConstant : linkedHashMap.values()) {
            CodeUtils.resolveFunctionType(pHPParseResult, pHPIndex, linkedHashMap, indexedConstant);
        }
        return linkedHashMap.values();
    }

    private void getLocalVariables_indexVariable(Variable variable, Map<String, IndexedConstant> map, String string, String string2, String string3) {
        String string4 = CodeUtils.extractVariableName(variable);
        if (this.isPrefix(string4, string)) {
            IndexedConstant indexedConstant = new IndexedConstant(string4, null, null, string2, variable.getStartOffset(), 0, string3);
            map.put(string4, indexedConstant);
        }
    }

    private boolean isPrefix(String string, String string2) {
        return string != null && (string.startsWith(string2) || this.nameKind == NameKind.CASE_INSENSITIVE_PREFIX && string.toLowerCase().startsWith(string2.toLowerCase()));
    }

    private void getLocalVariables_indexVariableInAssignment(Expression expression, Map<String, IndexedConstant> map, String string, String string2) {
        if (expression instanceof Assignment) {
            Assignment assignment = (Assignment)expression;
            if (assignment.getLeftHandSide() instanceof Variable) {
                Variable variable = (Variable)assignment.getLeftHandSide();
                String string3 = CodeUtils.extractVariableTypeFromAssignment(assignment);
                this.getLocalVariables_indexVariable(variable, map, string, string2, string3);
            }
            if (assignment.getRightHandSide() instanceof Assignment) {
                this.getLocalVariables_indexVariableInAssignment(assignment.getRightHandSide(), map, string, string2);
            }
        }
    }

    private Collection<IndexedConstant> getLocalVariables(Collection<Statement> collection, String string, int n, String string2) {
        HashMap<String, IndexedConstant> hashMap = new HashMap<String, IndexedConstant>();
        for (Statement statement : collection) {
            ASTNode aSTNode;
            if (statement.getStartOffset() > n) break;
            if (statement instanceof ExpressionStatement) {
                aSTNode = ((ExpressionStatement)statement).getExpression();
                this.getLocalVariables_indexVariableInAssignment((Expression)aSTNode, hashMap, string, string2);
            } else if (statement instanceof GlobalStatement) {
                aSTNode = (GlobalStatement)statement;
                for (Variable variable : ((GlobalStatement)aSTNode).getVariables()) {
                    this.getLocalVariables_indexVariable(variable, hashMap, string, string2, null);
                }
            } else if (statement instanceof StaticStatement) {
                aSTNode = (StaticStatement)statement;
                for (Variable variable : ((StaticStatement)aSTNode).getVariables()) {
                    this.getLocalVariables_indexVariable(variable, hashMap, string, string2, null);
                }
            } else if (!PHPCodeCompletion.offsetWithinStatement(n, statement)) continue;
            if (statement instanceof Block) {
                aSTNode = (Block)statement;
                this.getLocalVariables_MergeResults(hashMap, this.getLocalVariables(((Block)aSTNode).getStatements(), string, n, string2));
            } else if (statement instanceof IfStatement) {
                aSTNode = (IfStatement)statement;
                this.getLocalVariables_indexVariableInAssignment(((IfStatement)aSTNode).getCondition(), hashMap, string, string2);
                if (PHPCodeCompletion.offsetWithinStatement(n, ((IfStatement)aSTNode).getTrueStatement())) {
                    this.getLocalVariables_MergeResults(hashMap, this.getLocalVariables(Collections.singleton(((IfStatement)aSTNode).getTrueStatement()), string, n, string2));
                } else if (((IfStatement)aSTNode).getFalseStatement() != null && PHPCodeCompletion.offsetWithinStatement(n, ((IfStatement)aSTNode).getFalseStatement())) {
                    this.getLocalVariables_MergeResults(hashMap, this.getLocalVariables(Collections.singleton(((IfStatement)aSTNode).getFalseStatement()), string, n, string2));
                }
            } else if (statement instanceof WhileStatement) {
                aSTNode = (WhileStatement)statement;
                this.getLocalVariables_indexVariableInAssignment(((WhileStatement)aSTNode).getCondition(), hashMap, string, string2);
                this.getLocalVariables_MergeResults(hashMap, this.getLocalVariables(Collections.singleton(((WhileStatement)aSTNode).getBody()), string, n, string2));
            } else if (statement instanceof DoStatement) {
                aSTNode = (DoStatement)statement;
                this.getLocalVariables_MergeResults(hashMap, this.getLocalVariables(Collections.singleton(((DoStatement)aSTNode).getBody()), string, n, string2));
            } else if (statement instanceof ForStatement) {
                aSTNode = (ForStatement)statement;
                for (Expression expression : ((ForStatement)aSTNode).getInitializers()) {
                    this.getLocalVariables_indexVariableInAssignment(expression, hashMap, string, string2);
                }
                this.getLocalVariables_MergeResults(hashMap, this.getLocalVariables(Collections.singleton(((ForStatement)aSTNode).getBody()), string, n, string2));
            } else if (statement instanceof ForEachStatement) {
                Object object;
                aSTNode = (ForEachStatement)statement;
                if (((ForEachStatement)aSTNode).getKey() instanceof Variable) {
                    object = (Variable)((ForEachStatement)aSTNode).getKey();
                    this.getLocalVariables_indexVariable((Variable)object, hashMap, string, string2, null);
                }
                if (((ForEachStatement)aSTNode).getValue() instanceof Variable) {
                    object = (Variable)((ForEachStatement)aSTNode).getValue();
                    this.getLocalVariables_indexVariable((Variable)object, hashMap, string, string2, null);
                }
                this.getLocalVariables_indexVariableInAssignment(((ForEachStatement)aSTNode).getValue(), hashMap, string, string2);
                this.getLocalVariables_MergeResults(hashMap, this.getLocalVariables(Collections.singleton(((ForEachStatement)aSTNode).getStatement()), string, n, string2));
            } else if (statement instanceof FunctionDeclaration) {
                hashMap.clear();
                aSTNode = (FunctionDeclaration)statement;
                for (FormalParameter formalParameter : ((FunctionDeclaration)aSTNode).getFormalParameters()) {
                    String string3;
                    Expression expression = formalParameter.getParameterName();
                    if (expression instanceof Reference) {
                        Reference reference = (Reference)expression;
                        expression = reference.getExpression();
                    }
                    if (!(expression instanceof Variable)) continue;
                    String string4 = CodeUtils.extractVariableName((Variable)expression);
                    String string5 = string3 = formalParameter.getParameterType() != null ? formalParameter.getParameterType().getName() : null;
                    if (!this.isPrefix(string4, string)) continue;
                    IndexedConstant indexedConstant = new IndexedConstant(string4, null, null, string2, -1, 0, string3);
                    hashMap.put(string4, indexedConstant);
                }
                this.getLocalVariables_MergeResults(hashMap, this.getLocalVariables(Collections.singleton(((FunctionDeclaration)aSTNode).getBody()), string, n, string2));
            }
            if (statement instanceof MethodDeclaration) {
                aSTNode = (MethodDeclaration)statement;
                this.getLocalVariables_MergeResults(hashMap, this.getLocalVariables(Collections.singleton(((MethodDeclaration)aSTNode).getFunction()), string, n, string2));
                continue;
            }
            if (!(statement instanceof ClassDeclaration)) continue;
            aSTNode = (ClassDeclaration)statement;
            this.getLocalVariables_MergeResults(hashMap, this.getLocalVariables(Collections.singleton(((TypeDeclaration)aSTNode).getBody()), string, n, string2));
        }
        return hashMap.values();
    }

    private void getLocalVariables_MergeResults(Map<String, IndexedConstant> map, Collection<IndexedConstant> collection) {
        for (IndexedConstant indexedConstant : collection) {
            map.put(indexedConstant.getName(), indexedConstant);
        }
    }

    private static boolean offsetWithinStatement(int n, Statement statement) {
        return statement.getEndOffset() >= n && statement.getStartOffset() <= n;
    }

    public String document(CompilationInfo compilationInfo, ElementHandle elementHandle) {
        return DocRenderer.document(compilationInfo, elementHandle);
    }

    public ElementHandle resolveLink(String string, ElementHandle elementHandle) {
        return null;
    }

    private static final boolean isPHPIdentifierPart(char c) {
        return Character.isJavaIdentifierPart(c) || c == '@';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getPrefix(CompilationInfo compilationInfo, int n, boolean bl) {
        try {
            BaseDocument baseDocument = (BaseDocument)compilationInfo.getDocument();
            if (baseDocument == null) {
                return null;
            }
            baseDocument.readLock();
            try {
                int n2;
                int n3;
                String string;
                int n4;
                int n5;
                int n6 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
                if (n6 == -1) return null;
                int n7 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
                String string2 = baseDocument.getText(n6, n7 - n6);
                int n8 = n5 = n - n6;
                if (n5 > 0) {
                    int n9 = n5 - 1;
                    while (n9 >= 0 && PHPCodeCompletion.isPHPIdentifierPart((char)(n4 = (int)string2.charAt(n9)))) {
                        n8 = n9--;
                    }
                }
                if (bl) {
                    string = string2.substring(n8, n5);
                    n4 = string.lastIndexOf(36);
                    if (n4 > 0) {
                        string = string.substring(n4);
                    }
                } else if (n5 == string2.length()) {
                    string = string2.substring(n8);
                } else {
                    char c;
                    n4 = string2.length();
                    n3 = n5;
                    for (n2 = n5; n2 < n4 && PHPCodeCompletion.isPHPIdentifierPart(c = string2.charAt(n2)); ++n2) {
                        n3 = n2 + 1;
                    }
                    string = string2.substring(n8, n3);
                }
                if (string.length() > 0) {
                    if (string.endsWith("::")) {
                        String string3 = "";
                        return string3;
                    }
                    if (string.endsWith(":") && string.length() > 1) {
                        String string4 = null;
                        return string4;
                    }
                    n4 = string.lastIndexOf("::");
                    if (n4 != -1) {
                        string = string.substring(n4 + 2);
                    }
                    if (string.length() == 1) {
                        n3 = string.charAt(0);
                        if (!PHPCodeCompletion.isPHPIdentifierPart((char)n3) && n3 != 64 && n3 != 36 && n3 != 58) {
                            String string5 = null;
                            return string5;
                        }
                    } else {
                        for (n3 = string.length() - 2; n3 >= 0; --n3) {
                            n2 = string.charAt(n3);
                            if (n3 == 0 && n2 == 58 || PHPCodeCompletion.isPHPIdentifierPart((char)n2) || n2 == 64 || n2 == 36) continue;
                            string = string.substring(n3 + 1);
                            break;
                        }
                    }
                }
                String string6 = string;
                return string6;
            }
            finally {
                baseDocument.readUnlock();
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        return null;
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent jTextComponent, String string) {
        Token token;
        int n;
        if (string.length() == 0) {
            return CodeCompletionHandler.QueryType.NONE;
        }
        char c = string.charAt(string.length() - 1);
        Document document = jTextComponent.getDocument();
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence(PHPTokenId.language());
        int n2 = tokenSequence.move(n = jTextComponent.getCaretPosition());
        if ((n2 > 0 && tokenSequence.moveNext() || tokenSequence.movePrevious()) && ((token = tokenSequence.token()).id() == PHPTokenId.PHP_OBJECT_OPERATOR || token.id() == PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM || token.id() == PHPTokenId.PHP_TOKEN && c == '$' || token.id() == PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING && c == '$' || token.id() == PHPTokenId.PHPDOC_COMMENT && c == '@')) {
            return CodeCompletionHandler.QueryType.ALL_COMPLETION;
        }
        return CodeCompletionHandler.QueryType.NONE;
    }

    public String resolveTemplateVariable(String string, CompilationInfo compilationInfo, int n, String string2, Map map) {
        return null;
    }

    public Set<String> getApplicableTemplates(CompilationInfo compilationInfo, int n, int n2) {
        return null;
    }

    public ParameterInfo parameters(CompilationInfo compilationInfo, int n, CompletionProposal completionProposal) {
        return ParameterInfo.NONE;
    }

    private boolean startsWith(String string, String string2) {
        if (string2.length() == 0) {
            return true;
        }
        return this.caseSensitive ? string.startsWith(string2) : string.toLowerCase().startsWith(string2.toLowerCase());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CompletionContext {
        EXPRESSION,
        HTML,
        CLASS_NAME,
        INTERFACE_NAME,
        TYPE_NAME,
        STRING,
        CLASS_MEMBER,
        STATIC_CLASS_MEMBER,
        PHPDOC,
        INHERITANCE,
        METHOD_NAME,
        CLASS_CONTEXT_KEYWORDS,
        NONE;

    }
}

