/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor;

import java.io.IOException;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.SourceModelFactory;
import org.netbeans.modules.php.editor.CCDocHtmlFormatter;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.PHPCodeCompletion;
import org.netbeans.modules.php.editor.index.IndexedElement;
import org.netbeans.modules.php.editor.index.PHPDOCTagElement;
import org.netbeans.modules.php.editor.index.PredefinedSymbolElement;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ClassConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocBlock;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTag;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

class DocRenderer {
    private static final String TD_STYLE = "style=\"text-aling:left; border-width: 1px;padding: 1px;border-style: solid;border-color: gray;padding:3px\" ";
    private static final String TABLE_STYLE = "style=\"border-style:solid; border-color: black; border-width: 1px; width: 100%; border-collapse: collapse;\"";

    DocRenderer() {
    }

    static String document(CompilationInfo compilationInfo, ElementHandle elementHandle) {
        if (elementHandle instanceof PHPDOCTagElement) {
            PHPDOCTagElement pHPDOCTagElement = (PHPDOCTagElement)elementHandle;
            return pHPDOCTagElement.getDoc();
        }
        if (elementHandle instanceof PredefinedSymbolElement) {
            PredefinedSymbolElement predefinedSymbolElement = (PredefinedSymbolElement)elementHandle;
            return predefinedSymbolElement.getDoc();
        }
        if (elementHandle instanceof IndexedElement) {
            return DocRenderer.documentIndexedElement(compilationInfo, (IndexedElement)elementHandle);
        }
        return null;
    }

    private static String documentIndexedElement(CompilationInfo compilationInfo, IndexedElement indexedElement) {
        Sources sources;
        Project project;
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        CCDocHtmlFormatter cCDocHtmlFormatter = new CCDocHtmlFormatter();
        String string = null;
        if (indexedElement.getFile().isPlatform()) {
            string = NbBundle.getMessage(PHPCodeCompletion.class, (String)"PHPPlatform");
        } else {
            object = indexedElement.getFile().getFileObject();
            project = FileOwnerQuery.getOwner((FileObject)object);
            if (project != null) {
                sources = ProjectUtils.getSources((Project)project);
                SourceGroup[] sourceGroupArray = sources.getSourceGroups("PHPSOURCE");
                for (int i = 0; i < sourceGroupArray.length; ++i) {
                    if (!sourceGroupArray[i].contains((FileObject)object)) continue;
                    string = FileUtil.getRelativePath((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)object);
                    break;
                }
                if (string == null) {
                    string = object.getPath();
                }
            } else {
                string = indexedElement.getFilenameUrl();
            }
        }
        if (string != null) {
            cCDocHtmlFormatter.appendHtml(String.format("<div align=\"right\"><font size=-1>%s</font></div>", string));
        }
        object = new StringBuilder();
        if (indexedElement.getOffset() > -1) {
            project = indexedElement.getFileObject();
            if (project == null) {
                return null;
            }
            sources = SourceModelFactory.getInstance().getModel((FileObject)project);
            try {
                sources.runUserActionTask((CancellableTask)new PHPDocExtractor(cCDocHtmlFormatter, (StringBuilder)object, indexedElement), true);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (((StringBuilder)object).length() > 0) {
            stringBuilder.append((CharSequence)object);
        } else {
            stringBuilder.append(NbBundle.getMessage(PHPCodeCompletion.class, (String)"PHPDocNotFound"));
        }
        return cCDocHtmlFormatter.getText() + stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PHPDocExtractor
    implements CancellableTask<CompilationInfo> {
        private CCDocHtmlFormatter header;
        private StringBuilder phpDoc;
        private IndexedElement indexedElement;

        public PHPDocExtractor(CCDocHtmlFormatter cCDocHtmlFormatter, StringBuilder stringBuilder, IndexedElement indexedElement) {
            this.header = cCDocHtmlFormatter;
            this.phpDoc = stringBuilder;
            this.indexedElement = indexedElement;
        }

        public void cancel() {
        }

        private void doFunctionDeclaration(FunctionDeclaration functionDeclaration) {
            String string = CodeUtils.extractFunctionName(functionDeclaration);
            this.header.appendHtml("<font size=\"+1\">");
            this.header.name(ElementKind.METHOD, true);
            this.header.appendText(string);
            this.header.name(ElementKind.METHOD, false);
            this.header.appendHtml("</font>");
            this.header.parameters(true);
            this.header.appendText("(");
            int n = functionDeclaration.getFormalParameters().size();
            for (int i = 0; i < n; ++i) {
                FormalParameter formalParameter = functionDeclaration.getFormalParameters().get(i);
                if (formalParameter.getParameterType() != null) {
                    this.header.type(true);
                    this.header.appendText(formalParameter.getParameterType().getName() + " ");
                    this.header.type(false);
                }
                this.header.appendText(CodeUtils.getParamDisplayName(formalParameter));
                if (formalParameter.getDefaultValue() != null) {
                    this.header.type(true);
                    this.header.appendText("=");
                    if (formalParameter.getDefaultValue() instanceof Scalar) {
                        Scalar scalar = (Scalar)formalParameter.getDefaultValue();
                        this.header.appendText(scalar.getStringValue());
                    }
                    this.header.type(false);
                }
                if (i + 1 >= n) continue;
                this.header.appendText(", ");
            }
            this.header.appendText(")");
            this.header.parameters(false);
        }

        private void extractPHPDoc(PHPDocBlock pHPDocBlock) {
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            StringBuilder stringBuilder3 = new StringBuilder();
            StringBuilder stringBuilder4 = new StringBuilder();
            this.phpDoc.append(pHPDocBlock.getDescription());
            this.phpDoc.append("<br />\n");
            block5: for (PHPDocTag pHPDocTag : pHPDocBlock.getTags()) {
                switch (pHPDocTag.getKind()) {
                    case PARAM: {
                        String string;
                        String[] stringArray = pHPDocTag.getValue().split("\\s+", 3);
                        String string2 = "";
                        String string3 = "";
                        String string4 = "";
                        if (stringArray.length > 0) {
                            string4 = stringArray[0];
                            if (stringArray.length > 1) {
                                string3 = stringArray[1];
                                if (stringArray.length > 2) {
                                    string2 = stringArray[2];
                                }
                            }
                        }
                        if (string3.endsWith(string = "[optional]")) {
                            string3 = string3.substring(0, string3.length() - string.length());
                        }
                        String string5 = String.format("<tr><td valign=\"top\" %s>%s</td><td valign=\"top\" %s><b>$%s</b></td><td valign=\"top\" %s>%s</td></tr>\n", DocRenderer.TD_STYLE, string3, DocRenderer.TD_STYLE, string4, DocRenderer.TD_STYLE, string2);
                        stringBuilder.append(string5);
                        break;
                    }
                    case LINK: {
                        String string = String.format("<a href=\"%s\">%s</a><br>\n", pHPDocTag.getValue(), pHPDocTag.getValue());
                        stringBuilder2.append(string);
                        break;
                    }
                    case RETURN: {
                        String[] stringArray = pHPDocTag.getValue().split("\\s+", 2);
                        if (stringArray.length <= 0) continue block5;
                        String string = stringArray[0];
                        stringBuilder3.append(String.format("<b>%s:</b> %s<br><br>", NbBundle.getMessage(PHPCodeCompletion.class, (String)"Type"), string));
                        if (stringArray.length <= 1) continue block5;
                        String string6 = stringArray[1];
                        stringBuilder3.append(string6);
                        break;
                    }
                    default: {
                        String string = String.format("<tr><th>%s</th><td>%s</td></tr>\n", pHPDocTag.getKind().toString(), pHPDocTag.getValue());
                        stringBuilder4.append(string);
                    }
                }
            }
            if (stringBuilder.length() > 0) {
                this.phpDoc.append("<div style=\"padding-top:3px;\"><b>");
                this.phpDoc.append(NbBundle.getMessage(PHPCodeCompletion.class, (String)"Parameters"));
                this.phpDoc.append("</b></div>\n<table cellspacing=0 style=\"border-style:solid; border-color: black; border-width: 1px; width: 100%; border-collapse: collapse;\">\n" + stringBuilder + "</table>\n");
            }
            if (stringBuilder3.length() > 0) {
                this.phpDoc.append("<h3>");
                this.phpDoc.append(NbBundle.getMessage(PHPCodeCompletion.class, (String)"ReturnValue"));
                this.phpDoc.append("</h3>\n" + stringBuilder3);
            }
            if (stringBuilder2.length() > 0) {
                this.phpDoc.append("<h3>");
                this.phpDoc.append(NbBundle.getMessage(PHPCodeCompletion.class, (String)"OnlineDocs"));
                this.phpDoc.append("</h3>\n" + stringBuilder2);
            }
            if (stringBuilder4.length() > 0) {
                this.phpDoc.append("<table>\n" + stringBuilder4 + "</table>\n");
            }
        }

        private String getElementValue(Program program, ASTNode aSTNode) {
            if (aSTNode instanceof Identifier) {
                FunctionInvocation functionInvocation;
                if ("define".equals(((Identifier)aSTNode).getName()) && (functionInvocation = (FunctionInvocation)Utils.getNodeAtOffset(program, this.indexedElement.getOffset(), FunctionInvocation.class)) != null) {
                    Expression expression;
                    assert (functionInvocation.getStartOffset() == aSTNode.getStartOffset());
                    if (functionInvocation.getParameters().size() > 1 && (expression = functionInvocation.getParameters().get(1)) instanceof Scalar) {
                        Scalar scalar = (Scalar)expression;
                        return scalar.getStringValue();
                    }
                }
            } else if (aSTNode instanceof ClassConstantDeclaration) {
                Expression expression;
                Expression expression2;
                ClassConstantDeclaration classConstantDeclaration = (ClassConstantDeclaration)aSTNode;
                int n = -1;
                for (int i = 0; i < classConstantDeclaration.getNames().size(); ++i) {
                    expression2 = classConstantDeclaration.getNames().get(i);
                    if (!((Identifier)expression2).getName().equals(this.indexedElement.getName())) continue;
                    n = i;
                    break;
                }
                if (n >= 0 && (expression = classConstantDeclaration.getInitializers().get(n)) instanceof Scalar) {
                    expression2 = (Scalar)expression;
                    return ((Scalar)expression2).getStringValue();
                }
            }
            return null;
        }

        public void run(CompilationInfo compilationInfo) throws Exception {
            ParserResult parserResult = (ParserResult)compilationInfo.getEmbeddedResults("text/x-php5").iterator().next();
            Program program = Utils.getRoot(parserResult.getInfo());
            if (program != null) {
                Object object;
                ASTNode aSTNode = Utils.getNodeAtOffset(program, this.indexedElement.getOffset());
                if (aSTNode instanceof FunctionDeclaration) {
                    this.doFunctionDeclaration((FunctionDeclaration)aSTNode);
                } else {
                    this.header.name(this.indexedElement.getKind(), true);
                    this.header.appendText(this.indexedElement.getDisplayName());
                    this.header.name(this.indexedElement.getKind(), false);
                    object = this.getElementValue(program, aSTNode);
                    if (object != null) {
                        this.header.appendText(" = " + (String)object);
                    }
                }
                this.header.appendHtml("<br/><br/>");
                object = Utils.getCommentForNode(program, aSTNode);
                if (object instanceof PHPDocBlock) {
                    this.extractPHPDoc((PHPDocBlock)object);
                }
            }
        }
    }
}

