/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xpath.ext.schema.resolver;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.xpath.ext.XPathModel;
import org.netbeans.modules.xml.xpath.ext.XPathUtils;
import org.netbeans.modules.xml.xpath.ext.schema.resolver.SchemaCompHolder;
import org.netbeans.modules.xml.xpath.ext.schema.resolver.XPathSchemaContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WildcardSchemaContext
implements XPathSchemaContext {
    private XPathModel mXPathModel;
    private XPathSchemaContext mParentContext;
    private boolean lookForElements;
    private boolean lookForAttributes;
    private boolean lastInChain = false;
    private Set<XPathSchemaContext.SchemaCompPair> mSchemaCompPair = null;
    private Set<SchemaCompHolder> mUsedSchemaCompSet;

    public WildcardSchemaContext(XPathSchemaContext xPathSchemaContext, XPathModel xPathModel, boolean bl, boolean bl2) {
        this.mXPathModel = xPathModel;
        this.mParentContext = xPathSchemaContext;
        this.lookForElements = bl;
        this.lookForAttributes = bl2;
    }

    @Override
    public XPathSchemaContext getParentContext() {
        return this.mParentContext;
    }

    @Override
    public synchronized Set<XPathSchemaContext.SchemaCompPair> getSchemaCompPairs() {
        if (this.mSchemaCompPair == null) {
            this.mSchemaCompPair = this.calculateSchemaComponents();
        }
        return this.mSchemaCompPair;
    }

    private Set<XPathSchemaContext.SchemaCompPair> calculateSchemaComponents() {
        HashSet<XPathSchemaContext.SchemaCompPair> hashSet = new HashSet<XPathSchemaContext.SchemaCompPair>();
        if (this.mParentContext == null) {
            List<SchemaComponent> list = XPathUtils.findRootComponents(this.mXPathModel, this.lookForElements, this.lookForAttributes, false);
            for (SchemaComponent schemaComponent : list) {
                XPathSchemaContext.SchemaCompPair schemaCompPair = new XPathSchemaContext.SchemaCompPair(schemaComponent, (SchemaCompHolder)null);
                hashSet.add(schemaCompPair);
            }
        } else {
            List<XPathSchemaContext.SchemaCompPair> list = XPathUtils.findSubcomponents(this.mXPathModel, this.mParentContext, this.lookForElements, this.lookForAttributes, false);
            hashSet.addAll(list);
        }
        return hashSet;
    }

    @Override
    public Set<XPathSchemaContext.SchemaCompPair> getUsedSchemaCompPairs() {
        HashSet<XPathSchemaContext.SchemaCompPair> hashSet = new HashSet<XPathSchemaContext.SchemaCompPair>();
        if (this.mUsedSchemaCompSet != null) {
            for (XPathSchemaContext.SchemaCompPair schemaCompPair : this.getSchemaCompPairs()) {
                SchemaCompHolder schemaCompHolder = schemaCompPair.getCompHolder();
                for (SchemaCompHolder schemaCompHolder2 : this.mUsedSchemaCompSet) {
                    if (!schemaCompHolder.equals(schemaCompHolder2)) continue;
                    hashSet.add(schemaCompPair);
                }
            }
        }
        return hashSet;
    }

    @Override
    public void setUsedSchemaCompH(Set<SchemaCompHolder> set) {
        this.mUsedSchemaCompSet = set;
    }

    @Override
    public String toStringWithoutParent() {
        return "";
    }

    public boolean equals(Object object) {
        if (object instanceof XPathSchemaContext) {
            return XPathSchemaContext.Utilities.equals(this, (XPathSchemaContext)object);
        }
        return false;
    }

    @Override
    public boolean equalsChain(XPathSchemaContext xPathSchemaContext) {
        if (xPathSchemaContext instanceof XPathSchemaContext) {
            return XPathSchemaContext.Utilities.equalsChain(this, xPathSchemaContext);
        }
        return false;
    }

    @Override
    public boolean isLastInChain() {
        return this.lastInChain;
    }

    @Override
    public void setLastInChain(boolean bl) {
        this.lastInChain = bl;
    }
}

