/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xpath.ext.impl;

import javax.xml.namespace.QName;
import org.apache.commons.jxpath.ri.Compiler;
import org.netbeans.modules.xml.xpath.ext.CoreFunctionType;
import org.netbeans.modules.xml.xpath.ext.CoreOperationType;
import org.netbeans.modules.xml.xpath.ext.LocationStep;
import org.netbeans.modules.xml.xpath.ext.StepNodeNameTest;
import org.netbeans.modules.xml.xpath.ext.StepNodeTest;
import org.netbeans.modules.xml.xpath.ext.StepNodeTestType;
import org.netbeans.modules.xml.xpath.ext.StepNodeTypeTest;
import org.netbeans.modules.xml.xpath.ext.XPathCoreFunction;
import org.netbeans.modules.xml.xpath.ext.XPathCoreOperation;
import org.netbeans.modules.xml.xpath.ext.XPathExpression;
import org.netbeans.modules.xml.xpath.ext.XPathExpressionPath;
import org.netbeans.modules.xml.xpath.ext.XPathExtensionFunction;
import org.netbeans.modules.xml.xpath.ext.XPathLocationPath;
import org.netbeans.modules.xml.xpath.ext.XPathModel;
import org.netbeans.modules.xml.xpath.ext.XPathPredicateExpression;
import org.netbeans.modules.xml.xpath.ext.XPathVariableReference;
import org.netbeans.modules.xml.xpath.ext.impl.LocationStepImpl;

public class XPathTreeCompiler
implements Compiler {
    private XPathModel myXPathModel;

    public XPathTreeCompiler(XPathModel xPathModel) {
        this.myXPathModel = xPathModel;
    }

    public Object number(String string) {
        try {
            long l = Long.parseLong(string);
            return this.myXPathModel.getFactory().newXPathNumericLiteral(new Long(l));
        }
        catch (NumberFormatException numberFormatException) {
            try {
                double d = Double.parseDouble(string);
                return this.myXPathModel.getFactory().newXPathNumericLiteral(new Double(d));
            }
            catch (NumberFormatException numberFormatException2) {
                return null;
            }
        }
    }

    public Object literal(String string) {
        return this.myXPathModel.getFactory().newXPathStringLiteral(string);
    }

    public Object qname(String string, String string2) {
        if (string == null || string.length() == 0) {
            return new QName(string2);
        }
        return new QName(null, string2, string);
    }

    public Object sum(Object[] objectArray) {
        return this.createOperation(objectArray, CoreOperationType.OP_SUM);
    }

    public Object minus(Object object, Object object2) {
        return this.createOperation(object, object2, CoreOperationType.OP_MINUS);
    }

    public Object multiply(Object object, Object object2) {
        return this.createOperation(object, object2, CoreOperationType.OP_MULT);
    }

    public Object divide(Object object, Object object2) {
        return this.createOperation(object, object2, CoreOperationType.OP_DIV);
    }

    public Object mod(Object object, Object object2) {
        return this.createOperation(object, object2, CoreOperationType.OP_MOD);
    }

    public Object lessThan(Object object, Object object2) {
        return this.createOperation(object, object2, CoreOperationType.OP_LT);
    }

    public Object lessThanOrEqual(Object object, Object object2) {
        return this.createOperation(object, object2, CoreOperationType.OP_LE);
    }

    public Object greaterThan(Object object, Object object2) {
        return this.createOperation(object, object2, CoreOperationType.OP_GT);
    }

    public Object greaterThanOrEqual(Object object, Object object2) {
        return this.createOperation(object, object2, CoreOperationType.OP_GE);
    }

    public Object equal(Object object, Object object2) {
        return this.createOperation(object, object2, CoreOperationType.OP_EQ);
    }

    public Object notEqual(Object object, Object object2) {
        return this.createOperation(object, object2, CoreOperationType.OP_NE);
    }

    public Object minus(Object object) {
        XPathCoreOperation xPathCoreOperation = this.myXPathModel.getFactory().newXPathCoreOperation(CoreOperationType.OP_NEGATIVE);
        xPathCoreOperation.addChild((XPathExpression)object);
        return xPathCoreOperation;
    }

    public Object variableReference(Object object) {
        assert (object instanceof QName);
        XPathVariableReference xPathVariableReference = this.myXPathModel.getFactory().newXPathVariableReference((QName)object);
        return xPathVariableReference;
    }

    public Object function(int n, Object[] objectArray) {
        CoreFunctionType coreFunctionType = this.convertFunctionCodeToType(n);
        if (coreFunctionType == null) {
            return null;
        }
        XPathCoreFunction xPathCoreFunction = this.myXPathModel.getFactory().newXPathCoreFunction(coreFunctionType);
        if (objectArray != null) {
            for (Object object : objectArray) {
                xPathCoreFunction.addChild((XPathExpression)object);
            }
        }
        return xPathCoreFunction;
    }

    public Object function(Object object, Object[] objectArray) {
        XPathExtensionFunction xPathExtensionFunction = this.myXPathModel.getFactory().newXPathExtensionFunction((QName)object);
        if (objectArray != null) {
            for (Object object2 : objectArray) {
                xPathExtensionFunction.addChild((XPathExpression)object2);
            }
        }
        return xPathExtensionFunction;
    }

    public Object and(Object[] objectArray) {
        return this.createOperation(objectArray, CoreOperationType.OP_AND);
    }

    public Object or(Object[] objectArray) {
        return this.createOperation(objectArray, CoreOperationType.OP_OR);
    }

    public Object union(Object[] objectArray) {
        return this.createOperation(objectArray, CoreOperationType.OP_UNION);
    }

    public Object locationPath(boolean bl, Object[] objectArray) {
        XPathLocationPath xPathLocationPath = this.myXPathModel.getFactory().newXPathLocationPath(this.toLocationStepArray(objectArray));
        xPathLocationPath.setAbsolute(bl);
        return xPathLocationPath;
    }

    public Object expressionPath(Object object, Object[] objectArray, Object[] objectArray2) {
        XPathExpressionPath xPathExpressionPath = this.myXPathModel.getFactory().newXPathExpressionPath((XPathExpression)object, this.toLocationStepArray(objectArray2));
        return xPathExpressionPath;
    }

    public Object nodeNameTest(Object object) {
        return new StepNodeNameTest((QName)object);
    }

    public Object nodeTypeTest(int n) {
        return new StepNodeTypeTest(n, null);
    }

    public Object processingInstructionTest(String string) {
        StepNodeTypeTest stepNodeTypeTest = new StepNodeTypeTest(StepNodeTestType.NODETYPE_PI, string);
        return stepNodeTypeTest;
    }

    public Object step(int n, Object object, Object[] objectArray) {
        LocationStepImpl locationStepImpl = new LocationStepImpl(this.myXPathModel, n, (StepNodeTest)object, this.toPredicateExpressionArray(objectArray));
        return locationStepImpl;
    }

    private XPathPredicateExpression[] toPredicateExpressionArray(Object[] objectArray) {
        XPathPredicateExpression[] xPathPredicateExpressionArray = null;
        if (objectArray != null) {
            xPathPredicateExpressionArray = new XPathPredicateExpression[objectArray.length];
            for (int i = 0; i < xPathPredicateExpressionArray.length; ++i) {
                XPathExpression xPathExpression = (XPathExpression)objectArray[i];
                xPathPredicateExpressionArray[i] = xPathExpression instanceof XPathPredicateExpression ? (XPathPredicateExpression)xPathExpression : this.myXPathModel.getFactory().newXPathPredicateExpression(xPathExpression);
            }
        }
        return xPathPredicateExpressionArray;
    }

    private LocationStep[] toLocationStepArray(Object[] objectArray) {
        LocationStep[] locationStepArray = null;
        if (objectArray != null) {
            locationStepArray = new LocationStep[objectArray.length];
            for (int i = 0; i < locationStepArray.length; ++i) {
                locationStepArray[i] = (LocationStep)objectArray[i];
            }
        }
        return locationStepArray;
    }

    private Object createOperation(Object object, Object object2, CoreOperationType coreOperationType) {
        XPathCoreOperation xPathCoreOperation = this.myXPathModel.getFactory().newXPathCoreOperation(coreOperationType);
        xPathCoreOperation.addChild((XPathExpression)object);
        xPathCoreOperation.addChild((XPathExpression)object2);
        return xPathCoreOperation;
    }

    private Object createOperation(Object[] objectArray, CoreOperationType coreOperationType) {
        XPathCoreOperation xPathCoreOperation = this.myXPathModel.getFactory().newXPathCoreOperation(coreOperationType);
        for (Object object : objectArray) {
            xPathCoreOperation.addChild((XPathExpression)object);
        }
        return xPathCoreOperation;
    }

    private CoreFunctionType convertFunctionCodeToType(int n) {
        switch (n) {
            case 1: {
                return CoreFunctionType.FUNC_LAST;
            }
            case 2: {
                return CoreFunctionType.FUNC_POSITION;
            }
            case 3: {
                return CoreFunctionType.FUNC_COUNT;
            }
            case 4: {
                return CoreFunctionType.FUNC_ID;
            }
            case 5: {
                return CoreFunctionType.FUNC_LOCAL_NAME;
            }
            case 6: {
                return CoreFunctionType.FUNC_NAMESPACE_URI;
            }
            case 7: {
                return CoreFunctionType.FUNC_NAME;
            }
            case 8: {
                return CoreFunctionType.FUNC_STRING;
            }
            case 9: {
                return CoreFunctionType.FUNC_CONCAT;
            }
            case 10: {
                return CoreFunctionType.FUNC_STARTS_WITH;
            }
            case 11: {
                return CoreFunctionType.FUNC_CONTAINS;
            }
            case 12: {
                return CoreFunctionType.FUNC_SUBSTRING_BEFORE;
            }
            case 13: {
                return CoreFunctionType.FUNC_SUBSTRING_AFTER;
            }
            case 14: {
                return CoreFunctionType.FUNC_SUBSTRING;
            }
            case 15: {
                return CoreFunctionType.FUNC_STRING_LENGTH;
            }
            case 16: {
                return CoreFunctionType.FUNC_NORMALIZE_SPACE;
            }
            case 17: {
                return CoreFunctionType.FUNC_TRANSLATE;
            }
            case 18: {
                return CoreFunctionType.FUNC_BOOLEAN;
            }
            case 19: {
                return CoreFunctionType.FUNC_NOT;
            }
            case 20: {
                return CoreFunctionType.FUNC_TRUE;
            }
            case 21: {
                return CoreFunctionType.FUNC_FALSE;
            }
            case 22: {
                return CoreFunctionType.FUNC_LANG;
            }
            case 23: {
                return CoreFunctionType.FUNC_NUMBER;
            }
            case 24: {
                return CoreFunctionType.FUNC_SUM;
            }
            case 25: {
                return CoreFunctionType.FUNC_FLOOR;
            }
            case 26: {
                return CoreFunctionType.FUNC_CEILING;
            }
            case 27: {
                return CoreFunctionType.FUNC_ROUND;
            }
            case 28: 
            case 29: 
            case 30: {
                return null;
            }
        }
        return null;
    }
}

