/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialog;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialogMediator;
import org.netbeans.modules.db.explorer.dlg.ConnectionProgressListener;
import org.netbeans.modules.db.util.DatabaseExplorerInternalUIs;
import org.netbeans.modules.db.util.JdbcUrl;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class NewConnectionPanel
extends ConnectionDialog.FocusablePanel
implements DocumentListener,
ListDataListener {
    private ConnectionDialogMediator mediator;
    private DatabaseConnection connection;
    private ProgressHandle progressHandle;
    private Window window;
    private boolean updatingUrl = false;
    private boolean updatingFields = false;
    private final LinkedHashMap<String, UrlField> urlFields = new LinkedHashMap();
    private static final String BUNDLE = "org.netbeans.modules.db.resources.Bundle";
    private static final Logger LOGGER = Logger.getLogger(NewConnectionPanel.class.getName());
    private JTextField additionalPropsField;
    private JLabel additionalPropsLabel;
    private JTextField databaseField;
    private JLabel databaseLabel;
    private JTextField dsnField;
    private JLabel dsnLabel;
    private JLabel errorLabel;
    private JTextField hostField;
    private JLabel hostLabel;
    private JTextField instanceField;
    private JLabel instanceLabel;
    private JCheckBox passwordCheckBox;
    private JPasswordField passwordField;
    private JLabel passwordLabel;
    private JTextField portField;
    private JLabel portLabel;
    private JTextField serverNameField;
    private JLabel serverNameLabel;
    private JTextField serviceField;
    private JLabel serviceLabel;
    private JCheckBox showUrlCheckBox;
    private JTextField sidField;
    private JLabel sidLabel;
    private JComboBox templateComboBox;
    private JLabel templateLabel;
    private JTextField tnsField;
    private JLabel tnsLabel;
    private JTextField urlField;
    private JLabel urlLabel;
    private JTextField userField;
    private JLabel userLabel;

    private static ResourceBundle bundle() {
        return NbBundle.getBundle((String)BUNDLE);
    }

    private static String getMessage(String string, Object ... objectArray) {
        return MessageFormat.format(NewConnectionPanel.bundle().getString(string), objectArray);
    }

    private void initFieldMap() {
        this.urlFields.put("<HOST>", new UrlField(this.hostField, this.hostLabel));
        this.urlFields.put("<PORT>", new UrlField(this.portField, this.portLabel));
        this.urlFields.put("<DB>", new UrlField(this.databaseField, this.databaseLabel));
        this.urlFields.put("<SID>", new UrlField(this.sidField, this.sidLabel));
        this.urlFields.put("<SERVICE>", new UrlField(this.serviceField, this.serviceLabel));
        this.urlFields.put("<TNSNAME>", new UrlField(this.tnsField, this.tnsLabel));
        this.urlFields.put("<DSN>", new UrlField(this.dsnField, this.dsnLabel));
        this.urlFields.put("<SERVERNAME>", new UrlField(this.serverNameField, this.serverNameLabel));
        this.urlFields.put("<INSTANCE>", new UrlField(this.instanceField, this.instanceLabel));
        this.urlFields.put("<ADDITIONAL>", new UrlField(this.additionalPropsField, this.additionalPropsLabel));
    }

    public NewConnectionPanel(ConnectionDialogMediator connectionDialogMediator, String string, DatabaseConnection databaseConnection) {
        this.mediator = connectionDialogMediator;
        this.connection = databaseConnection;
        this.initComponents();
        this.initAccessibility();
        this.initFieldMap();
        DatabaseExplorerInternalUIs.connect(this.templateComboBox, JDBCDriverManager.getDefault(), string);
        ConnectionProgressListener connectionProgressListener = new ConnectionProgressListener(){

            public void connectionStarted() {
                NewConnectionPanel.this.startProgress();
            }

            public void connectionStep(String string) {
                NewConnectionPanel.this.setProgressMessage(string);
            }

            public void connectionFinished() {
                NewConnectionPanel.this.stopProgress(true);
            }

            public void connectionFailed() {
                NewConnectionPanel.this.stopProgress(false);
            }
        };
        connectionDialogMediator.addConnectionProgressListener(connectionProgressListener);
        this.userField.setText(databaseConnection.getUser());
        this.passwordField.setText(databaseConnection.getPassword());
        String string2 = databaseConnection.getDriver();
        String string3 = databaseConnection.getDriverName();
        if (string2 != null && string3 != null) {
            for (int i = 0; i < this.templateComboBox.getItemCount(); ++i) {
                Map.Entry<String, UrlField> entry = this.templateComboBox.getItemAt(i);
                if (!(entry instanceof JdbcUrl)) continue;
                JdbcUrl jdbcUrl = (JdbcUrl)((Object)entry);
                assert (jdbcUrl.getDriver() != null);
                if (!jdbcUrl.getClassName().equals(string2) || !jdbcUrl.getDriver().getName().equals(string3)) continue;
                this.templateComboBox.setSelectedIndex(i);
                break;
            }
        }
        for (Map.Entry<String, UrlField> entry : this.urlFields.entrySet()) {
            entry.getValue().getField().getDocument().addDocumentListener(this);
        }
        this.templateComboBox.getModel().addListDataListener(this);
        this.urlField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                NewConnectionPanel.this.updateFieldsFromUrl();
            }
        });
        this.urlField.setVisible(false);
        this.urlLabel.setVisible(false);
        this.showUrlCheckBox.setSelected(false);
        this.setUrlField();
        this.updateFieldsFromUrl();
        this.setUpFields();
    }

    public void setWindow(Window window) {
        this.window = window;
    }

    private void initAccessibility() {
        ResourceBundle resourceBundle = NbBundle.getBundle((String)BUNDLE);
        this.templateLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_NewConnectionDriverNameA11yDesc"));
        this.templateComboBox.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_NewConnectionDriverNameComboBoxA11yName"));
        this.userLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_NewConnectionUserNameA11yDesc"));
        this.userField.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_NewConnectionUserNameTextFieldA11yName"));
        this.passwordLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_NewConnectionPasswordA11yDesc"));
        this.passwordField.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_NewConnectionPasswordTextFieldA11yName"));
        this.hostLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_NewConnectionHostA11yDesc"));
        this.hostField.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_NewConnectionHostTextFieldA11yName"));
        this.portLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_NewConnectionPortA11yDesc"));
        this.portField.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_NewConnectionPortTextFieldA11yName"));
        this.serverNameField.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_NewConnectionServerNameTextFieldA11yName"));
        this.serverNameLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_NewConnectionServerNameA11yDesc"));
        this.databaseField.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_NewConnectionDatabaseNameTextFieldA11yName"));
        this.databaseLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_NewConnectionDatabaseNameA11yDesc"));
        this.additionalPropsField.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_NewConnectionAdditionalPropertiesTextFieldA11yName"));
        this.additionalPropsLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_NewConnectionAdditionalPropertiesA11yDesc"));
        this.urlField.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_NewConnectionJDBCURLTextFieldA11yName"));
        this.urlLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_NewConnectionJDBCURLA11yDesc"));
        this.sidField.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_NewConnectionSIDTextFieldA11yName"));
        this.sidLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_NewConnectionSIDA11yDesc"));
        this.serviceField.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_NewConnectionServiceNameTextFieldA11yName"));
        this.serviceLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_NewConnectionServiceNameA11yDesc"));
        this.tnsField.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_NewConnectionTNSNameTextFieldA11yName"));
        this.tnsLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_NewConnectionTNSNameA11yDesc"));
        this.dsnField.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_NewConnectionDSNTextFieldA11yName"));
        this.dsnLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_NewConnectionDSNA11yDesc"));
        this.instanceField.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_NewConnectionInstanceNameTextFieldA11yName"));
        this.instanceLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_NewConnectionInstanceNameA11yDesc"));
    }

    public void initializeFocus() {
        this.setFocus();
    }

    private void initComponents() {
        this.templateLabel = new JLabel();
        this.templateComboBox = new JComboBox();
        this.userField = new JTextField();
        this.additionalPropsField = new JTextField();
        this.serverNameLabel = new JLabel();
        this.serverNameField = new JTextField();
        this.userLabel = new JLabel();
        this.databaseField = new JTextField();
        this.portField = new JTextField();
        this.portLabel = new JLabel();
        this.hostLabel = new JLabel();
        this.passwordLabel = new JLabel();
        this.passwordCheckBox = new JCheckBox();
        this.additionalPropsLabel = new JLabel();
        this.hostField = new JTextField();
        this.passwordField = new JPasswordField();
        this.databaseLabel = new JLabel();
        this.showUrlCheckBox = new JCheckBox();
        this.urlField = new JTextField();
        this.urlLabel = new JLabel();
        this.errorLabel = new JLabel();
        this.sidField = new JTextField();
        this.serviceField = new JTextField();
        this.tnsField = new JTextField();
        this.dsnField = new JTextField();
        this.sidLabel = new JLabel();
        this.serviceLabel = new JLabel();
        this.tnsLabel = new JLabel();
        this.dsnLabel = new JLabel();
        this.instanceField = new JTextField();
        this.instanceLabel = new JLabel();
        FormListener formListener = new FormListener();
        this.templateLabel.setLabelFor(this.templateComboBox);
        Mnemonics.setLocalizedText((JLabel)this.templateLabel, (String)NbBundle.getBundle((String)BUNDLE).getString("NewConnectionDriverName"));
        this.templateComboBox.setToolTipText(NbBundle.getBundle((String)BUNDLE).getString("ACS_NewConnectionDriverNameComboBoxA11yDesc"));
        this.templateComboBox.addItemListener(formListener);
        this.templateComboBox.addActionListener(formListener);
        this.userField.setColumns(50);
        this.userField.setToolTipText(NbBundle.getBundle((String)BUNDLE).getString("ACS_NewConnectionUserNameTextFieldA11yDesc"));
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/db/resources/Bundle");
        this.additionalPropsField.setToolTipText(resourceBundle.getString("ACS_NewConnectionAdditionalPropertiesA11yDesc"));
        this.additionalPropsField.addActionListener(formListener);
        this.serverNameLabel.setLabelFor(this.serverNameField);
        Mnemonics.setLocalizedText((JLabel)this.serverNameLabel, (String)resourceBundle.getString("NewConnectionServerName"));
        this.serverNameField.setToolTipText(resourceBundle.getString("ACS_NewConnectionServerNameA11yDesc"));
        this.serverNameField.addActionListener(formListener);
        this.userLabel.setLabelFor(this.userField);
        Mnemonics.setLocalizedText((JLabel)this.userLabel, (String)NbBundle.getBundle((String)BUNDLE).getString("NewConnectionUserName"));
        this.databaseField.setToolTipText(resourceBundle.getString("ACS_NewConnectionDatabaseNameA11yDesc"));
        this.databaseField.addActionListener(formListener);
        this.portField.setToolTipText(resourceBundle.getString("ACS_NewConnectionPortA11yDesc"));
        this.portField.addActionListener(formListener);
        this.portLabel.setLabelFor(this.portField);
        Mnemonics.setLocalizedText((JLabel)this.portLabel, (String)resourceBundle.getString("NewConnectionPort"));
        this.hostLabel.setLabelFor(this.hostField);
        Mnemonics.setLocalizedText((JLabel)this.hostLabel, (String)resourceBundle.getString("NewConnectionHost"));
        this.passwordLabel.setLabelFor(this.passwordField);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getBundle((String)BUNDLE).getString("NewConnectionPassword"));
        Mnemonics.setLocalizedText((AbstractButton)this.passwordCheckBox, (String)NbBundle.getBundle((String)BUNDLE).getString("NewConnectionRememberPassword"));
        this.passwordCheckBox.setToolTipText(NbBundle.getBundle((String)BUNDLE).getString("ACS_NewConnectionRememberPasswordA11yDesc"));
        this.passwordCheckBox.setVerticalTextPosition(1);
        this.additionalPropsLabel.setLabelFor(this.additionalPropsField);
        Mnemonics.setLocalizedText((JLabel)this.additionalPropsLabel, (String)resourceBundle.getString("NewConnectionAdditionalProperties"));
        this.hostField.setText("localhost");
        this.hostField.setToolTipText(resourceBundle.getString("ACS_NewConnectionHostA11yDesc"));
        this.hostField.addActionListener(formListener);
        this.hostField.addFocusListener(formListener);
        this.passwordField.setColumns(50);
        this.passwordField.setToolTipText(NbBundle.getBundle((String)BUNDLE).getString("ACS_NewConnectionPasswordTextFieldA11yDesc"));
        this.databaseLabel.setLabelFor(this.databaseField);
        Mnemonics.setLocalizedText((JLabel)this.databaseLabel, (String)resourceBundle.getString("NewConnectionDatabase"));
        Mnemonics.setLocalizedText((AbstractButton)this.showUrlCheckBox, (String)resourceBundle.getString("NewConnectionShowJDBCURL"));
        this.showUrlCheckBox.setToolTipText("Check this to show or hide the JDBC URL");
        this.showUrlCheckBox.addActionListener(formListener);
        this.urlField.setToolTipText(resourceBundle.getString("ACS_NewConnectionJDBCURLA11yDesc"));
        this.urlField.addActionListener(formListener);
        this.urlField.addFocusListener(formListener);
        this.urlField.addKeyListener(formListener);
        this.urlLabel.setLabelFor(this.urlField);
        Mnemonics.setLocalizedText((JLabel)this.urlLabel, (String)NbBundle.getBundle((String)BUNDLE).getString("NewConnectionDatabaseURL"));
        this.urlLabel.setFocusable(false);
        this.errorLabel.setForeground(new Color(255, 0, 0));
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)"Error label");
        this.sidField.setToolTipText(resourceBundle.getString("ACS_NewConnectionSIDA11yDesc"));
        this.serviceField.setToolTipText(resourceBundle.getString("ACS_NewConnectionServiceNameA11yDesc"));
        this.tnsField.setToolTipText(resourceBundle.getString("ACS_NewConnectionTNSNameA11yDesc"));
        this.dsnField.setToolTipText(resourceBundle.getString("ACS_NewConnectionDSNA11yDesc"));
        this.sidLabel.setLabelFor(this.sidField);
        Mnemonics.setLocalizedText((JLabel)this.sidLabel, (String)resourceBundle.getString("NewConnectionSID"));
        this.serviceLabel.setLabelFor(this.serviceField);
        Mnemonics.setLocalizedText((JLabel)this.serviceLabel, (String)resourceBundle.getString("NewConnectionServiceName"));
        Mnemonics.setLocalizedText((JLabel)this.tnsLabel, (String)resourceBundle.getString("NewConnectionTNSName"));
        Mnemonics.setLocalizedText((JLabel)this.dsnLabel, (String)resourceBundle.getString("NewConnectionDSN"));
        this.instanceField.setToolTipText(resourceBundle.getString("ACS_NewConnectionInstanceNameA11yDesc"));
        this.instanceLabel.setLabelFor(this.instanceField);
        Mnemonics.setLocalizedText((JLabel)this.instanceLabel, (String)resourceBundle.getString("NewConnectionInstanceName"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.passwordLabel).add((Component)this.userLabel).add((Component)this.hostLabel).add((Component)this.databaseLabel).add((Component)this.portLabel).add((Component)this.templateLabel).add((Component)this.sidLabel).add((Component)this.serviceLabel).add((Component)this.tnsLabel).add((Component)this.dsnLabel).add((Component)this.serverNameLabel).add((Component)this.instanceLabel).add((Component)this.urlLabel)).add(27, 27, 27).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.dsnField, -1, 429, Short.MAX_VALUE).add(2, (Component)this.templateComboBox, 0, 429, Short.MAX_VALUE).add(2, (Component)this.hostField, -1, 429, Short.MAX_VALUE).add(2, (Component)this.portField, -1, 429, Short.MAX_VALUE).add(2, (Component)this.databaseField, -1, 429, Short.MAX_VALUE).add(2, (Component)this.sidField, -1, 429, Short.MAX_VALUE).add(2, (Component)this.serviceField, -1, 429, Short.MAX_VALUE).add(2, (Component)this.tnsField, -1, 429, Short.MAX_VALUE).add(2, (Component)this.instanceField, -1, 429, Short.MAX_VALUE).add(2, (Component)this.passwordField, -1, 429, Short.MAX_VALUE).add(2, (Component)this.userField, -1, 429, Short.MAX_VALUE).add(2, (Component)this.serverNameField, -1, 429, Short.MAX_VALUE).add(2, (Component)this.urlField, -1, 429, Short.MAX_VALUE).add((Component)this.passwordCheckBox, -2, 308, -2))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.additionalPropsLabel).add(18, 18, 18).add((Component)this.additionalPropsField, -1, 429, Short.MAX_VALUE))).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.errorLabel, -1, 552, Short.MAX_VALUE).add(23, 23, 23)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.showUrlCheckBox, -1, -1, Short.MAX_VALUE).add(454, 454, 454)))));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.templateLabel).add((Component)this.templateComboBox, -2, 27, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.hostLabel).add((Component)this.hostField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.portLabel).add((Component)this.portField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.databaseLabel).add((Component)this.databaseField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.sidLabel).add((Component)this.sidField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.serviceLabel).add((Component)this.serviceField, -2, -1, -2)).add(4, 4, 4).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.tnsLabel).add((Component)this.tnsField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.dsnLabel).add((Component)this.dsnField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.serverNameLabel).add((Component)this.serverNameField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.instanceLabel).add((Component)this.instanceField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.userLabel).add((Component)this.userField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.passwordLabel).add((Component)this.passwordField, -2, -1, -2)).add(11, 11, 11).add((Component)this.passwordCheckBox).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.additionalPropsLabel).add((Component)this.additionalPropsField, -2, -1, -2)).add(18, 18, 18).add((Component)this.showUrlCheckBox).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.urlField, -2, -1, -2).add((Component)this.urlLabel)).addPreferredGap(0).add((Component)this.errorLabel).addContainerGap(35, Short.MAX_VALUE)));
        groupLayout.linkSize(new Component[]{this.hostField, this.passwordField, this.portField, this.templateComboBox, this.userField, this.userLabel}, 2);
        this.additionalPropsField.getAccessibleContext().setAccessibleDescription("Specify additional JDBC properties here.  This needs to be in the format expected by this JDBC driver.");
        this.serverNameField.getAccessibleContext().setAccessibleName("Server Name");
        this.serverNameField.getAccessibleContext().setAccessibleDescription("The server name for this connection");
    }

    private void templateComboBoxItemStateChanged(ItemEvent itemEvent) {
        this.setUpFields();
    }

    private void templateComboBoxActionPerformed(ActionEvent actionEvent) {
        this.setUpFields();
    }

    private void hostFieldActionPerformed(ActionEvent actionEvent) {
    }

    private void showUrlCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.showUrl();
    }

    private void showUrl() {
        this.urlLabel.setVisible(this.showUrlCheckBox.isSelected());
        if (this.showUrlCheckBox.isSelected()) {
            this.updateUrlFromFields();
        }
        this.urlField.setVisible(this.showUrlCheckBox.isSelected());
        this.resize();
    }

    private void portFieldActionPerformed(ActionEvent actionEvent) {
    }

    private void databaseFieldActionPerformed(ActionEvent actionEvent) {
    }

    private void serverNameFieldActionPerformed(ActionEvent actionEvent) {
    }

    private void additionalPropsFieldActionPerformed(ActionEvent actionEvent) {
    }

    private void urlFieldActionPerformed(ActionEvent actionEvent) {
    }

    private void hostFieldFocusLost(FocusEvent focusEvent) {
    }

    private void urlFieldKeyPressed(KeyEvent keyEvent) {
    }

    private void urlFieldFocusLost(FocusEvent focusEvent) {
    }

    public void setConnectionInfo() {
        JdbcUrl jdbcUrl = this.getSelectedJdbcUrl();
        if (jdbcUrl != null) {
            JDBCDriver jDBCDriver = jdbcUrl.getDriver();
            assert (jDBCDriver != null);
            this.connection.setDriverName(jDBCDriver.getName());
            this.connection.setDriver(jDBCDriver.getClassName());
        }
        this.connection.setDatabase(this.urlField.getText());
        this.connection.setUser(this.userField.getText());
        this.connection.setPassword(this.getPassword());
        this.connection.setRememberPassword(this.passwordCheckBox.isSelected());
    }

    private void resize() {
        this.revalidate();
        if (this.window != null) {
            this.window.pack();
        }
    }

    private void setUpFields() {
        Object object = this.templateComboBox.getSelectedItem();
        if (object != null && !(object instanceof JdbcUrl)) {
            return;
        }
        JdbcUrl jdbcUrl = (JdbcUrl)object;
        if (jdbcUrl == null) {
            for (Map.Entry<String, UrlField> entry : this.urlFields.entrySet()) {
                entry.getValue().getField().setVisible(false);
                entry.getValue().getLabel().setVisible(false);
            }
            this.showUrlCheckBox.setVisible(false);
            this.urlField.setVisible(false);
            this.urlLabel.setVisible(false);
            this.checkValid();
            this.resize();
            return;
        }
        this.userField.setVisible(true);
        this.userLabel.setVisible(true);
        this.passwordField.setVisible(true);
        this.passwordLabel.setVisible(true);
        this.passwordCheckBox.setVisible(true);
        Font font = this.templateLabel.getFont();
        Font font2 = font.deriveFont(1);
        for (Map.Entry<String, UrlField> entry : this.urlFields.entrySet()) {
            entry.getValue().getField().setVisible(jdbcUrl.supportsToken(entry.getKey()));
            entry.getValue().getLabel().setVisible(jdbcUrl.supportsToken(entry.getKey()));
            entry.getValue().getLabel().setFont(jdbcUrl.requiresToken(entry.getKey()) ? font2 : font);
        }
        if (!jdbcUrl.urlIsParsed()) {
            this.showUrlCheckBox.setVisible(false);
            this.urlField.setVisible(true);
            this.urlLabel.setVisible(true);
        } else {
            this.showUrl();
        }
        this.setFocus();
        this.setUrlField();
        this.checkValid();
        this.resize();
    }

    private void setFocus() {
        if (this.templateComboBox.getItemCount() <= 1) {
            this.templateComboBox.requestFocusInWindow();
            return;
        }
        for (Map.Entry<String, UrlField> entry : this.urlFields.entrySet()) {
            if (!entry.getValue().getField().isVisible()) continue;
            entry.getValue().getField().requestFocusInWindow();
            return;
        }
        this.userField.requestFocusInWindow();
    }

    private JdbcUrl getSelectedJdbcUrl() {
        Object object = this.templateComboBox.getSelectedItem();
        if (!(object instanceof JdbcUrl)) {
            return null;
        }
        return (JdbcUrl)object;
    }

    private void setUrlField() {
        if (!this.connection.getDatabase().equals("")) {
            this.urlField.setText(this.connection.getDatabase());
            return;
        }
        JdbcUrl jdbcUrl = this.getSelectedJdbcUrl();
        if (jdbcUrl == null) {
            this.urlField.setText("");
            return;
        }
        if (jdbcUrl.urlIsParsed()) {
            this.updateUrlFromFields();
        } else {
            this.urlField.setText(jdbcUrl.getUrlTemplate());
        }
    }

    private String getPassword() {
        String string = new String(this.passwordField.getPassword());
        String string2 = string.length() > 0 ? string : null;
        return string2;
    }

    public String getTitle() {
        return NbBundle.getBundle((String)BUNDLE).getString("NewConnectionDialogTitle");
    }

    private void startProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NewConnectionPanel.this.progressHandle = ProgressHandleFactory.createHandle((String)NewConnectionPanel.getMessage("ConnectionProgress_Connecting", new Object[0]));
                NewConnectionPanel.this.progressHandle.start();
            }
        });
    }

    private void setProgressMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (NewConnectionPanel.this.progressHandle != null) {
                    NewConnectionPanel.this.progressHandle.setDisplayName(string);
                }
            }
        });
    }

    private void stopProgress(boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (NewConnectionPanel.this.progressHandle != null) {
                    NewConnectionPanel.this.progressHandle.finish();
                }
            }
        });
    }

    private void resetProgress() {
        if (this.progressHandle != null) {
            this.progressHandle.setDisplayName("");
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateUrlFromFields();
        this.fireChange();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateUrlFromFields();
        this.fireChange();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateUrlFromFields();
        this.fireChange();
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.updateUrlFromFields();
        this.fireChange();
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.fireChange();
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.fireChange();
    }

    private void fireChange() {
        this.firePropertyChange("argumentChanged", null, null);
        this.resetProgress();
    }

    private void updateUrlFromFields() {
        JdbcUrl jdbcUrl = this.getSelectedJdbcUrl();
        if (jdbcUrl == null || !jdbcUrl.urlIsParsed()) {
            return;
        }
        if (!this.updatingUrl) {
            this.updatingFields = true;
            for (Map.Entry<String, UrlField> entry : this.urlFields.entrySet()) {
                jdbcUrl.put(entry.getKey(), entry.getValue().getField().getText());
            }
            this.urlField.setText(jdbcUrl.getUrl());
            this.updatingFields = false;
        }
        this.checkValid();
    }

    private void checkValid() {
        JdbcUrl jdbcUrl = this.getSelectedJdbcUrl();
        boolean bl = false;
        if (jdbcUrl == null) {
            this.displayError(NewConnectionPanel.getMessage("NewConnection.MSG_SelectADriver", new Object[0]));
        } else if (jdbcUrl != null && jdbcUrl.urlIsParsed()) {
            for (Map.Entry<String, UrlField> entry : this.urlFields.entrySet()) {
                if (!jdbcUrl.requiresToken(entry.getKey()) || !this.isEmpty(entry.getValue().getField().getText())) continue;
                bl = true;
                this.displayError(NewConnectionPanel.getMessage("NewConnection.ERR_FieldRequired", entry.getValue().getLabel().getText()));
            }
            if (!bl) {
                this.clearError();
            }
        } else if (this.isEmpty(this.urlField.getText())) {
            this.displayError(NewConnectionPanel.getMessage("NewConnection.MSG_SpecifyURL", new Object[0]));
        } else {
            this.clearError();
        }
    }

    private boolean isEmpty(String string) {
        return string == null || string.equals("");
    }

    private void updateFieldsFromUrl() {
        JdbcUrl jdbcUrl = this.getSelectedJdbcUrl();
        if (jdbcUrl == null) {
            return;
        }
        if (this.updatingFields) {
            return;
        }
        try {
            jdbcUrl.setUrl(this.urlField.getText());
            this.clearError();
        }
        catch (MalformedURLException malformedURLException) {
            LOGGER.log(Level.FINE, null, malformedURLException);
            this.displayError(malformedURLException.getMessage());
            return;
        }
        if (jdbcUrl.urlIsParsed()) {
            this.updatingUrl = true;
            for (Map.Entry<String, UrlField> entry : this.urlFields.entrySet()) {
                entry.getValue().getField().setText((String)jdbcUrl.get(entry.getKey()));
            }
            this.updatingUrl = false;
        }
    }

    private void clearError() {
        this.errorLabel.setText("");
        this.errorLabel.setVisible(false);
        this.mediator.setValid(true);
        this.resize();
    }

    private void displayError(String string) {
        this.errorLabel.setText(string);
        this.errorLabel.setVisible(true);
        this.mediator.setValid(false);
        this.resize();
    }

    private class UrlField {
        private final JTextField field;
        private final JLabel label;

        public UrlField(JTextField jTextField, JLabel jLabel) {
            this.field = jTextField;
            this.label = jLabel;
        }

        public JTextField getField() {
            return this.field;
        }

        public JLabel getLabel() {
            return this.label;
        }
    }

    private class FormListener
    implements ActionListener,
    FocusListener,
    ItemListener,
    KeyListener {
        FormListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == NewConnectionPanel.this.templateComboBox) {
                NewConnectionPanel.this.templateComboBoxActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == NewConnectionPanel.this.additionalPropsField) {
                NewConnectionPanel.this.additionalPropsFieldActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == NewConnectionPanel.this.serverNameField) {
                NewConnectionPanel.this.serverNameFieldActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == NewConnectionPanel.this.databaseField) {
                NewConnectionPanel.this.databaseFieldActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == NewConnectionPanel.this.portField) {
                NewConnectionPanel.this.portFieldActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == NewConnectionPanel.this.hostField) {
                NewConnectionPanel.this.hostFieldActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == NewConnectionPanel.this.showUrlCheckBox) {
                NewConnectionPanel.this.showUrlCheckBoxActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == NewConnectionPanel.this.urlField) {
                NewConnectionPanel.this.urlFieldActionPerformed(actionEvent);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.getSource() == NewConnectionPanel.this.hostField) {
                NewConnectionPanel.this.hostFieldFocusLost(focusEvent);
            } else if (focusEvent.getSource() == NewConnectionPanel.this.urlField) {
                NewConnectionPanel.this.urlFieldFocusLost(focusEvent);
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() == NewConnectionPanel.this.templateComboBox) {
                NewConnectionPanel.this.templateComboBoxItemStateChanged(itemEvent);
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getSource() == NewConnectionPanel.this.urlField) {
                NewConnectionPanel.this.urlFieldKeyPressed(keyEvent);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

