/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.lib.ddl.DBConnection;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.modules.db.ExceptionListener;
import org.netbeans.modules.db.explorer.DatabaseConnectionAccessor;
import org.netbeans.modules.db.explorer.DatabaseUILogger;
import org.netbeans.modules.db.explorer.DbDriverManager;
import org.netbeans.modules.db.explorer.DerbyConectionEventListener;
import org.netbeans.modules.db.explorer.OpenConnection;
import org.netbeans.modules.db.explorer.OpenConnectionInterface;
import org.netbeans.modules.db.explorer.actions.ConnectAction;
import org.netbeans.modules.db.explorer.infos.ConnectionNodeInfo;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.nodes.DatabaseNode;
import org.netbeans.modules.db.explorer.nodes.RootNode;
import org.netbeans.modules.db.runtime.DatabaseRuntimeManager;
import org.netbeans.spi.db.explorer.DatabaseRuntime;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class DatabaseConnection
implements DBConnection {
    private static final Logger LOGGER = Logger.getLogger(DatabaseConnection.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    static final long serialVersionUID = 4554639187416958735L;
    private Set exceptionListeners = Collections.synchronizedSet(new HashSet());
    private Connection con;
    private String drv;
    private String drvname;
    private String db;
    private String usr;
    private String schema;
    private String pwd = "";
    private Boolean rpwd = Boolean.FALSE;
    private PropertyChangeSupport propertySupport;
    private String name;
    private transient org.netbeans.api.db.explorer.DatabaseConnection dbconn = DatabaseConnectionAccessor.DEFAULT.createDatabaseConnection(this);
    private static final String SUPPORT = "_schema_support";
    public static final String PROP_DRIVER = "driver";
    public static final String PROP_DATABASE = "database";
    public static final String PROP_USER = "user";
    public static final String PROP_PASSWORD = "password";
    public static final String PROP_REMEMBER_PASSWORD = "rememberpwd";
    public static final String PROP_SCHEMA = "schema";
    public static final String PROP_DRIVERNAME = "drivername";
    public static final String PROP_NAME = "name";
    private OpenConnectionInterface openConnection = null;
    private static final Lookup.Result openConnectionLookupResult;
    private static Collection openConnectionServices;

    public DatabaseConnection() {
        this.propertySupport = new PropertyChangeSupport(this);
    }

    public DatabaseConnection(String string, String string2, String string3, String string4) {
        this(string, null, string2, null, string3, string4, false);
    }

    public DatabaseConnection(String string, String string2, String string3, String string4, String string5, String string6) {
        this(string, string2, string3, string4, string5, string6, false);
    }

    public DatabaseConnection(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
        this();
        this.drv = string;
        this.drvname = string2;
        this.db = string3;
        this.usr = string5;
        this.schema = string4;
        this.pwd = string6;
        this.name = this.getName();
        this.rpwd = bl;
    }

    public JDBCDriver findJDBCDriver() {
        JDBCDriver[] jDBCDriverArray = JDBCDriverManager.getDefault().getDrivers(this.drv);
        if (jDBCDriverArray.length <= 0) {
            return null;
        }
        JDBCDriver jDBCDriver = jDBCDriverArray[0];
        for (int i = 0; i < jDBCDriverArray.length; ++i) {
            if (!jDBCDriverArray[i].getName().equals(this.getDriverName())) continue;
            jDBCDriver = jDBCDriverArray[i];
            break;
        }
        return jDBCDriver;
    }

    private Collection getOpenConnections() {
        if (openConnectionServices == null) {
            openConnectionServices = openConnectionLookupResult.allInstances();
        }
        return openConnectionServices;
    }

    private OpenConnectionInterface getOpenConnection() {
        if (this.openConnection != null) {
            return this.openConnection;
        }
        this.openConnection = new OpenConnection();
        String string = this.getDriver();
        if (string == null) {
            return this.openConnection;
        }
        try {
            Collection collection = this.getOpenConnections();
            Iterator iterator = collection.iterator();
            while (string != null && iterator.hasNext()) {
                OpenConnectionInterface openConnectionInterface = (OpenConnectionInterface)iterator.next();
                if (!openConnectionInterface.isFor(string)) continue;
                this.openConnection = openConnectionInterface;
                break;
            }
        }
        catch (Exception exception) {
            Logger.getLogger("global").log(Level.INFO, null, exception);
        }
        return this.openConnection;
    }

    public String getDriver() {
        return this.drv;
    }

    public void setDriver(String string) {
        if (string == null || string.equals(this.drv)) {
            return;
        }
        String string2 = this.drv;
        this.drv = string;
        this.propertySupport.firePropertyChange(PROP_DRIVER, string2, this.drv);
        this.openConnection = null;
    }

    public String getDriverName() {
        return this.drvname;
    }

    public void setDriverName(String string) {
        if (string == null || string.equals(this.drvname)) {
            return;
        }
        String string2 = this.drvname;
        this.drvname = string;
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_DRIVERNAME, string2, this.drvname);
        }
    }

    public String getDatabase() {
        if (this.db == null) {
            this.db = "";
        }
        return this.db;
    }

    public void setDatabase(String string) {
        if (string == null || string.equals(this.db)) {
            return;
        }
        String string2 = this.db;
        this.db = string;
        this.name = null;
        this.name = this.getName();
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_DATABASE, string2, this.db);
        }
    }

    public String getUser() {
        if (this.usr == null) {
            this.usr = "";
        }
        return this.usr;
    }

    public void setUser(String string) {
        if (string == null || string.equals(this.usr)) {
            return;
        }
        String string2 = this.usr;
        this.usr = string;
        this.name = null;
        this.name = this.getName();
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_USER, string2, this.usr);
        }
    }

    public String getName() {
        ResourceBundle resourceBundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
        if (this.name == null) {
            this.name = this.getSchema() == null || this.getSchema().length() == 0 ? MessageFormat.format(resourceBundle.getString("ConnectionNodeUniqueName"), this.getDatabase(), this.getUser(), resourceBundle.getString("SchemaIsNotSet")) : MessageFormat.format(resourceBundle.getString("ConnectionNodeUniqueName"), this.getDatabase(), this.getUser(), this.getSchema());
        }
        return this.name;
    }

    public void setName(String string) {
        if (this.name == null || this.name.equals(string)) {
            return;
        }
        String string2 = this.name;
        this.name = string;
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_NAME, string2, this.name);
        }
    }

    public String getSchema() {
        if (this.schema == null) {
            this.schema = "";
        }
        return this.schema;
    }

    public void setSchema(String string) {
        if (string == null || string.equals(this.schema)) {
            return;
        }
        String string2 = this.schema;
        this.schema = string;
        this.name = null;
        this.name = this.getName();
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_SCHEMA, string2, this.schema);
        }
    }

    public boolean rememberPassword() {
        return this.rpwd;
    }

    public void setRememberPassword(boolean bl) {
        Boolean bl2 = this.rpwd;
        this.rpwd = bl;
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_REMEMBER_PASSWORD, bl2, this.rpwd);
        }
    }

    public String getPassword() {
        return this.pwd;
    }

    public void setPassword(String string) {
        if (string == null || string.equals(this.pwd)) {
            return;
        }
        String string2 = this.pwd;
        if (string.length() == 0) {
            string = null;
        }
        this.pwd = string;
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_PASSWORD, string2, this.pwd);
        }
    }

    public Connection createJDBCConnection() throws DDLException {
        if (LOG) {
            LOGGER.log(Level.FINE, "createJDBCConnection()");
        }
        if (this.drv == null || this.db == null || this.usr == null) {
            throw new DDLException(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("EXC_InsufficientConnInfo"));
        }
        Properties properties = new Properties();
        if (this.usr != null && this.usr.length() > 0) {
            properties.put(PROP_USER, this.usr);
            properties.put(PROP_PASSWORD, this.pwd);
        }
        try {
            this.propertySupport.firePropertyChange("connecting", null, null);
            this.getOpenConnection().enable();
            this.startRuntimes();
            DerbyConectionEventListener.getDefault().beforeConnect(this);
            JDBCDriver jDBCDriver = this.findJDBCDriver();
            if (jDBCDriver == null) {
                Class.forName(this.drv);
            }
            Connection connection = DbDriverManager.getDefault().getConnection(this.db, properties, jDBCDriver);
            this.setConnection(connection);
            DatabaseUILogger.logConnection(this.drv);
            this.propertySupport.firePropertyChange("connected", null, null);
            this.getOpenConnection().disable();
            return connection;
        }
        catch (SQLException sQLException) {
            String string = MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("EXC_CannotEstablishConnection"), this.db, this.drv, sQLException.getMessage());
            this.propertySupport.firePropertyChange("failed", null, null);
            this.getOpenConnection().disable();
            this.initSQLException(sQLException);
            DDLException dDLException = new DDLException(string);
            dDLException.initCause(sQLException);
            throw dDLException;
        }
        catch (Exception exception) {
            String string = MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("EXC_CannotEstablishConnection"), this.db, this.drv, exception.getMessage());
            this.propertySupport.firePropertyChange("failed", null, null);
            this.getOpenConnection().disable();
            DDLException dDLException = new DDLException(string);
            dDLException.initCause(exception);
            throw dDLException;
        }
    }

    public void connectSync() throws DatabaseException {
        try {
            this.doConnect();
            ConnectionNodeInfo connectionNodeInfo = this.findConnectionNodeInfo(this.getName());
            assert (connectionNodeInfo != null);
            connectionNodeInfo.connect(this);
        }
        catch (Exception exception) {
            try {
                this.getConnection().close();
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.FINE, null, sQLException);
            }
            throw new DatabaseException(exception);
        }
    }

    private void doConnect() throws DDLException {
        if (this.drv == null || this.db == null || this.usr == null) {
            this.sendException(new DDLException(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("EXC_InsufficientConnInfo")));
        }
        Properties properties = new Properties();
        if (this.usr.length() > 0) {
            properties.put(PROP_USER, this.usr);
        }
        if (this.pwd != null && this.pwd.length() > 0) {
            properties.put(PROP_PASSWORD, this.pwd);
        }
        Connection connection = null;
        try {
            this.propertySupport.firePropertyChange("connecting", null, null);
            this.getOpenConnection().enable();
            this.startRuntimes();
            DerbyConectionEventListener.getDefault().beforeConnect(this);
            JDBCDriver jDBCDriver = this.findJDBCDriver();
            if (jDBCDriver == null) {
                Class.forName(this.drv);
            }
            connection = DbDriverManager.getDefault().getConnection(this.db, properties, jDBCDriver);
            this.setConnection(connection);
            DatabaseUILogger.logConnection(this.drv);
            this.propertySupport.firePropertyChange("connected", null, null);
        }
        catch (Exception exception) {
            String string = MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("EXC_CannotEstablishConnection"), this.db, this.drv, exception.getMessage());
            this.propertySupport.firePropertyChange("failed", null, null);
            if (exception instanceof SQLException) {
                this.initSQLException((SQLException)exception);
            }
            DDLException dDLException = new DDLException(string);
            dDLException.initCause(exception);
            if (connection != null) {
                this.setConnection(null);
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    Logger.getLogger("global").log(Level.WARNING, null, sQLException);
                }
            }
            throw dDLException;
        }
        finally {
            this.getOpenConnection().disable();
        }
    }

    public void connectAsync() {
        if (LOG) {
            LOGGER.log(Level.FINE, "connect()");
        }
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                try {
                    DatabaseConnection.this.doConnect();
                }
                catch (Exception exception) {
                    DatabaseConnection.this.sendException(exception);
                }
            }
        }, 0);
    }

    private void initSQLException(SQLException sQLException) {
        SQLException sQLException2 = sQLException.getNextException();
        while (sQLException2 != null) {
            try {
                sQLException.initCause(sQLException2);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            sQLException = sQLException2;
            sQLException2 = sQLException.getNextException();
        }
    }

    private void startRuntimes() {
        DatabaseRuntime[] databaseRuntimeArray = DatabaseRuntimeManager.getDefault().getRuntimes(this.drv);
        for (int i = 0; i < databaseRuntimeArray.length; ++i) {
            DatabaseRuntime databaseRuntime = databaseRuntimeArray[i];
            if (databaseRuntime.isRunning() || !databaseRuntime.canStart() || !databaseRuntime.acceptsDatabaseURL(this.db)) continue;
            databaseRuntime.start();
        }
    }

    public void addExceptionListener(ExceptionListener exceptionListener) {
        if (exceptionListener != null) {
            this.exceptionListeners.add(exceptionListener);
        }
    }

    public void removeExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListeners.remove(exceptionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendException(Exception exception) {
        Set set = this.exceptionListeners;
        synchronized (set) {
            for (ExceptionListener exceptionListener : this.exceptionListeners) {
                exceptionListener.exceptionOccurred(exception);
            }
        }
    }

    public void setConnection(Connection connection) {
        this.con = connection;
    }

    public Connection getConnection() {
        return this.con;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public int hashCode() {
        return this.drv.hashCode() + this.db.hashCode() + this.usr.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof DBConnection) {
            DBConnection dBConnection = (DBConnection)object;
            return this.toString().equals(dBConnection.toString());
        }
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.drv = (String)objectInputStream.readObject();
        this.db = (String)objectInputStream.readObject();
        this.usr = (String)objectInputStream.readObject();
        this.schema = (String)objectInputStream.readObject();
        this.rpwd = Boolean.FALSE;
        this.name = (String)objectInputStream.readObject();
        try {
            this.drvname = (String)objectInputStream.readObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.name == null || !this.name.equals(SUPPORT)) {
            this.schema = null;
        }
        this.name = null;
        this.name = this.getName();
        this.dbconn = DatabaseConnectionAccessor.DEFAULT.createDatabaseConnection(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.drv);
        objectOutputStream.writeObject(this.db);
        objectOutputStream.writeObject(this.usr);
        objectOutputStream.writeObject(this.schema);
        objectOutputStream.writeObject(SUPPORT);
        objectOutputStream.writeObject(this.drvname);
    }

    public String toString() {
        return "Driver:" + this.getDriver() + "Database:" + this.getDatabase().toLowerCase() + "User:" + this.getUser().toLowerCase() + "Schema:" + this.getSchema().toLowerCase();
    }

    public org.netbeans.api.db.explorer.DatabaseConnection getDatabaseConnection() {
        return this.dbconn;
    }

    public void selectInExplorer() {
        String string = null;
        try {
            string = this.findConnectionNodeInfo(this.getName()).getName();
        }
        catch (DatabaseException databaseException) {
            Exceptions.printStackTrace((Throwable)databaseException);
            return;
        }
        TopComponent topComponent = null;
        ExplorerManager explorerManager = null;
        Node node = null;
        for (TopComponent topComponent2 : TopComponent.getRegistry().getOpened()) {
            ExplorerManager explorerManager2;
            Component[] componentArray = topComponent2.getComponents();
            if (componentArray.length <= 0 || !"Runtime".equals((explorerManager2 = ExplorerManager.find((Component)componentArray[0])).getRootContext().getName())) continue;
            topComponent = topComponent2;
            explorerManager = explorerManager2;
            node = explorerManager2.getRootContext();
        }
        if (topComponent == null) {
            return;
        }
        Node node2 = null;
        try {
            node2 = NodeOp.findPath(node, (String[])new String[]{"Databases", string});
        }
        catch (NodeNotFoundException nodeNotFoundException) {
            Exceptions.printStackTrace((Throwable)nodeNotFoundException);
            return;
        }
        try {
            explorerManager.setSelectedNodes(new Node[]{node2});
        }
        catch (PropertyVetoException propertyVetoException) {
            Exceptions.printStackTrace((Throwable)propertyVetoException);
            return;
        }
        topComponent.requestActive();
    }

    public void showConnectionDialog() {
        try {
            final ConnectionNodeInfo connectionNodeInfo = this.findConnectionNodeInfo(this.getName());
            if (connectionNodeInfo != null && connectionNodeInfo.getConnection() == null) {
                Mutex.EVENT.readAccess(new Runnable(){

                    public void run() {
                        new ConnectAction.ConnectionDialogDisplayer().showDialog(connectionNodeInfo, false);
                    }
                });
            }
        }
        catch (DatabaseException databaseException) {
            Exceptions.printStackTrace((Throwable)databaseException);
        }
    }

    public Connection getJDBCConnection() {
        try {
            ConnectionNodeInfo connectionNodeInfo = this.findConnectionNodeInfo(this.getName());
            if (connectionNodeInfo != null && connectionNodeInfo.getConnection() != null) {
                return connectionNodeInfo.getConnection();
            }
        }
        catch (DatabaseException databaseException) {
            Exceptions.printStackTrace((Throwable)databaseException);
        }
        return null;
    }

    public void disconnect() throws DatabaseException {
        ConnectionNodeInfo connectionNodeInfo = this.findConnectionNodeInfo(this.getName());
        if (connectionNodeInfo != null && connectionNodeInfo.getConnection() != null) {
            connectionNodeInfo.disconnect();
        }
    }

    private ConnectionNodeInfo findConnectionNodeInfo(String string) throws DatabaseException {
        assert (string != null);
        Node[] nodeArray = RootNode.getInstance().getChildren().getNodes(true);
        for (int i = 0; i < nodeArray.length; ++i) {
            ConnectionNodeInfo connectionNodeInfo;
            DatabaseNodeInfo databaseNodeInfo;
            if (!(nodeArray[i] instanceof DatabaseNode) || (databaseNodeInfo = (DatabaseNodeInfo)nodeArray[i].getCookie(DatabaseNodeInfo.class)) == null || (connectionNodeInfo = (ConnectionNodeInfo)databaseNodeInfo.getParent("connection")) == null || !string.equals(connectionNodeInfo.getDatabaseConnection().getName())) continue;
            return connectionNodeInfo;
        }
        return null;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.propertySupport == null) {
            this.propertySupport = new PropertyChangeSupport(this);
        }
        return this;
    }

    static {
        openConnectionServices = null;
        openConnectionLookupResult = Lookup.getDefault().lookup(new Lookup.Template(OpenConnectionInterface.class));
        openConnectionLookupResult.addLookupListener(new LookupListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void resultChanged(LookupEvent lookupEvent) {
                Class<DatabaseConnection> clazz = DatabaseConnection.class;
                synchronized (DatabaseConnection.class) {
                    openConnectionServices = null;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
    }
}

