/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.javadoc;

import com.sun.javadoc.Doc;
import com.sun.javadoc.Tag;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.lexer.JavadocTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JavadocCompletionUtils {
    static final Pattern JAVADOC_LINE_BREAK = Pattern.compile("\\n[ \\t]*\\**[ \\t]*\\z");
    static final Pattern JAVADOC_WHITE_SPACE = Pattern.compile("[^ \\t]");
    static final Pattern JAVADOC_FIRST_WHITE_SPACE = Pattern.compile("[ \\t]*\\**[ \\t]*");
    private static Set<JavaTokenId> IGNORE_TOKES = EnumSet.of(JavaTokenId.WHITESPACE, JavaTokenId.BLOCK_COMMENT, JavaTokenId.LINE_COMMENT);

    JavadocCompletionUtils() {
    }

    public static boolean isJavadocContext(Document document, int n) {
        TokenSequence tokenSequence = SourceUtils.getJavaTokenSequence((TokenHierarchy)TokenHierarchy.get((Document)document), (int)n);
        if (!JavadocCompletionUtils.movedToJavadocToken((TokenSequence<JavaTokenId>)tokenSequence, n)) {
            return false;
        }
        TokenSequence tokenSequence2 = tokenSequence.embedded(JavadocTokenId.language());
        if (tokenSequence2 == null) {
            return false;
        }
        if (tokenSequence2.isEmpty()) {
            return JavadocCompletionUtils.isEmptyJavadoc((Token<JavaTokenId>)tokenSequence.token(), n - tokenSequence.offset());
        }
        tokenSequence2.move(n);
        if (!tokenSequence2.moveNext() && !tokenSequence2.movePrevious()) {
            return false;
        }
        return JavadocCompletionUtils.isInsideToken(tokenSequence2, n) && !JavadocCompletionUtils.isInsideIndent((Token<JavadocTokenId>)tokenSequence2.token(), n - tokenSequence2.offset());
    }

    public static Doc findJavadoc(CompilationInfo compilationInfo, Document document, int n) {
        Object object;
        TokenSequence tokenSequence = SourceUtils.getJavaTokenSequence((TokenHierarchy)compilationInfo.getTokenHierarchy(), (int)n);
        if (tokenSequence == null || !JavadocCompletionUtils.movedToJavadocToken((TokenSequence<JavaTokenId>)tokenSequence, n)) {
            return null;
        }
        int n2 = tokenSequence.offset() + tokenSequence.token().length();
        while (tokenSequence.moveNext()) {
            object = tokenSequence.token().id();
            if (IGNORE_TOKES.contains(object)) continue;
            n2 = tokenSequence.offset();
            ++n2;
            break;
        }
        object = compilationInfo.getTreeUtilities().pathFor(n2);
        Tree tree = ((TreePath)object).getLeaf();
        Tree.Kind kind = tree.getKind();
        SourcePositions sourcePositions = compilationInfo.getTrees().getSourcePositions();
        while (kind != Tree.Kind.CLASS && kind != Tree.Kind.METHOD && kind != Tree.Kind.VARIABLE && kind != Tree.Kind.COMPILATION_UNIT) {
            if ((object = ((TreePath)object).getParentPath()) == null) {
                tree = null;
                kind = null;
                break;
            }
            tree = ((TreePath)object).getLeaf();
            kind = tree.getKind();
        }
        if (tree == null || kind == Tree.Kind.COMPILATION_UNIT || sourcePositions.getStartPosition(compilationInfo.getCompilationUnit(), tree) < (long)n) {
            return null;
        }
        Element element = compilationInfo.getTrees().getElement((TreePath)object);
        return element != null ? compilationInfo.getElementUtilities().javaDocFor(element) : null;
    }

    static TokenSequence<JavadocTokenId> findJavadocTokenSequence(CompilationInfo compilationInfo, int n) {
        TokenSequence tokenSequence = SourceUtils.getJavaTokenSequence((TokenHierarchy)compilationInfo.getTokenHierarchy(), (int)n);
        if (tokenSequence == null || !JavadocCompletionUtils.movedToJavadocToken((TokenSequence<JavaTokenId>)tokenSequence, n)) {
            return null;
        }
        TokenSequence tokenSequence2 = tokenSequence.embedded(JavadocTokenId.language());
        if (tokenSequence2 == null) {
            return null;
        }
        tokenSequence2.move(n);
        return tokenSequence2;
    }

    static TokenSequence<JavadocTokenId> findJavadocTokenSequence(CompilationInfo compilationInfo, Element element) {
        if (element == null || compilationInfo.getElementUtilities().isSynthetic(element) || compilationInfo.getElements().getDocComment(element) == null) {
            return null;
        }
        Tree tree = compilationInfo.getTrees().getTree(element);
        if (tree == null) {
            return null;
        }
        int n = (int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), tree);
        TokenSequence tokenSequence = SourceUtils.getJavaTokenSequence((TokenHierarchy)compilationInfo.getTokenHierarchy(), (int)n);
        if (tokenSequence == null) {
            return null;
        }
        tokenSequence.move(n);
        Token token = null;
        while (tokenSequence.movePrevious() && IGNORE_TOKES.contains((token = tokenSequence.token()).id())) {
        }
        if (token == null || token.id() != JavaTokenId.JAVADOC_COMMENT) {
            return null;
        }
        return tokenSequence.embedded(JavadocTokenId.language());
    }

    static boolean isInsideIndent(Token<JavadocTokenId> token, int n) {
        int n2 = -1;
        if (token.id() == JavadocTokenId.OTHER_TEXT) {
            CharSequence charSequence = token.text();
            for (int i = 0; i < charSequence.length(); ++i) {
                char c = charSequence.charAt(i);
                if (c == '\n') {
                    if (i > n) break;
                    n2 = -1;
                    if (i >= n) break;
                    continue;
                }
                if (i == 0) break;
                if (c != '*' || n2 >= 0) continue;
                n2 = i;
                if (n <= i) break;
            }
        }
        return n2 >= n;
    }

    public static boolean isLineBreak(Token<JavadocTokenId> token) {
        return JavadocCompletionUtils.isLineBreak(token, token.length());
    }

    public static boolean isLineBreak(Token<JavadocTokenId> token, int n) {
        if (token == null || token.id() != JavadocTokenId.OTHER_TEXT) {
            return false;
        }
        if (n < 0 || n > token.length()) {
            throw new IndexOutOfBoundsException("pos: " + n + ", token.length: " + token.length());
        }
        CharSequence charSequence = token.text();
        boolean bl = n > 0 && JAVADOC_LINE_BREAK.matcher(charSequence.subSequence(0, n)).find() && (n == token.length() || !JavadocCompletionUtils.isInsideIndent(token, n));
        return bl;
    }

    public static boolean isWhiteSpace(CharSequence charSequence) {
        return charSequence != null && charSequence.length() > 0 && !JAVADOC_WHITE_SPACE.matcher(charSequence).find();
    }

    public static boolean isWhiteSpace(Token<JavadocTokenId> token) {
        if (token == null || token.id() != JavadocTokenId.OTHER_TEXT) {
            return false;
        }
        CharSequence charSequence = token.text();
        boolean bl = !JAVADOC_WHITE_SPACE.matcher(charSequence).find();
        return bl;
    }

    public static boolean isFirstWhiteSpaceAtFirstLine(Token<JavadocTokenId> token) {
        if (token == null || token.id() != JavadocTokenId.OTHER_TEXT) {
            return false;
        }
        CharSequence charSequence = token.text();
        boolean bl = JAVADOC_FIRST_WHITE_SPACE.matcher(charSequence).matches();
        return bl;
    }

    public static boolean isWhiteSpaceFirst(Token<JavadocTokenId> token) {
        if (token == null || token.id() != JavadocTokenId.OTHER_TEXT || token.length() < 1) {
            return false;
        }
        CharSequence charSequence = token.text();
        char c = charSequence.charAt(0);
        return c == ' ' || c == '\t';
    }

    public static boolean isWhiteSpaceLast(Token<JavadocTokenId> token) {
        if (token == null || token.id() != JavadocTokenId.OTHER_TEXT || token.length() < 1) {
            return false;
        }
        CharSequence charSequence = token.text();
        char c = charSequence.charAt(charSequence.length() - 1);
        return c == ' ' || c == '\t';
    }

    public static boolean isInlineTagStart(Token<JavadocTokenId> token) {
        if (token == null || token.id() != JavadocTokenId.OTHER_TEXT) {
            return false;
        }
        CharSequence charSequence = token.text();
        boolean bl = charSequence.charAt(charSequence.length() - 1) == '{';
        return bl;
    }

    public static boolean isBlockTag(Tag tag) {
        Doc doc = tag.holder();
        Tag[] tagArray = doc.tags();
        for (int i = 0; i < tagArray.length; ++i) {
            if (tag != tagArray[i]) continue;
            return true;
        }
        return false;
    }

    static CharSequence getCharSequence(Document document) {
        CharSequence charSequence = (CharSequence)document.getProperty(CharSequence.class);
        if (charSequence == null) {
            try {
                charSequence = document.getText(0, document.getLength());
            }
            catch (BadLocationException badLocationException) {
                throw (IndexOutOfBoundsException)new IndexOutOfBoundsException().initCause(badLocationException);
            }
        }
        return charSequence;
    }

    static CharSequence getCharSequence(Document document, int n, int n2) {
        CharSequence charSequence = (CharSequence)document.getProperty(CharSequence.class);
        if (charSequence != null) {
            charSequence = charSequence.subSequence(n, n2);
        } else {
            try {
                charSequence = document.getText(n, n2 - n);
            }
            catch (BadLocationException badLocationException) {
                throw (IndexOutOfBoundsException)new IndexOutOfBoundsException().initCause(badLocationException);
            }
        }
        return charSequence;
    }

    private static boolean isInsideToken(TokenSequence<?> tokenSequence, int n) {
        return n >= tokenSequence.offset() && n <= tokenSequence.offset() + tokenSequence.token().length();
    }

    private static boolean movedToJavadocToken(TokenSequence<JavaTokenId> tokenSequence, int n) {
        if (tokenSequence == null || !tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return false;
        }
        if (tokenSequence.token().id() != JavaTokenId.JAVADOC_COMMENT) {
            return false;
        }
        return JavadocCompletionUtils.isInsideToken(tokenSequence, n);
    }

    private static boolean isEmptyJavadoc(Token<JavaTokenId> token, int n) {
        if (token != null && token.id() == JavaTokenId.JAVADOC_COMMENT) {
            CharSequence charSequence = token.text();
            return n == 3 && "/***/".contentEquals(charSequence);
        }
        return false;
    }
}

