/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeCharacterData;
import org.netbeans.tax.TreeChild;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeReference;
import org.netbeans.tax.TreeUtilities;
import org.netbeans.tax.Util;
import org.netbeans.tax.spec.Attribute;
import org.netbeans.tax.spec.DocumentFragment;
import org.netbeans.tax.spec.Element;
import org.netbeans.tax.spec.GeneralEntityReference;

public class TreeCharacterReference
extends TreeChild
implements TreeReference,
TreeCharacterData,
DocumentFragment.Child,
Element.Child,
GeneralEntityReference.Child,
Attribute.Value {
    public static final String PROP_NAME = "name";
    private String name;

    public TreeCharacterReference(String string) throws InvalidArgumentException {
        this.checkName(string);
        this.name = string;
    }

    protected TreeCharacterReference(TreeCharacterReference treeCharacterReference) {
        super(treeCharacterReference);
        this.name = treeCharacterReference.name;
    }

    public Object clone() {
        return new TreeCharacterReference(this);
    }

    public boolean equals(Object object, boolean bl) {
        if (!super.equals(object, bl)) {
            return false;
        }
        TreeCharacterReference treeCharacterReference = (TreeCharacterReference)object;
        return Util.equals(this.getName(), treeCharacterReference.getName());
    }

    public void merge(TreeObject treeObject) throws CannotMergeException {
        super.merge(treeObject);
        TreeCharacterReference treeCharacterReference = (TreeCharacterReference)treeObject;
        this.setNameImpl(treeCharacterReference.getName());
    }

    public final String getName() {
        return this.name;
    }

    private final void setNameImpl(String string) {
        String string2 = this.name;
        this.name = string;
        this.firePropertyChange(PROP_NAME, string2, string);
    }

    public final void setName(String string) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.name, string)) {
            return;
        }
        this.checkReadOnly();
        this.checkName(string);
        this.setNameImpl(string);
    }

    protected final void checkName(String string) throws InvalidArgumentException {
        TreeUtilities.checkCharacterReferenceName(string);
    }

    public final String getData() {
        short s = this.name.startsWith("#x") ? Short.parseShort(this.name.substring(2), 16) : Short.parseShort(this.name.substring(1));
        return new String(new char[]{(char)s});
    }
}

