/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.common.data.helper;

import com.sun.esb.management.common.data.NMRStatisticsData;
import com.sun.esb.management.common.data.helper.NMRStatisticsDataXMLConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NMRStatisticsDataReader
extends DefaultHandler
implements NMRStatisticsDataXMLConstants,
Serializable {
    static final long serialVersionUID = -1L;
    private boolean parsingInProgress;
    private Stack<String> qNameStack = new Stack();
    private String nmrStatisticsDataListVersion;
    private List<String> activeChannelsList;
    private List<String> activeEndpointsList;
    private NMRStatisticsData data;
    private Map<String, NMRStatisticsData> dataMap;

    public Map<String, NMRStatisticsData> getNMRStatisticsDataMap() {
        return this.dataMap;
    }

    @Override
    public void startDocument() throws SAXException {
        this.parsingInProgress = true;
        this.qNameStack.removeAllElements();
    }

    @Override
    public void endDocument() throws SAXException {
        this.parsingInProgress = false;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName != null) {
            if (qName.endsWith("NMRStatisticsDataList")) {
                if (attributes != null && attributes.getLength() > 0) {
                    String namespace = attributes.getValue("xmlns");
                    this.nmrStatisticsDataListVersion = attributes.getValue("version");
                    if (this.nmrStatisticsDataListVersion != null && "1.0".equals(this.nmrStatisticsDataListVersion)) {
                        this.dataMap = new HashMap<String, NMRStatisticsData>();
                    }
                }
            } else if (qName.endsWith("ActiveChannelsList")) {
                if (this.dataMap != null && this.data != null) {
                    this.activeChannelsList = new ArrayList<String>();
                }
            } else if (qName.endsWith("ActiveEndpointsList")) {
                if (this.dataMap != null && this.data != null) {
                    this.activeEndpointsList = new ArrayList<String>();
                }
            } else if (qName.endsWith("NMRStatisticsData") && this.dataMap != null) {
                this.data = new NMRStatisticsData();
            }
            this.qNameStack.push(qName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String chars = new String(ch, start, length);
        String qName = this.qNameStack.peek();
        if (qName.endsWith("InstanceName")) {
            if (this.data != null) {
                this.data.setInstanceName(chars);
            }
        } else if (qName.endsWith("ActiveChannel")) {
            if (this.data != null && this.activeChannelsList != null) {
                this.activeChannelsList.add(chars);
            }
        } else if (qName.endsWith("ActiveEndpoint") && this.data != null && this.activeEndpointsList != null) {
            this.activeEndpointsList.add(chars);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.qNameStack.pop();
        if (qName != null) {
            if (qName.endsWith("NMRStatisticsData")) {
                if (this.dataMap != null && this.data != null) {
                    this.dataMap.put(this.data.getInstanceName(), this.data);
                    this.data = null;
                }
            } else if (qName.endsWith("ActiveChannelsList")) {
                if (this.data != null && this.activeChannelsList != null) {
                    this.data.setActiveChannelsList(this.activeChannelsList);
                    this.activeChannelsList = null;
                }
            } else if (qName.endsWith("ActiveEndpointsList") && this.data != null && this.activeEndpointsList != null) {
                this.data.setActiveEndpointsList(this.activeEndpointsList);
                this.activeChannelsList = null;
            }
        }
    }

    public static Map<String, NMRStatisticsData> parseFromXMLData(String rawXMLData) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        StringReader reader = new StringReader(rawXMLData);
        InputSource inputSource = new InputSource(reader);
        NMRStatisticsDataReader parser = new NMRStatisticsDataReader();
        saxParser.parse(inputSource, (DefaultHandler)parser);
        return parser.getNMRStatisticsDataMap();
    }

    public static Map<String, NMRStatisticsData> parseFromFile(String fileName) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        File file = new File(fileName);
        return NMRStatisticsDataReader.parseFromFile(file);
    }

    public static Map<String, NMRStatisticsData> parseFromFile(File file) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        FileInputStream inputStream = new FileInputStream(file);
        InputSource inputSource = new InputSource(inputStream);
        NMRStatisticsDataReader parser = new NMRStatisticsDataReader();
        saxParser.parse(inputSource, (DefaultHandler)parser);
        return parser.getNMRStatisticsDataMap();
    }

    public static Map<String, NMRStatisticsData> parseFromURI(String uriString) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        URI uri = new URI(uriString);
        return NMRStatisticsDataReader.parseFromURI(uri);
    }

    public static Map<String, NMRStatisticsData> parseFromURI(URI uri) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        InputStream inputStream = uri.toURL().openStream();
        InputSource inputSource = new InputSource(inputStream);
        NMRStatisticsDataReader parser = new NMRStatisticsDataReader();
        saxParser.parse(inputSource, (DefaultHandler)parser);
        return parser.getNMRStatisticsDataMap();
    }

    public static void main(String[] args) {
        String uri = "C:/test/schema/nmrstatistics/NMRStatisticsData.xml";
        try {
            Map<String, NMRStatisticsData> map = null;
            map = NMRStatisticsDataReader.parseFromFile(uri);
            for (String instanceName : map.keySet()) {
                System.out.println(map.get(instanceName).getDisplayString());
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

