/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.common.data;

import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.esb.management.common.data.helper.PerformanceDataMapWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformanceData
implements Serializable {
    static final long serialVersionUID = -1L;
    public static final String NUMBEROFMEASUREMENTS_KEY = "n";
    public static final String TOTALTIME_KEY = "total time (ms)";
    public static final String AVERAGEWITHOUTFIRSTMEASUREMENT_KEY = "average' (ms)";
    public static final String NUMBEROFMEASUREMENTOBJECTS_KEY = "act";
    public static final String FIRSTMEASUREMENTTIME_KEY = "first (ms)";
    public static final String AVERAGE_KEY = "average (ms)";
    public static final String THROUGHPUT_KEY = "throughput (s-1)";
    public static final String TIMETAKEN_KEY = "last-first (ms)";
    public static final String LOAD_KEY = "load";
    public static final String MEDIAN_KEY = "median (ms)";
    public static final String SOURCE_KEY = "source";
    public static final String SUB_TOPIC_KEY = "sub topic";
    public static final String TOPIC_KEY = "topic";
    double median;
    String sourceClassName;
    String endpoint;
    String category;
    double average;
    double averageWithoutFirstMeasurement;
    double firstMeasurementTime;
    double load;
    int numberOfMeasurementObjects;
    int numberOfMeasurements;
    double throughput;
    double timeTaken;
    double totalTime;

    public static Map<String, PerformanceData> retrieveDataMap(TabularData tabularData) {
        HashMap<String, PerformanceData> dataMap = new HashMap<String, PerformanceData>();
        for (CompositeData compositeData : tabularData.values()) {
            CompositeType compositeType = compositeData.getCompositeType();
            PerformanceData performanceData = new PerformanceData();
            for (String item : compositeType.keySet()) {
                Object value;
                if (item.equals(AVERAGE_KEY)) {
                    value = (Double)compositeData.get(item);
                    performanceData.setAverage((Double)value);
                }
                if (item.equals(AVERAGEWITHOUTFIRSTMEASUREMENT_KEY)) {
                    value = (Double)compositeData.get(item);
                    performanceData.setAverageWithoutFirstMeasurement((Double)value);
                }
                if (item.equals(FIRSTMEASUREMENTTIME_KEY)) {
                    value = (Double)compositeData.get(item);
                    performanceData.setFirstMeasurementTime((Double)value);
                }
                if (item.equals(LOAD_KEY)) {
                    value = (Double)compositeData.get(item);
                    performanceData.setLoad((Double)value);
                }
                if (item.equals(NUMBEROFMEASUREMENTOBJECTS_KEY)) {
                    value = (Integer)compositeData.get(item);
                    performanceData.setNumberOfMeasurementObjects((Integer)value);
                }
                if (item.equals(NUMBEROFMEASUREMENTS_KEY)) {
                    value = (Integer)compositeData.get(item);
                    performanceData.setNumberOfMeasurements((Integer)value);
                }
                if (item.equals(THROUGHPUT_KEY)) {
                    value = (Double)compositeData.get(item);
                    performanceData.setThroughput((Double)value);
                }
                if (item.equals(TIMETAKEN_KEY)) {
                    value = (Double)compositeData.get(item);
                    performanceData.setTimeTaken((Double)value);
                }
                if (item.equals(TOTALTIME_KEY)) {
                    value = (Double)compositeData.get(item);
                    performanceData.setTotalTime((Double)value);
                }
                if (item.equals(MEDIAN_KEY)) {
                    value = (Double)compositeData.get(item);
                    performanceData.setMedian((Double)value);
                }
                if (item.equals(SOURCE_KEY)) {
                    value = (String)compositeData.get(item);
                    performanceData.setSourceClassName((String)value);
                }
                if (item.equals(SUB_TOPIC_KEY)) {
                    value = (String)compositeData.get(item);
                    performanceData.setCategory((String)value);
                }
                if (!item.equals(TOPIC_KEY)) continue;
                value = (String)compositeData.get(item);
                performanceData.setEndpoint((String)value);
            }
            dataMap.put(performanceData.getCategory(), performanceData);
        }
        return dataMap;
    }

    public static String convertDataMapToXML(Map<String, PerformanceData> dataMap) throws ManagementRemoteException {
        String xmlText = null;
        try {
            xmlText = PerformanceDataMapWriter.serialize(dataMap);
        }
        catch (ParserConfigurationException e) {
            throw new ManagementRemoteException(e);
        }
        catch (TransformerException e) {
            throw new ManagementRemoteException(e);
        }
        return xmlText;
    }

    public double getAverage() {
        return this.average;
    }

    public double getAverageWithoutFirstMeasurement() {
        return this.averageWithoutFirstMeasurement;
    }

    public double getFirstMeasurementTime() {
        return this.firstMeasurementTime;
    }

    public double getLoad() {
        return this.load;
    }

    public int getNumberOfMeasurementObjects() {
        return this.numberOfMeasurementObjects;
    }

    public int getNumberOfMeasurements() {
        return this.numberOfMeasurements;
    }

    public double getThroughput() {
        return this.throughput;
    }

    public double getTimeTaken() {
        return this.timeTaken;
    }

    public double getTotalTime() {
        return this.totalTime;
    }

    public static long getSerialVersionUID() {
        return -1L;
    }

    public void setAverage(double average) {
        this.average = average;
    }

    public void setAverageWithoutFirstMeasurement(double averageWithoutFirstMeasurement) {
        this.averageWithoutFirstMeasurement = averageWithoutFirstMeasurement;
    }

    public void setFirstMeasurementTime(double firstMeasurementTime) {
        this.firstMeasurementTime = firstMeasurementTime;
    }

    public void setLoad(double load) {
        this.load = load;
    }

    public void setNumberOfMeasurementObjects(int numberOfMeasurementObjects) {
        this.numberOfMeasurementObjects = numberOfMeasurementObjects;
    }

    public void setNumberOfMeasurements(int numberOfMeasurements) {
        this.numberOfMeasurements = numberOfMeasurements;
    }

    public void setThroughput(double throughput) {
        this.throughput = throughput;
    }

    public void setTimeTaken(double timeTaken) {
        this.timeTaken = timeTaken;
    }

    public void setTotalTime(double totalTime) {
        this.totalTime = totalTime;
    }

    public double getMedian() {
        return this.median;
    }

    public void setMedian(double median) {
        this.median = median;
    }

    public String getSourceClassName() {
        return this.sourceClassName;
    }

    public void setSourceClassName(String sourceClassName) {
        this.sourceClassName = sourceClassName;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String anEndpoint) {
        this.endpoint = anEndpoint;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String subTopic) {
        this.category = subTopic;
    }

    public String getDisplayString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n  Category=" + this.getCategory());
        buffer.append("\n  Endpoint=" + this.getEndpoint());
        buffer.append("\n  Source Class Name=" + this.getSourceClassName());
        buffer.append("\n  Median=" + this.getMedian());
        buffer.append("\n  Average=" + this.getAverage());
        buffer.append("\n  Average Without First Measurement=" + this.getAverageWithoutFirstMeasurement());
        buffer.append("\n  First Measurement Time=" + this.getFirstMeasurementTime());
        buffer.append("\n  Load=" + this.getLoad());
        buffer.append("\n  Number Of Measurement Objects=" + this.getNumberOfMeasurementObjects());
        buffer.append("\n  Number Of Measurements=" + this.getNumberOfMeasurements());
        buffer.append("\n  Throughput=" + this.getThroughput());
        buffer.append("\n  Time Taken=" + this.getTimeTaken());
        buffer.append("\n  Total Time=" + this.getTotalTime());
        buffer.append("\n  ========================================\n");
        return buffer.toString();
    }
}

