/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.project.bdj;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;

public class BdjRun
extends Task {
    private File platformHome;
    private File deploymentRoot;
    private String jvmargs;
    private String args;
    private boolean debug;
    private String debuggerAddressProperty;
    protected PrintWriter fos = null;

    public void execute() throws BuildException {
        String executable = null;
        String image = null;
        File[] files = this.platformHome.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) continue;
            if (file.getName().startsWith("uDigital Theatre.exe")) {
                executable = file.getAbsolutePath();
                image = this.deploymentRoot.getAbsolutePath() + File.separatorChar + "BDMV" + File.separatorChar + "index.bdmv";
                break;
            }
            if (file.getName().startsWith("PowerDVD.exe")) {
                executable = file.getAbsolutePath();
                image = this.deploymentRoot.getAbsolutePath();
                break;
            }
            if (file.getName().startsWith("WinDVD.exe")) {
                executable = file.getAbsolutePath();
                image = this.deploymentRoot.getAbsolutePath();
                break;
            }
            if (!file.getName().startsWith("sunbdjlauncher")) continue;
            this.executeSunBdjLauncher();
            return;
        }
        if (executable == null) {
            throw new BuildException("Can not find any supported executable");
        }
        String[] arg = new String[]{executable, image};
        this.log("Execution arguments: ", 3);
        for (int i = 0; i < arg.length; ++i) {
            this.log(arg[i], 3);
        }
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(arg);
            StreamReader inputReader = new StreamReader(p.getInputStream(), 2);
            StreamReader errorReader = new StreamReader(p.getErrorStream(), 1);
            inputReader.start();
            errorReader.start();
            p.waitFor();
            inputReader.join();
            errorReader.join();
            p.destroy();
            this.logFlush();
            if (p.exitValue() != 0) {
                throw new BuildException("Emulator execution failed!");
            }
        }
        catch (IOException ex) {
            throw new BuildException("Emulator execution failed!");
        }
        catch (InterruptedException ex) {
            throw new BuildException("Emulator execution failed!");
        }
    }

    private void executeSunBdjLauncher() throws BuildException {
        String libPrefix = new File(this.getPlatformHome(), "lib").getAbsolutePath();
        StringBuilder classpath = new StringBuilder(3 * libPrefix.length());
        classpath.append(libPrefix);
        classpath.append(File.separator);
        classpath.append("bd-j__bdj-emulator.jar");
        classpath.append(File.pathSeparator);
        classpath.append(libPrefix);
        classpath.append(File.separator);
        classpath.append("bd-j__blu-ray-generator.jar");
        Java java = new Java((Task)this);
        java.setFork(true);
        java.setClasspath(new Path(this.getProject(), classpath.toString()));
        if (this.debug) {
            String debugAddress = null;
            try {
                debugAddress = Integer.toString(this.determineFreePort());
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
            if (this.debuggerAddressProperty != null) {
                this.getProject().setProperty(this.debuggerAddressProperty, debugAddress);
            }
            java.createJvmarg().setValue("-Xdebug");
            java.createJvmarg().setLine("-Xrunjdwp:transport=dt_socket,server=y,address=" + debugAddress);
        }
        java.createArg().setFile(this.deploymentRoot);
        java.setClassname("com.sun.jme.bdj.Launcher");
        java.execute();
    }

    public File getDeploymentRoot() {
        return this.deploymentRoot;
    }

    public void setDeploymentRoot(File deploymentRoot) {
        this.deploymentRoot = deploymentRoot;
    }

    public File getPlatformHome() {
        return this.platformHome;
    }

    public void setPlatformHome(File platformHome) {
        this.platformHome = platformHome;
    }

    public String getArgs() {
        return this.args;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getDebuggeraddressproperty() {
        return this.debuggerAddressProperty;
    }

    public void setDebuggeraddressproperty(String debuggeraddressproperty) {
        this.debuggerAddressProperty = debuggeraddressproperty;
    }

    public String getJvmargs() {
        return this.jvmargs;
    }

    public void setJvmargs(String jvmargs) {
        this.jvmargs = jvmargs;
    }

    private void outputLog(String line, int messageLevel) {
        if (this.fos == null) {
            this.log(line, messageLevel);
        } else {
            this.fos.println(line);
        }
    }

    private void logFlush() {
        if (this.fos != null) {
            this.fos.close();
        }
    }

    private int determineFreePort() throws IOException {
        Socket sock = new Socket();
        sock.bind(null);
        int port = sock.getLocalPort();
        sock.close();
        return port;
    }

    class StreamReader
    extends Thread {
        private BufferedReader din;
        private int messageLevel;
        private boolean endOfStream = false;
        private int SLEEP_TIME = 5;

        public StreamReader(InputStream is, int messageLevel) {
            this.din = new BufferedReader(new InputStreamReader(is));
            this.messageLevel = messageLevel;
        }

        public void pumpStream() throws IOException {
            if (!this.endOfStream) {
                String line = this.din.readLine();
                if (line != null) {
                    BdjRun.this.outputLog(line, this.messageLevel);
                } else {
                    this.endOfStream = true;
                }
            }
        }

        public void run() {
            try {
                try {
                    while (!this.endOfStream) {
                        this.pumpStream();
                        StreamReader.sleep(this.SLEEP_TIME);
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                this.din.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

