/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.inc;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.lib.lexer.LAState;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TokenOrEmbedding;
import org.netbeans.lib.lexer.inc.MutableTokenList;
import org.netbeans.lib.lexer.inc.RemovedTokenList;
import org.netbeans.lib.lexer.inc.TokenChangeInfo;
import org.netbeans.lib.lexer.token.AbstractToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenListChange<T extends TokenId> {
    private static final TokenOrEmbedding<?>[] EMPTY_TOKENS = new TokenOrEmbedding[0];
    private final TokenChangeInfo<T> tokenChangeInfo;
    private List<TokenOrEmbedding<T>> addedTokenOrEmbeddings;
    private LAState laState;
    int removedEndOffset;
    protected int matchIndex;
    protected int matchOffset;
    protected int addedEndOffset;

    public static <T extends TokenId> TokenListChange<T> createRebuildChange(MutableTokenList<T> mutableTokenList) {
        TokenListChange<T> tokenListChange = new TokenListChange<T>(mutableTokenList);
        tokenListChange.matchIndex = mutableTokenList.tokenCountCurrent();
        return tokenListChange;
    }

    public TokenListChange(MutableTokenList<T> mutableTokenList) {
        this.tokenChangeInfo = new TokenChangeInfo<T>(mutableTokenList);
    }

    public TokenChangeInfo<T> tokenChangeInfo() {
        return this.tokenChangeInfo;
    }

    public MutableTokenList<T> tokenList() {
        return (MutableTokenList)this.tokenChangeInfo.currentTokenList();
    }

    public void setMatchIndex(int n) {
        this.matchIndex = n;
    }

    public void setMatchOffset(int n) {
        this.matchOffset = n;
    }

    public int increaseMatchIndex() {
        this.matchOffset += this.tokenList().tokenOrEmbeddingUnsync(this.matchIndex++).token().length();
        return this.matchOffset;
    }

    public LanguagePath languagePath() {
        return this.tokenList().languagePath();
    }

    public int index() {
        return this.tokenChangeInfo.index();
    }

    public void setIndex(int n) {
        this.tokenChangeInfo.setIndex(n);
    }

    public int offset() {
        return this.tokenChangeInfo.offset();
    }

    public void setOffset(int n) {
        this.tokenChangeInfo.setOffset(n);
        this.addedEndOffset = n;
    }

    public int removedTokenCount() {
        return this.matchIndex - this.index();
    }

    public int removedEndOffset() {
        return this.matchOffset;
    }

    public int addedEndOffset() {
        return this.addedEndOffset;
    }

    public void setAddedEndOffset(int n) {
        this.addedEndOffset = n;
    }

    public void addToken(AbstractToken<T> abstractToken, int n, Object object) {
        if (this.addedTokenOrEmbeddings == null) {
            this.addedTokenOrEmbeddings = new ArrayList<TokenOrEmbedding<T>>(2);
            this.laState = LAState.empty();
        }
        this.addedTokenOrEmbeddings.add(abstractToken);
        this.laState = this.laState.add(n, object);
        this.addedEndOffset += abstractToken.length();
    }

    public List<TokenOrEmbedding<T>> addedTokenOrEmbeddings() {
        return this.addedTokenOrEmbeddings;
    }

    public int addedTokenOrEmbeddingsCount() {
        return this.addedTokenOrEmbeddings != null ? this.addedTokenOrEmbeddings.size() : 0;
    }

    public AbstractToken<T> removeLastAddedToken() {
        int n = this.addedTokenOrEmbeddings.size() - 1;
        AbstractToken<T> abstractToken = this.addedTokenOrEmbeddings.remove(n).token();
        this.laState.remove(n, 1);
        --this.matchIndex;
        int n2 = abstractToken.length();
        this.matchOffset -= n2;
        this.addedEndOffset -= n2;
        return abstractToken;
    }

    public AbstractToken<T> addedToken(int n) {
        return this.addedTokenOrEmbeddings.get(0).token();
    }

    public void syncAddedTokenCount() {
        this.tokenChangeInfo.setAddedTokenCount(this.addedTokenOrEmbeddings.size());
    }

    public void setRemovedTokens(TokenOrEmbedding<T>[] tokenOrEmbeddingArray) {
        this.tokenChangeInfo.setRemovedTokenList(new RemovedTokenList<T>(this.languagePath(), tokenOrEmbeddingArray));
    }

    public void setRemovedTokensEmpty() {
        TokenOrEmbedding<?>[] tokenOrEmbeddingArray = EMPTY_TOKENS;
        this.setRemovedTokens(tokenOrEmbeddingArray);
    }

    public boolean isBoundsChange() {
        return this.tokenChangeInfo.isBoundsChange();
    }

    public void markBoundsChange() {
        this.tokenChangeInfo.markBoundsChange();
    }

    public LAState laState() {
        return this.laState;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\"').append(this.languagePath().innerLanguage().mimeType());
        stringBuilder.append("\", ind=").append(this.index());
        stringBuilder.append(", off=").append(this.offset());
        stringBuilder.append(", maInd=").append(this.matchIndex);
        stringBuilder.append(", maOff=").append(this.matchOffset);
        stringBuilder.append(", Add:").append(this.addedTokenOrEmbeddingsCount());
        stringBuilder.append(", tCnt=").append(this.tokenList().tokenCountCurrent());
        if (this.isBoundsChange()) {
            stringBuilder.append(", BoChan");
        }
        return stringBuilder.toString();
    }

    public String toStringMods(int n) {
        int n2;
        int n3;
        StringBuilder stringBuilder = new StringBuilder();
        RemovedTokenList<T> removedTokenList = this.tokenChangeInfo.removedTokenList();
        if (removedTokenList != null && removedTokenList.tokenCount() > 0) {
            n3 = ArrayUtilities.digitCount((int)(removedTokenList.tokenCount() - 1));
            for (n2 = 0; n2 < removedTokenList.tokenCount(); ++n2) {
                stringBuilder.append('\n');
                ArrayUtilities.appendSpaces((StringBuilder)stringBuilder, (int)n);
                stringBuilder.append("Rem[");
                ArrayUtilities.appendIndex((StringBuilder)stringBuilder, (int)n2, (int)n3);
                stringBuilder.append("]: ");
                LexerUtilsConstants.appendTokenInfo(stringBuilder, removedTokenList, n2, null, false, 0, true);
            }
        }
        if (this.addedTokenOrEmbeddings() != null) {
            n3 = ArrayUtilities.digitCount((int)(this.addedTokenOrEmbeddings().size() - 1));
            for (n2 = 0; n2 < this.addedTokenOrEmbeddings().size(); ++n2) {
                stringBuilder.append('\n');
                ArrayUtilities.appendSpaces((StringBuilder)stringBuilder, (int)n);
                stringBuilder.append("Add[");
                ArrayUtilities.appendIndex((StringBuilder)stringBuilder, (int)n2, (int)n3);
                stringBuilder.append("]: ");
                LexerUtilsConstants.appendTokenInfo(stringBuilder, this.addedTokenOrEmbeddings.get(n2), this.laState.lookahead(n2), this.laState.state(n2), null, false, 0, true);
            }
        }
        return stringBuilder.toString();
    }
}

