/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.inc;

import org.netbeans.api.lexer.TokenChange;
import org.netbeans.api.lexer.TokenHierarchyEventType;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.lexer.LexerApiPackageAccessor;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.inc.OriginalText;
import org.netbeans.lib.lexer.inc.TokenChangeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenHierarchyEventInfo {
    private final TokenHierarchyOperation<?, ?> tokenHierarchyOperation;
    private final TokenHierarchyEventType type;
    private TokenChange<?> tokenChange;
    private final int modOffset;
    private final int removedLength;
    private final CharSequence removedText;
    private final int insertedLength;
    private final int diffLengthOrZero;
    private OriginalText originalText;
    private int affectedStartOffset;
    private int affectedEndOffset;

    public TokenHierarchyEventInfo(TokenHierarchyOperation<?, ?> tokenHierarchyOperation, TokenHierarchyEventType tokenHierarchyEventType, int n, int n2, CharSequence charSequence, int n3) {
        if (n < 0) {
            throw new IllegalArgumentException("modificationOffset=" + n + " < 0");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("removedLength=" + n2 + " < 0");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("insertedLength=" + n3 + " < 0");
        }
        this.tokenHierarchyOperation = tokenHierarchyOperation;
        this.type = tokenHierarchyEventType;
        this.modOffset = n;
        this.removedLength = n2;
        this.removedText = charSequence;
        this.insertedLength = n3;
        this.diffLengthOrZero = Math.max(0, n3 - n2);
        this.affectedStartOffset = n;
        this.affectedEndOffset = n + this.diffLengthOrZero;
    }

    public TokenHierarchyOperation<?, ?> tokenHierarchyOperation() {
        return this.tokenHierarchyOperation;
    }

    public TokenHierarchyEventType type() {
        return this.type;
    }

    public TokenChange<?> tokenChange() {
        return this.tokenChange;
    }

    public void setTokenChangeInfo(TokenChangeInfo<?> tokenChangeInfo) {
        this.tokenChange = LexerApiPackageAccessor.get().createTokenChange(tokenChangeInfo);
    }

    public int affectedStartOffset() {
        return this.affectedStartOffset;
    }

    public void setMinAffectedStartOffset(int n) {
        if (n < this.affectedStartOffset) {
            this.affectedStartOffset = n;
        }
    }

    public int affectedEndOffset() {
        return this.affectedEndOffset;
    }

    public void setMaxAffectedEndOffset(int n) {
        if (n > this.affectedEndOffset) {
            this.affectedEndOffset = n;
        }
    }

    public int modOffset() {
        return this.modOffset;
    }

    public int removedLength() {
        return this.removedLength;
    }

    public CharSequence removedText() {
        return this.removedText;
    }

    public int insertedLength() {
        return this.insertedLength;
    }

    public CharSequence insertedText() {
        return this.currentText().subSequence(this.modOffset(), this.modOffset() + this.insertedLength());
    }

    public int diffLength() {
        return this.insertedLength - this.removedLength;
    }

    public int diffLengthOrZero() {
        return this.diffLengthOrZero;
    }

    public OriginalText originalText() {
        if (this.originalText == null) {
            if (this.removedLength != 0 && this.removedText == null) {
                throw new IllegalStateException("Cannot obtain removed text for " + this.tokenHierarchyOperation.inputSource() + " which breaks token snapshots operation and" + " token text retaining after token's removal." + " Valid removedText in TokenHierarchyControl.textModified()" + " should be provided.");
            }
            this.originalText = new OriginalText(this.currentText(), this.modOffset, this.removedText, this.insertedLength);
        }
        return this.originalText;
    }

    public CharSequence currentText() {
        return this.tokenHierarchyOperation.text();
    }

    public String modificationDescription(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(this.originalText().length() + 300);
        if (this.removedLength() > 0) {
            stringBuilder.append("TEXT REMOVED <").append(this.modOffset()).append(",").append(this.modOffset() + this.removedLength()).append('>');
            stringBuilder.append(':').append(this.removedLength());
            if (this.removedText() != null) {
                stringBuilder.append(" \"");
                CharSequenceUtilities.debugText((StringBuilder)stringBuilder, (CharSequence)this.removedText());
                stringBuilder.append('\"');
            }
            stringBuilder.append('\n');
        }
        if (this.insertedLength() > 0) {
            stringBuilder.append("TEXT INSERTED <").append(this.modOffset()).append(",").append(this.modOffset() + this.insertedLength()).append(">:").append(this.insertedLength()).append(" \"");
            CharSequenceUtilities.debugText((StringBuilder)stringBuilder, (CharSequence)this.insertedText());
            stringBuilder.append("\"\n");
        }
        if (bl) {
            stringBuilder.append("\n\n----------------- ORIGINAL TEXT -----------------\n" + (Object)((Object)this.originalText()) + "\n----------------- BEFORE-CARET TEXT -----------------\n" + this.originalText().subSequence(0, this.modOffset()) + "|<--CARET\n");
        }
        return stringBuilder.toString();
    }

    public String dumpAffected() {
        StringBuilder stringBuilder = new StringBuilder("Affected(");
        stringBuilder.append(this.affectedStartOffset());
        stringBuilder.append(",");
        stringBuilder.append(this.affectedEndOffset());
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("modOffset=");
        stringBuilder.append(this.modOffset());
        if (this.removedLength() > 0) {
            stringBuilder.append(", removedLength=");
            stringBuilder.append(this.removedLength());
        }
        if (this.insertedLength() > 0) {
            stringBuilder.append(", insertedLength=");
            stringBuilder.append(this.insertedLength());
        }
        stringBuilder.append(", ").append(this.dumpAffected());
        return stringBuilder.toString();
    }
}

