/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.inc;

import java.util.Set;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.TokenOrEmbedding;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.lib.lexer.token.TextToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RemovedTokenList<T extends TokenId>
implements TokenList<T> {
    private final LanguagePath languagePath;
    private TokenOrEmbedding<T>[] tokenOrEmbeddings;
    private int removedTokensStartOffset;

    public RemovedTokenList(LanguagePath languagePath, TokenOrEmbedding<T>[] tokenOrEmbeddingArray) {
        this.languagePath = languagePath;
        this.tokenOrEmbeddings = tokenOrEmbeddingArray;
    }

    @Override
    public LanguagePath languagePath() {
        return this.languagePath;
    }

    @Override
    public TokenOrEmbedding<T> tokenOrEmbedding(int n) {
        return n < this.tokenOrEmbeddings.length ? this.tokenOrEmbeddings[n] : null;
    }

    @Override
    public int lookahead(int n) {
        return -1;
    }

    @Override
    public Object state(int n) {
        return null;
    }

    @Override
    public int tokenOffsetByIndex(int n) {
        Token<T> token = this.existingToken(n);
        if (token.isFlyweight()) {
            int n2 = 0;
            while (--n >= 0) {
                token = this.existingToken(n);
                n2 += token.length();
                if (token.isFlyweight()) continue;
                return n2 + token.offset(null);
            }
            return this.removedTokensStartOffset + n2;
        }
        return token.offset(null);
    }

    @Override
    public int[] tokenIndex(int n) {
        return LexerUtilsConstants.tokenIndexBinSearch(this, n, this.tokenCountCurrent());
    }

    private Token<T> existingToken(int n) {
        return this.tokenOrEmbeddings[n].token();
    }

    @Override
    public synchronized AbstractToken<T> replaceFlyToken(int n, AbstractToken<T> abstractToken, int n2) {
        TextToken textToken = ((TextToken)abstractToken).createCopy(this, n2);
        this.tokenOrEmbeddings[n] = textToken;
        return textToken;
    }

    @Override
    public int tokenCount() {
        return this.tokenCountCurrent();
    }

    @Override
    public int tokenCountCurrent() {
        return this.tokenOrEmbeddings.length;
    }

    @Override
    public int modCount() {
        return -1;
    }

    @Override
    public int tokenOffset(AbstractToken<T> abstractToken) {
        int n = abstractToken.rawOffset();
        return n;
    }

    public char charAt(int n) {
        throw new IllegalStateException("Querying of text for removed tokens not supported");
    }

    @Override
    public void wrapToken(int n, EmbeddingContainer embeddingContainer) {
        throw new IllegalStateException("Branching of removed tokens not supported");
    }

    @Override
    public TokenList<?> rootTokenList() {
        return null;
    }

    @Override
    public CharSequence inputSourceText() {
        return null;
    }

    @Override
    public TokenHierarchyOperation<?, ?> tokenHierarchyOperation() {
        return null;
    }

    @Override
    public InputAttributes inputAttributes() {
        return null;
    }

    @Override
    public int startOffset() {
        if (this.tokenCountCurrent() > 0 || this.tokenCount() > 0) {
            return this.tokenOffsetByIndex(0);
        }
        return 0;
    }

    @Override
    public int endOffset() {
        int n = this.tokenCount() - 1;
        if (n >= 0) {
            return this.tokenOffsetByIndex(n) + this.tokenOrEmbedding(n).token().length();
        }
        return 0;
    }

    @Override
    public boolean isRemoved() {
        return true;
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public Set<T> skipTokenIds() {
        return null;
    }

    public String toString() {
        return LexerUtilsConstants.appendTokenList(null, this).toString();
    }
}

