/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyEventType;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.lib.lexer.BatchTokenList;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.LanguageOperation;
import org.netbeans.lib.lexer.LexerApiPackageAccessor;
import org.netbeans.lib.lexer.LexerSpiPackageAccessor;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.TokenListList;
import org.netbeans.lib.lexer.TokenSequenceList;
import org.netbeans.lib.lexer.inc.IncTokenList;
import org.netbeans.lib.lexer.inc.TokenHierarchyEventInfo;
import org.netbeans.lib.lexer.inc.TokenHierarchyUpdate;
import org.netbeans.lib.lexer.inc.TokenListChange;
import org.netbeans.spi.lexer.MutableTextInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenHierarchyOperation<I, T extends TokenId> {
    static final Logger LOG = Logger.getLogger(TokenHierarchyOperation.class.getName());
    private static final Logger LOG_LOCK = Logger.getLogger(MutableTextInput.class.getName());
    private final I inputSource;
    private TokenHierarchy<I> tokenHierarchy;
    private MutableTextInput<I> mutableTextInput;
    private final TokenList<T> rootTokenList;
    private Activity activity;
    private EventListenerList listenerList;
    private Set<LanguagePath> languagePaths;
    private Set<Language<?>> exploredLanguages;
    private Map<LanguagePath, TokenListList<?>> path2tokenListList;
    private Set<Language<?>> rootChildrenLanguages;
    private int maxTokenListListPathSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenHierarchyOperation(Reader reader, Language<T> language, Set<T> set, InputAttributes inputAttributes) {
        if (reader == null) {
            throw new IllegalArgumentException("inputReader cannot be null");
        }
        if (language == null) {
            throw new IllegalArgumentException("language cannot be null");
        }
        Reader reader2 = reader;
        this.inputSource = reader2;
        char[] cArray = new char[4096];
        int n = 0;
        try {
            int n2;
            while ((n2 = reader.read(cArray, n, cArray.length - n)) != -1) {
                if ((n += n2) != cArray.length) continue;
                cArray = ArrayUtilities.charArray((char[])cArray);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        String string = new String(cArray, 0, n);
        this.rootTokenList = new BatchTokenList<T>(this, string, language, set, inputAttributes);
        this.init();
        this.activity = Activity.ACTIVE;
    }

    public TokenHierarchyOperation(CharSequence charSequence, boolean bl, Language<T> language, Set<T> set, InputAttributes inputAttributes) {
        if (charSequence == null) {
            throw new IllegalArgumentException("inputText cannot be null");
        }
        if (language == null) {
            throw new IllegalArgumentException("language cannot be null");
        }
        CharSequence charSequence2 = charSequence;
        this.inputSource = charSequence2;
        if (bl) {
            charSequence = ((Object)charSequence).toString();
        }
        this.rootTokenList = new BatchTokenList<T>(this, charSequence, language, set, inputAttributes);
        this.init();
        this.activity = Activity.ACTIVE;
    }

    public TokenHierarchyOperation(MutableTextInput<I> mutableTextInput) {
        this.inputSource = LexerSpiPackageAccessor.get().inputSource(mutableTextInput);
        this.mutableTextInput = mutableTextInput;
        this.rootTokenList = new IncTokenList(this);
        this.init();
        this.activity = Activity.NOT_INITED;
    }

    private void init() {
        assert (this.tokenHierarchy == null);
        this.tokenHierarchy = LexerApiPackageAccessor.get().createTokenHierarchy(this);
        this.listenerList = new EventListenerList();
        this.rootChildrenLanguages = Collections.emptySet();
    }

    public TokenHierarchy<I> tokenHierarchy() {
        return this.tokenHierarchy;
    }

    public TokenList<T> rootTokenList() {
        return this.rootTokenList;
    }

    public int modCount() {
        return this.rootTokenList.modCount();
    }

    public boolean isMutable() {
        return this.mutableTextInput != null;
    }

    public MutableTextInput mutableTextInput() {
        return this.mutableTextInput;
    }

    public I inputSource() {
        return this.inputSource;
    }

    public CharSequence text() {
        if (this.mutableTextInput != null) {
            return LexerSpiPackageAccessor.get().text(this.mutableTextInput);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(boolean bl) {
        this.ensureWriteLocked();
        TokenList<T> tokenList = this.rootTokenList;
        synchronized (tokenList) {
            this.setActiveImpl(bl);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setActiveImpl(boolean bl) {
        TokenListChange tokenListChange;
        Activity activity;
        assert (this.isMutable()) : "Activity changes only allowed for mutable input sources";
        Activity activity2 = activity = bl ? Activity.ACTIVE : Activity.INACTIVE;
        if (this.activity == activity) return;
        IncTokenList incTokenList = (IncTokenList)this.rootTokenList;
        boolean bl2 = this.listenerList.getListenerCount() > 0;
        TokenHierarchyEventInfo tokenHierarchyEventInfo = new TokenHierarchyEventInfo(this, TokenHierarchyEventType.ACTIVITY, 0, 0, "", 0);
        if (bl) {
            if (!incTokenList.updateLanguagePath()) return;
            incTokenList.reinit();
            tokenListChange = bl2 ? new TokenListChange(incTokenList) : null;
        } else {
            tokenListChange = TokenListChange.createRebuildChange(incTokenList);
            incTokenList.replaceTokens(tokenListChange, tokenHierarchyEventInfo, true);
            incTokenList.setLanguagePath(null);
            incTokenList.reinit();
        }
        if (this.activity != Activity.NOT_INITED) {
            incTokenList.incrementModCount();
        }
        this.activity = activity;
        if (!bl2) return;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Firing ACTIVITY change to " + this.listenerList.getListenerCount() + " listeners: " + (Object)((Object)this.activity));
        }
        CharSequence charSequence = LexerSpiPackageAccessor.get().text(this.mutableTextInput);
        tokenHierarchyEventInfo.setMaxAffectedEndOffset(charSequence.length());
        if (this.activity == Activity.INACTIVE) {
            tokenHierarchyEventInfo.setTokenChangeInfo(tokenListChange.tokenChangeInfo());
            this.invalidatePath2TokenListList();
        }
        this.fireTokenHierarchyChanged(tokenHierarchyEventInfo);
    }

    private void invalidatePath2TokenListList() {
        this.path2tokenListList = null;
        this.rootChildrenLanguages = Collections.emptySet();
        this.maxTokenListListPathSize = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        this.ensureReadLocked();
        TokenList<T> tokenList = this.rootTokenList;
        synchronized (tokenList) {
            return this.isActiveImpl();
        }
    }

    public boolean isActiveImpl() {
        if (this.activity == Activity.NOT_INITED) {
            this.setActiveImpl(true);
        }
        return this.isActiveNoInit();
    }

    public boolean isActiveNoInit() {
        return this.activity == Activity.ACTIVE;
    }

    public void ensureReadLocked() {
        if (this.isMutable() && LOG_LOCK.isLoggable(Level.FINE) && !LexerSpiPackageAccessor.get().isReadLocked(this.mutableTextInput)) {
            LOG_LOCK.log(Level.INFO, "!!WARNING!! Missing READ-LOCK of input source " + LexerSpiPackageAccessor.get().inputSource(this.mutableTextInput), new Exception());
        }
    }

    public void ensureWriteLocked() {
        if (this.isMutable() && LOG_LOCK.isLoggable(Level.FINE) && !LexerSpiPackageAccessor.get().isWriteLocked(this.mutableTextInput)) {
            LOG_LOCK.log(Level.INFO, "!!WARNING!! Missing WRITE-LOCK of input source " + LexerSpiPackageAccessor.get().inputSource(this.mutableTextInput), new Exception());
        }
    }

    public TokenSequence<T> tokenSequence() {
        return this.tokenSequence(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenSequence<T> tokenSequence(Language<?> language) {
        this.ensureReadLocked();
        TokenList<T> tokenList = this.rootTokenList;
        synchronized (tokenList) {
            return this.isActiveImpl() && (language == null || this.rootTokenList.languagePath().topLanguage() == language) ? LexerApiPackageAccessor.get().createTokenSequence(this.rootTokenList) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TokenSequence<?>> tokenSequenceList(LanguagePath languagePath, int n, int n2) {
        if (languagePath == null) {
            throw new IllegalArgumentException("languagePath cannot be null");
        }
        this.ensureReadLocked();
        TokenList<T> tokenList = this.rootTokenList;
        synchronized (tokenList) {
            return this.isActiveImpl() ? new TokenSequenceList(this.rootTokenList, languagePath, n, n2) : null;
        }
    }

    public <ET extends TokenId> TokenListList<ET> tokenListList(LanguagePath languagePath) {
        assert (this.isActiveNoInit()) : "Token hierarchy expected to be active.";
        TokenListList<Object> tokenListList = this.path2tokenListList().get(languagePath);
        if (tokenListList == null) {
            tokenListList = new TokenListList(this.rootTokenList, languagePath);
            this.path2tokenListList.put(languagePath, tokenListList);
            this.maxTokenListListPathSize = Math.max(languagePath.size(), this.maxTokenListListPathSize);
            Language<?> language = languagePath.innerLanguage();
            if (languagePath.size() >= 3) {
                this.tokenListList(languagePath.parent()).notifyChildAdded(language);
            } else {
                assert (languagePath.size() == 2);
                assert (languagePath.parent() == this.rootTokenList.languagePath());
                if (this.rootChildrenLanguages.size() == 0) {
                    this.rootChildrenLanguages = new HashSet();
                }
                boolean bl = this.rootChildrenLanguages.add(language);
                assert (bl) : "Language " + language + " already contained: " + this.rootChildrenLanguages;
            }
        }
        return tokenListList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ET extends TokenId> TokenListList<ET> existingTokenListList(LanguagePath languagePath) {
        TokenList<T> tokenList = this.rootTokenList();
        synchronized (tokenList) {
            TokenListList<?> tokenListList = this.path2tokenListList != null ? this.path2tokenListList.get(languagePath) : null;
            return tokenListList;
        }
    }

    public Set<Language<?>> rootChildrenLanguages() {
        return this.rootChildrenLanguages;
    }

    private Map<LanguagePath, TokenListList<?>> path2tokenListList() {
        if (this.path2tokenListList == null) {
            this.path2tokenListList = new HashMap(4, 0.5f);
        }
        return this.path2tokenListList;
    }

    public int maxTokenListListPathSize() {
        return this.maxTokenListListPathSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuild() {
        this.ensureWriteLocked();
        TokenList<T> tokenList = this.rootTokenList;
        synchronized (tokenList) {
            if (this.isActiveNoInit()) {
                IncTokenList incTokenList = (IncTokenList)this.rootTokenList;
                incTokenList.incrementModCount();
                CharSequence charSequence = LexerSpiPackageAccessor.get().text(this.mutableTextInput);
                TokenHierarchyEventInfo tokenHierarchyEventInfo = new TokenHierarchyEventInfo(this, TokenHierarchyEventType.REBUILD, 0, 0, "", 0);
                TokenListChange tokenListChange = TokenListChange.createRebuildChange(incTokenList);
                incTokenList.replaceTokens(tokenListChange, tokenHierarchyEventInfo, true);
                incTokenList.reinit();
                tokenHierarchyEventInfo.setTokenChangeInfo(tokenListChange.tokenChangeInfo());
                tokenHierarchyEventInfo.setMaxAffectedEndOffset(charSequence.length());
                this.invalidatePath2TokenListList();
                this.fireTokenHierarchyChanged(tokenHierarchyEventInfo);
            }
        }
    }

    public void fireTokenHierarchyChanged(TokenHierarchyEventInfo tokenHierarchyEventInfo) {
        TokenHierarchyEvent tokenHierarchyEvent = LexerApiPackageAccessor.get().createTokenChangeEvent(tokenHierarchyEventInfo);
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length;
        for (int i = 1; i < n; i += 2) {
            ((TokenHierarchyListener)objectArray[i]).tokenHierarchyChanged(tokenHierarchyEvent);
        }
    }

    public void addTokenHierarchyListener(TokenHierarchyListener tokenHierarchyListener) {
        this.listenerList.add(TokenHierarchyListener.class, tokenHierarchyListener);
    }

    public void removeTokenHierarchyListener(TokenHierarchyListener tokenHierarchyListener) {
        this.listenerList.remove(TokenHierarchyListener.class, tokenHierarchyListener);
    }

    public void textModified(int n, int n2, CharSequence charSequence, int n3) {
        this.ensureWriteLocked();
        boolean bl = this.isActiveNoInit();
        if (!bl && this.listenerList.getListenerCount() > 0) {
            bl = this.isActive();
        }
        if (bl) {
            TokenHierarchyEventInfo tokenHierarchyEventInfo = new TokenHierarchyEventInfo(this, TokenHierarchyEventType.MODIFICATION, n, n2, charSequence, n3);
            new TokenHierarchyUpdate(tokenHierarchyEventInfo).update();
            this.fireTokenHierarchyChanged(tokenHierarchyEventInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<LanguagePath> languagePaths() {
        Set set;
        this.ensureReadLocked();
        TokenList<T> tokenList = this.rootTokenList;
        synchronized (tokenList) {
            set = this.languagePaths;
            if (set == null) {
                Set set2;
                Set set3;
                if (!this.isActiveImpl()) {
                    return Collections.emptySet();
                }
                LanguagePath languagePath = this.rootTokenList.languagePath();
                Language<?> language = languagePath.topLanguage();
                LanguageOperation<?> languageOperation = LexerApiPackageAccessor.get().languageOperation(language);
                set = set3 = (Set)((HashSet)languageOperation.languagePaths()).clone();
                this.exploredLanguages = set2 = (Set)((HashSet)languageOperation.exploredLanguages()).clone();
                this.languagePaths = set;
            }
        }
        return set;
    }

    public void addLanguagePath(LanguagePath languagePath) {
        Set<LanguagePath> set = this.languagePaths();
        if (!set.contains(languagePath)) {
            HashSet<LanguagePath> hashSet = new HashSet<LanguagePath>();
            LanguageOperation.findLanguagePaths(set, hashSet, this.exploredLanguages, languagePath);
            set.addAll(hashSet);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("TOKEN HIERARCHY");
        if (this.inputSource() != null) {
            stringBuilder.append(" for " + this.inputSource());
        }
        if (!this.isActive()) {
            stringBuilder.append(" is NOT ACTIVE.");
            return stringBuilder.toString();
        }
        stringBuilder.append(":\n");
        LexerUtilsConstants.appendTokenList(stringBuilder, this.rootTokenList);
        if (this.path2tokenListList != null && this.path2tokenListList.size() > 0) {
            stringBuilder.append(this.path2tokenListList.size());
            stringBuilder.append(" TokenListList(s) maintained:\n");
            for (TokenListList<?> tokenListList : this.path2tokenListList.values()) {
                stringBuilder.append(tokenListList).append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public String checkConsistency() {
        String string = LexerUtilsConstants.checkConsistencyTokenList(this.rootTokenList(), true);
        if (string == null && this.path2tokenListList != null) {
            for (TokenListList<?> tokenListList : this.path2tokenListList.values()) {
                string = tokenListList.checkConsistency();
                if (string != null) {
                    return string;
                }
                Iterator iterator = tokenListList.iterator();
                while (iterator.hasNext()) {
                    EmbeddedTokenList embeddedTokenList = (EmbeddedTokenList)iterator.next();
                    string = LexerUtilsConstants.checkConsistencyTokenList(embeddedTokenList, false);
                    if (string == null) continue;
                    return string;
                }
            }
        }
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Activity {
        NOT_INITED,
        INACTIVE,
        ACTIVE;

    }
}

