/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.lexer;

import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Set;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.JoinTokenList;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.SubSequenceTokenList;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.TokenOrEmbedding;
import org.netbeans.lib.lexer.token.AbstractToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenSequence<T extends TokenId> {
    private final TokenList<T> tokenList;
    private AbstractToken<T> token;
    private int tokenIndex;
    private int tokenOffset = -1;
    private final int modCount;

    TokenSequence(TokenList<T> tokenList) {
        this.tokenList = tokenList;
        this.modCount = tokenList.modCount();
    }

    public Language<T> language() {
        return LexerUtilsConstants.innerLanguage(this.languagePath());
    }

    public LanguagePath languagePath() {
        return this.tokenList.languagePath();
    }

    public Token<T> token() {
        return this.token;
    }

    public Token<T> offsetToken() {
        this.checkTokenNotNull();
        if (this.token.isFlyweight()) {
            this.token = this.tokenList.replaceFlyToken(this.tokenIndex, this.token, this.offset());
        }
        return this.token;
    }

    public int offset() {
        this.checkTokenNotNull();
        if (this.tokenOffset == -1) {
            this.tokenOffset = this.tokenList.tokenOffsetByIndex(this.tokenIndex);
        }
        return this.tokenOffset;
    }

    public int index() {
        return this.tokenIndex;
    }

    public TokenSequence<?> embedded() {
        this.checkTokenNotNull();
        return this.embeddedImpl(null, false);
    }

    public <ET extends TokenId> TokenSequence<ET> embedded(Language<ET> language) {
        this.checkTokenNotNull();
        return this.embeddedImpl(Collections.singleton(language), false);
    }

    public TokenSequence<?> embeddedJoined() {
        this.checkTokenNotNull();
        return this.embeddedImpl(null, true);
    }

    public <ET extends TokenId> TokenSequence<ET> embeddedJoined(Language<ET> language) {
        this.checkTokenNotNull();
        return this.embeddedImpl(Collections.singleton(language), true);
    }

    private <ET extends TokenId> TokenSequence<ET> embeddedImpl(Set<Language<?>> set, boolean bl) {
        if (this.token.isFlyweight()) {
            return null;
        }
        EmbeddedTokenList embeddedTokenList = EmbeddingContainer.embeddedTokenList(this.tokenList, this.tokenIndex, set, true);
        if (embeddedTokenList != null) {
            TokenSequence tokenSequence;
            JoinTokenList joinTokenList;
            embeddedTokenList.embeddingContainer().updateStatus();
            if (bl && (joinTokenList = embeddedTokenList.joinTokenList()) != null) {
                tokenSequence = new TokenSequence(joinTokenList);
                tokenSequence.moveIndex(joinTokenList.activeStartJoinIndex());
            } else {
                tokenSequence = new TokenSequence(embeddedTokenList);
            }
            return tokenSequence;
        }
        return null;
    }

    public boolean createEmbedding(Language<?> language, int n, int n2) {
        return this.createEmbedding(language, n, n2, false);
    }

    public boolean createEmbedding(Language<?> language, int n, int n2, boolean bl) {
        this.checkTokenNotNull();
        return EmbeddingContainer.createEmbedding(this.tokenList, this.tokenIndex, language, n, n2, bl);
    }

    public boolean removeEmbedding(Language<?> language) {
        this.checkTokenNotNull();
        return EmbeddingContainer.removeEmbedding(this.tokenList, this.tokenIndex, language);
    }

    public boolean moveNext() {
        TokenOrEmbedding<T> tokenOrEmbedding;
        this.checkModCount();
        if (this.token != null) {
            ++this.tokenIndex;
        }
        if ((tokenOrEmbedding = this.tokenList.tokenOrEmbedding(this.tokenIndex)) != null) {
            AbstractToken<T> abstractToken = this.token;
            this.token = tokenOrEmbedding.token();
            if (this.tokenOffset != -1) {
                this.tokenOffset = abstractToken != null ? (this.tokenList.isContinuous() || this.token.isFlyweight() ? (this.tokenOffset += abstractToken.length()) : -1) : -1;
            }
            return true;
        }
        if (this.token != null) {
            --this.tokenIndex;
        }
        return false;
    }

    public boolean movePrevious() {
        this.checkModCount();
        if (this.tokenIndex > 0) {
            AbstractToken<T> abstractToken = this.token;
            --this.tokenIndex;
            this.token = this.tokenList.tokenOrEmbedding(this.tokenIndex).token();
            if (this.tokenOffset != -1) {
                this.tokenOffset = this.tokenList.isContinuous() || abstractToken.isFlyweight() ? (this.tokenOffset -= this.token.length()) : -1;
            }
            return true;
        }
        return false;
    }

    public int moveIndex(int n) {
        this.checkModCount();
        if (n >= 0) {
            TokenOrEmbedding<T> tokenOrEmbedding = this.tokenList.tokenOrEmbedding(n);
            if (tokenOrEmbedding != null) {
                this.resetTokenIndex(n, -1);
            } else {
                this.resetTokenIndex(this.tokenCount(), -1);
            }
        } else {
            this.resetTokenIndex(0, -1);
        }
        return n - this.tokenIndex;
    }

    public void moveStart() {
        this.moveIndex(0);
    }

    public void moveEnd() {
        this.moveIndex(this.tokenCount());
    }

    public int move(int n) {
        this.checkModCount();
        int[] nArray = this.tokenList.tokenIndex(n);
        if (nArray[0] != -1) {
            this.resetTokenIndex(nArray[0], nArray[1]);
        } else {
            this.resetTokenIndex(0, -1);
        }
        return n - nArray[1];
    }

    public boolean isEmpty() {
        return this.tokenIndex == 0 && this.tokenList.tokenOrEmbedding(0) == null;
    }

    public int tokenCount() {
        this.checkModCount();
        return this.tokenList.tokenCount();
    }

    public TokenSequence<T> subSequence(int n) {
        return this.subSequence(n, Integer.MAX_VALUE);
    }

    public TokenSequence<T> subSequence(int n, int n2) {
        TokenList<T> tokenList;
        this.checkModCount();
        if (this.tokenList.getClass() == SubSequenceTokenList.class) {
            SubSequenceTokenList subSequenceTokenList = (SubSequenceTokenList)this.tokenList;
            tokenList = subSequenceTokenList.delegate();
            n = Math.max(n, subSequenceTokenList.limitStartOffset());
            n2 = Math.min(n2, subSequenceTokenList.limitEndOffset());
        } else {
            tokenList = this.tokenList;
        }
        return new TokenSequence<T>(new SubSequenceTokenList<T>(tokenList, n, n2));
    }

    public boolean isValid() {
        return this.tokenList.modCount() == this.modCount;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("TokenSequence for ").append(this.tokenList.languagePath().mimePath());
        stringBuilder.append(" at tokenIndex=").append(this.tokenIndex);
        stringBuilder.append(". TokenList contains ").append(this.tokenList.tokenCount()).append(" tokens:\n");
        LexerUtilsConstants.appendTokenList(stringBuilder, this.tokenList, this.tokenIndex, 0, Integer.MAX_VALUE, true, 0, true);
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }

    private void resetTokenIndex(int n, int n2) {
        this.tokenIndex = n;
        this.token = null;
        this.tokenOffset = n2;
    }

    private void checkTokenNotNull() {
        if (this.token == null) {
            throw new IllegalStateException("Caller of TokenSequence forgot to call moveNext/Previous() or it returned false (no more tokens)\n" + this);
        }
    }

    private void checkModCount() {
        if (this.tokenList.modCount() != this.modCount) {
            throw new ConcurrentModificationException("Caller uses obsolete token sequence which is no longer valid. Underlying token hierarchy has been modified: modCount=" + this.modCount + " != upToDateModCount=" + this.tokenList.modCount() + "\nPlease report against caller's module which needs to be fixed (not the lexer module).");
        }
    }
}

