/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php.findusages;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.refactoring.php.findusages.AttributedNodes;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedSupport;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class WhereUsedPanel
extends JPanel
implements CustomRefactoringPanel {
    private final transient WhereUsedSupport usage;
    private WhereUsedSupport newElement;
    private final transient ChangeListener parent;
    private boolean initialized = false;
    private String methodDeclaringSuperClass = null;
    private String methodDeclaringClass = null;
    private ButtonGroup buttonGroup;
    private JRadioButton c_directOnly;
    private JRadioButton c_subclasses;
    private JRadioButton c_usages;
    private JPanel classesPanel;
    private JPanel commentsPanel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel label;
    private JCheckBox m_isBaseClass;
    private JCheckBox m_overriders;
    private JCheckBox m_usages;
    private JPanel methodsPanel;
    private JCheckBox searchInComments;

    public WhereUsedPanel(String string, WhereUsedSupport whereUsedSupport, ChangeListener changeListener) {
        this.setName(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_WhereUsed"));
        this.usage = whereUsedSupport;
        this.parent = changeListener;
        this.initComponents();
        this.searchInComments.setEnabled(false);
    }

    String getMethodDeclaringClass() {
        return this.isMethodFromBaseClass() ? this.methodDeclaringSuperClass : this.methodDeclaringClass;
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                WhereUsedPanel.this.setupPanels();
            }
        });
        this.initialized = true;
    }

    private void setupPanels() {
        AttributedNodes.AttributedElement attributedElement = this.usage.getAttributeElement();
        assert (attributedElement != null);
        String string = this.usage.getName();
        String string2 = attributedElement.isClassMember() ? ((AttributedNodes.ClassMemberElement)attributedElement).getClassName() : null;
        String string3 = this.bundleKeyForLabel();
        Set<Modifier> set = this.usage.getModifiers();
        String string4 = string2 != null ? NbBundle.getMessage(WhereUsedPanel.class, (String)string3, (Object)string, (Object)string2) : NbBundle.getMessage(WhereUsedPanel.class, (String)string3, (Object)string);
        this.remove(this.classesPanel);
        this.remove(this.methodsPanel);
        this.c_subclasses.setVisible(false);
        this.m_overriders.setVisible(false);
        this.label.setText(string4);
        if (this.usage.getKind() == WhereUsedSupport.Kind.METHOD) {
            this.add((Component)this.methodsPanel, "Center");
            this.methodsPanel.setVisible(true);
            this.m_usages.setVisible(!set.contains(Modifier.STATIC));
            if (this.methodDeclaringSuperClass != null) {
                this.m_isBaseClass.setVisible(true);
                this.m_isBaseClass.setSelected(true);
            } else {
                this.m_isBaseClass.setVisible(false);
                this.m_isBaseClass.setSelected(false);
            }
        } else if (this.usage.getKind() == WhereUsedSupport.Kind.CLASS) {
            this.add((Component)this.classesPanel, "Center");
            this.classesPanel.setVisible(true);
        } else {
            this.remove(this.classesPanel);
            this.remove(this.methodsPanel);
            this.c_subclasses.setVisible(false);
            this.m_usages.setVisible(false);
            this.c_usages.setVisible(false);
            this.c_directOnly.setVisible(false);
        }
        this.validate();
    }

    private String bundleKeyForLabel() {
        String string = null;
        switch (this.usage.getKind()) {
            case CLASS: {
                string = "DSC_ClassUsages";
                break;
            }
            case VARIABLE: {
                string = "DSC_VariableUsages";
                break;
            }
            case FUNCTION: {
                string = "DSC_FuncUsages";
                break;
            }
            case FIELD: {
                string = "DSC_FieldUsages";
                break;
            }
            case METHOD: {
                string = "DSC_MethodUsages";
                break;
            }
            case CONSTANT: {
                string = "DSC_ConstantUsages";
                break;
            }
            case CLASS_CONSTANT: {
                string = "DSC_ClassConstantUsages";
            }
        }
        return string;
    }

    public WhereUsedSupport getBaseMethod() {
        return this.usage;
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.methodsPanel = new JPanel();
        this.m_isBaseClass = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.m_overriders = new JCheckBox();
        this.m_usages = new JCheckBox();
        this.classesPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.c_subclasses = new JRadioButton();
        this.c_usages = new JRadioButton();
        this.c_directOnly = new JRadioButton();
        this.commentsPanel = new JPanel();
        this.label = new JLabel();
        this.searchInComments = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.methodsPanel.setLayout(new GridBagLayout());
        this.m_isBaseClass.setSelected(true);
        this.m_isBaseClass.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WhereUsedPanel.this.m_isBaseClassActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.methodsPanel.add((Component)this.m_isBaseClass, gridBagConstraints);
        this.m_isBaseClass.getAccessibleContext().setAccessibleDescription("null");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.methodsPanel.add((Component)this.jPanel1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.m_overriders, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindOverridingMethods"));
        this.m_overriders.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WhereUsedPanel.this.m_overridersActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.methodsPanel.add((Component)this.m_overriders, gridBagConstraints);
        this.m_overriders.getAccessibleContext().setAccessibleDescription("null");
        this.m_usages.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.m_usages, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindUsages"));
        this.m_usages.setMargin(new Insets(10, 2, 2, 2));
        this.m_usages.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WhereUsedPanel.this.m_usagesActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.methodsPanel.add((Component)this.m_usages, gridBagConstraints);
        this.m_usages.getAccessibleContext().setAccessibleDescription("null");
        this.add((Component)this.methodsPanel, "Center");
        this.classesPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.classesPanel.add((Component)this.jPanel2, gridBagConstraints);
        this.buttonGroup.add(this.c_subclasses);
        Mnemonics.setLocalizedText((AbstractButton)this.c_subclasses, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindAllSubtypes"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.classesPanel.add((Component)this.c_subclasses, gridBagConstraints);
        this.c_subclasses.getAccessibleContext().setAccessibleDescription("null");
        this.buttonGroup.add(this.c_usages);
        this.c_usages.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.c_usages, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindUsages"));
        this.c_usages.setMargin(new Insets(4, 2, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.classesPanel.add((Component)this.c_usages, gridBagConstraints);
        this.c_usages.getAccessibleContext().setAccessibleDescription("null");
        this.buttonGroup.add(this.c_directOnly);
        Mnemonics.setLocalizedText((AbstractButton)this.c_directOnly, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindDirectSubtypesOnly"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.classesPanel.add((Component)this.c_directOnly, gridBagConstraints);
        this.c_directOnly.getAccessibleContext().setAccessibleDescription("null");
        this.add((Component)this.classesPanel, "Center");
        this.commentsPanel.setLayout(new BorderLayout());
        this.commentsPanel.add((Component)this.label, "North");
        this.searchInComments.setSelected(NbPreferences.forModule(WhereUsedPanel.class).getBoolean("searchInComments.whereUsed", Boolean.FALSE));
        Mnemonics.setLocalizedText((AbstractButton)this.searchInComments, (String)NbBundle.getBundle(WhereUsedPanel.class).getString("LBL_SearchInComents"));
        this.searchInComments.setMargin(new Insets(10, 14, 2, 2));
        this.searchInComments.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                WhereUsedPanel.this.searchInCommentsItemStateChanged(itemEvent);
            }
        });
        this.searchInComments.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WhereUsedPanel.this.searchInCommentsActionPerformed(actionEvent);
            }
        });
        this.commentsPanel.add((Component)this.searchInComments, "Center");
        this.searchInComments.getAccessibleContext().setAccessibleDescription(this.searchInComments.getText());
        this.add((Component)this.commentsPanel, "North");
    }

    private void searchInCommentsItemStateChanged(ItemEvent itemEvent) {
        Boolean bl = itemEvent.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        NbPreferences.forModule(WhereUsedPanel.class).putBoolean("searchInComments.whereUsed", bl);
    }

    private void m_isBaseClassActionPerformed(ActionEvent actionEvent) {
        this.parent.stateChanged(null);
    }

    private void m_overridersActionPerformed(ActionEvent actionEvent) {
        this.parent.stateChanged(null);
    }

    private void m_usagesActionPerformed(ActionEvent actionEvent) {
        this.parent.stateChanged(null);
    }

    private void searchInCommentsActionPerformed(ActionEvent actionEvent) {
    }

    public boolean isMethodFromBaseClass() {
        return this.m_isBaseClass.isSelected();
    }

    public boolean isMethodOverriders() {
        return this.m_overriders.isSelected();
    }

    public boolean isClassSubTypes() {
        return this.c_subclasses.isSelected();
    }

    public boolean isClassSubTypesDirectOnly() {
        return this.c_directOnly.isSelected();
    }

    public boolean isMethodFindUsages() {
        return this.m_usages.isSelected();
    }

    public boolean isClassFindUsages() {
        return this.c_usages.isSelected();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(dimension.width + 30, dimension.height + 80);
    }

    public boolean isSearchInComments() {
        return this.searchInComments.isSelected();
    }

    public Component getComponent() {
        return this;
    }
}

