/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.project.jsf.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.visualweb.project.jsf.api.JsfProjectUtils;
import org.openide.util.NbBundle;

public class PagebeanPackagePanelGUI
extends JPanel
implements DocumentListener {
    private Project project;
    private final List listeners = new ArrayList();
    private JLabel packageLabel;
    private JTextField packageTextField;

    public PagebeanPackagePanelGUI(Project project) {
        this.project = project;
        this.initComponents();
        this.initValues(project);
        this.packageTextField.getDocument().addDocumentListener(this);
    }

    public void initValues(Project project) {
        String string = JsfProjectUtils.getProjectProperty(project, "jsf.pagebean.package");
        if (string == null || string.length() == 0) {
            string = JsfProjectUtils.deriveSafeName(project.getProjectDirectory().getName());
        }
        this.packageTextField.setText(string);
        this.packageTextField.setEditable(!JsfProjectUtils.isJsfProject(project));
    }

    public String getPackageName() {
        String string = this.packageTextField.getText().trim();
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList arrayList;
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object object = this;
        synchronized (object) {
            arrayList = new ArrayList(this.listeners);
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            ((ChangeListener)object.next()).stateChanged(changeEvent);
        }
    }

    private void initComponents() {
        this.packageLabel = new JLabel();
        this.packageTextField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PagebeanPackagePanelGUI.class).getString("AD_PagebeanPackagePanelGUI"));
        this.packageLabel.setDisplayedMnemonic(NbBundle.getMessage(PagebeanPackagePanelGUI.class, (String)"MNE_PagebeanPackage_Label").charAt(0));
        this.packageLabel.setLabelFor(this.packageTextField);
        this.packageLabel.setText(NbBundle.getMessage(PagebeanPackagePanelGUI.class, (String)"LBL_PagebeanPackage_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.packageLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.packageTextField, gridBagConstraints);
        this.packageTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PagebeanPackagePanelGUI.class).getString("AD_packageTextField"));
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.fireChange();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.fireChange();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.fireChange();
    }
}

