/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.InnerClassesInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.shrink.UsageMarker;

public class InnerUsageMarker
extends SimplifiedVisitor
implements AttributeVisitor,
InnerClassesInfoVisitor,
ConstantVisitor,
ClassVisitor {
    private final UsageMarker usageMarker;
    private boolean attributeUsed;
    private boolean classUsed;

    public InnerUsageMarker(UsageMarker usageMarker) {
        this.usageMarker = usageMarker;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
        this.attributeUsed = false;
        innerClassesAttribute.innerClassEntriesAccept(clazz, this);
        if (this.attributeUsed) {
            this.usageMarker.markAsUsed(innerClassesAttribute);
            this.markConstant(clazz, innerClassesAttribute.u2attributeNameIndex);
        }
    }

    public void visitInnerClassesInfo(Clazz clazz, InnerClassesInfo innerClassesInfo) {
        boolean bl = this.usageMarker.isUsed(innerClassesInfo);
        if (!bl) {
            int n = innerClassesInfo.u2innerClassIndex;
            int n2 = innerClassesInfo.u2outerClassIndex;
            int n3 = innerClassesInfo.u2innerNameIndex;
            bl = true;
            if (n != 0) {
                this.markConstant(clazz, n);
                bl = this.classUsed;
            }
            if (n2 != 0) {
                this.markConstant(clazz, n2);
                bl &= this.classUsed;
            }
            if (bl) {
                this.usageMarker.markAsUsed(innerClassesInfo);
                if (n3 != 0) {
                    this.markConstant(clazz, n3);
                }
            }
        }
        this.attributeUsed |= bl;
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        this.classUsed = this.usageMarker.isUsed(classConstant);
        if (!this.classUsed) {
            this.classUsed = true;
            classConstant.referencedClassAccept(this);
            if (this.classUsed) {
                this.usageMarker.markAsUsed(classConstant);
                this.markConstant(clazz, classConstant.u2nameIndex);
            }
        }
    }

    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
        this.usageMarker.markAsUsed(utf8Constant);
    }

    public void visitProgramClass(ProgramClass programClass) {
        this.classUsed = this.usageMarker.isUsed(programClass);
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        this.classUsed = true;
    }

    private void markConstant(Clazz clazz, int n) {
        clazz.constantPoolEntryAccept(n, this);
    }
}

